/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.copymoveWizard;

import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.CopyMoveFilesBean;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.DirectoryLister;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ListModel;

public class CopyMoveDirectoriesPage
extends KumbaCoreWizardPage<CopyMoveFilesBean> {
    private static final String[] destinationFileStores = new String[]{"cert:", "config:", "isamcert:", "isamconfig:", "isamwebroot:", "local:", "pubcert:", "sharedcert:", "store:", "temporary:"};
    ConfigObjectCache<DataPowerFileInfo> dpDirectoryCache;
    private JMListModel<String> directoryListModel;
    private JMList<String> directoryList;

    public CopyMoveDirectoriesPage(CopyMoveFilesBean model) {
        super(model);
    }

    public CopyMoveDirectoriesPage(CopyMoveFilesBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean doesPageApply() {
        return !((CopyMoveFilesBean)this.model).duplicateSourceDirectories();
    }

    @Override
    protected void saveDataToModel() {
        ((CopyMoveFilesBean)this.model).clearDestinationDirectories();
        List selectedDirectories = this.directoryList.getSelectedValuesList();
        for (String selectedDirectory : selectedDirectories) {
            for (DataPowerFileInfo dpDir : this.dpDirectoryCache.getObjectCache()) {
                String absolutePath;
                if (dpDir == null || !(absolutePath = dpDir.getAbsolutePath()).contains(selectedDirectory)) continue;
                ((CopyMoveFilesBean)this.model).addDestinationDirectory(dpDir.getSourceDomain(), selectedDirectory);
            }
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        this.directoryListModel = new JMListModel();
        this.directoryList = new JMList<String>((ListModel<String>)this.directoryListModel);
        panel.add((Component)new JMLabel("Destination Directories"), "North");
        panel.add(new JMScrollPane(this.directoryList));
        return panel;
    }

    @Override
    protected void updateControls() {
        ArrayList<Appliance> appliances = ((CopyMoveFilesBean)this.model).getDestinationAppliances();
        ArrayList<String> domains = ((CopyMoveFilesBean)this.model).getDestinationDomains();
        Index<Appliance, Domain> searchDomains = new Index<Appliance, Domain>();
        for (Appliance appliance : appliances) {
            for (String domainName : domains) {
                Domain domain = appliance.getDomain(domainName, true);
                if (domain == null) continue;
                searchDomains.put(appliance, domain);
            }
        }
        ArrayList<String> fileStores = new ArrayList<String>(Arrays.asList(destinationFileStores));
        if (this.dpDirectoryCache == null) {
            this.dpDirectoryCache = new ConfigObjectCache();
        } else {
            this.dpDirectoryCache.clearCache();
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        DirectoryLister.list(searchDomains, fileStores, mtil);
        DirectoryLister.addConfigObjectSubscriber(this.dpDirectoryCache);
        ThreadManager.monitorAsynchThreadLifeCycle("CopyMoveDirectoriesPage.updateControls()", mtil, fileStores.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        UniqueArrayList<String> directoryNames = new UniqueArrayList<String>();
        for (DataPowerFileInfo dpFileInfo : this.dpDirectoryCache.getObjectCache()) {
            if (dpFileInfo == null) continue;
            Object dpDirName = dpFileInfo.getName();
            if (!((String)dpDirName).endsWith("/")) {
                dpDirName = (String)dpDirName + "/";
            }
            directoryNames.add(StringUtility.coalesce((String)dpDirName, "/"));
        }
        Collections.sort(directoryNames);
        this.directoryListModel.clear();
        this.directoryListModel.addAll(directoryNames);
    }
}

