/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.createLogTargetWizard;

import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import javax.swing.JDialog;

public class LogTargetFileInfoPage
extends KumbaCoreWizardPage<ConfigLogTarget> {
    private JMTextField tfFileName;
    private JMRadioButton rbLogTemp;
    private JMRadioButton rbLogStore;
    private NumberField nfFileSize;
    private NumberField nfNumberOfRotations;

    public LogTargetFileInfoPage(ConfigLogTarget model) {
        super(model);
    }

    public LogTargetFileInfoPage(ConfigLogTarget model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    public boolean isDataValid() {
        if (StringUtility.isEmpty(this.tfFileName.getText())) {
            new JMMessageBox((JDialog)this.parentDialog, "File Name is Empty", "Please enter a valid name for the logging target file");
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        String fileStore = this.rbLogStore.isSelected() ? "logstore:///" : "logtemp:///";
        String fileName = this.tfFileName.getText();
        ((ConfigLogTarget)this.model).setLocalFile(fileStore + fileName);
        ((ConfigLogTarget)this.model).setSize((long)this.nfFileSize.getNumber());
        ((ConfigLogTarget)this.model).setRotate((long)this.nfNumberOfRotations.getNumber());
    }

    @Override
    protected void updateControls() {
        String logTargetName = ((ConfigLogTarget)this.model).getName();
        String localFile = String.format("logstore:///%s.log", logTargetName);
        int lastSlash = localFile.lastIndexOf("/");
        String fileStore = localFile.substring(0, lastSlash + 1);
        Object fileName = localFile.substring(lastSlash + 1);
        if (StringUtility.isEmpty((String)fileName)) {
            fileName = ((ConfigLogTarget)this.model).getName() + ".log";
        }
        this.tfFileName.setText((String)fileName);
        ((ConfigLogTarget)this.model).setLocalFile(fileStore + (String)fileName);
        if (fileStore.startsWith("logstore:")) {
            this.rbLogStore.setSelected(true);
            this.rbLogTemp.setSelected(false);
        } else {
            this.rbLogStore.setSelected(false);
            this.rbLogTemp.setSelected(true);
        }
        this.nfFileSize.setNumber(((ConfigLogTarget)this.model).getSize());
        this.nfNumberOfRotations.setNumber(((ConfigLogTarget)this.model).getRotate());
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createVerticalFlowLayout(0));
        this.tfFileName = new JMTextField();
        LabeledComponent lblName = new LabeledComponent("File Name:", (Component)this.tfFileName, 100, 300);
        this.rbLogStore = new JMRadioButton("logstore:", true);
        this.rbLogTemp = new JMRadioButton("logtemp:");
        new JMButtonGroup(this.rbLogStore, this.rbLogTemp);
        JMPanel storePanel = new JMPanel(new VerticalFlowLayout(0, 3));
        storePanel.addAll(this.rbLogStore, this.rbLogTemp);
        this.nfFileSize = new NumberField();
        NumberSpinner nsFileSize = new NumberSpinner(this.nfFileSize, 100.0, 100.0, 2.147483647E9);
        LabeledComponent lblFileSize = new LabeledComponent("File Size:", (Component)nsFileSize, 150, 100);
        this.nfNumberOfRotations = new NumberField();
        NumberSpinner nsNumberOfRotations = new NumberSpinner(this.nfNumberOfRotations, 1.0, 1.0, 2.147483647E9);
        LabeledComponent lblNumberOfRotations = new LabeledComponent("Number of Rotations:", (Component)nsNumberOfRotations, 150, 100);
        panel.addAll(lblName, storePanel, lblFileSize, lblNumberOfRotations);
        return panel;
    }
}

