/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.createValCredWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.table.BeanRowSorter;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.DynamicBeanRowSorter;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

abstract class AbstractCreateValcredWizardPage<TableModelType extends TableModel, ColumnModelType extends TableColumnModel>
extends KumbaCoreWizardPage<DynamicBean> {
    protected JMTextField tfValCredName;
    protected JMComboBox<String> cbxValidationMode;
    protected JMCheckBox cbxUseCRL;
    protected JMCheckBox cbxRequireCRL;
    protected JMRadioButton rbCRLDistroHandlingIgnore;
    protected JMRadioButton rbCRLDistroHandlingRequire;
    protected JMCheckBox cbxCheckDates;
    protected Index<Appliance, Domain> selectedDomains;
    protected ArrayList<StatusObjectStatus> existingValcreds;
    protected TableModelType tableModel;
    protected ColumnModelType columnModel;
    protected JMTable table;

    public AbstractCreateValcredWizardPage(DynamicBean model) {
        super(model);
    }

    public AbstractCreateValcredWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isDataValid() {
        String valcredName = this.tfValCredName.getText();
        if (!ConfigurationManager.isObjectNameValid(valcredName)) {
            new JMMessageBox((JDialog)this.parentDialog, "Validation Credential Name Invalid", ConfigurationManager.getStandardInvalidObjectNameMessage("validation credential"));
            return false;
        }
        Stream stream = this.existingValcreds.stream();
        List matching = stream.filter(o -> o.getName().equalsIgnoreCase(valcredName)).collect(Collectors.toList());
        if (CollectionUtility.isNotEmpty(matching)) {
            new JMMessageBox((JDialog)this.parentDialog, "Validation Credential Exists", LabelUtility.wrapInHTML(String.format("A validation credential object having the name '%s' already exists.\n\nContinuing will replace the configuration of any existing one with the new configuration.\n\nDo you want to continue?", valcredName)), 12);
            if (JMMessageBox.getSelection() == 8) {
                new AsynchMethodInvoker((Object)this.tfValCredName, "requestFocusInWindow");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        String valcredName = this.tfValCredName.getText();
        int validationModeIndex = this.cbxValidationMode.getSelectedIndex();
        String validationMode = DPEnumerations.CRYPTO_VAL_CRED_CERT_VALIDATION_MODE[validationModeIndex];
        String useCRL = this.cbxUseCRL.isSelected() ? "on" : "off";
        String requireCRL = this.cbxRequireCRL.isSelected() ? "on" : "off";
        String crlDistroHandling = this.rbCRLDistroHandlingIgnore.isSelected() ? DPEnumerations.CRLDPHANDLING[0] : DPEnumerations.CRLDPHANDLING[1];
        String checkDates = this.cbxCheckDates.isSelected() ? "on" : "off";
        ((DynamicBean)this.model).setProperty("valCredName", valcredName);
        ((DynamicBean)this.model).setProperty("validationMode", validationMode);
        ((DynamicBean)this.model).setProperty("useCRL", useCRL);
        ((DynamicBean)this.model).setProperty("requireCRL", requireCRL);
        ((DynamicBean)this.model).setProperty("crlDistroHandling", crlDistroHandling);
        ((DynamicBean)this.model).setProperty("checkDates", checkDates);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.selectedDomains = (Index)((DynamicBean)this.model).getProperty("selectedDomains");
        new AsynchMethodInvoker((Object)this, "getExistingValidationCredentials");
        this.table = this.createTable();
        return new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
    }

    protected JMPanel createValcredDetailsPanel() {
        this.tfValCredName = new JMTextField(20);
        LabeledComponent lbl = new LabeledComponent("Validation Credential Name:", (Component)this.tfValCredName);
        this.cbxValidationMode = new JMComboBox<String>((ItemType[])new String[]{"Match exact certificate or immediate issuer", "Full certificate chain checking (PKIX)", "Match exact certificate"});
        this.cbxValidationMode.setSelectedIndex(0);
        LabeledComponent lblValidationMode = new LabeledComponent("Validation Mode:", this.cbxValidationMode);
        this.cbxUseCRL = new JMCheckBox("Use CRL", true);
        this.cbxRequireCRL = new JMCheckBox("Require CRL");
        JMPanel crlPanel = KumbaCoreUIConstants.createGridLayoutPanel(1, 2);
        crlPanel.addAll(this.cbxUseCRL, this.cbxRequireCRL);
        JMLabel distroLabel = new JMLabel("CRL Distribution Handling: ");
        this.rbCRLDistroHandlingIgnore = new JMRadioButton("Ignore", true);
        this.rbCRLDistroHandlingRequire = new JMRadioButton("Require");
        new JMButtonGroup(this.rbCRLDistroHandlingIgnore, this.rbCRLDistroHandlingRequire);
        JMPanel distroPanel = KumbaCoreUIConstants.createGridLayoutPanel(1, 3);
        distroPanel.addAll(distroLabel, this.rbCRLDistroHandlingIgnore, this.rbCRLDistroHandlingRequire);
        this.cbxCheckDates = new JMCheckBox("Check Dates", true);
        KumbaCoreWizardPanel valCredDetailsPanel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createVerticalFlowLayout(0));
        valCredDetailsPanel.addAll(lbl, lblValidationMode, crlPanel, distroPanel, this.cbxCheckDates);
        return valCredDetailsPanel;
    }

    protected JMTable createTable() {
        this.tableModel = this.createTableModel();
        this.columnModel = this.createColumnModel();
        JMTable table = new JMTable((TableModel)this.tableModel, (TableColumnModel)this.columnModel);
        TableModelType TableModelType = this.tableModel;
        if (TableModelType instanceof BeanTableModel) {
            BeanTableModel model = (BeanTableModel)TableModelType;
            table.setRowSorter(new BeanRowSorter(model));
        } else {
            table.setRowSorter(new DynamicBeanRowSorter((DynamicBeanTableModel)this.tableModel));
        }
        table.optimizeColumnWidths();
        return table;
    }

    protected abstract TableModelType createTableModel();

    protected abstract ColumnModelType createColumnModel();

    @Reflected
    private void getExistingValidationCredentials() {
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.existingValcreds = configurationManager.listObjects(this.selectedDomains, "CryptoValCred", ".*");
    }
}

