/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.createValCredWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.CreateCertificateFromFileBean;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.createValCredWizard.AbstractNewCertificateFromExternalSourcesPage;
import java.io.File;
import javax.swing.JFileChooser;

public class NewCertificateFromFilesWizardPage
extends AbstractNewCertificateFromExternalSourcesPage<CreateCertificateFromFileBean> {
    private static File lastDirectory;

    public NewCertificateFromFilesWizardPage(DynamicBean model) {
        super("Files:", model);
        this.isFinalPage = true;
    }

    public NewCertificateFromFilesWizardPage(DynamicBean model, String contentsOrFileName) {
        super("Files:", model, contentsOrFileName);
    }

    @Override
    protected void addRow() {
        this.table.commitEdits();
        JFileChooser fileChooser = new JFileChooser(lastDirectory);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setDialogTitle("Select one or more certificate files or directories containing certificate files");
        int option = fileChooser.showDialog(this.parentDialog, "Select");
        if (option == 1) {
            return;
        }
        Object[] selectedFiles = fileChooser.getSelectedFiles();
        if (ArrayUtility.isEmpty(selectedFiles)) {
            return;
        }
        lastDirectory = null;
        Object[] objectArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).isDirectory()) {
                if (lastDirectory == null) {
                    lastDirectory = file;
                }
                this.processDirectory((File)file);
            } else {
                if (lastDirectory == null) {
                    lastDirectory = ((File)file).getParentFile();
                }
                this.addUploadFile((File)file);
            }
            ++n2;
        }
        this.table.optimizeColumnWidths();
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        new AsynchMethodInvoker((Object)this, "addRow", KumbaCoreConstants.STARTUP_DELAY);
        return panel;
    }

    private void processDirectory(File directory) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.processDirectory(file);
            } else {
                this.addUploadFile(file);
            }
            ++n2;
        }
    }

    private void addUploadFile(File file) {
        CreateCertificateFromFileBean newRow = this.createNewRowInstance();
        newRow.setLocalFile(file);
        newRow.setFileStore("cert:");
        String baseFileName = file.getName();
        newRow.setDpFileName(baseFileName);
        String certificateObjectName = StringUtility.removeAll(baseFileName, " !@#$%^&*()+=`~[]{};:'\"/\\|?,<>");
        if (certificateObjectName.matches(".+?\\..{3,}")) {
            int lastPeriod = certificateObjectName.lastIndexOf(46);
            certificateObjectName = certificateObjectName.substring(0, lastPeriod);
        }
        newRow.setCertificateObjectName(certificateObjectName);
        this.tableModel.addRow(newRow);
    }

    @Override
    protected CreateCertificateFromFileBean createNewRowInstance() {
        return new CreateCertificateFromFileBean();
    }

    @Override
    protected String[] getEditableColumns() {
        return new String[]{"fileStore", "dpFileName", "certificateObjectName", "password", "passwordAliasName"};
    }

    @Override
    protected String[] getHiddenColumns() {
        return new String[]{"dataPowerFQFN"};
    }

    @Override
    protected String[] getColumnOrder() {
        return new String[]{"localFile", "fileStore", "dpFileName", "certificateObjectName", "password", "passwordAliasName"};
    }
}

