/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPasswordField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import javax.swing.JDialog;

abstract class AbstractCryptoObjectWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    protected JMCheckBox cbxNeedsPassword;
    protected JMPasswordField tfPassword;

    public AbstractCryptoObjectWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    public boolean isDataValid() {
        boolean needsPassword = this.cbxNeedsPassword.isSelected();
        String password = this.tfPassword.getText();
        if (needsPassword && StringUtility.isEmpty(password)) {
            new JMMessageBox((JDialog)this.parentDialog, "Password Not Provided", LabelUtility.wrapInHTML("You've indicated this object configuration needs\na password but did not provide one.\n\nPlease enter a password."));
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        boolean needsPassword = this.cbxNeedsPassword.isSelected();
        String password = this.tfPassword.getText();
        ((DynamicBean)this.model).setProperty("needsPassword", needsPassword);
        ((DynamicBean)this.model).setProperty("password", password);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createVerticalFlowLayout(3));
        int sourceType = (Integer)((DynamicBean)this.model).getProperty("sourcetype");
        boolean isKey = sourceType == 2 || sourceType == 3;
        this.cbxNeedsPassword = new JMCheckBox("Use a password?");
        this.tfPassword = new JMPasswordField();
        LabeledComponent passwordLabel = new LabeledComponent("Password:", (Component)this.tfPassword);
        passwordLabel.setPreferredSize(100, 25);
        this.cbxNeedsPassword.setSelected(isKey);
        this.tfPassword.setEnabled(isKey);
        MethodInvoker isSelectedPointer = new MethodInvoker((Object)this.cbxNeedsPassword, "isSelected", new Object[0]);
        new ItemEventInvoker(this.cbxNeedsPassword, this.tfPassword, "setEnabled", isSelectedPointer);
        panel.addAll(this.cbxNeedsPassword, passwordLabel);
        return panel;
    }
}

