/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.component.FileSelectionListener;
import com.jmorgan.swing.component.FileSelectorComponent;
import com.jmorgan.swing.util.LabelUtility;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.AbstractCryptoObjectFromExternalSourceWizardPage;
import java.awt.Component;
import java.io.File;
import javax.swing.JDialog;

public class CryptoObjectFromExternalFileWizardPage
extends AbstractCryptoObjectFromExternalSourceWizardPage
implements FileSelectionListener {
    private FileSelectorComponent fsFileSelector;

    public CryptoObjectFromExternalFileWizardPage(DynamicBean model, String helpFile) {
        super(model, helpFile);
    }

    @Override
    public boolean isDataValid() {
        if (!super.isDataValid()) {
            return false;
        }
        File externalFile = this.fsFileSelector.getSelectedFile();
        if (externalFile == null) {
            new JMMessageBox((JDialog)this.parentDialog, "No File Selected", "You must select a file for upload.");
            return false;
        }
        if (externalFile.isDirectory()) {
            new JMMessageBox((JDialog)this.parentDialog, "Invalid File", LabelUtility.wrapInHTML("You selected a directory rather than a file.\nPlease select a file."));
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        super.saveDataToModel();
        File externalFile = this.fsFileSelector.getSelectedFile();
        ((DynamicBean)this.model).setProperty("externalFile", externalFile);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.fsFileSelector = new FileSelectorComponent("File:", "...");
        this.fsFileSelector.setPreferredSize(600, 25);
        this.fsFileSelector.hideActionButton();
        this.fsFileSelector.addFileSelectionListener(this);
        panel.add((Component)this.fsFileSelector, 0);
        return panel;
    }

    @Override
    public void fileSelected(Object source, File selectedFile) {
        String filename = selectedFile.getName();
        this.tfDPFileName.setText(filename);
    }
}

