/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DirectoryLister;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.ThreadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

class LoadCryptoObjectData
extends AbstractTool {
    protected Index<Appliance, Domain> selectedDomains;
    protected ArrayList<StatusObjectStatus> selectedObjects;
    protected String updateType;
    protected Index<String, DataPowerFileInfo> dataPowerFiles;
    protected Index<String, DataPowerFileInfo> dataPowerDirectories;
    protected ArrayList<ConfigCrypto> cryptoObjects;

    public LoadCryptoObjectData(DynamicBean model) {
        this.selectedDomains = (Index)model.getProperty("domains");
        this.selectedObjects = (ArrayList)model.getProperty("selectedObjects");
        this.updateType = (String)model.getProperty("updateType");
        new AsynchMethodInvoker((Object)this, "loadFileSystem");
        new AsynchMethodInvoker((Object)this, "loadCryptoObjects");
    }

    @Reflected
    protected void loadCryptoObjects() {
        logger.finer("(): Starting.  Loading crypto objects.");
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<DataPowerConfig> configs = configurationManager.getObjects(this.selectedObjects);
        this.cryptoObjects = new ArrayList(configs.size());
        for (DataPowerConfig config : configs) {
            this.cryptoObjects.add((ConfigCrypto)config);
        }
        logger.finer(() -> LMG.log("(): Loaded %d Crypto Objects.  Done.", () -> configs.size()));
    }

    public Index<String, DataPowerFileInfo> getDataPowerFiles() {
        return this.dataPowerFiles;
    }

    public ArrayList<ConfigCrypto> getCryptoObjects() {
        return this.cryptoObjects;
    }

    public Index<String, DataPowerFileInfo> getDataPowerDirectories() {
        return this.dataPowerDirectories;
    }

    @Reflected
    protected void loadFileSystem() {
        String[] cryptoStores;
        logger.finer("(): Starting.  Building domain index to include the default domain for file search.");
        Index<Appliance, Domain> domainsForFileSearch = new Index<Appliance, Domain>();
        for (Appliance appliance : this.selectedDomains.getKeys()) {
            boolean isDefaultPresent = false;
            for (Domain domain : this.selectedDomains.get(appliance)) {
                if (domain.getName().equals("default")) {
                    isDefaultPresent = true;
                }
                domainsForFileSearch.put(appliance, domain);
            }
            if (isDefaultPresent) continue;
            domainsForFileSearch.put(appliance, appliance.getDomain("default"));
        }
        UniqueArrayList<String> domainNames = new UniqueArrayList<String>();
        for (Appliance appliance : domainsForFileSearch.getKeys()) {
            Collection domains = domainsForFileSearch.get(appliance);
            for (Domain domain : domains) {
                domainNames.add(domain.getName());
            }
        }
        logger.finer(() -> LMG.log("(): Assembling crypto files and directories from %d domains.", () -> domainNames.size()));
        ArrayList<String> directories = new ArrayList<String>();
        String[] stringArray = cryptoStores = new String[]{"cert:", "pubcert:", "sharedcert:", "isamcert:", "hsm:"};
        int n = cryptoStores.length;
        int domain = 0;
        while (domain < n) {
            String fileStore = stringArray[domain];
            directories.add(fileStore + "/");
            if (fileStore.equals("cert:")) {
                for (String domainName : domainNames) {
                    if (domainName.equals("default")) continue;
                    directories.add(String.format("%s/%s/", fileStore, domainName));
                }
            }
            ++domain;
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        logger.finer("(): Getting Files.");
        ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
        ListFiles.list(domainsForFileSearch, directories, "", mtil);
        ListFiles.addConfigObjectSubscriber(fileCache);
        logger.finer("(): Getting Directories.");
        ConfigObjectCache<DataPowerFileInfo> directoryCache = new ConfigObjectCache<DataPowerFileInfo>();
        DirectoryLister.list(domainsForFileSearch, CollectionUtility.createListFrom(cryptoStores), mtil);
        DirectoryLister.addConfigObjectSubscriber(directoryCache);
        ThreadManager.monitorAsynchThreadLifeCycle("LoadCryptoObjectData.loadFileSystem()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        Vector<DataPowerFileInfo> cryptoFiles = fileCache.getObjectCache();
        boolean isForKey = this.updateType.equals("keyFromLocalFile");
        for (StatusObjectStatus objectStatus : this.selectedObjects) {
            String dataPowerType = objectStatus.getDataPowerClass();
            if (!dataPowerType.equals("CryptoKey")) continue;
            isForKey = true;
            break;
        }
        if (!isForKey) {
            logger.finer("(): Update is not for a key.  Removing all HSM files.");
            Vector<DataPowerFileInfo> looper = new Vector<DataPowerFileInfo>(cryptoFiles);
            for (DataPowerFileInfo file : looper) {
                if (!file.getName().startsWith("hsm:")) continue;
                cryptoFiles.remove(file);
            }
        }
        logger.finer(() -> LMG.log("(): Got %d Crypto Files", () -> cryptoFiles.size()));
        Vector<DataPowerFileInfo> cryptoDirectories = directoryCache.getObjectCache();
        logger.finer(() -> LMG.log("(): Got %d Crypto Directories", () -> cryptoDirectories.size()));
        this.dataPowerFiles = this.getFileIndex(cryptoFiles);
        this.dataPowerDirectories = this.getFileIndex(cryptoDirectories);
    }

    protected Index<String, StatusObjectStatus> getObjectIndex(Collection<StatusObjectStatus> objects) {
        BeanIndexer<StatusObjectStatus> nameIndexer = new BeanIndexer<StatusObjectStatus>(objects);
        Index<String, StatusObjectStatus> filesByName = nameIndexer.getIndexOf("name", "");
        return filesByName;
    }

    protected Index<String, DataPowerFileInfo> getFileIndex(Vector<DataPowerFileInfo> files) {
        BeanIndexer<DataPowerFileInfo> nameIndexer = new BeanIndexer<DataPowerFileInfo>(files);
        Index<String, DataPowerFileInfo> filesByName = nameIndexer.getIndexOf("name", "");
        return filesByName;
    }
}

