/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigCryptoIdentCred;
import com.kumbasoft.core.beans.config.ConfigCryptoKey;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.AbstractUpdateCryptoConfig;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.LoadCredentialsData;
import java.io.File;
import java.util.ArrayList;

public class UpdateCryptoIDCred
extends AbstractUpdateCryptoConfig {
    public UpdateCryptoIDCred(DynamicBean model) {
        super(model);
    }

    @Override
    @Reflected
    protected void updateConfigurations() {
        LoadCredentialsData dataLoader = (LoadCredentialsData)this.model.getProperty("dataLoader");
        ArrayList<ConfigCryptoIdentCred> cryptoIDCreds = dataLoader.getCryptoIDCreds();
        ArrayList<ConfigCryptoCertificate> cryptoCertificates = dataLoader.getCryptoCertificates();
        ArrayList<ConfigCryptoKey> cryptoKeys = dataLoader.getCryptoKeys();
        while (cryptoIDCreds == null || cryptoCertificates == null || cryptoKeys == null) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            cryptoIDCreds = dataLoader.getCryptoIDCreds();
            cryptoCertificates = dataLoader.getCryptoCertificates();
            cryptoKeys = dataLoader.getCryptoKeys();
        }
        int sourceType = (Integer)this.model.getProperty("sourcetype");
        String localFile = this.model.getProperty("localFile", null);
        File externalFile = this.model.getProperty("externalFile", null);
        String url = this.model.getProperty("URL", null);
        if (externalFile != null) {
            this.uploadFile(externalFile, localFile);
        } else if (url != null) {
            File urlFile = this.fetchFileFromURL(url);
            if (urlFile == null) {
                logger.severe(() -> LMG.log("(): No file fetched from URL: %s", () -> url));
                return;
            }
            this.uploadFile(urlFile, localFile);
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        if (sourceType == 1 || sourceType == 3) {
            this.updateObjects(cryptoCertificates, localFile, mtil);
        }
        if (sourceType == 2 || sourceType == 3) {
            this.updateObjects(cryptoKeys, localFile, mtil);
        }
        ThreadManager.monitorAsynchThreadLifeCycle("UpdateCryptoIDCred.updateConfigurations", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
    }

    @Override
    protected void updateObjects(ArrayList<? extends ConfigCrypto> objects, String localFile, MultiThreadInvocationListener mtil) {
        super.updateObjects(objects, localFile, mtil);
        this.updatePassword(objects, mtil);
    }
}

