/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.deleteWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.InvocationEventInvoker;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationRelationship;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ExportOptions;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.ExportConfiguration;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.util.DataPowerFileUtility;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteObjectException;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteObjectTableCellRenderer;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

public class DeleteObjectFinalWizardPage
extends AbstractTableWizardPage
implements InvocationListener,
TableModelListener {
    private static final String SELECTED_OBJECT_STATUS = "selectedObjects";
    static final String DELETE_COLUMN_NAME = "delete";
    private static final String DELETE_ORDER_COLUMN_NAME = "deleteOrder";
    private static final String APPLIANCE_COLUMN_NAME = "appliance";
    private static final String DOMAIN_COLUMN_NAME = "domain";
    private static final String OBJECT_TYPE_COLUMN_NAME = "objectType";
    private static final String OBJECT_NAME_COLUMN_NAME = "objectName";
    private static final String RREFERENCING_TYPE_COLUMN_NAME = "referencingType";
    private static final String REFERENCING_NAME_COLUMN_NAME = "referencingName";
    private static final String OBJECT_STATUS_COLUMN_NAME = "objectStatus";
    private static final String[] SORT_ORDER = new String[]{"deleteOrder", "appliance", "domain"};
    private JMButton btnSaveSelectedObjects;
    private ArrayList<DeleteObjectException> objectDeleteExceptions;
    private JMButton btnAddObjectDeleteExceptions;
    private JMCheckBox cbxSynchronize;
    private JMButton btnSelectAll;
    private JMButton btnSelectNone;
    private Boolean lastCascade = null;
    boolean nextButtonEnabled = false;

    public DeleteObjectFinalWizardPage(DynamicBean model) {
        super(model);
    }

    public DeleteObjectFinalWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isNextButtonEnabled() {
        return this.nextButtonEnabled;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        ArrayList<DynamicBean> deleteData = this.getDeleteObjectSelection();
        ((DynamicBean)this.model).setProperty("deleteData", deleteData);
    }

    private ArrayList<DynamicBean> getDeleteObjectSelection() {
        logger.finer("(): Starting");
        this.table.commitEdits();
        ArrayList<DynamicBean> allData = this.tableModel.getModelData(false);
        ArrayList<DynamicBean> deleteData = new ArrayList<DynamicBean>();
        for (DynamicBean bean : allData) {
            boolean delete = (Boolean)bean.getProperty(DELETE_COLUMN_NAME);
            if (!delete) continue;
            deleteData.add(bean);
        }
        BeanComparator sorter = new BeanComparator();
        sorter.setCompareProperties(SORT_ORDER);
        Collections.sort(deleteData, sorter);
        logger.finer(() -> LMG.log("(): Done.  Returning %d objects.", () -> deleteData.size()));
        return deleteData;
    }

    @Override
    protected void updateControls() {
        this.loadObjectDeleteExceptions();
        new AsynchMethodInvoker((Object)this, "finalizeDataUpdate");
        super.updateControls();
    }

    @Reflected
    private void finalizeDataUpdate() {
        logger.finer("(): Starting.");
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        boolean cascade = (Boolean)((DynamicBean)this.model).getProperty("cascade");
        if (this.lastCascade == null || this.lastCascade != cascade) {
            logger.finer("(): Preparing cascade data.");
            MultiThreadInvocationListener mtil = null;
            this.tableModel.reset();
            ArrayList selectedObjectList = (ArrayList)((DynamicBean)this.model).getProperty(SELECTED_OBJECT_STATUS);
            if (cascade) {
                logger.finer("(): Building thread manager due to cascade.");
                mtil = new MultiThreadInvocationListener();
            }
            for (StatusObjectStatus selectedObject : selectedObjectList) {
                Appliance appliance = selectedObject.getAppliance();
                Domain domain = selectedObject.getSourceDomain();
                String objectType = selectedObject.getDataPowerClass();
                String objectName = selectedObject.getName();
                String configState = selectedObject.getConfigState();
                if (configState != null && configState.equals("external")) {
                    logger.finer(() -> LMG.log("(): Ignoring exterally configured object '%s->%s->%s->%s'.", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
                    continue;
                }
                if (cascade) {
                    logger.finer(() -> LMG.log("(): Building cascade list for '%s->%s->%s->%s'.", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
                    SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
                    ConfigurationRelationship cr = new ConfigurationRelationship(selectedObject, ConfigurationRelationshipType.PARENT_DOWN);
                    AsynchMethodInvoker<Void> setupThread = cr.getSetupThread();
                    setupThread.addInvocationListener(stil);
                    new InvocationEventInvoker(setupThread, 2, this, "addRelatedObjects", cr, null, 0);
                    mtil.addThread(setupThread);
                    boolean complete = stil.waitForCompletion(KumbaCoreConstants.SOMA_READ_TIMEOUT);
                    if (complete) {
                        logger.finer(() -> LMG.log("(): Done building cascade list for '%s->%s->%s->%s'.", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
                        continue;
                    }
                    logger.info(() -> LMG.log("(): Timed out building cascade list for '%s->%s->%s->%s'.", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
                    continue;
                }
                logger.finer(() -> LMG.log("(): Creating table row for '%s->%s->%s->%s'.", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
                DynamicBean row = new DynamicBean();
                row.setProperty(DELETE_COLUMN_NAME, !objectName.contains("default"));
                row.setProperty(DELETE_ORDER_COLUMN_NAME, 0);
                row.setProperty(APPLIANCE_COLUMN_NAME, appliance);
                row.setProperty(DOMAIN_COLUMN_NAME, domain);
                row.setProperty(OBJECT_TYPE_COLUMN_NAME, objectType);
                row.setProperty(OBJECT_NAME_COLUMN_NAME, objectName);
                row.setProperty(RREFERENCING_TYPE_COLUMN_NAME, "");
                row.setProperty(REFERENCING_NAME_COLUMN_NAME, "");
                row.setProperty(OBJECT_STATUS_COLUMN_NAME, selectedObject);
                this.tableModel.addRow(row);
            }
            if (cascade) {
                logger.finer("(): Waiting for all cascading digs to complete.");
                boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("DeleteObjectFinalWizardPanel.finalizeDataUpdate()", mtil, KumbaCoreConstants.STARTUP_DELAY, KumbaCoreConstants.THREAD_TIMEOUT * 5);
                if (!completedOnTime) {
                    logger.config("Timed out waiting for all threads to complete.");
                }
            }
            this.tableModel.setEditableColumns(DELETE_COLUMN_NAME);
            this.table.optimizeColumnWidths();
        }
        logger.finer("():  Removing duplicated objects.");
        this.removeDuplicates();
        logger.finer("(): Applying delete exceptions and finalizing UI.");
        this.applyObjectDeleteExceptions();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        this.nextButtonEnabled = true;
        this.parentDialog.manageButtonState();
        this.lastCascade = cascade;
        logger.finer("(): Done.");
    }

    @Reflected
    private void addRelatedObjects(ConfigurationRelationship configurationRelationship, ConfigurationRelationship parent, int level) {
        boolean deleteFiles = (Boolean)((DynamicBean)this.model).getProperty("deleteFiles");
        DataPowerConfig dataPowerObject = configurationRelationship.getObjectInFocus();
        if (dataPowerObject == null) {
            logger.warning("(ConfigurationRelationship, ConfigurationRelationship, level): dataPowerObject is null.  How?");
            return;
        }
        boolean isFile = dataPowerObject instanceof DataPowerFileInfo;
        if (isFile && !deleteFiles) {
            return;
        }
        Appliance appliance = dataPowerObject.getAppliance();
        Domain domain = dataPowerObject.getSourceDomain();
        String objectType = dataPowerObject.getConfigObjectType();
        StatusObjectStatus objectStatus = dataPowerObject.getStatus();
        if (isFile) {
            objectType = "File";
        }
        String objectName = dataPowerObject.getName();
        if (isFile) {
            String fileName = StringUtility.substringAfter(StringUtility.coalesce(objectName, "/"), ":/");
            if (StringUtility.containsAnyOf(objectName, "*?[]{}()") || StringUtility.isEmpty(fileName)) {
                logger.fine(() -> LMG.log("(ConfigurationRelationship, ConfigurationRelationship, level): File name '%s' appears invalid.  Skipping.", () -> objectName));
                return;
            }
            if (StringUtility.startsWithAnyOf(objectName, DataPowerFileUtility.DEFAULT_DOMAIN_FILESTORES)) {
                logger.fine(() -> LMG.log("(ConfigurationRelationship, ConfigurationRelationship, level): File name '%s' exists in default domain.  Fixing domain.", () -> objectName));
                domain = appliance.getDomain("default");
            }
        }
        DynamicBean row = new DynamicBean();
        row.setProperty(DELETE_COLUMN_NAME, true);
        row.setProperty(DELETE_ORDER_COLUMN_NAME, level);
        row.setProperty(APPLIANCE_COLUMN_NAME, appliance);
        row.setProperty(DOMAIN_COLUMN_NAME, domain);
        row.setProperty(OBJECT_TYPE_COLUMN_NAME, objectType);
        row.setProperty(OBJECT_NAME_COLUMN_NAME, objectName);
        row.setProperty(OBJECT_STATUS_COLUMN_NAME, objectStatus);
        String referencingType = "";
        String referencingName = "";
        if (parent != null) {
            DataPowerConfig parentObject = parent.getObjectInFocus();
            referencingType = parentObject.getConfigObjectType();
            referencingName = parentObject.getName();
        }
        row.setProperty(RREFERENCING_TYPE_COLUMN_NAME, referencingType);
        row.setProperty(REFERENCING_NAME_COLUMN_NAME, referencingName);
        this.tableModel.addRow(row);
        ArrayList<ConfigurationRelationship> relationships = configurationRelationship.getReferences();
        ++level;
        for (ConfigurationRelationship relationship : relationships) {
            this.addRelatedObjects(relationship, configurationRelationship, level);
        }
    }

    private void removeDuplicates() {
        logger.finer("(): Starting");
        ArrayList<DynamicBean> model = this.tableModel.getModelData(true);
        HashSet<Integer> objectHashes = new HashSet<Integer>();
        int r = model.size() - 1;
        while (r >= 0) {
            int rr = r;
            DynamicBean row = model.get(r);
            Appliance appliance = (Appliance)row.getProperty(APPLIANCE_COLUMN_NAME);
            Domain domain = (Domain)row.getProperty(DOMAIN_COLUMN_NAME);
            String objectType = (String)row.getProperty(OBJECT_TYPE_COLUMN_NAME);
            String objectName = (String)row.getProperty(OBJECT_NAME_COLUMN_NAME);
            Integer hash = Objects.hash(appliance, domain, objectType, objectName);
            if (objectHashes.contains(hash)) {
                logger.finer(() -> LMG.log("(): Removing row %d with hash %d for %s->%s->%s->%s", () -> rr, () -> (int)hash, () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
                this.tableModel.deleteRow(r);
            } else {
                logger.finer(() -> LMG.log("(): Adding hash %d of row %d for %s->%s->%s->%s", () -> (int)hash, () -> rr, () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
                objectHashes.add(hash);
            }
            --r;
        }
        logger.finer("(): Done");
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.tableModel.addTableModelListener(this);
        this.cbxSynchronize = ComponentFactory.createCheckbox(null, "Synchronize Delete Choices", "Synchronize changes to the delete choices by domain, object type and name", true, true, null, null, new Object[0]);
        this.btnSelectAll = ComponentFactory.createButton(KumbaCoreUIConstants.SELECT_ALL_ICON, null, "Set all objects to be delete", true, this, "setDeleteState", true);
        this.btnSelectNone = ComponentFactory.createButton(KumbaCoreUIConstants.SELECT_NONE_ICON, null, "Clear delete flags for all objects", true, this, "setDeleteState", false);
        this.btnSaveSelectedObjects = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ICON, null, "Create an export of objects selected to be deleted", true, this, "exportObjects", new Object[0]);
        this.btnAddObjectDeleteExceptions = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, null, "Add object exceptions", true, this, "addSelectedExceptions", new Object[0]);
        JMPanel controlActionsPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        controlActionsPanel.addAll(this.cbxSynchronize, ComponentFactory.createSpacer(50, 20), this.btnSelectAll, this.btnSelectNone);
        JMPanel manageExceptionsPanel = KumbaCoreUIConstants.createFlowLayoutPanel(2);
        manageExceptionsPanel.addAll(this.btnSaveSelectedObjects, ComponentFactory.createSpacer(20, 10), this.btnAddObjectDeleteExceptions);
        JMPanel optionsPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        optionsPanel.add((Component)controlActionsPanel, "West");
        optionsPanel.add((Component)manageExceptionsPanel, "East");
        panel.add((Component)optionsPanel, "North");
        this.loadObjectDeleteExceptions();
        return panel;
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        this.tableModel.addComputedExpression(APPLIANCE_COLUMN_NAME, "name");
        this.tableModel.addComputedExpression(DOMAIN_COLUMN_NAME, "name");
        return tableModel;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel columnModel = super.createColumnModel();
        columnModel.setColumnOrder(DELETE_COLUMN_NAME, APPLIANCE_COLUMN_NAME, DOMAIN_COLUMN_NAME, OBJECT_TYPE_COLUMN_NAME, OBJECT_NAME_COLUMN_NAME, RREFERENCING_TYPE_COLUMN_NAME, REFERENCING_NAME_COLUMN_NAME);
        columnModel.setColumnTitle(OBJECT_TYPE_COLUMN_NAME, "Type");
        columnModel.setColumnTitle(OBJECT_NAME_COLUMN_NAME, "Name");
        columnModel.setColumnTitle(REFERENCING_NAME_COLUMN_NAME, "Referenced By");
        this.columnModel.hideColumn(DELETE_ORDER_COLUMN_NAME);
        this.columnModel.hideColumn(OBJECT_STATUS_COLUMN_NAME);
        DeleteObjectTableCellRenderer cellRenderer = new DeleteObjectTableCellRenderer();
        this.columnModel.setRenderer(".*", (TableCellRenderer)cellRenderer);
        return columnModel;
    }

    private void loadObjectDeleteExceptions() {
        Application application;
        KumbaCoreApplicationProperties appProperties;
        String deleteExceptionsFileName;
        File deleteExceptionsFile;
        if (this.objectDeleteExceptions != null) {
            this.objectDeleteExceptions.clear();
            this.objectDeleteExceptions = null;
        }
        if ((deleteExceptionsFile = new File(deleteExceptionsFileName = (appProperties = (KumbaCoreApplicationProperties)(application = Application.getApplication()).getApplicationProperties()).getDeleteExceptionsFile().substring(1))).exists()) {
            this.objectDeleteExceptions = (ArrayList)FileUtility.readObject(deleteExceptionsFile, true);
        }
    }

    private void writeObjectDeleteExceptions() {
        if (CollectionUtility.isEmpty(this.objectDeleteExceptions)) {
            return;
        }
        Application application = Application.getApplication();
        KumbaCoreApplicationProperties appProperties = (KumbaCoreApplicationProperties)application.getApplicationProperties();
        String deleteExceptionsFileName = appProperties.getDeleteExceptionsFile().substring(1);
        File deleteExceptionsFile = new File(deleteExceptionsFileName);
        FileUtility.writeObject(deleteExceptionsFile, this.objectDeleteExceptions, true);
    }

    @Reflected
    private void setDeleteState(boolean state) {
        ArrayList<DynamicBean> allObjects = this.tableModel.getModelData(false);
        for (DynamicBean objectToDelete : allObjects) {
            objectToDelete.setProperty(DELETE_COLUMN_NAME, state);
        }
        this.table.repaint();
    }

    @Reflected
    private void exportObjects() {
        logger.finer("(): Starting");
        ArrayList<DynamicBean> deletedObjects = this.getDeleteObjectSelection();
        if (CollectionUtility.isEmpty(deletedObjects)) {
            logger.info("(): No objects selected for delete, therefore, no objects to export. Returning.");
            new JMMessageBox((JDialog)this.parentDialog, "Export Objects to Delete", "No objects are selected to be deleted.");
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        ArrayList<StatusObjectStatus> objectsToExport = new ArrayList<StatusObjectStatus>(deletedObjects.size());
        for (DynamicBean object : deletedObjects) {
            StatusObjectStatus objectToExport = (StatusObjectStatus)object.getProperty(OBJECT_STATUS_COLUMN_NAME);
            if (objectToExport == null) {
                logger.severe(() -> LMG.log("(): Object Status for %s->%s->%s->%s is null.", () -> object.getProperty(APPLIANCE_COLUMN_NAME), () -> object.getProperty(DOMAIN_COLUMN_NAME), () -> object.getProperty(OBJECT_TYPE_COLUMN_NAME), () -> object.getProperty(OBJECT_NAME_COLUMN_NAME)));
                continue;
            }
            objectsToExport.add(objectToExport);
        }
        logger.finer("(): Invoking export.");
        ExportOptions exportOptions = ExportConfiguration.createDefaultExportOptions();
        exportOptions.setAllFiles(false);
        ExportConfiguration.exportConfigurations(objectsToExport, exportOptions, null);
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        new JMMessageBox((JDialog)this.parentDialog, "Export Completed", "Export completed successfully.");
        logger.finer("(): Done");
    }

    @Reflected
    private void addSelectedExceptions() {
        int[] selectedRows = this.table.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            logger.info("(): No objects selected to be added to the exceptions.  Returning.");
            new JMMessageBox((JDialog)this.parentDialog, "Add Exceptions", "Please select one or more objects to add to the exception list.");
            return;
        }
        ArrayList<DynamicBean> selectedData = this.tableModel.getValues(selectedRows);
        if (this.objectDeleteExceptions == null) {
            this.objectDeleteExceptions = new ArrayList();
        }
        for (DynamicBean object : selectedData) {
            Domain domain = (Domain)object.getProperty(DOMAIN_COLUMN_NAME);
            String domainName = domain.getName();
            String objectType = (String)object.getProperty(OBJECT_TYPE_COLUMN_NAME);
            String objectName = (String)object.getProperty(OBJECT_NAME_COLUMN_NAME);
            DeleteObjectException exception = new DeleteObjectException(".*", this.toRegularExpression(domainName), this.toRegularExpression(objectType), this.toRegularExpression(objectName));
            this.objectDeleteExceptions.add(exception);
        }
        this.writeObjectDeleteExceptions();
        this.applyObjectDeleteExceptions();
        new JMMessageBox((JDialog)this.parentDialog, "Selections Added", "The selected exceptions were successfully added.");
    }

    private String toRegularExpression(String plainExpression) {
        return String.format("(?i)^%s$", plainExpression.toLowerCase());
    }

    private void applyObjectDeleteExceptions() {
        if (CollectionUtility.isEmpty(this.objectDeleteExceptions)) {
            return;
        }
        ArrayList<DynamicBean> allObjects = this.tableModel.getModelData(false);
        for (DynamicBean objectToDelete : allObjects) {
            Appliance appliance = (Appliance)objectToDelete.getProperty(APPLIANCE_COLUMN_NAME);
            String applianceName = appliance.getName();
            Domain domain = (Domain)objectToDelete.getProperty(DOMAIN_COLUMN_NAME);
            String domainName = domain.getName();
            String objectType = (String)objectToDelete.getProperty(OBJECT_TYPE_COLUMN_NAME);
            String objectName = (String)objectToDelete.getProperty(OBJECT_NAME_COLUMN_NAME);
            for (DeleteObjectException exception : this.objectDeleteExceptions) {
                if (!applianceName.matches(exception.getApplianceExpression()) || !domainName.matches(exception.getDomainExpression()) || !objectType.matches(exception.getObjectTypeExpression()) || !objectName.matches(exception.getObjectNameExpression())) continue;
                objectToDelete.setProperty(DELETE_COLUMN_NAME, false);
            }
        }
        this.table.repaint();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() != 0) {
            return;
        }
        if (!this.cbxSynchronize.isSelected()) {
            return;
        }
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (row < 0 || column < 0) {
            return;
        }
        DynamicBean rowValue = this.tableModel.getValue(row);
        Domain domain = (Domain)rowValue.getProperty(DOMAIN_COLUMN_NAME);
        String domainName = domain.getName();
        String objectType = (String)rowValue.getProperty(OBJECT_TYPE_COLUMN_NAME);
        String objectName = (String)rowValue.getProperty(OBJECT_NAME_COLUMN_NAME);
        boolean deleteValue = (Boolean)rowValue.getProperty(DELETE_COLUMN_NAME);
        int r = 0;
        while (r < this.tableModel.getRowCount()) {
            if (r != row) {
                DynamicBean rValue = this.tableModel.getValue(r);
                Domain otherDomain = (Domain)rValue.getProperty(DOMAIN_COLUMN_NAME);
                String otherDomainName = otherDomain.getName();
                String otherObjectType = (String)rValue.getProperty(OBJECT_TYPE_COLUMN_NAME);
                String otherObjectName = (String)rValue.getProperty(OBJECT_NAME_COLUMN_NAME);
                if (otherDomainName.equals(domainName) && otherObjectType.equals(objectType) && otherObjectName.equals(objectName)) {
                    rValue.setProperty(DELETE_COLUMN_NAME, deleteValue);
                }
            }
            ++r;
        }
        try {
            Robot robot = new Robot();
            robot.keyPress(9);
            robot.keyRelease(9);
        }
        catch (AWTException awtException) {
            awtException.printStackTrace();
        }
        this.table.repaint(50L);
    }
}

