/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.fileWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.ui.models.DataPowerFileInfoColumnModel;
import com.kumbasoft.core.ui.models.DataPowerFileInfoTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class NewFileReviewWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private BeanTableModel<DataPowerFileInfo> tableModel;
    private BeanColumnModel<DataPowerFileInfo> columnModel;
    private JMTable table;

    public NewFileReviewWizardPage(DynamicBean model) {
        super(model);
    }

    public NewFileReviewWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void updateControls() {
        this.tableModel.reset();
        String baseDirectory = (String)((DynamicBean)this.model).getProperty("selectedDirectory");
        String newDirectory = (String)((DynamicBean)this.model).getProperty("newDirectory");
        if (StringUtility.isEmpty(newDirectory)) {
            newDirectory = null;
        }
        String newFileName = (String)((DynamicBean)this.model).getProperty("newFileName");
        Index nameIndex = (Index)((DynamicBean)this.model).getProperty("directoryIndex");
        Collection destinations = nameIndex.get(baseDirectory);
        ArrayList<DataPowerFileInfo> destinationFiles = new ArrayList<DataPowerFileInfo>();
        for (DataPowerFileInfo destinationDir : destinations) {
            DataPowerFileInfo destinationFile = BeanService.getClone(destinationDir);
            Object baseDir = null;
            baseDir = newDirectory != null ? baseDirectory + newDirectory : destinationFile.getAbsolutePath();
            baseDir = StringUtility.coalesce((String)baseDir, "/");
            destinationFile.setBaseDirectory((String)baseDir);
            destinationFile.setFileName(newFileName);
            String fullName = String.format("%s/%s", baseDir, newFileName);
            destinationFile.setName(fullName);
            destinationFiles.add(destinationFile);
        }
        this.tableModel.addAll(destinationFiles);
        this.table.optimizeColumnWidths();
    }

    @Override
    protected void saveDataToModel() {
        ArrayList<DataPowerFileInfo> newFiles = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("finalData", newFiles);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.tableModel = new DataPowerFileInfoTableModel("name", "name");
        this.columnModel = new DataPowerFileInfoColumnModel();
        this.columnModel.hideColumns("baseDirectory", "fileName", "fileDate", "fileSize", "fileStore", "fileData", "isReadOnly", "deleteable", "status", "fQON");
        this.columnModel.setColumnTitle("name", "New File");
        this.table = new JMTable(this.tableModel, this.columnModel);
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        panel.add((Component)new JMScrollPane(this.table), "Center");
        return panel;
    }
}

