/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.fileWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JDialog;

public class SearchReplaceExpressionsPage
extends AbstractTableWizardPage
implements ConfigObjectSubscriber<DataPowerFileInfo> {
    private static ArrayList<DynamicBean> lastSearchReplaceExpressions;
    private JMButton btnAdd;
    private JMButton btnDelete;
    private ArrayList<DataPowerFileInfo> dataPowerFiles;

    public SearchReplaceExpressionsPage(DynamicBean model) {
        super(model);
        new AsynchMethodInvoker((Object)this, "readAllFiles");
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.btnAdd = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, null, "Add new searcn and replace expressions", true, this, "editAdd", new Object[0]);
        this.btnDelete = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, null, "Delete the select searcn and replace expressions", false, this, "editDelete", new Object[0]);
        JMPanel buttonPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        buttonPanel.addAll(this.btnAdd, this.btnDelete);
        panel.add((Component)buttonPanel, "North");
        this.tableModel.setEditable();
        if (CollectionUtility.isEmpty(lastSearchReplaceExpressions)) {
            new AsynchMethodInvoker((Object)this, "editAdd", KumbaCoreConstants.STARTUP_DELAY);
        }
        return panel;
    }

    @Override
    protected void setParentDialog(WizardDialog dialog) {
        super.setParentDialog(dialog);
        this.parentDialog.manageButtonState();
    }

    @Override
    public boolean isNextButtonEnabled() {
        return this.tableModel.getRowCount() > 0;
    }

    @Reflected
    private void editAdd() {
        DynamicBean newRow = new DynamicBean();
        newRow.setProperty("searchExpression", "");
        newRow.setProperty("replaceExpression", "");
        this.tableModel.addRow(newRow);
        this.columnModel.setColumnWidth("searchExpression", 300);
        this.columnModel.setColumnWidth("replaceExpression", 300);
        this.btnDelete.setEnabled(true);
        if (this.parentDialog != null) {
            this.parentDialog.manageButtonState();
        }
    }

    @Reflected
    private void editDelete() {
        this.table.commitEdits();
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        new JMMessageBox((JDialog)this.parentDialog, "Delete Rows", "Are you sure you want to delete all selected rows", 12);
        if (JMMessageBox.getSelection() == 8) {
            return;
        }
        this.tableModel.deleteAll(selectedRows);
        this.btnDelete.setEnabled(this.tableModel.getRowCount() > 0);
        this.parentDialog.manageButtonState();
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel columnModel = super.createColumnModel();
        columnModel.setColumnOrder("searchExpression", "replaceExpression");
        return columnModel;
    }

    @Override
    protected void updateControls() {
        if (CollectionUtility.isNotEmpty(lastSearchReplaceExpressions)) {
            this.tableModel.addAll(lastSearchReplaceExpressions);
            this.btnDelete.setEnabled(true);
        }
        super.updateControls();
    }

    @Override
    protected void saveDataToModel() {
        logger.finer("(): Starting");
        this.table.commitEdits();
        ArrayList<DynamicBean> searchReplaceExpressions = this.tableModel.getModelData(false);
        ((DynamicBean)this.model).setProperty("searchAndReplaceValues", searchReplaceExpressions);
        lastSearchReplaceExpressions = searchReplaceExpressions;
        logger.finer("(): Done.");
    }

    @Reflected
    private void readAllFiles() {
        logger.finer("(): Starting");
        this.dataPowerFiles = new ArrayList();
        ArrayList filesToSearch = (ArrayList)((DynamicBean)this.model).getProperty("selectedFiles");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        DataPowerFileReader.readFiles(filesToSearch, mtil, this);
        logger.finer("(): Waiting for files to be read off of the appliances.");
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("SearchReplaceExpressionPage.readAllFiles()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            logger.info("(): Timed out reading all files.  There may be files missing in the final page.");
        } else {
            logger.finer("(): All files finished reading in time.");
        }
        ((DynamicBean)this.model).setProperty("filesToSearch", this.dataPowerFiles);
        logger.finer("(): Done");
    }

    @Override
    public void processDataPowerConfig(DataPowerFileInfo dataPowerConfig) {
        this.dataPowerFiles.add(dataPowerConfig);
    }

    @Override
    public void configProcessingComplete() {
        logger.finer("(): Starting");
        logger.finer("(): Done");
    }
}

