/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.fileWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.RowFocusEvent;
import com.jmorgan.swing.table.RowFocusListener;
import com.jmorgan.swing.util.ScrollSynchronizer;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JEditorPane;

public class SearchReplaceFinalPage
extends AbstractTableWizardPage
implements RowFocusListener {
    private JEditorPane sourcePane;
    private JEditorPane replacePane;
    private ScrollSynchronizer scrollSynchronizer;
    private int lastSelectedRow = -1;

    public SearchReplaceFinalPage(DynamicBean model) {
        super(model);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.sourcePane = new JEditorPane();
        this.sourcePane.setEditable(false);
        this.sourcePane.setPreferredSize(new Dimension(400, 400));
        this.sourcePane.setMaximumSize(new Dimension(600, 500));
        this.replacePane = new JEditorPane();
        this.replacePane.setPreferredSize(new Dimension(400, 400));
        this.replacePane.setMaximumSize(new Dimension(600, 500));
        JMScrollPane sourceScroller = new JMScrollPane(this.sourcePane);
        sourceScroller.setPreferredSize(new Dimension(400, 400));
        sourceScroller.setMaximumSize(new Dimension(600, 500));
        JMScrollPane replaceScroller = new JMScrollPane(this.replacePane);
        replaceScroller.setPreferredSize(new Dimension(400, 400));
        replaceScroller.setMaximumSize(new Dimension(600, 500));
        this.scrollSynchronizer = new ScrollSynchronizer(sourceScroller, replaceScroller);
        JMPanel textPanel = KumbaCoreUIConstants.createGridLayoutPanel(1, 2);
        textPanel.addAll(sourceScroller, replaceScroller);
        panel.add((Component)textPanel, "South");
        return panel;
    }

    @Override
    protected JMTable getTable() {
        JMTable table = super.getTable();
        table.setSelectionMode(0);
        table.addRowFocusListener(this);
        table.setPreferredSize(new Dimension(800, 300));
        return table;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel model = super.createColumnModel();
        model.hideColumns("dataPowerFileInfo", "changedFileContent");
        model.setColumnOrder("appliance", "domain", "fileName");
        return model;
    }

    @Override
    protected void updateControls() {
        logger.finer("(): Starting");
        this.table.clearSelection();
        this.lastSelectedRow = -1;
        this.sourcePane.setText("");
        this.replacePane.setText("");
        if (this.tableModel.getRowCount() > 0) {
            this.tableModel.reset();
        }
        try {
            ArrayList filesToSearch = (ArrayList)((DynamicBean)this.model).getProperty("filesToSearch");
            logger.finer(() -> LMG.log("(): %d files to process.", () -> filesToSearch.size()));
            for (DataPowerFileInfo dpFileInfo : filesToSearch) {
                Appliance appliance = dpFileInfo.getAppliance();
                Domain domain = dpFileInfo.getSourceDomain();
                String fileName = dpFileInfo.getAbsolutePath();
                DynamicBean row = new DynamicBean();
                row.setProperty("appliance", appliance.getName());
                row.setProperty("domain", domain.getName());
                row.setProperty("fileName", fileName);
                row.setProperty("dataPowerFileInfo", dpFileInfo);
                row.setProperty("changedFileContent", "");
                logger.finer(() -> LMG.log("(): Adding %s->%s->%s.", () -> appliance.getName(), () -> domain.getName(), () -> fileName));
                this.tableModel.addRow(row);
            }
        }
        catch (PropertyNotFoundException e) {
            logger.finer("(): Files to search not found.  Likely means they all haven't been read yet.  Trying again.");
            new AsynchMethodInvoker((Object)this, "updateControls", KumbaCoreConstants.THREAD_WAIT);
            return;
        }
        this.table.optimizeColumnWidths();
        this.applySearchAndReplace();
        logger.finer("(): Done");
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    public void rowFocusChange(RowFocusEvent event) {
        if (this.lastSelectedRow != -1) {
            this.saveChangedContent();
        }
        int selectedRow = this.table.getSelectedRow();
        DynamicBean selectedBean = this.tableModel.getValue(selectedRow);
        DataPowerFileInfo fileInfo = (DataPowerFileInfo)selectedBean.getProperty("dataPowerFileInfo");
        String sourceText = fileInfo.getFileContent();
        String changedFileContent = (String)selectedBean.getProperty("changedFileContent");
        String mimeType = FileUtility.getMimeType(fileInfo.getFileName());
        this.sourcePane.setContentType(mimeType);
        this.replacePane.setContentType(mimeType);
        this.sourcePane.setText(sourceText);
        this.replacePane.setText(changedFileContent);
        this.lastSelectedRow = selectedRow;
    }

    private void applySearchAndReplace() {
        logger.finer("(): Starting");
        ArrayList searchReplaceExpressions = (ArrayList)((DynamicBean)this.model).getProperty("searchAndReplaceValues");
        ArrayList<DynamicBean> fileData = this.tableModel.getModelData(false);
        for (DynamicBean row : fileData) {
            String originalContent;
            DataPowerFileInfo file = (DataPowerFileInfo)row.getProperty("dataPowerFileInfo");
            logger.finer(() -> LMG.log("(): Applying S&R to '%s'", () -> file.getFQON()));
            String changedContent = originalContent = file.getFileContent();
            for (DynamicBean searchReplaceExpression : searchReplaceExpressions) {
                String searchExpression = (String)searchReplaceExpression.getProperty("searchExpression");
                String replaceExpression = (String)searchReplaceExpression.getProperty("replaceExpression");
                changedContent = changedContent.replaceAll(searchExpression, replaceExpression);
            }
            row.setProperty("changedFileContent", changedContent);
            logger.finer(() -> LMG.log("(): Replace complete on '%s'", () -> file.getFQON()));
        }
        logger.finer("(): Done");
    }

    private void saveChangedContent() {
        DynamicBean selectedBean = this.tableModel.getValue(this.lastSelectedRow);
        String changedFileContent = this.replacePane.getText();
        selectedBean.setProperty("changedFileContent", changedFileContent);
    }

    @Override
    protected void saveDataToModel() {
        ArrayList<DynamicBean> allData = this.tableModel.getModelData(false);
        ArrayList<DataPowerFileInfo> filesToSave = new ArrayList<DataPowerFileInfo>();
        for (DynamicBean row : allData) {
            DataPowerFileInfo fileInfo = (DataPowerFileInfo)row.getProperty("dataPowerFileInfo");
            String originalContent = fileInfo.getFileContent();
            String changedFileContent = (String)row.getProperty("changedFileContent");
            if (StringUtility.isEmpty(changedFileContent) || originalContent.equals(changedFileContent)) continue;
            fileInfo.setFileContent(changedFileContent);
            filesToSave.add(fileInfo);
        }
        ((DynamicBean)this.model).setProperty("filesToUpload", filesToSave);
    }
}

