/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.initWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.DirectoryFileChooser;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

public class InitWizardPreferencesPage
extends KumbaCoreWizardPage<DPAAApplicationProperties> {
    private static final int LABEL_WIDTH = 150;
    private static final int FIELD_WIDTH = 400;
    private JMTextField tfLogsDirectory;
    private JMTextField tfCertificateFiles;
    private JMTextField tfCLIScriptsDirectory;
    private JMTextField tfConfigExportsDirectory;
    private JMTextField tfDomainBackupsDirectory;
    private JMTextField tfErrorReportsDirectory;
    private JMTextField tfFileBackupDirectory;
    private JMTextField tfPacketCaptureDirectory;
    private JMTextField tfSnapshotsDirectory;

    public InitWizardPreferencesPage(DPAAApplicationProperties model) {
        super(model);
    }

    @Override
    protected void saveDataToModel() {
        ((DPAAApplicationProperties)this.model).setLogsDirectory(this.tfLogsDirectory.getText());
        ((DPAAApplicationProperties)this.model).setCertificateFileDirectory(this.tfCertificateFiles.getText());
        ((DPAAApplicationProperties)this.model).setCliScriptsDirectory(this.tfCLIScriptsDirectory.getText());
        ((DPAAApplicationProperties)this.model).setConfigExportsDirectory(this.tfConfigExportsDirectory.getText());
        ((DPAAApplicationProperties)this.model).setDomainBackupsDirectory(this.tfDomainBackupsDirectory.getText());
        ((DPAAApplicationProperties)this.model).setErrorReportsDirectory(this.tfErrorReportsDirectory.getText());
        ((DPAAApplicationProperties)this.model).setFileBackupDirectory(this.tfFileBackupDirectory.getText());
        ((DPAAApplicationProperties)this.model).setPacketCaptureDirectory(this.tfPacketCaptureDirectory.getText());
        ((DPAAApplicationProperties)this.model).setSnapShotsDirectory(this.tfSnapshotsDirectory.getText());
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(new VerticalFlowLayout(0));
        this.tfLogsDirectory = this.createField(panel, "Logs Directory:", ((DPAAApplicationProperties)this.model).getLogsDirectory());
        this.tfCertificateFiles = this.createField(panel, "Certificate Files:", ((DPAAApplicationProperties)this.model).getCertificateFileDirectory());
        this.tfSnapshotsDirectory = this.createField(panel, "Snapshots:", ((DPAAApplicationProperties)this.model).getSnapShotsDirectory());
        this.tfCLIScriptsDirectory = this.createField(panel, "CLI Scripts:", ((DPAAApplicationProperties)this.model).getCliScriptsDirectory());
        this.tfConfigExportsDirectory = this.createField(panel, "Configuration Exports:", ((DPAAApplicationProperties)this.model).getConfigExportsDirectory());
        this.tfDomainBackupsDirectory = this.createField(panel, "Domain Backups:", ((DPAAApplicationProperties)this.model).getDomainBackupsDirectory());
        this.tfFileBackupDirectory = this.createField(panel, "File Backups:", ((DPAAApplicationProperties)this.model).getFileBackupDirectory());
        this.tfPacketCaptureDirectory = this.createField(panel, "Packet Captures:", ((DPAAApplicationProperties)this.model).getPacketCaptureDirectory());
        this.tfErrorReportsDirectory = this.createField(panel, "Error Reports:", ((DPAAApplicationProperties)this.model).getErrorReportsDirectory());
        return panel;
    }

    private JMTextField createField(JMPanel panel, String label, String initialValue) {
        JMTextField tf = new JMTextField(initialValue);
        JMButton btnOpenDir = new JMButton("...");
        new ActionEventInvoker(btnOpenDir, this, "browseForDirectory", label, tf);
        JMPanel tfAndButton = new JMPanel(new BorderLayout(10, 1));
        tfAndButton.add((Component)tf, "Center");
        tfAndButton.add((Component)btnOpenDir, "East");
        LabeledComponent lc = new LabeledComponent(label, (Component)tfAndButton, 150, 400);
        panel.add(lc);
        return tf;
    }

    @Reflected
    private void browseForDirectory(String label, JMTextField tf) {
        DirectoryFileChooser fileSelector;
        int selection;
        File directory = null;
        String directoryName = tf.getText();
        if (!(StringUtility.isEmpty(directoryName) || (directory = new File(directoryName)).isDirectory() && directory.exists())) {
            directory = null;
        }
        if ((selection = (fileSelector = new DirectoryFileChooser(directory, label)).showOpenDialog(this)) == 0) {
            tf.setText(fileSelector.getSelectedFile().getAbsolutePath());
        }
    }
}

