/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.IPAddress;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.status.StatusIPAddressStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JDialog;

public class AddIPNewIPWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private JMTextField tfIPList;
    private JMCheckBox cbxCreateHAs;
    private JMTextField tfHAList;

    public AddIPNewIPWizardPage(DynamicBean model) {
        super(model);
    }

    public AddIPNewIPWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isDataValid() {
        boolean isPrimary = (Boolean)((DynamicBean)this.model).getProperty("isPrimary");
        boolean isStandby = (Boolean)((DynamicBean)this.model).getProperty("isStandby");
        Index allIPs = (Index)((DynamicBean)this.model).getProperty("allIPs");
        String ipText = this.tfIPList.getText();
        UniqueArrayList<String> ipList = AddIPNewIPWizardPage.processList(ipText);
        if (isPrimary && ipList.size() > 1) {
            new JMMessageBox((JDialog)this.parentDialog, "Invalid Configuration", "You can't have more than one IP assigned as a Primary IP");
            return false;
        }
        StringBuilder newIPList = new StringBuilder();
        for (String ip : ipList) {
            String ipAddressStr;
            String cleanIPAddressStr;
            block14: {
                try {
                    IPAddress ipAddress = new IPAddress(ip);
                    if (newIPList.length() > 0) {
                        newIPList.append(", ");
                    }
                    if (!allIPs.containsKey(cleanIPAddressStr = StringUtility.substringBefore(ipAddressStr = ipAddress.toString(), "/"))) break block14;
                    ArrayList currentIPs = (ArrayList)allIPs.get(cleanIPAddressStr);
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < currentIPs.size()) {
                        if (i == currentIPs.size() - 1) {
                            sb.append(" and an ");
                        } else if (i > 0) {
                            sb.append(", an ");
                        }
                        StatusIPAddressStatus currentIP = (StatusIPAddressStatus)currentIPs.get(i);
                        String applianceName = currentIP.getAppliance().getName();
                        sb.append(currentIP.getName());
                        sb.append(" on ");
                        sb.append(applianceName);
                        ++i;
                    }
                    new JMMessageBox((JDialog)this.parentDialog, "Invalid Configuration", String.format("The IP %s already exists as an %s.", cleanIPAddressStr, sb.toString()));
                    return false;
                }
                catch (Exception e) {
                    new JMMessageBox((JDialog)this.parentDialog, "Invalid IP Address", String.format("The IP %s is not valid", ip));
                    return false;
                }
            }
            if (isStandby) {
                ipAddressStr = cleanIPAddressStr;
            }
            newIPList.append(ipAddressStr);
        }
        this.tfIPList.setText(newIPList.toString());
        if (this.cbxCreateHAs.isSelected()) {
            String haList = this.tfHAList.getText();
            UniqueArrayList<String> has = AddIPNewIPWizardPage.processList(haList);
            if (has.size() != ipList.size()) {
                new JMMessageBox((JDialog)this.parentDialog, "Invalid Configuration", "The number of host aliases must match the number of IP addresses");
                return false;
            }
            for (String ha : has) {
                if (!ha.startsWith("eth")) continue;
                new JMMessageBox((JDialog)this.parentDialog, "Invalid Configuration", "Host Alias names beginning with 'eth' are reserved.");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        boolean createHostAliases = this.cbxCreateHAs.isSelected();
        ((DynamicBean)this.model).setProperty("createHostAliases", createHostAliases);
        String ipList = this.tfIPList.getText();
        ((DynamicBean)this.model).setProperty("newIPs", AddIPNewIPWizardPage.processList(ipList));
        if (createHostAliases) {
            String haList = this.tfHAList.getText();
            ((DynamicBean)this.model).setProperty("hostAliases", AddIPNewIPWizardPage.processList(haList));
        } else {
            ((DynamicBean)this.model).setProperty("hostAliases", null);
        }
    }

    private static UniqueArrayList<String> processList(String list) {
        if (StringUtility.isEmpty(list)) {
            return null;
        }
        String[] listItems = list.split(",");
        UniqueArrayList<String> listElements = new UniqueArrayList<String>();
        String[] stringArray = listItems;
        int n = listItems.length;
        int n2 = 0;
        while (n2 < n) {
            String listItem = stringArray[n2];
            if (!StringUtility.isEmpty(listItem)) {
                listElements.add(listItem.trim());
            }
            ++n2;
        }
        return listElements;
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createVerticalFlowLayout(0));
        this.tfIPList = new JMTextField();
        ComponentService.addClearIcon(this.tfIPList, "Clear the search expression from the field.");
        ComponentService.addHelpIcon(this.tfIPList, "Enter multiple IP addresses separated by commas");
        LabeledComponent lblIPList = new LabeledComponent("IP List:", (Component)this.tfIPList, 100, 300);
        this.cbxCreateHAs = new JMCheckBox("Create Host Aliases?");
        String haHelpText = "Enter a list of host aliases matching one to one with the list of IP addresses in the IP List above.";
        this.tfHAList = new JMTextField();
        ComponentService.addHelpIcon(this.tfHAList, haHelpText);
        ComponentService.addClearIcon(this.tfHAList, "Cleat the list of host aliases");
        this.tfHAList.setEnabled(false);
        LabeledComponent lblHAList = new LabeledComponent("HA List:", (Component)this.tfHAList, 100, 300);
        panel.addAll(lblIPList, this.cbxCreateHAs, lblHAList);
        MethodInvoker getSelectedMethodPointer = new MethodInvoker((Object)this.cbxCreateHAs, "isSelected", new Object[0]);
        new ItemEventInvoker(this.cbxCreateHAs, this.tfHAList, "setEnabled", getSelectedMethodPointer);
        return panel;
    }
}

