/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.config.ConfigIPInterface;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.panels.configurations.ManageIPPanel;
import java.awt.Component;
import java.util.ArrayList;

public class AddIPPreviewWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable table;

    public AddIPPreviewWizardPage(DynamicBean model) {
        super(model);
    }

    public AddIPPreviewWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void updateControls() {
        ArrayList selectedAppliances = (ArrayList)((DynamicBean)this.model).getProperty("appliances");
        ArrayList<ConfigIPInterface> selectedInterfaces = this.getSelectedInterfaces("isEthernet", "ethernetInterface", "ethernetInterfaces");
        if (selectedInterfaces == null) {
            selectedInterfaces = this.getSelectedInterfaces("isLinkAggregation", "linkAggInterface", "linkAggregationInterfaces");
        }
        if (selectedInterfaces == null) {
            selectedInterfaces = this.getSelectedInterfaces("isVLAN", "vlanInterface", "vlanInterfaces");
        }
        ((DynamicBean)this.model).setProperty("selectedInterfaces", selectedInterfaces);
        boolean isStandby = (Boolean)((DynamicBean)this.model).getProperty("isStandby");
        boolean isPrimary = (Boolean)((DynamicBean)this.model).getProperty("isPrimary");
        boolean isSecondary = (Boolean)((DynamicBean)this.model).getProperty("isSecondary");
        ArrayList newIPs = (ArrayList)((DynamicBean)this.model).getProperty("newIPs");
        boolean createHAs = (Boolean)((DynamicBean)this.model).getProperty("createHostAliases");
        ArrayList newHAs = (ArrayList)((DynamicBean)this.model).getProperty("hostAliases");
        this.tableModel.reset();
        for (Appliance appliance : selectedAppliances) {
            ConfigIPInterface matchingInterface = ManageIPPanel.getInterfaceOfAppliance(appliance, selectedInterfaces);
            int i = 0;
            while (i < newIPs.size()) {
                String newIP = (String)newIPs.get(i);
                String hostAlias = createHAs ? (String)newHAs.get(i) : "";
                DynamicBean ipRow = new DynamicBean();
                ipRow.setProperty("appliance", appliance);
                ipRow.setProperty("interface", matchingInterface);
                ipRow.setProperty("newIP", newIP);
                ipRow.setProperty("hostAlias", hostAlias);
                ipRow.setProperty("primary", isPrimary);
                ipRow.setProperty("standby", isStandby);
                ipRow.setProperty("secondary", isSecondary);
                this.tableModel.addRow(ipRow);
                ++i;
            }
        }
    }

    private ArrayList<ConfigIPInterface> getSelectedInterfaces(String booleanPropertyName, String selectedInterfaceName, String interfacesPropertyName) {
        boolean isType = (Boolean)((DynamicBean)this.model).getProperty(booleanPropertyName);
        if (!isType) {
            return null;
        }
        String interfaceName = (String)((DynamicBean)this.model).getProperty(selectedInterfaceName);
        ArrayList interfaces = (ArrayList)((DynamicBean)this.model).getProperty(interfacesPropertyName);
        ArrayList<ConfigIPInterface> selectedInterfaces = new ArrayList<ConfigIPInterface>();
        for (ConfigIPInterface i : interfaces) {
            if (!i.getName().equals(interfaceName)) continue;
            selectedInterfaces.add(i);
        }
        return selectedInterfaces;
    }

    @Override
    protected void saveDataToModel() {
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        JMLabel tableLabel = new JMLabel("IP Creation Review");
        panel.add((Component)tableLabel, "North");
        this.tableModel = new DynamicBeanTableModel();
        this.tableModel.addComputedExpression("appliance", "name");
        this.tableModel.addComputedExpression("interface", "name");
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        this.columnModel.setColumnOrder("appliance", "interface", "newIP", "hostAlias", "primary", "standby", "secondary");
        this.table = new JMTable(this.tableModel, this.columnModel);
        panel.add(new JMScrollPane(this.table));
        return panel;
    }
}

