/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JScrollPane;

public class TCPConnectionTestWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private static final String STANDARD_PORTS = "standardPorts";
    private static final String PORT_LIST = "portList";
    private static final String DETAIL_PORTS = "detailTable";
    private static final String PORT_DELIMITER = "[,; ]";
    private JMRadioButton rbStandardPorts;
    private JMRadioButton rbProvidedPorts;
    private JMRadioButton rbCustomizedPorts;
    private JMCheckBox cbxPort80;
    private JMCheckBox cbxPort443;
    private JMCheckBox cbxPort8080;
    private JMCheckBox cbxPort8443;
    private JMTextField tfPortList;
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable ipTable;
    private CardLayout cardLayout;

    public TCPConnectionTestWizardPage(DynamicBean model) {
        super(model);
    }

    public TCPConnectionTestWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isDataValid() {
        this.ipTable.commitEdits();
        int portCount = 0;
        if (this.cbxPort80.isSelected()) {
            ++portCount;
        }
        if (this.cbxPort443.isSelected()) {
            ++portCount;
        }
        if (this.cbxPort8080.isSelected()) {
            ++portCount;
        }
        if (this.cbxPort8443.isSelected()) {
            ++portCount;
        }
        String portList = this.tfPortList.getText();
        portCount += TCPConnectionTestWizardPage.countPorts(portList);
        ArrayList ipPorts = (ArrayList)((DynamicBean)this.model).getProperty("ipPortData");
        for (DynamicBean ipPort : ipPorts) {
            String ipPortList = (String)ipPort.getProperty("ports");
            portCount += TCPConnectionTestWizardPage.countPorts(ipPortList);
        }
        return portCount > 0;
    }

    private static int countPorts(String portList) {
        String[] ports;
        if (StringUtility.isEmpty(portList)) {
            return 0;
        }
        int portCount = 0;
        String[] stringArray = ports = portList.split(PORT_DELIMITER);
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            if (!StringUtility.isEmpty(port) && NumberUtility.isInteger(port) && TCPConnectionTestWizardPage.isPortValid(port)) {
                ++portCount;
            }
            ++n2;
        }
        return portCount;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        this.ipTable.commitEdits();
        UniqueArrayList<Integer> universalPorts = new UniqueArrayList<Integer>();
        if (this.cbxPort80.isSelected()) {
            universalPorts.add(80);
        }
        if (this.cbxPort443.isSelected()) {
            universalPorts.add(443);
        }
        if (this.cbxPort8080.isSelected()) {
            universalPorts.add(8080);
        }
        if (this.cbxPort8443.isSelected()) {
            universalPorts.add(8443);
        }
        String portList = this.tfPortList.getText();
        TCPConnectionTestWizardPage.addPorts(portList, universalPorts);
        ArrayList ipPorts = (ArrayList)((DynamicBean)this.model).getProperty("ipPortData");
        for (DynamicBean ipPort : ipPorts) {
            String ipPortList = (String)ipPort.getProperty("ports");
            UniqueArrayList<Integer> aiPorts = new UniqueArrayList<Integer>(universalPorts);
            TCPConnectionTestWizardPage.addPorts(ipPortList, aiPorts);
            ipPort.setProperty("allPorts", aiPorts);
        }
    }

    private static void addPorts(String portList, UniqueArrayList<Integer> ports) {
        if (!StringUtility.isEmpty(portList)) {
            String[] listedPorts;
            String[] stringArray = listedPorts = portList.split(PORT_DELIMITER);
            int n = listedPorts.length;
            int n2 = 0;
            while (n2 < n) {
                int port;
                String listedPort = stringArray[n2];
                if (!StringUtility.isEmpty(listedPort) && NumberUtility.isInteger(listedPort) && TCPConnectionTestWizardPage.isPortValid(port = Integer.parseInt(listedPort))) {
                    ports.add(port);
                }
                ++n2;
            }
        }
    }

    private static boolean isPortValid(int port) {
        return port > 0 && port < 65536;
    }

    private static boolean isPortValid(String port) {
        if (StringUtility.isEmpty(port) || !NumberUtility.isInteger(port)) {
            return false;
        }
        return TCPConnectionTestWizardPage.isPortValid(Integer.parseInt(port));
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel controls = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        this.rbStandardPorts = new JMRadioButton("Standard Ports", true);
        this.rbProvidedPorts = new JMRadioButton("List Ports");
        this.rbCustomizedPorts = new JMRadioButton("Custom Ports");
        new JMButtonGroup(this.rbStandardPorts, this.rbProvidedPorts, this.rbCustomizedPorts);
        JMPanel portTypeChoices = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        portTypeChoices.addAll(this.rbStandardPorts, this.rbProvidedPorts, this.rbCustomizedPorts);
        this.cbxPort80 = new JMCheckBox("Port 80");
        this.cbxPort443 = new JMCheckBox("Port 443");
        this.cbxPort8080 = new JMCheckBox("Port 8080");
        this.cbxPort8443 = new JMCheckBox("Port 8443");
        JMPanel stdPortPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        stdPortPanel.addAll(this.cbxPort80, this.cbxPort443, this.cbxPort8080, this.cbxPort8443);
        this.tfPortList = new JMTextField();
        LabeledComponent lblPortList = new LabeledComponent("Port List:", (Component)this.tfPortList, 1, 75, 600);
        JMPanel portListPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        portListPanel.add((Component)lblPortList, "Center");
        this.tableModel = new DynamicBeanTableModel();
        this.tableModel.setEditableColumns("ports");
        this.tableModel.addComputedExpression("appliance", "name");
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        ArrayList modelData = (ArrayList)((DynamicBean)this.model).getProperty("ipPortData");
        this.tableModel.addAll(modelData);
        this.ipTable = new JMTable(this.tableModel, this.columnModel);
        this.ipTable.optimizeColumnWidths();
        JMPanel tablePanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        tablePanel.add(new JScrollPane(this.ipTable));
        this.cardLayout = new CardLayout();
        JMPanel panels = new JMPanel(this.cardLayout);
        panels.add((Component)stdPortPanel, STANDARD_PORTS);
        panels.add((Component)portListPanel, PORT_LIST);
        panels.add((Component)tablePanel, DETAIL_PORTS);
        new ItemEventInvoker(this.rbStandardPorts, this.cardLayout, "show", panels, STANDARD_PORTS);
        new ItemEventInvoker(this.rbProvidedPorts, this.cardLayout, "show", panels, PORT_LIST);
        new ItemEventInvoker(this.rbCustomizedPorts, this.cardLayout, "show", panels, DETAIL_PORTS);
        controls.add((Component)portTypeChoices, "West");
        controls.add((Component)panels, "Center");
        return controls;
    }
}

