/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.manageListMembersWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.table.MultiLineTableHeaderRenderer;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.DynamicClassLoader;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.AnyObjectComparator;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.ColumnEditorInfo;
import com.kumbasoft.core.ui.beans.ComplexTypeTableEditorInfo;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.ui.editors.DPEnumerationTableCellEditor;
import com.kumbasoft.core.ui.editors.DPFileTableCellEditor;
import com.kumbasoft.core.ui.editors.DPObjectListTableCellEditor;
import com.kumbasoft.core.util.DataPowerFileUtility;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.dialogs.manageListMembersWizard.validators.Validator;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ManageComplexPropertiesEditPage
extends KumbaCoreWizardPage<DynamicBean>
implements TableModelListener {
    private static final String[] NUMERICAL_TYPES = new String[]{"long", "int"};
    private ComplexTypeTableEditorInfo tableEditorInfo;
    private ArrayList<DataPowerConfig> dataPowerObjects;
    private ArrayList<StatusObjectStatus> allReferencedObjects;
    private HashMap<String, DataPowerConfig> columnToObjectMap;
    private HashMap<String, ColumnEditorInfo> columnToInfoMap;
    private DynamicBean[] columnInfo;
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable containedTypeElementTable;
    private JMScrollPane scrollPane;
    private JMCheckBox cbxSynchronizeChanges;
    private int lastRow;
    private int lastCol;
    private Object lastValue;
    private AnyObjectComparator compareTool;
    private boolean configurationsLoaded;

    private static JMBean createDefaultComplexType(Class<? extends JMBean> containedType, ComplexTypeTableEditorInfo tei) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JMBean complexType = BeanService.getBean(containedType);
        ArrayList<ColumnEditorInfo> ceiList = tei.getColumnInfo();
        for (ColumnEditorInfo cei : ceiList) {
            String propertyName = cei.getPropertyName();
            String columnType = cei.getColumnType();
            if (columnType.startsWith("com.kumbasoft.core.beans.types")) {
                try {
                    JMBean nestedType = (JMBean)BeanService.getBean(columnType);
                    BeanService.setPropertyValue(complexType, propertyName, nestedType);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String defaultValue = cei.getDefaultValue();
            if (StringUtility.isEmpty(defaultValue)) continue;
            String dataPowerType = cei.getDataPowerType();
            Object value = defaultValue;
            if (dataPowerType.equals("dmReference")) {
                columnType = "java.lang.String";
            }
            switch (columnType) {
                case "int": {
                    value = Integer.parseInt(defaultValue);
                    break;
                }
                case "long": {
                    value = Long.parseLong(defaultValue);
                    break;
                }
                default: {
                    logger.info(() -> LMG.log("(Class<? extends JMBean> containedType, ComplexTypeTableEditorInfo): Data type '%s' of the '%s' property of '%s' is not handled.  Fix it.", () -> cei.getColumnType(), () -> propertyName, () -> containedType.getSimpleName()));
                }
                case "java.lang.String": 
            }
            BeanService.setPropertyValue(complexType, propertyName, value);
        }
        return complexType;
    }

    private static Object getDefaultValue(JMBean complextPropertyValue, String propertyName, XMLInfo xmlInfo) {
        int multiplicity = -1;
        String javaType = "";
        String defaultValue = "";
        String dataPowerType = "String";
        if (xmlInfo == null) {
            Class<?> type = BeanService.getPropertyType(complextPropertyValue, propertyName);
            javaType = type.getSimpleName();
            if (javaType.equals("ArrayList")) {
                multiplicity = 2;
            } else if (javaType.equals("ObjectReference")) {
                dataPowerType = "dmReference";
            } else if (Comparison.isIn(javaType, NUMERICAL_TYPES)) {
                dataPowerType = "int";
            }
        } else {
            multiplicity = xmlInfo.multiplicity();
            javaType = xmlInfo.javaType();
            defaultValue = xmlInfo.defaultValue();
            dataPowerType = xmlInfo.dataPowerType();
        }
        if (multiplicity > 1) {
            return null;
        }
        switch (javaType) {
            case "String": {
                if (StringUtility.isNotEmpty(defaultValue)) {
                    return defaultValue;
                }
                if (dataPowerType.equals("dmToggle")) {
                    return "off";
                }
                return "";
            }
            case "long": {
                if (StringUtility.isNotEmpty(defaultValue)) {
                    return Long.parseLong(defaultValue);
                }
                return 0L;
            }
            case "int": {
                if (StringUtility.isNotEmpty(defaultValue)) {
                    return Integer.parseInt(defaultValue);
                }
                return 0;
            }
        }
        if (dataPowerType.equals("dmReference")) {
            return "";
        }
        return null;
    }

    public ManageComplexPropertiesEditPage(DynamicBean model, String leftHelpFileName) {
        super(model, leftHelpFileName);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        logger.finer("(TableModelEvent): Starting.");
        if (e.getType() != 0) {
            logger.finer("(TableModelEvent): Event is not an update - returning.");
            return;
        }
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (row < 0 || column < 1) {
            logger.info(() -> LMG.log("(TableModelEvent): Row (%d) or column(%d) is out of range - returning.", () -> row, () -> column));
            return;
        }
        Object cellValue = this.tableModel.getValueAt(row, column);
        int cmp = this.compareTool.compare(this.lastValue, cellValue);
        if (this.lastRow == row && this.lastCol == column && cmp != 0) {
            logger.fine(() -> LMG.log("(TableModelEvent): Value at (%d, %d) has changed.", () -> row, () -> column));
            if (this.cbxSynchronizeChanges.isSelected()) {
                logger.finer("(TableModelEvent): Syncrhonized editing is on.");
                int columnCount = this.tableModel.getColumnCount();
                int c = 1;
                while (c < columnCount) {
                    int fc = c;
                    if (c == column) {
                        logger.finer(() -> LMG.log("(TableModelEvent): Skipping edited column %d on synchronization.", () -> fc));
                    } else {
                        String columnName = this.tableModel.getColumnName(c);
                        if (columnName.contains("propertyName")) {
                            logger.finer(() -> LMG.log("(TableModelEvent): Skipping 'propertyName' column on synchronization.", () -> fc));
                        } else {
                            logger.fine(() -> LMG.log("(TableModelEvent): Synchronizing value for column '%s' at (%d, %d).", () -> columnName, () -> row, () -> fc));
                            this.tableModel.setValueAt(cellValue, row, c);
                        }
                    }
                    ++c;
                }
            }
        }
        this.lastRow = row;
        this.lastCol = column;
        this.lastValue = cellValue;
        logger.finer("(TableModelEvent): Done.");
    }

    @Reflected
    private void getObjectConfigurations() {
        logger.finer("(): Starting");
        this.configurationsLoaded = false;
        ArrayList selectedObjectList = (ArrayList)((DynamicBean)this.model).getProperty("selectedObjects");
        logger.finer(() -> LMG.log("(): Getting %d selected object configurations", () -> selectedObjectList.size()));
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.dataPowerObjects = configurationManager.getObjects(selectedObjectList);
        logger.finer(() -> LMG.log("(): Got %d object configurations", () -> this.dataPowerObjects.size()));
        ComplexTypeTableEditorInfo tableEditorInfo = (ComplexTypeTableEditorInfo)((DynamicBean)this.model).getProperty("tableEditorInfo");
        String containingType = tableEditorInfo.getContainingType();
        BeanComparator sorter = new BeanComparator();
        sorter.addCompareProperties("sourceDomain", "appliance");
        Collections.sort(this.dataPowerObjects, sorter);
        ((DynamicBean)this.model).setProperty(containingType, this.dataPowerObjects);
        this.configurationsLoaded = true;
        logger.finer("(): Finished");
    }

    @Override
    public boolean isDataValid() {
        logger.finer("(): Starting");
        this.containedTypeElementTable.commitEdits();
        String fieldName = "";
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            DynamicBean rowData = this.tableModel.getValue(i);
            int row = i;
            logger.finer(() -> LMG.log("():  Getting row data from row %d", () -> row));
            Object apn = rowData.getProperty("propertyName");
            logger.finer(() -> LMG.log("():  Type of 'propertyName' field from row %d is '%s'", () -> row, () -> apn == null ? "-null-" : apn.getClass().getName()));
            String actualPropertyName = (String)rowData.getProperty("propertyName");
            String propertyName = StringUtility.substringAfter(actualPropertyName, ".");
            logger.finer(() -> LMG.log("():  For row %d:  Actual Property Name: '%s', Property Name: '%s'", () -> row, () -> actualPropertyName, () -> propertyName));
            ColumnEditorInfo cei = this.columnToInfoMap.get(propertyName);
            if (cei == null) {
                logger.warning(() -> LMG.log("():  ColumnEditorInfo doesn't exist for property '%s'.", () -> actualPropertyName));
            } else {
                boolean isRequired = cei.isRequired();
                boolean fieldsRequired = false;
                boolean fieldsValid = true;
                Collection<String> propertyNames = rowData.getPropertyNames();
                for (String columnName : propertyNames) {
                    String title;
                    block13: {
                        if (columnName.contains("propertyName")) {
                            logger.finer(() -> LMG.log("():  Skipping column '%s' for property '%s'", () -> columnName, () -> actualPropertyName));
                            continue;
                        }
                        Object value = rowData.getProperty(columnName);
                        fieldName = cei.getColumnTitle();
                        String sValue = String.valueOf(value);
                        if (isRequired && (value == null || StringUtility.isEmpty(sValue))) {
                            logger.info(() -> LMG.log("():  Required field for '%s' missing for '%s'", () -> columnName, () -> actualPropertyName));
                            fieldsRequired = true;
                            break;
                        }
                        String validator = cei.getValidator();
                        if (StringUtility.isNotEmpty(validator)) {
                            logger.finer(() -> LMG.log("():  Validator exists for column '%s' for property '%s'", () -> columnName, () -> actualPropertyName));
                            if (validator.startsWith("com.kumbasoft")) {
                                try {
                                    Validator validatorInstance = (Validator)BeanService.getBean(validator);
                                    if (!validatorInstance.isValid(this.tableModel, rowData, propertyName, sValue)) {
                                        logger.info(() -> LMG.log("():  Validator '%s' returned not valid for value of '%s' for column '%s' of property '%s'", () -> validator, () -> sValue, () -> columnName, () -> actualPropertyName));
                                        fieldsValid = false;
                                        break;
                                    }
                                    break block13;
                                }
                                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                                    logger.severe(() -> LMG.log("():  Validator '%s' is configured but does not exist for column '%s' for property '%s'", () -> validator, () -> columnName, () -> actualPropertyName));
                                    e.printStackTrace();
                                    break block13;
                                }
                            }
                            if (!sValue.matches(validator)) {
                                logger.info(() -> LMG.log("():  Validator '%s' does not match value of '%s' for column '%s' of property '%s'", () -> validator, () -> sValue, () -> columnName, () -> actualPropertyName));
                                fieldsValid = false;
                                break;
                            }
                        }
                    }
                    if (fieldsRequired) {
                        logger.info(() -> LMG.log("():  Not all required field values exist for property '%s'", () -> columnName, () -> actualPropertyName));
                        title = String.format("All %s must be provided", StringUtility.pluralize(fieldName));
                        String message = String.format("Missing %s", fieldName);
                        new JMMessageBox((JDialog)this.parentDialog, title, message);
                        logger.fine("(): Done - Returning false");
                        return false;
                    }
                    if (fieldsValid) continue;
                    logger.info(() -> LMG.log("():  Not all field values are valid for property '%s'", () -> columnName, () -> actualPropertyName));
                    title = String.format("%s is not valid", StringUtility.pluralize(fieldName));
                    String message = String.format("%s is present but not valid.  Please correct the value and try again.", fieldName);
                    new JMMessageBox((JDialog)this.parentDialog, title, message);
                    logger.fine("(): Done - Returning false");
                    return false;
                }
            }
            ++i;
        }
        logger.finer("(): Done - Returning true");
        return true;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        logger.finer("(): Starting");
        String containingType = this.tableEditorInfo.getContainingType();
        if (containingType.equals("ConfigAAAPolicy")) {
            Class<?> containedType = this.tableEditorInfo.getContainedTypeClass();
            String propertyName = this.tableEditorInfo.getContainerPropertyName();
            logger.finer(() -> LMG.log("(): Contianing Type is a AAA Policy.  Creating whole new instances of '%s'.", () -> propertyName));
            for (DataPowerConfig configObject : this.dataPowerObjects) {
                try {
                    JMBean newContainedInstance = ManageComplexPropertiesEditPage.createDefaultComplexType(containedType, this.tableEditorInfo);
                    BeanService.setPropertyValue(configObject, propertyName, newContainedInstance);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        logger.finer("(): Getting all model data - Converting rows back to columns.");
        ArrayList<DynamicBean> data = this.tableModel.getModelData();
        for (DynamicBean rowData : data) {
            String actualPropertyName = (String)rowData.getProperty("propertyName");
            logger.finer(() -> LMG.log("(): Property Name is '%s'.", () -> actualPropertyName));
            String referencePropertyName = StringUtility.substringAfter(actualPropertyName, ".");
            ColumnEditorInfo cei = this.columnToInfoMap.get(referencePropertyName);
            if (cei == null) {
                logger.severe(() -> LMG.log("(): Column Editor Info is null for '%s'.   Why?", () -> referencePropertyName));
                continue;
            }
            Collection<String> propertyNames = rowData.getPropertyNames();
            for (String columnName : propertyNames) {
                if (columnName.contains("propertyName")) {
                    logger.finer(() -> LMG.log("(): Skpping 'propertyName' column for '%s'", () -> referencePropertyName));
                    continue;
                }
                String fColumnName = columnName;
                logger.finer(() -> LMG.log("(): Processing column '%s' of '%s'", () -> fColumnName, () -> referencePropertyName));
                DataPowerConfig configObject = this.columnToObjectMap.get(columnName);
                if (configObject == null) {
                    logger.severe(() -> LMG.log("(): Configuration object of '%s' of '%s' is null.  How?", () -> fColumnName, () -> referencePropertyName));
                    continue;
                }
                Object dataValue = rowData.getProperty(columnName);
                String sDataValue = dataValue == null ? "-null" : dataValue.toString();
                logger.finer(() -> LMG.log("(): The value of column '%s' of '%s' is '%s'", () -> fColumnName, () -> referencePropertyName, () -> sDataValue));
                if (cei.getDataPowerType().equals("dmReference")) {
                    logger.finer(() -> LMG.log("(): Type of column '%s' of '%s' is an object reference.  Converting.", () -> fColumnName, () -> referencePropertyName));
                    ObjectReference objectReference = new ObjectReference();
                    objectReference.setClassName(cei.getColumnType());
                    objectReference.setName(String.valueOf(dataValue));
                    dataValue = objectReference;
                }
                logger.finer(() -> LMG.log("(): Setting the value of column '%s' on '%s' on config object.", () -> fColumnName, () -> referencePropertyName));
                BeanService.setPropertyValue(configObject, actualPropertyName, dataValue);
            }
        }
        logger.finer("(): Done");
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        new AsynchMethodInvoker((Object)this, "getObjectConfigurations");
        this.lastRow = -1;
        this.lastCol = -1;
        this.compareTool = new AnyObjectComparator(1);
        this.tableEditorInfo = (ComplexTypeTableEditorInfo)((DynamicBean)this.model).getProperty("tableEditorInfo");
        KumbaCoreWizardPanel tablePanel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        JMPanel topPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        this.cbxSynchronizeChanges = new JMCheckBox("Synchronize changes", true);
        topPanel.add(this.cbxSynchronizeChanges);
        String containerPropertyName = this.tableEditorInfo.getContainerPropertyName();
        containerPropertyName = StringUtility.getDisplayableTitle(containerPropertyName);
        containerPropertyName = StringUtility.pluralize(containerPropertyName);
        tablePanel.add((Component)topPanel, "North");
        this.containedTypeElementTable = this.buildTable();
        this.scrollPane = new JMScrollPane(this.containedTypeElementTable);
        tablePanel.add((Component)this.scrollPane, "Center");
        Dimension tableSize = this.containedTypeElementTable.getPreferredSize();
        int width = tableSize.width + 23;
        int height = tableSize.height + 122;
        if (width > 1880) {
            width = 1880;
        } else if (width < 400) {
            width = 400;
        }
        if (height > 1000) {
            height = 1000;
        } else if (height < 400) {
            height = 400;
        }
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
        return tablePanel;
    }

    private JMTable buildTable() {
        Iterator editableRows;
        Object xmlInfo;
        logger.finer("(): Start");
        this.tableModel = new DynamicBeanTableModel();
        String containedTypeName = this.tableEditorInfo.getContainedType();
        logger.finer(() -> LMG.log("(): Loading '%s'", () -> containedTypeName));
        Class<?> containedType = null;
        try {
            containedType = DynamicClassLoader.loadClass(containedTypeName);
        }
        catch (ClassNotFoundException e) {
            logger.severe(() -> LMG.log("(): Unable to load '%s'.  This should never happen.", () -> containedTypeName));
            e.printStackTrace();
        }
        String containedTypeBaseName = StringUtility.getNthOfDelimited(containedTypeName, ".");
        String editProperty = this.tableEditorInfo.getContainerPropertyName();
        logger.finer(() -> LMG.log("(): The property being edited within '%s' is '%s'", () -> containedTypeName, () -> editProperty));
        ArrayList<ColumnEditorInfo> columnEditorInfoList = this.tableEditorInfo.getColumnInfo();
        BeanComparator sorter = new BeanComparator();
        sorter.addCompareProperties("columnOrder");
        Collections.sort(columnEditorInfoList, sorter);
        HashMap<String, XMLInfo> xmlInfoByName = new HashMap<String, XMLInfo>();
        this.columnToInfoMap = new HashMap();
        UniqueArrayList<String> objectReferenceTypes = null;
        String nestedPropertyName = null;
        Class<?> nestedPropertyType = null;
        for (ColumnEditorInfo columnEditorInfo : columnEditorInfoList) {
            Method propertyAccessor;
            XMLInfo xmlInfo2;
            Object columnType;
            String propertyName = columnEditorInfo.getPropertyName();
            this.columnToInfoMap.put(propertyName, columnEditorInfo);
            if (columnEditorInfo.isHidden()) {
                logger.finer(() -> LMG.log("(): '%s' is hidden within '%s' of '%s'", () -> propertyName, () -> editProperty, () -> containedTypeName));
            }
            if (!columnEditorInfo.isEditable()) {
                logger.finer(() -> LMG.log("(): '%s' is uneditable within '%s' of '%s'", () -> propertyName, () -> editProperty, () -> containedTypeName));
            }
            if (((String)(columnType = columnEditorInfo.getColumnType())).startsWith("com.kumbasoft.core.beans.types")) {
                logger.finer(() -> LMG.log("(): '%s' is a complex type itsef within '%s' of '%s'", () -> propertyName, () -> editProperty, () -> containedTypeName));
                nestedPropertyName = propertyName;
                nestedPropertyType = BeanService.getPropertyType(containedType, nestedPropertyName);
            }
            Class<?> typeContainingActualProperty = containedType;
            String actualPropertyName = propertyName;
            if (propertyName.contains(".")) {
                typeContainingActualProperty = nestedPropertyType;
                actualPropertyName = propertyName.replace(nestedPropertyName, "").replace(".", "");
            }
            if ((xmlInfo2 = (XMLInfo)BeanService.getMethodAnnotation(propertyAccessor = BeanService.getPropertyAccessor(typeContainingActualProperty, actualPropertyName), XMLInfo.class)) == null) {
                logger.fine(() -> LMG.log("(): Did not find XMLInfo for '%s' within '%s' of '%s'", () -> propertyName, () -> editProperty, () -> containedTypeName));
            } else {
                logger.finer(() -> LMG.log("(): Found XMLInfo for '%s' within '%s' of '%s'", () -> propertyName, () -> editProperty, () -> containedTypeName));
                if (objectReferenceTypes == null) {
                    objectReferenceTypes = new UniqueArrayList<String>();
                }
                if (xmlInfo2.dataPowerType().equals("dmReference")) {
                    String referencedType = xmlInfo2.refType();
                    objectReferenceTypes.add(referencedType);
                }
            }
            xmlInfoByName.put(propertyName, xmlInfo2);
        }
        if (objectReferenceTypes != null) {
            logger.fine("(): Listing reference types.");
            new AsynchMethodInvoker((Object)this, "loadObjectReferenceTypes", objectReferenceTypes);
        }
        logger.fine("(): Checking if DataPower objects loaded.");
        while (!this.configurationsLoaded) {
            logger.finer("(): DataPower objects not yet loaded.... waiting...");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        logger.fine("(): DataPower objects loaded.  Building column information.");
        this.columnToObjectMap = new HashMap();
        String[] columnNames = new String[this.dataPowerObjects.size() + 2];
        this.columnInfo = new DynamicBean[columnNames.length];
        columnNames[0] = String.format("%s\npropertyName", containedTypeBaseName);
        int cn = 1;
        for (DataPowerConfig dataPowerObject : this.dataPowerObjects) {
            String applianceName = dataPowerObject.getAppliance().getName();
            String domainName = dataPowerObject.getSourceDomain().getName();
            String objectType = dataPowerObject.getConfigObjectType();
            String objectName = dataPowerObject.getName();
            DynamicBean ci = new DynamicBean();
            ci.setProperty("appliance", dataPowerObject.getAppliance());
            ci.setProperty("domain", dataPowerObject.getSourceDomain());
            ci.setProperty("obectType", objectType);
            ci.setProperty("objectName", objectName);
            this.columnInfo[cn] = ci;
            logger.finer(() -> LMG.log("(): Column Name is: %s %s %s %s", () -> applianceName, () -> domainName, () -> objectType, () -> objectName));
            columnNames[cn] = String.format("%s\n%s\n%s\n%s", applianceName, domainName, objectType, objectName);
            this.columnToObjectMap.put(columnNames[cn], dataPowerObject);
            ++cn;
        }
        columnNames[cn] = "propertyName";
        logger.finer("(): Done building columns.  Structuring data into beans for the model.");
        Index<String, Integer> editableCells = new Index<String, Integer>();
        Index<String, Integer> urlTypeCells = new Index<String, Integer>();
        Index<Integer, Pair<Integer, String>> enumeratedCells = new Index<Integer, Pair<Integer, String>>();
        Index<Integer, Pair<Integer, String>> referenceCells = new Index<Integer, Pair<Integer, String>>();
        ArrayList<DynamicBean> tableData = new ArrayList<DynamicBean>(columnEditorInfoList.size());
        logger.finer(() -> LMG.log("(): The number of rows in the table will be: %d", () -> columnEditorInfoList.size()));
        int row = -1;
        for (ColumnEditorInfo cei : columnEditorInfoList) {
            String displayPropertyName = cei.getColumnTitle();
            String propertyName = cei.getPropertyName();
            logger.finer(() -> LMG.log("(): Display to actual property name: %s -> %s", () -> displayPropertyName, () -> propertyName));
            if (cei.isHidden()) {
                logger.finer(() -> LMG.log("(): Property name: %s -> %s", () -> displayPropertyName, () -> propertyName));
                continue;
            }
            DynamicBean tableRow = new DynamicBean();
            tableRow.setProperty(columnNames[0], displayPropertyName);
            xmlInfo = (XMLInfo)xmlInfoByName.get(propertyName);
            ++row;
            cn = 1;
            for (DataPowerConfig object : this.dataPowerObjects) {
                String dataPowerType;
                Object value = null;
                boolean isEnumeration = false;
                String enumerationName = null;
                boolean isURL = false;
                boolean isReference = false;
                String referencedType = "";
                JMBean complexTypeValue = (JMBean)BeanService.getPropertyValue(object, editProperty);
                if (complexTypeValue == null) {
                    try {
                        logger.info(() -> LMG.log("(): '%s' is null for '%s'.  Building default value.", () -> editProperty, () -> object.getFQON()));
                        complexTypeValue = ManageComplexPropertiesEditPage.createDefaultComplexType(containedType, this.tableEditorInfo);
                        BeanService.setPropertyValue(object, editProperty, complexTypeValue);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        logger.severe(() -> LMG.log("(): Unable to build default bean for '%s'.  Should be possible.", () -> editProperty));
                        e.printStackTrace();
                    }
                }
                if (isEnumeration = xmlInfo.isEnumeration()) {
                    logger.finer(() -> LMG.log("(): '%s' within '%s' of '%s' is an enumeration.", () -> propertyName, () -> editProperty, () -> containedTypeName));
                    enumerationName = xmlInfo.dataPowerType();
                }
                if ((dataPowerType = xmlInfo.dataPowerType()).equals("dmURL") || dataPowerType.equals("dmFSFile")) {
                    logger.finer(() -> LMG.log("(): '%s' within '%s' of '%s' is a URL.", () -> propertyName, () -> editProperty, () -> containedTypeName));
                    isURL = true;
                } else if (dataPowerType.equals("dmReference")) {
                    isReference = true;
                    referencedType = xmlInfo.refType();
                    logger.finer(() -> ManageComplexPropertiesEditPage.lambda$139(propertyName, editProperty, containedTypeName, (XMLInfo)xmlInfo));
                }
                value = BeanService.getPropertyValue(complexTypeValue, propertyName);
                if (value == null) {
                    logger.finer(() -> LMG.log("(): '%s' within '%s' of '%s' is null.  Building default type.", () -> propertyName, () -> editProperty, () -> containedTypeName));
                    value = ManageComplexPropertiesEditPage.getDefaultValue(complexTypeValue, propertyName, (XMLInfo)xmlInfo);
                }
                logger.finer(() -> LMG.log("(): Getting the display value for '%s' within '%s' of '%s'.", () -> propertyName, () -> editProperty, () -> containedTypeName));
                if (value != null) {
                    if (value instanceof ObjectReference) {
                        ObjectReference objectReference = (ObjectReference)value;
                        value = objectReference.getName();
                        logger.finer(() -> LMG.log("(): Value for '%s' within '%s' of '%s' references '%s'.", () -> propertyName, () -> editProperty, () -> containedTypeName, () -> objectReference.getName()));
                    } else if (value instanceof ArrayList) {
                        ArrayList values = (ArrayList)value;
                        logger.info(() -> LMG.log("(): Value for '%s' within '%s' of '%s' is a list - NEED TO CODE FOR THIS.", () -> propertyName, () -> editProperty, () -> containedTypeName));
                        StringBuilder sb = new StringBuilder("");
                        for (Object v : values) {
                            if (sb.length() > 12) {
                                sb.append("<br/>");
                            }
                            if (v instanceof ObjectReference) {
                                ObjectReference objectReference = (ObjectReference)v;
                                v = objectReference.getName();
                            } else if (v instanceof JMBean) {
                                v = ManageComplexPropertiesEditPage.buildBeanCellValue(v);
                                v = String.valueOf(v) + "<br/>";
                            }
                            sb.append(v.toString());
                        }
                        value = LabelUtility.wrapInHTML(sb.toString());
                    } else if (value instanceof JMBean) {
                        logger.info(() -> LMG.log("(): The value for '%s' within '%s' of '%s' is itself a complex type:  NEED TO CODE FOR THIS.", () -> propertyName, () -> editProperty, () -> containedTypeName));
                        value = LabelUtility.wrapInHTML(ManageComplexPropertiesEditPage.buildBeanCellValue(complexTypeValue));
                    }
                }
                logger.finer(() -> LMG.log("(): Setting up special editor data for '%s' within '%s' of '%s'.", () -> propertyName, () -> editProperty, () -> containedTypeName));
                if (ManageComplexPropertiesEditPage.isEditableProperty(complexTypeValue, propertyName, value)) {
                    editableCells.put(columnNames[cn], row);
                    if (isURL) {
                        urlTypeCells.put(columnNames[cn], row);
                    }
                    if (isEnumeration) {
                        enumeratedCells.put(Integer.valueOf(cn), new Pair<Integer, String>(row, enumerationName));
                    }
                    if (isReference) {
                        referenceCells.put(Integer.valueOf(cn), new Pair<Integer, String>(row, referencedType));
                    }
                }
                String columnName = columnNames[cn];
                String logValue = String.valueOf(value);
                logger.finer(() -> LMG.log("(): Value for '%s\n%s' is '%s'.", () -> columnName, () -> propertyName, () -> logValue));
                tableRow.setProperty(columnNames[cn++], value);
            }
            tableRow.setProperty("propertyName", editProperty + "." + propertyName);
            tableData.add(tableRow);
        }
        logger.finer("(): Done building table data.  Building models");
        this.tableModel = new DynamicBeanTableModel();
        this.tableModel.addAll(tableData);
        this.tableModel.addTableModelListener(this);
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        this.columnModel.setColumnOrder(columnNames);
        this.columnModel.hideColumn("propertyName");
        logger.fine("(): Defining editable cells.");
        for (String columnName : editableCells.getKeys()) {
            editableRows = editableCells.get(columnName);
            int editableColumn = this.tableModel.getColumnIndex(columnName);
            xmlInfo = editableRows.iterator();
            while (xmlInfo.hasNext()) {
                int editableRow = (Integer)xmlInfo.next();
                this.tableModel.setCellEditable(editableRow, editableColumn);
            }
        }
        logger.finer("(): Building file drop down for URL type cells");
        Index<String, String> editorFiles = new Index<String, String>();
        for (String propertyName : urlTypeCells.getKeys()) {
            Collection editableRows2 = urlTypeCells.get(propertyName);
            int editableColumn = this.columnModel.getColumnIndex(propertyName);
            DynamicBean columnData = this.columnInfo[editableColumn];
            Appliance appliance = (Appliance)columnData.getProperty("appliance");
            Domain domain = (Domain)columnData.getProperty("domain");
            String editorFilesKey = String.format("%s-%s", appliance.getName(), domain.getName());
            ArrayList<String> domainFiles = (ArrayList<String>)editorFiles.get(editorFilesKey);
            if (domainFiles == null) {
                domainFiles = DataPowerFileUtility.getDomainFiles(appliance, domain);
                for (String domainFile : domainFiles) {
                    editorFiles.put(editorFilesKey, domainFile);
                }
            }
            Iterator isURL = editableRows2.iterator();
            while (isURL.hasNext()) {
                int editableRow = (Integer)isURL.next();
                DPFileTableCellEditor cellEditor = new DPFileTableCellEditor(domainFiles);
                this.columnModel.setEditor(editableRow, editableColumn, cellEditor);
            }
        }
        logger.finer("(): Building enumeration drop down for enumerated types");
        editableRows = enumeratedCells.getKeys().iterator();
        while (editableRows.hasNext()) {
            int columnNumber = (Integer)editableRows.next();
            Collection enumeratedRows = enumeratedCells.get(columnNumber);
            for (Pair enumeratedRow : enumeratedRows) {
                DPEnumerationTableCellEditor cellEditor = new DPEnumerationTableCellEditor((String)enumeratedRow.second);
                this.columnModel.setEditor((Integer)enumeratedRow.first, columnNumber, cellEditor);
            }
        }
        if (referenceCells.size() > 0) {
            logger.fine("(): Checking for existence of all objects.");
            while (CollectionUtility.isEmpty(this.allReferencedObjects)) {
                logger.finer("(): All objects not finished... Waiting...");
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            }
            logger.fine("(): All objects have loaded.  Proceeding to map to referenced types.");
            BeanComparator statusSorter = new BeanComparator("name");
            HashMap<Appliance, Index<Domain, StatusObjectStatus>> objectMap = DataStructureUtility.mapByApplianceDomain(this.allReferencedObjects);
            logger.finer("(): Building drop downs for referenced types");
            Iterator iterator = referenceCells.getKeys().iterator();
            while (iterator.hasNext()) {
                int columnNumber = (Integer)iterator.next();
                Collection referenceRows = referenceCells.get(columnNumber);
                for (Pair referenceRow : referenceRows) {
                    int refRow = (Integer)referenceRow.first;
                    String objectType = (String)referenceRow.second;
                    DynamicBean ci = this.columnInfo[columnNumber];
                    Appliance appliance = (Appliance)ci.getProperty("appliance");
                    Domain domain = (Domain)ci.getProperty("domain");
                    Index<Domain, StatusObjectStatus> objectsByAppliance = objectMap.get(appliance);
                    Collection<StatusObjectStatus> objectsByDomain = objectsByAppliance.get(domain);
                    HashMap<String, Index<String, StatusObjectStatus>> mapByTypeName = DataStructureUtility.mapByTypeAndName(objectsByDomain);
                    Index<String, StatusObjectStatus> objectsByType = mapByTypeName.get(objectType);
                    ArrayList objectsForEditor = null;
                    int fColumnNumber = columnNumber;
                    int numberOfObjectsByType = CollectionUtility.isEmpty(objectsByType) ? 0 : objectsByType.size();
                    logger.finer(() -> LMG.log("(): Cell (%d,%d) has %d objects referencing '%s'", () -> refRow, () -> fColumnNumber, () -> numberOfObjectsByType, () -> objectType));
                    if (!CollectionUtility.isEmpty(objectsByType)) {
                        logger.finer(() -> LMG.log("(): There are no objects for '%s'.  Building a blank one.", () -> objectType));
                        objectsForEditor = (ArrayList)objectsByType.getValues();
                        StatusObjectStatus blankObject = new StatusObjectStatus();
                        blankObject.setAppliance(appliance);
                        blankObject.setSourceDomain(domain);
                        blankObject.setAdminState("enabled");
                        blankObject.setDataPowerClass(objectType);
                        blankObject.setName("");
                        objectsForEditor.add(blankObject);
                        Collections.sort(objectsForEditor, statusSorter);
                    } else {
                        objectsForEditor = new ArrayList();
                    }
                    DPObjectListTableCellEditor cellEditor = new DPObjectListTableCellEditor(objectsForEditor);
                    this.columnModel.setEditor(refRow, columnNumber, cellEditor);
                }
            }
        }
        logger.finer("(): All editors set.  Models complete.  Building table.");
        this.containedTypeElementTable = new JMTable(this.tableModel, this.columnModel);
        this.containedTypeElementTable.getTableHeader().setDefaultRenderer(new MultiLineTableHeaderRenderer(this.containedTypeElementTable));
        this.containedTypeElementTable.setMinimumColumnWidth(100);
        this.containedTypeElementTable.optimizeColumnWidths();
        this.containedTypeElementTable.optimizeRowHeights();
        logger.finer("(): Done");
        return this.containedTypeElementTable;
    }

    @Reflected
    private void loadObjectReferenceTypes(UniqueArrayList<String> objectReferenceTypes) {
        logger.finer("(objectReferenceTypes): Starting.");
        ArrayList selectedObjectList = (ArrayList)((DynamicBean)this.model).getProperty("selectedObjects");
        HashMap objectsByApplianceDomain = DataStructureUtility.mapByApplianceDomain(selectedObjectList);
        Index<Appliance, Domain> searchDomains = new Index<Appliance, Domain>();
        for (Appliance appliance : objectsByApplianceDomain.keySet()) {
            Index objectsByDomain = objectsByApplianceDomain.get(appliance);
            searchDomains.put(appliance, objectsByDomain.getKeys());
        }
        String objectTypeExpression = StringUtility.getRegexMatchExpression(objectReferenceTypes);
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.allReferencedObjects = configurationManager.listObjects(searchDomains, objectTypeExpression, null);
        logger.finer("(objectReferenceTypes): Done.");
    }

    private static String buildBeanCellValue(Object value) {
        ArrayList<String> beanProperties = BeanService.getPropertyNames(value);
        StringBuilder sb = new StringBuilder();
        for (String beanProperty : beanProperties) {
            Object beanPropertyValue;
            if (sb.length() > 0) {
                sb.append("<br/>");
            }
            if ((beanPropertyValue = BeanService.getPropertyValue(value, beanProperty)) == null) {
                beanPropertyValue = "";
            }
            sb.append(String.format("%s=%s", beanProperty, beanPropertyValue.toString()));
        }
        return sb.toString();
    }

    private static boolean isEditableProperty(JMBean complexType, String propertyName, Object propertyValue) {
        String javaType;
        if (!BeanService.hasProperty(complexType, propertyName)) {
            return false;
        }
        Class<?> propertyType = BeanService.getPropertyType(complexType, propertyName);
        switch (javaType = propertyType.getSimpleName()) {
            case "ObjectReference": 
            case "String": 
            case "Integer": 
            case "Long": 
            case "Boolean": 
            case "Double": {
                return true;
            }
            case "ArrayList": {
                return false;
            }
        }
        KumbaCoreWizardPage.logger.info(() -> LMG.log("(complexType=%s, propertyName=%s, propertyValue=%s): Should this be editable", () -> complexType.getClass().getSimpleName(), () -> propertyName, () -> propertyType.getName()));
        return false;
    }

    private static /* synthetic */ String lambda$139(String string, String string2, String string3, XMLInfo xMLInfo) {
        return LMG.log("(): '%s' within '%s' of '%s' references an object type of '%s'.", () -> string, () -> string2, () -> string3, () -> xMLInfo.refType());
    }
}

