/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.passwordWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.table.StringOptionsTableCellEditor;
import com.jmorgan.swing.table.TableCellEditorRenderer;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MigratePasswordsWizardPage
extends AbstractTableWizardPage
implements TableModelListener {
    private HashMap<Appliance, Index<Domain, StatusObjectStatus>> passMapAliasMap;
    private JMCheckBox cbxSynchronizeChanges;
    private JMCheckBox cbxRemovePlaintextPassword;
    private boolean suppressChangeEvents;

    public MigratePasswordsWizardPage(DynamicBean model) {
        super(model);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        new AsynchMethodInvoker((Object)this, "loadPassMapAliases");
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.cbxSynchronizeChanges = new JMCheckBox("Synchronize Changes", true);
        this.cbxRemovePlaintextPassword = new JMCheckBox("Remove Plaintext Password", true);
        JMPanel cbxPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        cbxPanel.addAll(this.cbxSynchronizeChanges, this.cbxRemovePlaintextPassword);
        panel.add((Component)cbxPanel, "North");
        this.tableModel.addTableModelListener(this);
        return panel;
    }

    @Reflected
    private void loadPassMapAliases() {
        logger.finer("(): Starting");
        Collection migrationTargets = (Collection)((DynamicBean)this.model).getProperty("migrationTargets");
        HashMap map = DataStructureUtility.mapByApplianceDomain(migrationTargets);
        Index<Appliance, Domain> domainIndex = new Index<Appliance, Domain>();
        for (Appliance appliance : map.keySet()) {
            Index objectMap = map.get(appliance);
            domainIndex.put(appliance, objectMap.getKeys());
        }
        logger.finer("(): Getting password map aliases from migration target appliances/domains");
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> passMapAliasList = configurationManager.listObjects(domainIndex, "PasswordAlias", ".*");
        logger.finer(() -> LMG.log("(): Got %d password map aliases from migration target appliances/domains", () -> passMapAliasList.size()));
        this.passMapAliasMap = DataStructureUtility.mapByApplianceDomain(passMapAliasList);
        while (this.table == null) {
            logger.finer("(): Waiting to table to be created.");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        logger.finer("(): Defining cell editors");
        int rowCount = this.table.getRowCount();
        int row = 0;
        while (row < rowCount) {
            DynamicBean rowData = this.tableModel.getValue(this.table.convertRowIndexToModel(row));
            Appliance appliance = (Appliance)rowData.getProperty("appliance");
            Domain domain = (Domain)rowData.getProperty("domain");
            Index<Domain, StatusObjectStatus> passMapsByAppliance = this.passMapAliasMap.get(appliance);
            if (passMapsByAppliance != null) {
                Collection<StatusObjectStatus> passMapsByDomain = passMapsByAppliance.get(domain);
                Collection passMapAliasNames = CollectionUtility.getPropertyValues(passMapsByDomain, "name");
                ArrayList<String> passMapAliasNameList = new ArrayList<String>(passMapAliasNames);
                passMapAliasNameList.add("");
                Collections.sort(passMapAliasNameList);
                int fRow = row;
                logger.finer(() -> LMG.log("(): Row %d will have %d aliases to select from.", () -> fRow, () -> passMapAliasNameList.size()));
                StringOptionsTableCellEditor editor = new StringOptionsTableCellEditor(passMapAliasNameList);
                editor.makeComboBoxEditable();
                this.columnModel.setEditor(row, 5, editor);
            } else {
                TableCellEditorRenderer editor = new TableCellEditorRenderer();
                this.columnModel.setEditor(row, 5, editor);
            }
            ++row;
        }
        logger.finer("(): Done");
    }

    public HashMap<Appliance, Index<Domain, StatusObjectStatus>> getPassMapAliasMap() {
        return this.passMapAliasMap;
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        ArrayList migrationTargets = (ArrayList)((DynamicBean)this.model).getProperty("migrationTargets");
        BeanComparator sorter = new BeanComparator("configObjectType", "name", "appliance.name", "sourceDomain.name");
        Collections.sort(migrationTargets, sorter);
        for (DataPowerConfig object : migrationTargets) {
            Appliance appliance = object.getAppliance();
            Domain domain = object.getSourceDomain();
            String objectName = object.getName();
            String dataPowerType = object.getConfigObjectType();
            String password = (String)BeanService.getPropertyValue(object, "password");
            DynamicBean row = new DynamicBean();
            row.setProperty("appliance", appliance);
            row.setProperty("domain", domain);
            row.setProperty("dataPowerType", dataPowerType);
            row.setProperty("objectName", objectName);
            row.setProperty("password", password);
            row.setProperty("alias", "");
            tableModel.addRow(row);
        }
        tableModel.addComputedExpression("appliance", "name");
        tableModel.addComputedExpression("domain", "name");
        tableModel.setEditableColumns("alias");
        return tableModel;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel columnModel = super.createColumnModel();
        columnModel.setColumnOrder("appliance", "domain", "dataPowerType", "objectName", "password", "alias");
        return columnModel;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        ExtendedTableModelEvent ee = (ExtendedTableModelEvent)e;
        if (!this.cbxSynchronizeChanges.isSelected() || this.suppressChangeEvents || ee.getNewValue().equals(ee.getOldValue())) {
            return;
        }
        this.suppressChangeEvents = true;
        int changedRow = e.getFirstRow();
        DynamicBean changedValue = this.tableModel.getValue(changedRow);
        Domain domain = (Domain)changedValue.getProperty("domain");
        String objectType = (String)changedValue.getProperty("dataPowerType");
        String objectName = (String)changedValue.getProperty("objectName");
        String password = (String)changedValue.getProperty("password");
        String passwordAlias = (String)changedValue.getProperty("alias");
        int rowCount = this.tableModel.getRowCount();
        int row = 0;
        while (row < rowCount) {
            if (row != changedRow) {
                DynamicBean value = this.tableModel.getValue(row);
                Domain vDomain = (Domain)value.getProperty("domain");
                String vObjectType = (String)value.getProperty("dataPowerType");
                String vObjectName = (String)value.getProperty("objectName");
                String vPassword = (String)value.getProperty("password");
                if (domain.equals(vDomain) && objectType.equals(vObjectType) && objectName.equals(vObjectName) && password.equals(vPassword)) {
                    value.setProperty("alias", passwordAlias);
                }
            }
            ++row;
        }
        this.suppressChangeEvents = false;
        this.table.repaint();
    }

    @Override
    protected void saveDataToModel() {
        this.table.commitEdits();
        boolean removePlaintextPassword = this.cbxRemovePlaintextPassword.isSelected();
        ((DynamicBean)this.model).setProperty("removePlaintextPassword", removePlaintextPassword);
        ArrayList<DynamicBean> modelData = this.tableModel.getModelData();
        ArrayList<DynamicBean> migrateData = new ArrayList<DynamicBean>();
        for (DynamicBean modelRow : modelData) {
            String passMapAliasName = (String)modelRow.getProperty("alias");
            if (StringUtility.isEmpty(passMapAliasName)) continue;
            migrateData.add(modelRow);
        }
        ((DynamicBean)this.model).setProperty("migrationFinalData", migrateData);
    }
}

