/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.io.ASCFileReader;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.AccordionComponent;
import com.jmorgan.swing.splitpane.SplitPane;
import com.jmorgan.swing.splitpane.SplitPaneLayout;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanRowSorter;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.config.ConfigStylePolicyAction;
import com.kumbasoft.core.beans.probe.CallTrace;
import com.kumbasoft.core.beans.probe.ExecutionTrace;
import com.kumbasoft.core.beans.probe.TransactionContext;
import com.kumbasoft.core.beans.probe.TransactionManifest;
import com.kumbasoft.core.beans.probe.TransactionRule;
import com.kumbasoft.core.beans.types.StylesheetParameter;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.FileUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JEditorPane;

public class ActionViewDialog
extends JMDialog {
    private TransactionContext context;
    private BeanTableModel<CallTrace> callTraceTableModel;
    private JMTable extensionTraceTable;
    private JEditorPane extensionTraceRequestPanel;
    private JEditorPane extensionTraceResponsePanel;
    private JEditorPane extensionTraceErrorPanel;
    private BeanTableModel<ExecutionTrace> executionTraceTableModel;
    private JMTable executionTraceTable;
    private JEditorPane executionTraceOutputPanel;
    private JMTable tableCreated;

    public ActionViewDialog(JDialog owner, TransactionContext context) {
        super(owner, "", context);
        this.setSize(1000, 600);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        this.context = (TransactionContext)arguments[0];
        ConfigStylePolicyAction action = this.context.getActionConfig();
        String dialogTitle = String.format("Processing Step %d: %s", this.context.getContextNumber(), action.getName());
        this.setTitle(dialogTitle);
        JMTabbedPane tabbedPane = new JMTabbedPane();
        String transForm = action.getTransform();
        this.addFileTab(tabbedPane, "Transform File", transForm);
        String gwScriptLocation = action.getGatewayScriptLocation();
        this.addFileTab(tabbedPane, "GatewayScript File", gwScriptLocation);
        String jsonSchemaURL = action.getJSONSchemaURL();
        this.addFileTab(tabbedPane, "JSON Schema File", jsonSchemaURL);
        String sqlText = action.getSQLText();
        this.addFileTab(tabbedPane, "SQL Source Text", sqlText);
        tabbedPane.addTab("Extension Trace", this.createExtensionTraceTab());
        tabbedPane.addTab("Execution Trace", this.createExecutionTraceTab());
        ArrayList<StylesheetParameter> attachments = action.getStylesheetParameters();
        tabbedPane.addTab("Stylesheet Parameters", this.createStylesheetParametersTab(attachments));
        this.contentPane.add(tabbedPane);
    }

    private void addFileTab(JMTabbedPane tabbedPane, String tabTitle, String capturedFileName) {
        JMDialog.applicationLogger.finer(() -> LMG.log("(tabbedPane, tabTitle=%s, capturedFileName=%s): Starting", () -> tabTitle, () -> capturedFileName));
        JMPanel transformFileTab = this.createTransformTab(capturedFileName);
        if (transformFileTab != null) {
            tabbedPane.addTab(tabTitle, transformFileTab);
        }
    }

    private JMPanel createTransformTab(String transformFileName) {
        JMDialog.applicationLogger.finer(() -> LMG.log("(transformFileName=%s): Starting", () -> transformFileName));
        if (StringUtility.isEmpty(transformFileName)) {
            JMDialog.applicationLogger.info(() -> LMG.log("(transformFileName=%s): transformm file name is empty.  Skipping.", () -> transformFileName));
            return null;
        }
        if (!transformFileName.trim().startsWith("local:") && !transformFileName.trim().startsWith("store:")) {
            JMDialog.applicationLogger.info(() -> LMG.log("(transformFileName=%s): Not local: nor store:. Where is the transform file?  Skipping.", () -> transformFileName));
            return null;
        }
        String fileContents = this.getReferencedFileContent(transformFileName);
        if (StringUtility.isEmpty(fileContents)) {
            JMDialog.applicationLogger.info(() -> LMG.log("(transformFileName=%s): File contents is empty.  Skipping.", () -> transformFileName));
            return null;
        }
        JMDialog.applicationLogger.finer(() -> LMG.log("(transformFileName=%s): All good.  Building panel.", () -> transformFileName));
        JMPanel panel = KumbaCoreUIConstants.createBorderLayoutPanel();
        JEditorPane fileDisplay = new JEditorPane();
        fileDisplay.setContentType(FileUtility.getMimeType(transformFileName));
        fileDisplay.setText(fileContents);
        fileDisplay.setEditable(false);
        JMScrollPane scrollPane = new JMScrollPane(fileDisplay);
        JMLabel title = new JMLabel(transformFileName);
        panel.add((Component)title, "North");
        panel.add((Component)scrollPane, "Center");
        JMDialog.applicationLogger.finer(() -> LMG.log("(transformFileName=%s): Done.", () -> transformFileName));
        return panel;
    }

    private String getReferencedFileContent(String capturedFileName) {
        JMDialog.applicationLogger.finer(() -> LMG.log("(capturedFileName=%s): Starting", () -> capturedFileName));
        TransactionRule actionRule = this.context.getRule();
        TransactionManifest ruleManifest = actionRule.getManifest();
        HashMap<String, File> fileSystemDirectories = ruleManifest.getFileSystemDirectories();
        String fileStore = StringUtility.substringBefore(capturedFileName, ":");
        File fileStoreDirectory = fileSystemDirectories.get(fileStore);
        String relativeFileName = StringUtility.substringAfter(StringUtility.coalesce(capturedFileName, "/"), "/");
        File capturedFile = new File(fileStoreDirectory, relativeFileName);
        JMDialog.applicationLogger.finer(() -> LMG.log("(capturedFileName=%s): Reading captured file: %s", () -> capturedFileName, () -> capturedFile.getAbsolutePath()));
        try {
            ASCFileReader reader = new ASCFileReader(capturedFile);
            String fileContents = reader.readAll();
            JMDialog.applicationLogger.finer(() -> LMG.log("(capturedFileName=%s): Done.  Returning file contents.", () -> capturedFileName));
            return fileContents;
        }
        catch (IOException e) {
            JMDialog.applicationLogger.warning(() -> LMG.log("(capturedFileName=%s): Error reading file contents.", () -> capturedFileName));
            e.printStackTrace();
            return null;
        }
    }

    private JMPanel createExtensionTraceTab() {
        ArrayList<CallTrace> callTraces = this.context.getCallTraces();
        int callTraceCount = callTraces == null ? 0 : callTraces.size();
        JMDialog.applicationLogger.finer(() -> LMG.log("(): Showing %d extension traces.", () -> callTraceCount));
        this.callTraceTableModel = this.createCallTraceTableModel(callTraces);
        BeanColumnModel<CallTrace> columnModel = ActionViewDialog.createCallTraceColumnModel(this.callTraceTableModel);
        JMPanel tablePanel = this.createTablePanel(this.callTraceTableModel, columnModel);
        this.extensionTraceRequestPanel = ActionViewDialog.createEditorPane();
        this.extensionTraceResponsePanel = ActionViewDialog.createEditorPane();
        this.extensionTraceErrorPanel = ActionViewDialog.createEditorPane();
        AccordionComponent accordionControl = new AccordionComponent();
        accordionControl.addCategory("Request", new JMScrollPane(this.extensionTraceRequestPanel));
        accordionControl.addCategory("Response", new JMScrollPane(this.extensionTraceResponsePanel));
        accordionControl.addCategory("Error", new JMScrollPane(this.extensionTraceErrorPanel));
        SplitPane splitPane = new SplitPane(1, 2);
        SplitPaneLayout layout = (SplitPaneLayout)splitPane.getLayout();
        layout.setColumnWidth(0, 0.65);
        splitPane.add(tablePanel);
        splitPane.add(accordionControl);
        this.extensionTraceTable = this.tableCreated;
        this.extensionTraceTable.addRowFocusListener(e -> this.callTraceSelectionChanged());
        this.tableCreated = null;
        return splitPane;
    }

    private static JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane("text/xml", "");
        editorPane.setEditable(false);
        editorPane.setPreferredSize(new Dimension(300, 400));
        return editorPane;
    }

    private void callTraceSelectionChanged() {
        int selectedRow = this.extensionTraceTable.getSelectedRow();
        CallTrace selectedCallTrace = this.callTraceTableModel.getValue(this.extensionTraceTable.convertRowIndexToModel(selectedRow));
        this.extensionTraceRequestPanel.setText(selectedCallTrace.getRequest());
        this.extensionTraceResponsePanel.setText(selectedCallTrace.getResponse());
        this.extensionTraceErrorPanel.setText(selectedCallTrace.getError());
    }

    private BeanTableModel<CallTrace> createCallTraceTableModel(ArrayList<CallTrace> callTraces) {
        this.callTraceTableModel = new BeanTableModel<CallTrace>(CallTrace.class);
        if (CollectionUtility.isNotEmpty(callTraces)) {
            this.callTraceTableModel.addAll(callTraces);
        }
        return this.callTraceTableModel;
    }

    private static BeanColumnModel<CallTrace> createCallTraceColumnModel(BeanTableModel<CallTrace> tableModel) {
        BeanColumnModel<CallTrace> columnModel = new BeanColumnModel<CallTrace>(tableModel);
        columnModel.setColumnOrder("sequence", "type", "uRL");
        columnModel.hideColumns("request", "response", "error");
        return columnModel;
    }

    private JMPanel createExecutionTraceTab() {
        ArrayList<ExecutionTrace> executionTraces = this.context.getExecutionTraces();
        this.executionTraceTableModel = ActionViewDialog.createExecutionTraceTableModel(executionTraces);
        BeanColumnModel<ExecutionTrace> columnModel = ActionViewDialog.createExecutionTraceColumnModel(this.executionTraceTableModel);
        JMPanel tablePanel = this.createTablePanel(this.executionTraceTableModel, columnModel);
        this.executionTraceTable = this.tableCreated;
        this.executionTraceTable.addRowFocusListener(e -> this.executionTraceSelectionChanged());
        this.tableCreated = null;
        this.executionTraceOutputPanel = ActionViewDialog.createEditorPane();
        SplitPane splitPane = new SplitPane(1, 2);
        SplitPaneLayout layout = (SplitPaneLayout)splitPane.getLayout();
        layout.setColumnWidth(0, 0.65);
        splitPane.add(tablePanel);
        splitPane.add(new JMScrollPane(this.executionTraceOutputPanel));
        return splitPane;
    }

    private void executionTraceSelectionChanged() {
        int selectedRow = this.executionTraceTable.getSelectedRow();
        ExecutionTrace selectedCallTrace = this.executionTraceTableModel.getValue(this.executionTraceTable.convertRowIndexToModel(selectedRow));
        this.executionTraceOutputPanel.setText(selectedCallTrace.getOutput());
    }

    private static BeanTableModel<ExecutionTrace> createExecutionTraceTableModel(ArrayList<ExecutionTrace> executionTraces) {
        BeanTableModel<ExecutionTrace> tableModel = new BeanTableModel<ExecutionTrace>(ExecutionTrace.class);
        tableModel.addAll(executionTraces);
        return tableModel;
    }

    private static BeanColumnModel<ExecutionTrace> createExecutionTraceColumnModel(BeanTableModel<ExecutionTrace> tableModel) {
        BeanColumnModel<ExecutionTrace> columnModel = new BeanColumnModel<ExecutionTrace>(tableModel);
        columnModel.setColumnOrder("sequence", "template", "line", "trace");
        columnModel.hideColumn("output");
        return columnModel;
    }

    private JMPanel createStylesheetParametersTab(ArrayList<StylesheetParameter> parameters) {
        BeanTableModel<StylesheetParameter> tableModel = ActionViewDialog.createParametersTableModel(parameters);
        BeanColumnModel<StylesheetParameter> columnModel = ActionViewDialog.createParametersColumnModel(tableModel);
        return this.createTablePanel(tableModel, columnModel);
    }

    private static BeanTableModel<StylesheetParameter> createParametersTableModel(ArrayList<StylesheetParameter> stylesheetParameters) {
        BeanTableModel<StylesheetParameter> tableModel = new BeanTableModel<StylesheetParameter>(StylesheetParameter.class);
        tableModel.addAll(stylesheetParameters);
        return tableModel;
    }

    private static BeanColumnModel<StylesheetParameter> createParametersColumnModel(BeanTableModel<StylesheetParameter> tableModel) {
        BeanColumnModel<StylesheetParameter> columnModel = new BeanColumnModel<StylesheetParameter>(tableModel);
        columnModel.setColumnTitle("parameterName", "Name");
        columnModel.setColumnTitle("parameterValue", "Value");
        return columnModel;
    }

    private JMPanel createTablePanel(BeanTableModel<?> tableModel, BeanColumnModel<?> columnModel) {
        JMTable table = new JMTable(tableModel, columnModel);
        table.optimizeColumnWidths();
        BeanRowSorter rowSorter = new BeanRowSorter(tableModel);
        table.setRowSorter(rowSorter);
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createBorderLayout());
        panel.add(new JMScrollPane(table));
        this.tableCreated = table;
        return panel;
    }
}

