/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableCellRenderer;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.ColorBeanTableModelPropertyValueRule;
import com.jmorgan.util.collection.CollectionPropertySelector;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.probe.TransactionManifest;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class TransactionManifestPanel
extends AbstractTablePanel<TransactionManifest> {
    public TransactionManifestPanel() {
        super(TransactionManifest.class);
    }

    @Override
    protected void setElementType(Class<TransactionManifest> elementType) {
        logger.finer(() -> LMG.log("(elementType): Starting", () -> elementType.getSimpleName()));
        this.elementType = elementType;
        this.setupModel();
        logger.finer(() -> LMG.log("(elementType): Done", () -> elementType.getSimpleName()));
    }

    @Override
    public BeanTableModel<TransactionManifest> getTableModel() {
        BeanTableModel<TransactionManifest> tableModel = super.getTableModel();
        tableModel.addComputedExpression("appliance", "appliance.name");
        tableModel.addComputedExpression("domain", "domain.name");
        return tableModel;
    }

    @Override
    protected BeanColumnModel<TransactionManifest> getColumnModel() {
        BeanColumnModel<TransactionManifest> columnModel = super.getColumnModel();
        columnModel.setColumnOrder("appliance", "domain", "serviceType", "serviceName", "policyName", "matchedRuleName", "clientIP", "transactionTime", "globalTransactionID", "transactionID", "inURL", "outURL");
        columnModel.hideColumns("passthruMode", "transactionHistory", "transactionAborted", "transactionDirectory", "transactionRules", "fileSystemDirectories");
        ColorBeanTableModelPropertyValueRule errorColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "transactionAborted", (Object)true);
        errorColor.setColor(KumbaCoreUIConstants.ERROR_COLOR);
        ColorBeanTableModelPropertyValueRule lightColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "transactionAborted", (Object)true);
        lightColor.setColor(Color.YELLOW);
        BeanTableCellRenderer cellRenderer = new BeanTableCellRenderer();
        cellRenderer.addUnSelectedForegroundColorRule(errorColor);
        cellRenderer.addSelectedBackgroundColorRule(lightColor);
        columnModel.setRenderer(".*", cellRenderer);
        return columnModel;
    }

    public void addTableData(ArrayList<TransactionManifest> tableData) {
        logger.finer(() -> LMG.log("(tableData): Starting with %d elements.", () -> tableData.size()));
        ArrayList modelData = this.tableModel.getModelData();
        int modelSize = modelData.size();
        CollectionPropertySelector transactionIDSelector = new CollectionPropertySelector(modelData);
        Collection<Long> existingTransactionIDs = transactionIDSelector.get("transactionID", Long.class);
        BeanIndexer<TransactionManifest> indexer = new BeanIndexer<TransactionManifest>(tableData);
        HashMap<Long, TransactionManifest> transactionMap = indexer.getMapOf("transactionID", -1L);
        for (Long transactionID : transactionMap.keySet()) {
            logger.finer(() -> LMG.log("(tableData): Evaluating transaction %d.", () -> transactionID));
            if (!existingTransactionIDs.contains(transactionID)) continue;
            TransactionManifest tm = transactionMap.get(transactionID);
            int i = 0;
            while (i < modelSize) {
                TransactionManifest modelElement = (TransactionManifest)modelData.get(i);
                if (modelElement.getTransactionID() == transactionID.longValue()) {
                    logger.finer(() -> LMG.log("(tableData): Updating manifest for transaction %d.", () -> transactionID));
                    modelData.set(i, modelElement);
                    break;
                }
                ++i;
            }
            tableData.remove(tm);
        }
        this.tableModel.addAll(tableData);
        this.displayTable.optimizeColumnWidths();
        logger.finer(() -> LMG.log("(tableData): Added %d elements.  Done.", () -> tableData.size()));
    }

    public void setTableData(ArrayList<TransactionManifest> tableData) {
        logger.finer(() -> LMG.log("(tableData): Adding %d elements.", () -> tableData.size()));
        this.tableModel.reset();
        this.tableModel.addAll(tableData);
        this.displayTable.optimizeColumnWidths();
        logger.finer(() -> LMG.log("(tableData): Added %d elements.  Done.", () -> tableData.size()));
    }

    public void reset() {
        this.tableModel.reset();
    }
}

