/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigDynamicSchema;
import com.kumbasoft.core.beans.config.ConfigHTTPInputConversionMap;
import com.kumbasoft.core.beans.config.ConfigJOSERecipientIdentifier;
import com.kumbasoft.core.beans.config.ConfigParseSettings;
import com.kumbasoft.core.beans.config.ConfigSQLDataSource;
import com.kumbasoft.core.beans.config.ConfigStylePolicyAction;
import com.kumbasoft.core.beans.config.ConfigURLRewritePolicy;
import com.kumbasoft.core.beans.probe.TransactionContext;
import com.kumbasoft.core.beans.probe.TransactionIdentity;
import com.kumbasoft.core.beans.probe.TransactionRule;
import com.kumbasoft.core.beans.types.Condition;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.DynamicParseSettingsReference;
import com.kumbasoft.core.beans.types.StylesheetParameter;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.probe.ProbeContextInfo;
import com.kumbasoft.dpaa.ui.dialogs.probe.ActionViewDialog;
import com.kumbasoft.dpaa.ui.dialogs.probe.ContextViewDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JSeparator;

public class TransactionRulePanel
extends AbstractPanel {
    private TransactionRule transactionRule;
    private ScrollablePanel ruleScroller = new ScrollablePanel(KumbaCoreUIConstants.createFlowLayout(0));

    public TransactionRulePanel(TransactionRule transactionRule) {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.transactionRule = transactionRule;
        String title = this.transactionRule.getRuleName();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(KumbaCoreUIConstants.LIGHT_BACKGROUND), title));
        this.setInsets(new Insets(20, 5, 5, 5));
        this.add((Component)new JMScrollPane(this.ruleScroller), "Center");
        this.showRuleComponents();
    }

    @Reflected
    private void showRuleComponents() {
        ArrayList<TransactionContext> transactionContexts = this.transactionRule.getTransactionContexts();
        AbstractPanel.logger.finer(() -> LMG.log("(): Starting. Found %d contexts in '%s' rule.", () -> transactionContexts.size(), () -> this.transactionRule.getRuleName()));
        int width = 0;
        for (TransactionContext transactionContext : transactionContexts) {
            TransactionContext nextContext;
            TransactionIdentity transactionIdentity = transactionContext.getTransactionIdentity();
            AbstractPanel.logger.finer(() -> LMG.log("(): Visualizing %d context in '%s' rule.", () -> transactionContext.getContextNumber(), () -> this.transactionRule.getRuleName()));
            JMButton inputContextComponent = ProbeContextInfo.createContextComponent(transactionContext);
            inputContextComponent.setPreferredSize(new Dimension(16, 22));
            inputContextComponent.addActionListener(e_ -> this.showContext(transactionContext));
            width += 16;
            this.ruleScroller.add(inputContextComponent);
            String nextOp = transactionIdentity.getNextOperation();
            if (nextOp == null) continue;
            AbstractPanel.logger.finer(() -> LMG.log("(): Visualizing next operation %s for %d context in '%s' rule.", () -> nextOp, () -> transactionContext.getContextNumber(), () -> this.transactionRule.getRuleName()));
            JMButton actionComponent = this.createActionComponent(transactionContext);
            actionComponent.addActionListener(e -> this.showActionContext(transactionContext));
            actionComponent.setPreferredSize(new Dimension(16, 16));
            width += 16;
            this.ruleScroller.add(actionComponent);
            String outputContextName = transactionContext.getActionConfig().getOutput();
            if (outputContextName != null && (nextContext = this.getNextContext(transactionContext)) != null) {
                TransactionContext namedContext;
                TransactionContext outputContext = new TransactionContext(this.transactionRule);
                TransactionIdentity outputIdentity = new TransactionIdentity();
                outputIdentity.setTimestamp(nextContext.getTransactionIdentity().getTimestamp());
                outputIdentity.setRuleName(transactionIdentity.getRuleName());
                outputIdentity.setRuleDirection(transactionIdentity.getRuleDirection());
                outputIdentity.setPreviousAction(transactionIdentity.getCurrentAction());
                outputIdentity.setPreviousOperation(transactionIdentity.getCurrentOperation());
                outputIdentity.setNextAction(transactionIdentity.getNextAction());
                outputIdentity.setNextOperation(transactionIdentity.getNextOperation());
                outputIdentity.setVariables(nextContext.getTransactionIdentity().getVariables());
                outputIdentity.setInputContext(outputContextName);
                outputContext.setTransactionIdentity(outputIdentity);
                outputContext.setContextNumber(transactionContext.getContextNumber());
                outputContext.setProtocolHeaders(nextContext.getProtocolHeaders());
                outputContext.setVariables(nextContext.getVariables());
                outputContext.setErrorContext(transactionContext.isErrorContext());
                outputContext.setTransactionInput("");
                if (!outputContextName.equalsIgnoreCase("null") && (namedContext = this.getNamedContext(nextContext, outputContextName)) != null) {
                    outputContext.setTransactionInput(namedContext.getTransactionInput());
                }
                JMButton outputContextComponent = ProbeContextInfo.createContextComponent(outputContext);
                outputContextComponent.setPreferredSize(new Dimension(16, 22));
                outputContextComponent.addActionListener(e -> this.showContext(transactionContext.getContextNumber(), outputContextName));
                width += 16;
                this.ruleScroller.add(outputContextComponent);
            }
            JSeparator sep = new JSeparator();
            sep.setPreferredSize(new Dimension(16, 1));
            this.ruleScroller.add(sep);
            width += 16;
        }
        int totalWidth = width;
        int height = 35;
        AbstractPanel.logger.finer(() -> LMG.log("(): Setting Rule Container to size: (%d, %d).", () -> totalWidth, () -> 35));
        this.ruleScroller.setSize(width, 35);
        this.ruleScroller.setPreferredSize(width, 35);
        Insets insets = this.getInsets();
        int borderedWidth = width + insets.left + insets.right;
        int borderedHeight = 35 + insets.top + insets.bottom + 20;
        AbstractPanel.logger.finer(() -> LMG.log("(): Setting Rule Panel to size: (%d, %d).", () -> borderedWidth, () -> borderedHeight));
        this.setSize(borderedWidth, borderedHeight);
        this.setPreferredSize(borderedWidth, borderedHeight);
        AbstractPanel.logger.finer("(): Done.");
    }

    private TransactionContext getNextContext(TransactionContext current) {
        int currentContextNumber = current.getContextNumber();
        AbstractPanel.logger.finer(() -> LMG.log("(TransactionContext): Starting from context %d.", () -> currentContextNumber));
        TransactionContext nextContext = null;
        ArrayList<TransactionContext> contexts = this.transactionRule.getTransactionContexts();
        for (TransactionContext context : contexts) {
            if (context.getContextNumber() <= currentContextNumber) continue;
            nextContext = context;
            break;
        }
        if (nextContext != null) {
            int nextContextNumber = nextContext.getContextNumber();
            AbstractPanel.logger.finer(() -> LMG.log("(TransactionContext): Returning nextContext %d from context %d.", () -> nextContextNumber, () -> currentContextNumber));
        } else {
            AbstractPanel.logger.finer(() -> LMG.log("(TransactionContext): Did not find next context from context %d.", () -> currentContextNumber));
        }
        return nextContext;
    }

    private TransactionContext getNamedContext(TransactionContext startingContext, String contextName) {
        TransactionContext namedContext = null;
        int fromContextNumber = startingContext.getContextNumber();
        AbstractPanel.logger.finer(() -> LMG.log("(TransactionContext startingContext, contextName=%s):  Searching for context by name following context %d.", () -> contextName, () -> fromContextNumber));
        ArrayList<TransactionContext> contexts = this.transactionRule.getTransactionContexts();
        for (TransactionContext context : contexts) {
            String name;
            if (context.getContextNumber() < fromContextNumber || !(name = context.getTransactionIdentity().getInputContext()).equals(contextName)) continue;
            namedContext = context;
            break;
        }
        if (namedContext != null) {
            int namedContextNumber = namedContext.getContextNumber();
            AbstractPanel.logger.finer(() -> LMG.log("(TransactionContext startingContext, contextName=%s):  Found named context %d.", () -> contextName, () -> namedContextNumber));
        } else {
            AbstractPanel.logger.finer(() -> LMG.log("(TransactionContext startingContext, contextName=%s):  Did not find context by name.", () -> contextName));
        }
        return namedContext;
    }

    private JMButton createActionComponent(TransactionContext transactionContext) {
        String actionType = transactionContext.getTransactionIdentity().getNextOperation();
        if (actionType == null) {
            logger.fine("(TransactionContext):  Action type null for this tranaction.  No more operations.");
            return null;
        }
        logger.finer(() -> LMG.log("(TransactionContext):  Starting for action type '%s'", () -> actionType));
        ConfigStylePolicyAction actionConfig = transactionContext.getActionConfig();
        ArrayList<StylesheetParameter> parameters = actionConfig.getStylesheetParameters();
        String actionTypeName = null;
        Image image = null;
        ArrayList<String> additionalDisplayProperties = new ArrayList<String>();
        boolean includeOutput = true;
        block38 : switch (actionType) {
            case "aaa": {
                actionTypeName = "AAA";
                image = ProbeContextInfo.AAA_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>AAA Policy: %s</p>", actionConfig.getAAA().getName()));
                break;
            }
            case "call": {
                actionTypeName = "Call Processing Rule";
                image = ProbeContextInfo.CALL_PROCESSING_RULE_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Processing Rule: %s</p>", actionConfig.getRule()));
                break;
            }
            case "conditional": {
                actionTypeName = "Conditional";
                image = ProbeContextInfo.CONDITIONAL_ACTION_IMAGE;
                ArrayList<Condition> conditions = actionConfig.getCondition();
                if (CollectionUtility.isNotEmpty(conditions)) {
                    StringBuilder conditionTable = new StringBuilder("<br/><table border='0'><tr><th colspan='2'>Conditions</tr><tr><th>Expression</th><th>Action</th></tr>");
                    for (Condition condition : conditions) {
                        conditionTable.append(String.format("<tr><td>%s</td><td>%s</td></tr>", condition.getExpression(), condition.getConditionAction()));
                    }
                    conditionTable.append("</table><br/>");
                    additionalDisplayProperties.add(conditionTable.toString());
                }
                includeOutput = false;
                break;
            }
            case "convert-http": {
                actionTypeName = "Convert Query Params to XML";
                image = ProbeContextInfo.CONVERT_HTTP_ACTION_IMAGE;
                ObjectReference<ConfigHTTPInputConversionMap> inputConversionMap = actionConfig.getInputConversion();
                if (inputConversionMap == null) break;
                String inputConversion = inputConversionMap.getName();
                additionalDisplayProperties.add(String.format("<p>Input Conversion: %s</p>", inputConversion));
                break;
            }
            case "cryptobin": {
                actionTypeName = "Crypto Binary";
                image = ProbeContextInfo.CRYPTO_BINARY_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", actionConfig.getDestination()));
                break;
            }
            case "event-sink": {
                actionTypeName = "Event Sink";
                image = ProbeContextInfo.EVENT_SYNC_IMAGE;
                ArrayList<String> asyncActions = actionConfig.getAsyncAction();
                if (CollectionUtility.isNotEmpty(asyncActions)) {
                    for (String asyncAction : asyncActions) {
                        additionalDisplayProperties.add(String.format("<p>Asynchronous Action: %s</p>", asyncAction));
                    }
                }
                additionalDisplayProperties.add(String.format("<p>Timeout: %d</p>", actionConfig.getTimeout()));
                break;
            }
            case "extract": {
                Iterator<StylesheetParameter> variable;
                actionTypeName = "Extract using XPath";
                image = ProbeContextInfo.EXTRACT_ACTION_IMAGE;
                String xPath = actionConfig.getXPath();
                if (xPath != null) {
                    additionalDisplayProperties.add(String.format("<p>XPath: %s</p>", xPath));
                }
                if ((variable = actionConfig.getVariable()) == null) break;
                additionalDisplayProperties.add(String.format("<p>Variable: %s</p>", variable));
                break;
            }
            case "fetch": {
                actionTypeName = "Fetch";
                image = ProbeContextInfo.FETCH_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>URL: %s</p>", actionConfig.getDestination()));
                additionalDisplayProperties.add(String.format("<p>Method: %s</p>", actionConfig.getMethodType()));
                break;
            }
            case "filter": {
                if (CollectionUtility.isNotEmpty(parameters)) {
                    for (StylesheetParameter parameter : parameters) {
                        String parameterName = parameter.getParameterName();
                        if (parameterName.contains("decryptkey")) {
                            actionTypeName = "Verify";
                            image = ProbeContextInfo.VERIFY_ACTION_IMAGE;
                            break;
                        }
                        if (!parameterName.contains("ICAPRemoteHost")) continue;
                        actionTypeName = "Anti-Virus";
                        image = ProbeContextInfo.ANTI_VIRUS_ACTION_IMAGE;
                        break;
                    }
                }
                if (actionTypeName == null) {
                    actionTypeName = "Filter";
                    image = ProbeContextInfo.FILTER_ACTION_IMAGE;
                }
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", actionConfig.getDestination()));
                includeOutput = false;
                break;
            }
            case "loop": 
            case "for-each": {
                actionTypeName = "For Each";
                image = ProbeContextInfo.FOREACH_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Use Multiple Outputs: %s</p>", actionConfig.getMultipleOutputs()));
                String iteratorType = actionConfig.getIteratorType();
                additionalDisplayProperties.add(String.format("<p>Iterator Type: %s</p>", iteratorType));
                if (iteratorType.equals(DPEnumerations.ITERATOR_TYPE[0])) {
                    additionalDisplayProperties.add(String.format("<p>XPath Expression: %s</p>", actionConfig.getXPath()));
                } else {
                    additionalDisplayProperties.add(String.format("<p>Iterator Count: %d</p>", actionConfig.getIteratorCount()));
                }
                additionalDisplayProperties.add(String.format("<p>Loop Action: %s</p>", actionConfig.getLoopAction()));
                break;
            }
            case "gatewayscript": {
                actionTypeName = "Gateway Script";
                image = ProbeContextInfo.GATEWAY_SCRIPT_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>GatewayScript File: %s</p>", actionConfig.getGatewayScriptLocation()));
                additionalDisplayProperties.add(String.format("<p>GatewayScript Debug: %s</p>", actionConfig.getActionDebug()));
                break;
            }
            case "header-rewrite": {
                actionTypeName = "Header Rewrite";
                image = ProbeContextInfo.HEADER_REWRITE_ACTION_IMAGE;
                ObjectReference<ConfigURLRewritePolicy> urlRewritePolicy = actionConfig.getPolicy();
                if (urlRewritePolicy != null) {
                    additionalDisplayProperties.add(String.format("<p>URL Rewrite Policy: %s</p>", urlRewritePolicy.getName()));
                }
                includeOutput = false;
                break;
            }
            case "jose-decrpyt": {
                actionTypeName = "JSON Web Decrypt";
                image = ProbeContextInfo.JSON_WEB_DECRYPT_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>GatewayScript File: %s</p>", actionConfig.getGatewayScriptLocation()));
                String joseDecryptType = actionConfig.getJOSEDecryptType();
                additionalDisplayProperties.add(String.format("<p>Identifier Type: %s</p>", joseDecryptType));
                switch (joseDecryptType) {
                    case "identifiers": {
                        Object recipientIdentifiers = actionConfig.getRecipientIdentifier();
                        if (!CollectionUtility.isNotEmpty(recipientIdentifiers)) break block38;
                        Iterator iterator = ((ArrayList)recipientIdentifiers).iterator();
                        while (iterator.hasNext()) {
                            ObjectReference ref = (ObjectReference)iterator.next();
                            additionalDisplayProperties.add(String.format("<p>Recipient Identifier: %s</p>", ref.getName()));
                        }
                        break block38;
                    }
                    case "single-key": {
                        additionalDisplayProperties.add(String.format("<p>Private Key: %s</p>", actionConfig.getSingleKey().getName()));
                        break;
                    }
                    case "single-sskey": {
                        additionalDisplayProperties.add(String.format("<p>Shared Secret Key: %s</p>", actionConfig.getSingleSSKey().getName()));
                        break;
                    }
                    case "direct-key": {
                        additionalDisplayProperties.add(String.format("<p>Direct Key: %s</p>", actionConfig.getJWEDirectKeyObject().getName()));
                    }
                }
                break;
            }
            case "jose-encrypt": {
                actionTypeName = "JSON Web Encrypt";
                image = ProbeContextInfo.JSON_WEB_ENCRYPT_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>GatewayScript File: %s</p>", actionConfig.getGatewayScriptLocation()));
                additionalDisplayProperties.add(String.format("<p>Serialization: %s</p>", actionConfig.getJOSESerializationType()));
                additionalDisplayProperties.add(String.format("<p>Algorithm: %s</p>", actionConfig.getJWEEncAlgorithm()));
                additionalDisplayProperties.add(String.format("<p>JWE Header: %s</p>", actionConfig.getJWEHeaderObject().getName()));
                break;
            }
            case "jose-sign": {
                actionTypeName = "JSON Web Sign";
                image = ProbeContextInfo.JSON_WEB_SIGN_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>GatewayScript File: %s</p>", actionConfig.getGatewayScriptLocation()));
                additionalDisplayProperties.add(String.format("<p>Serialization: %s</p>", actionConfig.getJOSESerializationType()));
                additionalDisplayProperties.add(String.format("<p>Signature: %s</p>", actionConfig.getJWSSignatureObject().getName()));
                break;
            }
            case "jose-verify": {
                actionTypeName = "JSON Web Verify";
                image = ProbeContextInfo.JSON_WEB_VERIFY_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>GatewayScript File: %s</p>", actionConfig.getGatewayScriptLocation()));
                String joseVerifyType = actionConfig.getJOSEVerifyType();
                switch (joseVerifyType) {
                    case "identifiers": {
                        ArrayList<ObjectReference<ConfigJOSERecipientIdentifier>> recipientIdentifiers = actionConfig.getRecipientIdentifier();
                        if (!CollectionUtility.isNotEmpty(recipientIdentifiers)) break;
                        for (ObjectReference<ConfigJOSERecipientIdentifier> ref : recipientIdentifiers) {
                            additionalDisplayProperties.add(String.format("<p>Recipient Identifier: %s</p>", ref.getName()));
                        }
                        break;
                    }
                    case "single-cert": {
                        additionalDisplayProperties.add(String.format("<p>Certificate: %s</p>", actionConfig.getSingleCertificate().getName()));
                        break;
                    }
                    case "single-sskey": {
                        additionalDisplayProperties.add(String.format("<p>Shared Secret Key: %s</p>", actionConfig.getSingleSSKey().getName()));
                    }
                }
                additionalDisplayProperties.add(String.format("<p>Strip Signature: %s</p>", actionConfig.getJWSVerifyStripSignature()));
                break;
            }
            case "log": {
                actionTypeName = "Log";
                image = ProbeContextInfo.LOG_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>External URL: %s</p>", actionConfig.getDestination()));
                additionalDisplayProperties.add(String.format("<p>Log Level: %s</p>", actionConfig.getLogLevel()));
                additionalDisplayProperties.add(String.format("<p>Log Type: %s</p>", actionConfig.getLogType().getName()));
                additionalDisplayProperties.add(String.format("<p>Method: %s</p>", actionConfig.getMethodType()));
                break;
            }
            case "method-rewrite": {
                actionTypeName = "Method Rewrite";
                image = ProbeContextInfo.METHOD_REWRITE_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Method: %s</p>", actionConfig.getMethodRewriteType()));
                includeOutput = false;
                break;
            }
            case "on-error": {
                actionTypeName = "On Error";
                image = ProbeContextInfo.ON_ERROR_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Error Mode: %s</p>", actionConfig.getErrorMode()));
                additionalDisplayProperties.add(String.format("<p>Error Input: %s</p>", actionConfig.getErrorInput()));
                additionalDisplayProperties.add(String.format("<p>Error Output: %s</p>", actionConfig.getErrorOutput()));
                includeOutput = false;
                break;
            }
            case "parse": {
                actionTypeName = "Parse";
                image = ProbeContextInfo.PARSE_ACTION_IMAGE;
                DynamicParseSettingsReference parseSettings = actionConfig.getParseSettingsReference();
                if (parseSettings != null) {
                    String urlRef = parseSettings.getURL();
                    String literalConfig = parseSettings.getLiteral();
                    ObjectReference<ConfigParseSettings> defaultType = parseSettings.getDefaultType();
                    if (StringUtility.isNotEmpty(urlRef)) {
                        additionalDisplayProperties.add(String.format("<p>URL Reference: %s</p>", actionConfig.getErrorOutput()));
                    }
                    if (StringUtility.isNotEmpty(literalConfig)) {
                        additionalDisplayProperties.add(String.format("<p>Literal Configuration: %s</p>", actionConfig.getErrorOutput()));
                    }
                    if (defaultType != null) {
                        additionalDisplayProperties.add(String.format("<p>Parse Settings: %s</p>", defaultType.getName()));
                    }
                }
                additionalDisplayProperties.add(String.format("<p>Parse Metrics Result Type: %s</p>", actionConfig.getParseMetricsResultType()));
                additionalDisplayProperties.add(String.format("<p>Parse Metrics Result Location: %s</p>", actionConfig.getParseMetricsResultLocation()));
                break;
            }
            case "results": {
                actionTypeName = "Results";
                image = ProbeContextInfo.RESULTS_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Transactional: %s</p>", actionConfig.getTransactional()));
                String resultsDestination = actionConfig.getDestination();
                if (StringUtility.isNotEmpty(resultsDestination)) {
                    additionalDisplayProperties.add(String.format("<p>Destination: %s</p>", resultsDestination));
                }
                additionalDisplayProperties.add(String.format("<p>Multi-Way Results Mode: %s</p>", actionConfig.getResultsMode()));
                additionalDisplayProperties.add(String.format("<p>Number of Retries: %d</p>", actionConfig.getRetryCount()));
                additionalDisplayProperties.add(String.format("<p>Retry Interval: %d</p>", actionConfig.getRetryInterval()));
                additionalDisplayProperties.add(String.format("<p>Use Multiple Outputs: %s</p>", actionConfig.getMultipleOutputs()));
                additionalDisplayProperties.add(String.format("<p>Method: %s</p>", actionConfig.getMethodType()));
                break;
            }
            case "results-async": {
                actionTypeName = "Results Asynchronous";
                image = ProbeContextInfo.RESULTS_ASYNCHRONOUS_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Transactional: %s</p>", actionConfig.getTransactional()));
                String asynchDestination = actionConfig.getDestination();
                if (StringUtility.isNotEmpty(asynchDestination)) {
                    additionalDisplayProperties.add(String.format("<p>Destination: %s</p>", asynchDestination));
                }
                additionalDisplayProperties.add(String.format("<p>Multi-Way Results Mode: %s</p>", actionConfig.getResultsMode()));
                additionalDisplayProperties.add(String.format("<p>Number of Retries: %d</p>", actionConfig.getRetryCount()));
                additionalDisplayProperties.add(String.format("<p>Retry Interval: %d</p>", actionConfig.getRetryInterval()));
                additionalDisplayProperties.add(String.format("<p>Use Multiple Outputs: %s</p>", actionConfig.getMultipleOutputs()));
                additionalDisplayProperties.add(String.format("<p>Method: %s</p>", actionConfig.getMethodType()));
                includeOutput = false;
                break;
            }
            case "route-action": {
                actionTypeName = "Route";
                image = ProbeContextInfo.ROUTE_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Route Type: %s</p>", actionConfig.getType()));
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", actionConfig.getTransform()));
                includeOutput = false;
                break;
            }
            case "route-set": {
                actionTypeName = "Route Using Variable";
                image = ProbeContextInfo.ROUTE_USING_VARIABLE_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Route Type: %s</p>", actionConfig.getType()));
                additionalDisplayProperties.add(String.format("<p>Destination: %s</p>", actionConfig.getDestination()));
                String tlsClientType = actionConfig.getSSLClientConfigType();
                if (StringUtility.isNotEmpty(tlsClientType)) {
                    additionalDisplayProperties.add(String.format("<p>TLS Client Type: %s</p>", tlsClientType));
                    if (tlsClientType.equals("proxy")) {
                        sslCredRef = actionConfig.getSSLCred();
                        if (sslCredRef != null) {
                            additionalDisplayProperties.add(String.format("<p>SSL Proxy Pofile: %s</p>", sslCredRef));
                        }
                    } else {
                        sslCredRef = actionConfig.getSSLClientCred();
                        if (sslCredRef != null) {
                            additionalDisplayProperties.add(String.format("<p>TLS Client Profile: %s</p>", sslCredRef.getName()));
                        }
                    }
                }
                includeOutput = false;
                break;
            }
            case "setvar": {
                actionTypeName = "Set Variable";
                image = ProbeContextInfo.SET_VARIABLE_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Variable Name: %s</p>", actionConfig.getVariable()));
                additionalDisplayProperties.add(String.format("<p>Variable Assignment: %s</p>", actionConfig.getValue()));
                includeOutput = false;
                break;
            }
            case "sign": {
                actionTypeName = "Sign";
                image = ProbeContextInfo.SIGN_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", actionConfig.getTransform()));
                break;
            }
            case "slm": {
                actionTypeName = "SLM";
                image = ProbeContextInfo.SLM_ACTION_IMAGE;
                String slmPolicyRef = actionConfig.getSLMPolicy();
                if (StringUtility.isNotEmpty(slmPolicyRef)) {
                    additionalDisplayProperties.add(String.format("<p>SLM Policy: %s</p>", slmPolicyRef));
                }
                includeOutput = false;
                break;
            }
            case "sql": {
                actionTypeName = "SQL";
                image = ProbeContextInfo.SQL_ACTION_IMAGE;
                String sqlSourceType = actionConfig.getSQLSourceType();
                additionalDisplayProperties.add(String.format("<p>SQL Input Method: %s</p>", sqlSourceType));
                ObjectReference<ConfigSQLDataSource> sqlDataSourceRef = actionConfig.getSQLDataSource();
                if (sqlDataSourceRef != null) {
                    additionalDisplayProperties.add(String.format("<p>SQL Source: %s</p>", sqlDataSourceRef.getName()));
                }
                if (sqlSourceType.equals(DPEnumerations.SQLSOURCE_TYPE[0])) {
                    additionalDisplayProperties.add(String.format("<p>SQL Text: %s</p>", actionConfig.getSQLText()));
                    break;
                }
                if (sqlSourceType.equals(DPEnumerations.SQLSOURCE_TYPE[1])) {
                    additionalDisplayProperties.add(String.format("<p>Variable: %s</p>", actionConfig.getVariable()));
                    break;
                }
                if (!sqlSourceType.equals(DPEnumerations.SQLSOURCE_TYPE[2])) break;
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", actionConfig.getTransform()));
                break;
            }
            case "strip-attachments": {
                actionTypeName = "Strip Attachments";
                image = ProbeContextInfo.STRIP_ATTACHMENTS_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Attachment URI: %s</p>", actionConfig.getAttachmentURI()));
                break;
            }
            case "validate": {
                ObjectReference<ConfigDynamicSchema> schemaExceptionMap;
                String wsdlURL;
                String jsonSchemaURL;
                actionTypeName = "Validate";
                image = ProbeContextInfo.VALIDATE_ACTION_IMAGE;
                String validateType = "";
                String displayProperty = "";
                ObjectReference<ConfigURLRewritePolicy> urlPolicyRef = actionConfig.getPolicy();
                if (urlPolicyRef != null) {
                    validateType = "Validate via Attribute Rewrite Rule";
                    displayProperty = String.format("<p>URL Rewrite Policy: %s</p>", urlPolicyRef.getName());
                }
                if (StringUtility.isNotEmpty(jsonSchemaURL = actionConfig.getJSONSchemaURL())) {
                    validateType = "Validate via JSON Schema URL";
                }
                displayProperty = String.format("<p>JSON Schema URL: %s</p>", jsonSchemaURL);
                String schemaURL = actionConfig.getSchemaURL();
                if (StringUtility.isNotEmpty(schemaURL)) {
                    validateType = "Validate via Schema Attribute";
                    displayProperty = String.format("<p>Schema URL: %s</p>", schemaURL);
                }
                if (StringUtility.isNotEmpty(wsdlURL = actionConfig.getWsdlURL())) {
                    validateType = "Validate via WDSL URL";
                    displayProperty = String.format("<p>WSDL URL: %s</p>", wsdlURL);
                }
                if ((schemaExceptionMap = actionConfig.getDynamicSchema()) != null) {
                    validateType = "Validate with Encrypted Sections";
                    displayProperty = String.format("<p>Schema Exception Map: %s</p>", schemaExceptionMap.getName());
                }
                additionalDisplayProperties.add(String.format("<p>Validate Type: %s</p>", validateType));
                additionalDisplayProperties.add(displayProperty);
                break;
            }
            case "xform": {
                String transformFileName = actionConfig.getTransform();
                if (!StringUtility.isNotEmpty(transformFileName)) break;
                if (transformFileName.startsWith("store:///sign")) {
                    actionTypeName = "Sign";
                    image = ProbeContextInfo.SIGN_ACTION_IMAGE;
                } else if (transformFileName.startsWith("store:///encrypt")) {
                    actionTypeName = "Encrypt";
                    image = ProbeContextInfo.ENCRYPT_ACTION_IMAGE;
                } else if (transformFileName.startsWith("store:///decrypt")) {
                    actionTypeName = "Decrypt";
                    image = ProbeContextInfo.DECRYPT_ACTION_IMAGE;
                } else if (transformFileName.equals("store:///mq-header.xsl")) {
                    actionTypeName = "MQ Header";
                    image = ProbeContextInfo.MQ_HEADER_ACTION_IMAGE;
                } else {
                    actionTypeName = "Transform with XSLT Stylesheet";
                    image = ProbeContextInfo.TRANSFORM_WITH_XSL_STYLESHEET_ACTION_IMAGE;
                }
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", transformFileName));
                break;
            }
            case "xformbin": {
                actionTypeName = "Transform Binary";
                image = ProbeContextInfo.TRANSFORM_BINARY_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", actionConfig.getTransform()));
                additionalDisplayProperties.add(String.format("<p>ITX Map File: %s</p>", actionConfig.getTxMap()));
                additionalDisplayProperties.add(String.format("<p>ITX Map Mode: %s</p>", actionConfig.getTxMode()));
                additionalDisplayProperties.add(String.format("<p>ITX Audit Log: %s</p>", actionConfig.getTxAuditLog()));
                ObjectReference<ConfigURLRewritePolicy> binURLRewriteRef = actionConfig.getPolicy();
                if (binURLRewriteRef == null) break;
                additionalDisplayProperties.add(String.format("<p>URL Rewrite Policy: %s</p>", binURLRewriteRef.getName()));
                break;
            }
            case "xformpc": {
                actionTypeName = "Transform with Processing Control File";
                image = ProbeContextInfo.TRANSFORM_WITH_PROCESSING_CONTROL_FILE_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", actionConfig.getTransform()));
                additionalDisplayProperties.add(String.format("<p>Input Language: %s</p>", actionConfig.getInputLanguage()));
                additionalDisplayProperties.add(String.format("<p>Transform Language: %s</p>", actionConfig.getTransformLanguage()));
                additionalDisplayProperties.add(String.format("<p>Output Language: %s</p>", actionConfig.getOutputLanguage()));
                ObjectReference<ConfigURLRewritePolicy> binURLRewriteRefPC = actionConfig.getPolicy();
                if (binURLRewriteRefPC == null) break;
                additionalDisplayProperties.add(String.format("<p>URL Rewrite Policy: %s</p>", binURLRewriteRefPC.getName()));
                break;
            }
            case "xformpi": {
                actionTypeName = "Transform with Processing Instructions";
                image = ProbeContextInfo.TRANSFORM_WITH_PROCESSING_INSTRUCTIONS_ACTION_IMAGE;
                additionalDisplayProperties.add(String.format("<p>Transform File: %s</p>", actionConfig.getTransform()));
                ObjectReference<ConfigURLRewritePolicy> binURLRewriteRefPI = actionConfig.getPolicy();
                if (binURLRewriteRefPI == null) break;
                additionalDisplayProperties.add(String.format("<p>URL Rewrite Policy: %s</p>", binURLRewriteRefPI.getName()));
                break;
            }
            default: {
                actionTypeName = "Error determining action type";
                image = ProbeContextInfo.ERROR_IMAGE;
                AbstractPanel.logger.severe(() -> LMG.log("(actionType=%s):  Action type is not handled.", () -> actionType));
            }
        }
        String DETERMINED_TYPE = actionTypeName;
        logger.finer(() -> LMG.log("(TransactionContext):  Action type '%s' name is '%s'", () -> actionType, () -> DETERMINED_TYPE));
        String actionName = actionConfig.getName();
        ArrayList<StylesheetParameter> stylesheetParameters = actionConfig.getStylesheetParameters();
        StringBuilder sb = new StringBuilder("<html><body>");
        sb.append(String.format("<p>Action Name: %s</p>", actionName));
        sb.append(String.format("<p>Action Type: %s</p>", actionTypeName));
        sb.append(String.format("<p>Input: %s</p>", transactionContext.getTransactionIdentity().getInputContext()));
        for (String displayProperty : additionalDisplayProperties) {
            sb.append(displayProperty);
        }
        if (includeOutput) {
            sb.append(String.format("<p>Output: %s</p>", actionConfig.getOutput()));
            sb.append(String.format("<p>Output Type: %s</p>", actionConfig.getOutputType()));
        }
        sb.append(String.format("<p>Asynchronous: %s</p>", actionConfig.getAsynchronous()));
        if (CollectionUtility.isNotEmpty(stylesheetParameters)) {
            sb.append("<br/><table border='0'><tr><th colspan='2'>Stylesheet Parameters</tr><tr><th>Parameter Name</th><th>Parameter Value</th></tr>");
            for (StylesheetParameter parameter : stylesheetParameters) {
                sb.append(String.format("<tr><td>%s</td><td>%s</td></tr>", parameter.getParameterName(), parameter.getParameterValue()));
            }
            sb.append("</table>");
        }
        sb.append("</body></html>");
        AbstractPanel.logger.finer(() -> LMG.log("(actionType=%s):  Creating action button.", () -> DETERMINED_TYPE));
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(image);
        }
        catch (NullPointerException e) {
            AbstractPanel.logger.severe(() -> LMG.log("(actionType=%s):  Action button image is null.", () -> DETERMINED_TYPE));
        }
        JMButton actionComponent = null;
        if (icon == null) {
            icon = new ImageIcon(ProbeContextInfo.UNKNOWN_ACTION_IMAGE);
            actionComponent = new JMButton(icon, sb.toString());
            actionComponent.setToolTipText(String.format("Action image for '%s' is missing.  Please report this to Kumbasoft Technical Support.", DETERMINED_TYPE));
        } else {
            actionComponent = new JMButton(icon, sb.toString());
        }
        return actionComponent;
    }

    @Reflected
    private void showContext(TransactionContext context) {
        new ContextViewDialog((JDialog)GUIServices.getParentWindow(this), context);
    }

    @Reflected
    private void showContext(int contextNumber, String contextName) {
        AbstractPanel.logger.finer(() -> LMG.log("(contextNumber=%d, contextName=%s)\n", () -> contextNumber, () -> contextName));
        ArrayList<TransactionContext> transactionContexts = this.transactionRule.getTransactionContexts();
        int contextCount = transactionContexts.size();
        TransactionContext contextToShow = null;
        if (contextName.equals("NULL")) {
            contextToShow = contextNumber < contextCount - 1 ? transactionContexts.get(contextNumber + 1) : transactionContexts.get(contextNumber);
        } else {
            int cn = contextNumber + 1;
            while (cn < transactionContexts.size()) {
                TransactionContext transactionContext = transactionContexts.get(cn);
                TransactionIdentity transactionIdentity = transactionContext.getTransactionIdentity();
                String inputContextName = transactionIdentity.getInputContext();
                if (inputContextName.equals(contextName)) {
                    contextToShow = transactionContext;
                    break;
                }
                ++cn;
            }
            if (contextToShow == null) {
                contextToShow = transactionContexts.get(contextNumber);
            }
        }
        this.showContext(contextToShow);
    }

    @Reflected
    private void showActionContext(TransactionContext context) {
        new ActionViewDialog((JDialog)GUIServices.getParentWindow(this), context);
    }
}

