/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.probe.TransactionManifest;
import com.kumbasoft.core.beans.probe.TransactionRule;
import com.kumbasoft.core.beans.probe.TransactionRuleReader;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.dialogs.probe.TransactionRulePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;

public class TransactionViewPanel
extends AbstractPanel {
    private TransactionManifest transactionManifest;
    private JMLabel lblAppliance;
    private JMLabel lblDomain;
    private JMLabel lblServceType;
    private JMLabel lblServiceObject;
    private JMLabel lblServicePolicy;
    private JMLabel lblClientIP;
    private JMLabel lblTransactionID;
    private JMLabel lblTransactionTime;
    private JMLabel lblURLIn;
    private JMLabel lblURLOut;
    private JMPanel rulePanel;

    public TransactionViewPanel(TransactionManifest transactionManifest) {
        super(KumbaCoreUIConstants.createVerticalFlowLayout(3));
        this.setBorder(BorderFactory.createLineBorder(KumbaCoreUIConstants.LIGHT_BACKGROUND));
        this.transactionManifest = transactionManifest;
        this.add(this.createTopPanel());
        new ComponentEventInvoker(this, 8, (Object)this, "resizeRulePanel");
        this.showTransaction();
    }

    private JMPanel createTopPanel() {
        this.lblAppliance = new JMLabel(this.transactionManifest.getAppliance().getName());
        this.lblDomain = new JMLabel(this.transactionManifest.getDomain().getName());
        this.lblServceType = new JMLabel(this.transactionManifest.getServiceType());
        this.lblServiceObject = new JMLabel(this.transactionManifest.getServiceName());
        this.lblServicePolicy = new JMLabel(this.transactionManifest.getPolicyName());
        this.lblClientIP = new JMLabel(this.transactionManifest.getClientIP());
        this.lblTransactionID = new JMLabel("" + this.transactionManifest.getTransactionID());
        this.lblTransactionTime = new JMLabel(this.transactionManifest.getTransactionTime().toString());
        this.lblURLIn = new JMLabel(this.transactionManifest.getInURL());
        this.lblURLOut = new JMLabel(this.transactionManifest.getOutURL());
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createGridLayout(4, 2));
        panel.addAll(new LabeledComponent("Appliance:", (Component)this.lblAppliance), new LabeledComponent("Service Policy:", (Component)this.lblServicePolicy), new LabeledComponent("Domain:", (Component)this.lblDomain), new LabeledComponent("Client IP:", (Component)this.lblClientIP), new LabeledComponent("Service Type:", (Component)this.lblServceType), new LabeledComponent("Transaction ID:", (Component)this.lblTransactionID), new LabeledComponent("Service Object:", (Component)this.lblServiceObject), new LabeledComponent("URL In:", (Component)this.lblURLIn), new LabeledComponent("URL Out:", (Component)this.lblURLOut), new LabeledComponent("Transaction Time:", (Component)this.lblTransactionTime));
        return panel;
    }

    @Reflected
    private void resizeRulePanel() {
        if (this.rulePanel == null) {
            return;
        }
        AbstractPanel.logger.finer("(): Starting");
        Dimension thisSize = this.getSize();
        Insets insets = this.getInsets();
        int width = thisSize.width - insets.left - insets.right;
        Component[] components = this.rulePanel.getComponents();
        AbstractPanel.logger.finer(() -> LMG.log("(): Panel Size: (%d, %d).  New rule panel width: %d.   Number of panels: %d", () -> dimension.width, () -> dimension.height, () -> width, () -> components.length));
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component rulePanel = componentArray[n2];
            Dimension panelSize = rulePanel.getSize();
            Dimension newPanelSize = new Dimension(width, panelSize.height);
            rulePanel.setSize(newPanelSize);
            rulePanel.setPreferredSize(newPanelSize);
            ++n2;
        }
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    private void showTransaction() {
        AbstractPanel.logger.finer("(): Starting.");
        ArrayList<TransactionRule> transactionRules = this.transactionManifest.getTransactionRules();
        if (CollectionUtility.isEmpty(transactionRules)) {
            AbstractPanel.logger.finer("(): No rules yet exist for transaction manifest.  Reading rules..");
            TransactionRuleReader.readTransactionData(this.transactionManifest);
            transactionRules = this.transactionManifest.getTransactionRules();
        }
        int ruleCount = CollectionUtility.isEmpty(transactionRules) ? 0 : transactionRules.size();
        AbstractPanel.logger.finer(() -> LMG.log("(): Manifest has %d rules.", () -> ruleCount));
        this.rulePanel = new JMPanel(KumbaCoreUIConstants.createVerticalFlowLayout(3));
        int widestRulePanel = 0;
        for (TransactionRule transactionRule : transactionRules) {
            AbstractPanel.logger.finer(() -> LMG.log("(): Building rule panel %d.", () -> transactionRule.getRuleNumber()));
            TransactionRulePanel transactionRulePanel = new TransactionRulePanel(transactionRule);
            this.rulePanel.add(transactionRulePanel);
            int rulePanelWidth = transactionRulePanel.getWidth();
            if (rulePanelWidth <= widestRulePanel) continue;
            widestRulePanel = rulePanelWidth;
        }
        int totalWidth = widestRulePanel;
        AbstractPanel.logger.finer(() -> LMG.log("(): Widest rule panel is %d.", () -> totalWidth));
        this.rulePanel.setPreferredSize(widestRulePanel, 90 * transactionRules.size());
        this.add((Component)this.rulePanel, "Center");
        AbstractPanel.logger.finer("(): Done.");
    }
}

