/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.snapshotWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.Index;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JDialog;
import javax.swing.ListModel;

public class SnapshotDiffSelectionWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private JMListModel<String> sourceModel;
    private JMListModel<String> targetModel;
    private JMList<String> sourceList;
    private JMList<String> targetList;
    private File snapShotsDirectory;
    private Index<Appliance, Domain> domains;

    public SnapshotDiffSelectionWizardPage(DynamicBean model) {
        super(model);
    }

    public SnapshotDiffSelectionWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        String sourceDate = this.sourceList.getSelectedItem();
        String targetDate = this.targetList.getSelectedItem();
        ((DynamicBean)this.model).setProperty("sourceDate", sourceDate);
        ((DynamicBean)this.model).setProperty("targetDate", targetDate);
    }

    @Override
    public boolean isDataValid() {
        String sourceDate = this.sourceList.getSelectedItem();
        String targetDate = this.targetList.getSelectedItem();
        if (sourceDate == null || targetDate == null) {
            new JMMessageBox((JDialog)this.parentDialog, "Invalid Selection", "Select at least one source date and one target date.");
            return false;
        }
        if (sourceDate.equals(targetDate)) {
            new JMMessageBox((JDialog)this.parentDialog, "Duplicate Seletion", "The source and target dates cannot be the same.");
            return false;
        }
        return true;
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.snapShotsDirectory = (File)((DynamicBean)this.model).getProperty("snapshotDirectory");
        this.domains = (Index)((DynamicBean)this.model).getProperty("selectedDomains");
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createGridLayout(1, 2));
        ArrayList<String> snapShotDates = this.getSnapshotDates();
        this.sourceModel = new JMListModel<String>(snapShotDates);
        this.targetModel = new JMListModel<String>(snapShotDates);
        this.sourceList = new JMList<String>((ListModel<String>)this.sourceModel);
        this.targetList = new JMList<String>((ListModel<String>)this.targetModel);
        LabeledComponent lcSource = new LabeledComponent("Select Source:", (Component)new JMScrollPane(this.sourceList), 1);
        LabeledComponent lcTarget = new LabeledComponent("Select Target:", (Component)new JMScrollPane(this.targetList), 1);
        panel.addAll(lcSource, lcTarget);
        return panel;
    }

    private ArrayList<String> getSnapshotDates() {
        File[] snapShots;
        ArrayList<String> dates = new ArrayList<String>();
        if (!this.snapShotsDirectory.exists()) {
            return dates;
        }
        File[] fileArray = snapShots = this.snapShotsDirectory.listFiles();
        int n = snapShots.length;
        int n2 = 0;
        while (n2 < n) {
            File snapShot = fileArray[n2];
            if (this.snapShotHasApplianceDomain(snapShot)) {
                dates.add(snapShot.getName());
            }
            ++n2;
        }
        Collections.sort(dates);
        return dates;
    }

    private boolean snapShotHasApplianceDomain(File snapshotDir) {
        File[] applianceDirectories;
        File[] fileArray = applianceDirectories = snapshotDir.listFiles();
        int n = applianceDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            File applianceDirectory = fileArray[n2];
            String applianceName = applianceDirectory.getName();
            for (Appliance appliance : this.domains.getKeys()) {
                File[] domainDirectories;
                if (!applianceName.equals(appliance.getName())) continue;
                File[] fileArray2 = domainDirectories = applianceDirectory.listFiles();
                int n3 = domainDirectories.length;
                int n4 = 0;
                while (n4 < n3) {
                    File domainDirectory = fileArray2[n4];
                    String domainName = domainDirectory.getName();
                    for (Domain domain : this.domains.get(appliance)) {
                        if (!domainName.equals(domain.getName())) continue;
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }
}

