/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.wizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractRefactorWizardPage;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.event.TableModelEvent;

public abstract class AbstractSaveAsRenameWizardPage
extends AbstractRefactorWizardPage {
    public AbstractSaveAsRenameWizardPage(DynamicBean model) {
        super(model);
    }

    public AbstractSaveAsRenameWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (!this.cbxSynchronizeChanges.isSelected() || this.table.getRowCount() < 2) {
            return;
        }
        ExtendedTableModelEvent tableModelEvent = (ExtendedTableModelEvent)evt;
        if (tableModelEvent.getType() == 0) {
            int row = tableModelEvent.getFirstRow();
            if (row == -1) {
                return;
            }
            DynamicBean editedData = this.tableModel.getValue(row);
            String type = (String)editedData.getProperty("dataPowerClass");
            String name = (String)editedData.getProperty("name");
            String newName = (String)editedData.getProperty("newName");
            int r = 0;
            while (r < this.tableModel.getRowCount()) {
                if (r != row) {
                    DynamicBean rData = this.tableModel.getValue(r);
                    String rType = (String)rData.getProperty("dataPowerClass");
                    String rName = (String)rData.getProperty("name");
                    if (type.equals(rType) && name.equals(rName)) {
                        rData.setProperty("newName", newName);
                    }
                }
                ++r;
            }
        }
        this.table.repaint();
    }

    @Override
    public boolean isDataValid() {
        ArrayList<DynamicBean> data = this.tableModel.getModelData();
        for (DynamicBean row : data) {
            String newName = (String)row.getProperty("newName");
            String oldName = (String)row.getProperty("name");
            if (oldName.equals(newName)) continue;
            if (StringUtility.isEmpty(newName) || !ConfigurationManager.isObjectNameValid(newName)) {
                new JMMessageBox((JDialog)this.parentDialog, "Invalid Name", String.format("The name '%s' is not valid.", newName));
                return false;
            }
            String type = (String)row.getProperty("dataPowerClass");
            for (StatusObjectStatus object : this.allObjectsByType.get(type)) {
                String objectType = object.getDataPowerClass();
                String objectName = object.getName();
                if (!newName.equals(objectName) || !type.equals(objectType) || this.shouldContinueDataValidation(type, oldName, newName)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract boolean shouldContinueDataValidation(String var1, String var2, String var3);

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        ArrayList selectedObjects = (ArrayList)((DynamicBean)this.model).getProperty("selectedObjects");
        this.refactorModel = new ArrayList(selectedObjects.size());
        for (StatusObjectStatus object : selectedObjects) {
            DynamicBean objectClone = new DynamicBean(object);
            objectClone.setProperty("newName", object.getName());
            this.refactorModel.add(objectClone);
        }
        return super.createControlsPanel();
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        tableModel.setEditableColumns("newName");
        return tableModel;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        this.columnModel = super.createColumnModel();
        this.columnModel.setColumnOrder("appliance", "sourceDomain", "dataPowerClass", "name", "newName");
        return this.columnModel;
    }
}

