/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.models;

import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.list.ThreadSafeListModelWorker;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DataPowerFileInfoListModel
extends JMListModel<String>
implements ConfigObjectSubscriber<DataPowerFileInfo> {
    private Set<String> directories;
    private ThreadSafeListModelWorker<String> listModelWorker;
    private ArrayList<String> exemptionPatterns;
    private boolean exemptionsExist;

    public DataPowerFileInfoListModel() {
        this.setOrdered(true);
        this.directories = Collections.synchronizedSet(new HashSet());
        this.listModelWorker = new ThreadSafeListModelWorker<String>(this);
    }

    public ArrayList<String> getExemptionPatterns() {
        return this.exemptionPatterns;
    }

    public void addExemptionPatterns(String ... exemptionPatterns) {
        String[] stringArray = exemptionPatterns;
        int n = exemptionPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String exemptionPattern = stringArray[n2];
            this.addExemptionPattern(exemptionPattern);
            ++n2;
        }
    }

    public void addExemptionPattern(String exemptionPattern) {
        if (this.exemptionPatterns == null) {
            this.exemptionPatterns = new ArrayList();
        }
        this.exemptionPatterns.add(exemptionPattern);
        this.exemptionsExist = true;
    }

    public void setExemptionPatterns(ArrayList<String> exemptionPatterns) {
        this.exemptionPatterns = exemptionPatterns;
        this.exemptionsExist = !CollectionUtility.isEmpty(exemptionPatterns);
    }

    @Override
    public void processDataPowerConfig(DataPowerFileInfo dataPowerConfig) {
        String directoryName;
        switch (directoryName = dataPowerConfig.getName()) {
            case "cert:": {
                String string = "cert:/";
                break;
            }
            case "config:": {
                String string = "config:/";
                break;
            }
            case "local:": {
                String string = "local:/";
                break;
            }
            case "logstore:": {
                String string = "logstore:/";
                break;
            }
            case "logtemp:": {
                String string = "logtemp:/";
                break;
            }
            case "pubcert:": {
                String string = "pubcert:/";
                break;
            }
            case "sharedcert:": {
                String string = "sharedcert:/";
                break;
            }
            case "store:": {
                String string = "store:/";
                break;
            }
            default: {
                String string = directoryName = directoryName;
            }
        }
        if (this.exemptionsExist) {
            for (String exemptionPattern : this.exemptionPatterns) {
                if (!directoryName.matches(exemptionPattern)) continue;
                return;
            }
        }
        if (!this.directories.contains(directoryName)) {
            this.directories.add(directoryName);
            this.listModelWorker.addElement(directoryName);
        }
    }

    @Override
    public void configProcessingComplete() {
    }
}

