/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.models;

import com.jmorgan.swing.dnd.FileDropHandlerListener;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.FileUploadBean;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.io.File;
import java.util.HashMap;

public class FileUploadTableModel
extends BeanTableModel<FileUploadBean>
implements FileDropHandlerListener {
    private static final HashMap<String, String> DIRECTORY_INFORMATION = new HashMap();
    private UniqueArrayList<String> listedDirectories;

    static {
        String[] stringArray = DPEnumerations.FILESTORE_LOCATION;
        int n = DPEnumerations.FILESTORE_LOCATION.length;
        int n2 = 0;
        while (n2 < n) {
            String fileStore = stringArray[n2];
            String plainFileStore = fileStore.replace(":", "");
            String localDir = String.format("%s%s%s", File.separator, plainFileStore, File.separator);
            DIRECTORY_INFORMATION.put(localDir, fileStore);
            ++n2;
        }
    }

    public FileUploadTableModel() {
        super(FileUploadBean.class);
        this.setEditableColumns("fileStore", "directory", "newDirectory", "fileName");
    }

    public UniqueArrayList<String> getListedDirectories() {
        return this.listedDirectories;
    }

    public void setListedDirectories(UniqueArrayList<String> listedDirectories) {
        this.listedDirectories = listedDirectories;
    }

    @Override
    public void addDroppedFile(File file) {
        if (file.isDirectory()) {
            this.addDroppedDirectory(file);
            return;
        }
        String defaultFileStore = "local:";
        String stripAfter = String.format("%slocal%s", File.separator, File.separator);
        String absolutePath = file.getAbsolutePath();
        boolean isDPFSSimile = false;
        for (String localDir : DIRECTORY_INFORMATION.keySet()) {
            if (!absolutePath.contains(localDir)) continue;
            stripAfter = localDir;
            defaultFileStore = DIRECTORY_INFORMATION.get(localDir);
            isDPFSSimile = true;
            break;
        }
        int stripAfterIndex = absolutePath.indexOf(stripAfter) + stripAfter.length();
        String fileDirectory = absolutePath.substring(stripAfterIndex - 1);
        fileDirectory = fileDirectory.replace(File.separatorChar + file.getName(), "");
        fileDirectory = fileDirectory.replace(File.separator, "/");
        if (fileDirectory.trim().length() == 0) {
            fileDirectory = "/";
        }
        String defaultDirectory = "/";
        String newDirectory = fileDirectory;
        if (!isDPFSSimile || fileDirectory.equals("/")) {
            newDirectory = "";
        } else if (CollectionUtility.isNotEmpty(this.listedDirectories)) {
            for (String directoryName : this.listedDirectories) {
                if (!directoryName.startsWith(defaultFileStore) || !(directoryName = directoryName.replace(defaultFileStore, "")).startsWith(fileDirectory)) continue;
                defaultDirectory = directoryName;
                newDirectory = fileDirectory.replace(defaultDirectory, "");
                break;
            }
        } else {
            newDirectory = "";
        }
        while (newDirectory.startsWith("/")) {
            newDirectory = newDirectory.substring(1);
        }
        FileUploadBean newRow = new FileUploadBean();
        newRow.setFile(file);
        newRow.setSourceFileName(absolutePath);
        newRow.setFileStore(defaultFileStore);
        newRow.setDirectory(defaultDirectory);
        newRow.setNewDirectory(newDirectory);
        newRow.setFileName(file.getName());
        try {
            this.addRow(newRow);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void addDroppedDirectory(File droppedDirectory) {
        File[] files;
        if (!droppedDirectory.isDirectory()) {
            return;
        }
        File[] fileArray = files = droppedDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addDroppedFile(file);
            ++n2;
        }
    }
}

