/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.Testing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.util.GUIServices;
import com.kumbasoft.core.tools.ApplianceInvocationProfile;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.FileUtility;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JFrame;

public class InvocationProfileViewPanel
extends AbstractTablePanel<ApplianceInvocationProfile> {
    private JMButton btnOpenFile;

    public InvocationProfileViewPanel() {
        super(ApplianceInvocationProfile.class);
        JMPanel buttonPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        this.btnOpenFile = ComponentFactory.createButton(KumbaCoreUIConstants.OPEN_ICON, "Open File", "Open An Invocation Profile File", true, this, "fileOpen", new Object[0]);
        buttonPanel.add(this.btnOpenFile);
        this.add((Component)buttonPanel, "North");
    }

    @Override
    protected void setupModel() {
        super.setupModel();
        this.columnModel.setColumnOrder("applianceName", "invokerTarget", "invokedMethod", "invocationCount", "averageTime");
    }

    @Reflected
    private void fileOpen() {
        File selectedFile = GUIServices.fileOpenDialog(null);
        if (selectedFile == null) {
            return;
        }
        this.tableModel.reset();
        ConcurrentHashMap invocationProfiles = (ConcurrentHashMap)FileUtility.readObject(selectedFile, true);
        if (invocationProfiles == null && (invocationProfiles = (ConcurrentHashMap)FileUtility.readObject(selectedFile, false)) == null) {
            new JMMessageBox((JFrame)frame, "Error Reading Profiles", "Please select a file containing\ninvocation profiles.");
            return;
        }
        Collection profiles = invocationProfiles.values();
        this.tableModel.addAll(profiles);
        this.displayTable.optimizeColumnWidths();
    }
}

