/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.cacheManagement;

import com.jmorgan.annotations.Reflected;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionFlushPDPCache;
import com.kumbasoft.core.beans.config.ConfigXACMLPDP;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.dpaa.ui.panels.cacheManagement.AbstractObjectCacheManagementPanel;

public class PDPCacheManagementPanel
extends AbstractObjectCacheManagementPanel<ConfigXACMLPDP> {
    @Override
    protected String getListNameLabel() {
        return "XACML PDP";
    }

    @Override
    protected String getObjectType() {
        return "XACMLPDP";
    }

    @Override
    protected String getButtonText() {
        return "Clear PDP Cache";
    }

    @Override
    protected String getButtonToolTip() {
        return "Clears the PDP Cache for all selected XACML objects";
    }

    @Override
    protected int getVerticalSpacingForClearButton() {
        return 0;
    }

    @Override
    protected String getActionEventMethod() {
        return "clearPDPCache";
    }

    @Reflected
    private void clearPDPCache() {
        this.openResultsDialogAndSetWaitCursor("Clear PDP Cache");
        this.clearCache("clearPDPCache");
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void clearPDPCache(Appliance appliance, Domain domain, String pdpPolicy) {
        ActionFlushPDPCache flushPDPCache = new ActionFlushPDPCache();
        ObjectReference<ConfigXACMLPDP> or = new ObjectReference<ConfigXACMLPDP>();
        or.setClassName("PDPPolicy");
        or.setName(pdpPolicy);
        flushPDPCache.setXACMLPDP(or);
        ActionTool actionTool = new ActionTool(appliance, domain, flushPDPCache);
        actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
    }
}

