/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.cli;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.KeyEventInvoker;
import com.jmorgan.swing.menu.JMMenu;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.tabbedpane.TabPlacementDNDController;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.SystemClipboard;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.ui.panels.cli.DataPowerSSHPanel;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CLIPanel
extends AbstractPanel {
    private static final ArrayList<Pair<String, String>> CLI_POPUP_MENU_ITEMS = new ArrayList();
    private JMTextField tfCLICommand;
    private JMButton btnSendCommand;
    private JMTabbedPane cliPanelTabbedPane;
    private JMLabel lblScriptFileName;
    private JMButton btnOpenScriptFile;
    private JMButton btnRunScript;
    private JMButton btnSaveScript;
    private JMTextArea taCLIScript;
    private File scriptFile;
    private HashMap<String, DataPowerSSHPanel> sshPanels;
    private ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private boolean runningScript;
    private boolean changingAppliances;

    static {
        try {
            String[] cliCommands;
            String cliCommandData = FileUtility.readFile(applicationProperties.getCliCommandsFileName());
            String[] stringArray = cliCommands = cliCommandData.split("\\R");
            int n = cliCommands.length;
            int n2 = 0;
            while (n2 < n) {
                String cliCommand = stringArray[n2];
                String[] menuItemElements = cliCommand.split("\\|");
                Pair<String, String> menuItems = new Pair<String, String>(menuItemElements[0], menuItemElements[1]);
                CLI_POPUP_MENU_ITEMS.add(menuItems);
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CLIPanel() {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.sshPanels = new HashMap();
        JMPanel cliCommandComponent = this.createCommandPanel();
        this.cliPanelTabbedPane = new JMTabbedPane();
        this.cliPanelTabbedPane.setTabLayoutPolicy(1);
        new TabPlacementDNDController(this.cliPanelTabbedPane);
        JMPanel bottomPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        bottomPanel.add((Component)this.cliPanelTabbedPane, "Center");
        bottomPanel.add((Component)this.createScriptPanel(), "West");
        this.add((Component)cliCommandComponent, "North");
        this.add((Component)bottomPanel, "Center");
        ApplianceDomainChangeMonitor.getInstance().addApplianceChangeSubscriber(this, "appliancesChanged");
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
    }

    private JMPanel createCommandPanel() {
        this.tfCLICommand = new JMTextField();
        ComponentService.addClearIcon(this.tfCLICommand, "Clear the CLI command");
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>();
        this.tfCLICommand.setFocusTraversalKeys(0, keys);
        keys.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        this.tfCLICommand.setFocusTraversalKeys(0, keys);
        this.tfCLICommand.setToolTipText("Press Enter to send the typed command to the appliances");
        LabeledComponent lblCLICommand = new LabeledComponent("CLI Command:", (Component)this.tfCLICommand, 100, 400);
        this.btnSendCommand = new JMButton(KumbaCoreUIConstants.START_ICON, "Send the command to the selected appliances.");
        this.btnSendCommand.setActivator(this.tfCLICommand, 10);
        MethodInvoker getCommandText = new MethodInvoker((Object)this.tfCLICommand, "getText", new Object[0]);
        new ActionEventInvoker(this.btnSendCommand, this, "sendSingleCommand", getCommandText);
        JMPanel commandPanel = new JMPanel(new BorderLayout());
        commandPanel.add((Component)lblCLICommand, "Center");
        commandPanel.add((Component)this.btnSendCommand, "East");
        JMPanel cliCommandComponent = KumbaCoreUIConstants.createBorderLayoutPanel();
        cliCommandComponent.add((Component)commandPanel, "Center");
        cliCommandComponent.add((Component)this.getPopupMenuButton(), "East");
        this.createPopupMenu();
        return cliCommandComponent;
    }

    @Override
    protected void createPopupMenu() {
        JMPopupMenu popupMenu = this.getPopupMenu(this.popupMenuButton);
        HashMap<String, JMMenu> menuGroups = new HashMap<String, JMMenu>();
        for (Pair<String, String> popupMenuItem : CLI_POPUP_MENU_ITEMS) {
            String menuItemGroup = null;
            JMMenu groupMenu = null;
            String menuItemText = popupMenuItem.getFirst();
            if (menuItemText.contains("->")) {
                String[] menuItemGroupInfo = menuItemText.split("->");
                menuItemGroup = menuItemGroupInfo[0];
                menuItemText = menuItemGroupInfo[1];
            }
            if (menuItemGroup != null && (groupMenu = (JMMenu)menuGroups.get(menuItemGroup)) == null) {
                groupMenu = new JMMenu(menuItemGroup + " ???");
                popupMenu.add(groupMenu);
                menuGroups.put(menuItemGroup, groupMenu);
            }
            if (menuItemText.equals("-")) {
                if (menuItemGroup == null) {
                    popupMenu.addSeparator();
                    continue;
                }
                groupMenu.addSeparator();
                continue;
            }
            JMMenuItem mi = new JMMenuItem(menuItemText);
            new ActionEventInvoker(mi, this, "sendSingleCommand", popupMenuItem.getSecond());
            if (menuItemGroup == null) {
                popupMenu.add(mi);
            } else {
                groupMenu.add(mi);
            }
            JMPopupMenu.forceMenuItemSize(mi);
        }
        popupMenu.addSeparator();
        popupMenu.addMenuItem("Clear CLI Screens", (Object)this, "clearCLIScreen");
        popupMenu.addMenuItem("Copy CLI Output", (Object)this, "copyConsoles");
        popupMenu.addMenuItem("Delete CLI Output", (Object)this, "deleteConsoles");
    }

    @Override
    protected boolean isPopupReady() {
        return true;
    }

    private JMPanel createScriptPanel() {
        JMPanel panel = KumbaCoreUIConstants.createBorderLayoutPanel();
        this.taCLIScript = new JMTextArea();
        new KeyEventInvoker((Object)this.taCLIScript, 4, this, "setScriptButtonStatus");
        this.lblScriptFileName = new JMLabel("");
        this.btnOpenScriptFile = ComponentFactory.createButton(KumbaCoreUIConstants.OPEN_ICON, null, "Open a saved CLI Script", true, this, "fileOpen", new Object[0]);
        this.btnRunScript = ComponentFactory.createButton(KumbaCoreUIConstants.RUN_ICON, null, "Run the CLI script", false, this, "fileRun", new Object[0]);
        this.btnSaveScript = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ICON, null, "Save the CLI Script", true, this, "fileSave", new Object[0]);
        JMPanel topPanel = new JMPanel(new BorderLayout(10, 0));
        JMPanel buttonPanel = new JMPanel(new FlowLayout(2));
        buttonPanel.addAll(this.btnOpenScriptFile, this.btnRunScript, this.btnSaveScript);
        topPanel.add((Component)this.lblScriptFileName, "Center");
        topPanel.add((Component)buttonPanel, "East");
        panel.add((Component)topPanel, "North");
        panel.add((Component)new JMScrollPane(this.taCLIScript), "Center");
        panel.setPreferredSize(200, 200);
        return panel;
    }

    @Reflected
    private void copyConsoles() {
        logger.finer("(): Starting");
        String separator = "*".repeat(80);
        StringBuilder sb = new StringBuilder();
        for (String applianceName : this.sshPanels.keySet()) {
            logger.finer(() -> LMG.log("(): Building output for %s", () -> applianceName));
            sb.append(separator);
            sb.append("\n");
            sb.append(StringUtility.setInField(applianceName, 80, ' ', 2));
            sb.append("\n");
            sb.append(separator);
            sb.append("\n");
            DataPowerSSHPanel sshPanel = this.sshPanels.get(applianceName);
            sb.append(sshPanel.getConsoleText());
            sb.append("\n\n");
        }
        logger.fine("(): Copying contents to clipboard");
        SystemClipboard.setContents(sb.toString());
        logger.finer("(): Done");
    }

    @Reflected
    private void clearCLIScreen() {
        for (DataPowerSSHPanel sshPanel : this.sshPanels.values()) {
            sshPanel.clearScreen();
        }
    }

    @Reflected
    private void deleteConsoles() {
        logger.finer("(): Starting.");
        for (DataPowerSSHPanel sshPanel : this.sshPanels.values()) {
            logger.fine(() -> LMG.log("(): Removing all console output from %s.", () -> sshPanel.getAppliance().getName()));
            sshPanel.editDelete();
        }
        logger.finer("(): Done.");
    }

    @Reflected
    private void sendSingleCommand(String commandString) {
        String loggerPrefix = String.format("(String commandString=%s)", commandString);
        logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        int waitIterations = 0;
        while (CollectionUtility.isEmpty(this.sshPanels)) {
            int waitCount = waitIterations++;
            logger.finer(() -> LMG.log("%s: Waiting for SSH Panels to be created.  Iteration=%d.", () -> loggerPrefix, () -> waitCount + 1));
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT * 2);
            if (waitIterations != 10) continue;
            logger.finer(() -> LMG.log("%s: Timed out waiting for SSH panel creation.", () -> loggerPrefix));
            if (this.isShowing()) {
                logger.fine(() -> LMG.log("%s: CLI Panel is showing.  Forcing SSH panel creation.", () -> loggerPrefix));
                UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
                this.appliancesChanged(selectedAppliances);
            }
            logger.finer(() -> LMG.log("%s: Returning early due to time out.", () -> loggerPrefix));
            return;
        }
        if (StringUtility.isEmpty(commandString)) {
            logger.finer(() -> LMG.log("%s: Command String is empty.  Returning.", () -> loggerPrefix));
            this.taCLIScript.append("\n");
            return;
        }
        if (commandString.trim().startsWith("#")) {
            logger.finer(() -> LMG.log("%s: Ignoring comment.", () -> loggerPrefix));
            this.taCLIScript.append(commandString);
            this.taCLIScript.append("\n");
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        String[] commands = null;
        if (commandString.contains(";")) {
            logger.finer(() -> LMG.log("%s: Multiple commands on one line.  Splitting.", () -> loggerPrefix));
            commands = commandString.split(";");
        } else {
            commands = new String[]{commandString};
        }
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            Object command = stringArray[n2];
            String command1 = command;
            logger.finer(() -> LMG.log("%s: Preparing command '%s'.", () -> loggerPrefix, () -> command1));
            if (((String)command).contains("#") && !StringUtility.isMarked((String)command, "#", "\"", "\"")) {
                logger.finer(() -> LMG.log("%s: Found comment notation at end.  Removing.", () -> loggerPrefix));
                command = ((String)command).substring(0, ((String)command).indexOf("#"));
            }
            String command2 = command;
            logger.finer(() -> LMG.log("%s: Running command '%s'.", () -> loggerPrefix, () -> command2));
            command = ((String)command).trim() + "\n";
            ArrayList<DataPowerSSHPanel> looper = new ArrayList<DataPowerSSHPanel>(this.sshPanels.values());
            for (DataPowerSSHPanel panel : looper) {
                String applianceName = panel.getAppliance().getName();
                logger.finer(() -> LMG.log("%s: Preparing to send SSH to %s.", () -> loggerPrefix, () -> applianceName));
                int totalWait = 0;
                int waitTime = KumbaCoreConstants.THREAD_WAIT * 4;
                while (panel.isRunningCommand() && totalWait < KumbaCoreConstants.CLI_CONNECTION_TIMEOUT) {
                    int totalWaitTime = totalWait;
                    logger.fine(() -> LMG.log("%s: SSH on %s is busy for %dms.  Waiting.", () -> loggerPrefix, () -> applianceName, () -> totalWaitTime));
                    ThreadUtility.sleep(waitTime);
                    totalWait += waitTime;
                }
                if (totalWait >= KumbaCoreConstants.CLI_CONNECTION_TIMEOUT) {
                    logger.warning(() -> LMG.log("%s: Timed out waiting for busy connection on %s to complete.", () -> loggerPrefix, () -> applianceName));
                    continue;
                }
                Object command3 = command;
                logger.fine(() -> CLIPanel.lambda$39(loggerPrefix, (String)command3, applianceName));
                AsynchMethodInvoker cliThread = ThreadManager.getThread(panel.getAppliance(), panel, "sendCLICommand", 0, command);
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT * 2);
                logger.fine(() -> CLIPanel.lambda$43(loggerPrefix, (String)command3, applianceName));
            }
            if (!this.runningScript) {
                Object command4 = command;
                logger.finer(() -> CLIPanel.lambda$47(loggerPrefix, (String)command4));
                this.taCLIScript.append((String)command);
                this.setScriptButtonStatus();
                this.tfCLICommand.setText("");
                this.tfCLICommand.requestFocus();
            }
            ++n2;
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }

    private void setScriptButtonStatus() {
        boolean buttonStatus = !StringUtility.isEmpty(this.taCLIScript.getText());
        this.btnRunScript.setEnabled(buttonStatus);
        this.btnSaveScript.setEnabled(buttonStatus);
    }

    @Reflected
    private void fileOpen() {
        logger.finer("(): Starting");
        File scriptFile = GUIServices.fileOpenDialog(applicationProperties.getCliScriptsDirectory());
        if (scriptFile == null) {
            logger.finer("(): User cancelled file open.  Returning.");
            return;
        }
        if (!scriptFile.exists()) {
            logger.info(() -> LMG.log("(): CLI script file %s does not exist", () -> scriptFile.getAbsolutePath()));
            return;
        }
        logger.fine(() -> LMG.log("(): Opening CLI script file '%s'.", () -> scriptFile.getAbsolutePath()));
        this.scriptFile = scriptFile;
        try {
            ASCFileReader fileReader = new ASCFileReader(this.scriptFile);
            String fileContent = fileReader.readAll();
            this.taCLIScript.setText(fileContent);
            this.setScriptButtonStatus();
            logger.finer("(): CLI Script file processed OK.");
        }
        catch (IOException e) {
            String errorMessage = String.format("Error reading CLI script file %s.", scriptFile.getName());
            logger.severe("(): " + errorMessage);
            e.printStackTrace();
            this.showMessage("Error Reading Script File", errorMessage);
        }
        logger.finer("(): Done");
    }

    @Reflected
    private boolean fileRunEnabled() {
        return !StringUtility.isEmpty(this.taCLIScript.getText());
    }

    @Reflected
    private void fileRun() {
        logger.finer("(): Starting");
        this.runningScript = true;
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        try {
            String script = this.taCLIScript.getText();
            if (StringUtility.isEmpty(script)) {
                logger.fine("():  Script is empty.  Nothing to do.");
                return;
            }
            String[] scriptElements = script.split("\n");
            logger.finer(() -> LMG.log("(): Processing %d elements.", () -> scriptElements.length));
            String[] stringArray = scriptElements;
            int n = scriptElements.length;
            int n2 = 0;
            while (n2 < n) {
                String scriptElement = stringArray[n2];
                if (!StringUtility.isEmpty(scriptElement)) {
                    logger.finer(() -> LMG.log("(): Sending '%s' to SSH", () -> scriptElement));
                    this.sendSingleCommand(scriptElement);
                }
                ++n2;
            }
        }
        finally {
            this.runningScript = false;
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        logger.finer("(): Done");
    }

    @Reflected
    private void fileSave() {
        String message;
        File newFile = GUIServices.fileSaveDialog(applicationProperties.getCliScriptsDirectory());
        if (newFile == null) {
            return;
        }
        if (newFile.exists() && !this.continueAction("Replace?", message = String.format("%s exists.  Do you want to replace it?", newFile.getName()))) {
            return;
        }
        this.scriptFile = newFile;
        this.saveFile();
    }

    private void saveFile() {
        try {
            new ASCFileWriter(this.scriptFile, this.taCLIScript.getText());
        }
        catch (IOException e) {
            String errorMessage = String.format("Error saving CLI script file %s.", this.scriptFile.getName());
            logger.severe("(): " + errorMessage);
            e.printStackTrace();
            this.showMessage("Error Writing Script File", errorMessage);
        }
    }

    @Reflected
    private void editPaste() {
        this.taCLIScript.append(SystemClipboard.getContents());
        this.setScriptButtonStatus();
    }

    @Reflected
    private void appliancesChanged(UniqueArrayList<Appliance> selectedAppliances) {
        AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances): Starting");
        if (this.changingAppliances) {
            AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances).  Currently changing appliances.  Not continuing.");
            return;
        }
        this.changingAppliances = true;
        int tabCount = this.sshPanels.size();
        AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Current Tab Count: %d", () -> tabCount));
        if (tabCount > 0) {
            this.removeTabs(selectedAppliances);
        }
        AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Adding %d new panels and tabs", () -> selectedAppliances.size()));
        for (Appliance appliance : selectedAppliances) {
            String applianceName = appliance.getName();
            AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Adding %s", () -> applianceName));
            if (this.sshPanels.containsKey(applianceName) || !appliance.isSSHAvailable()) continue;
            AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Building tab for %s", () -> applianceName));
            DataPowerSSHPanel newPanel = new DataPowerSSHPanel(appliance);
            AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Adding %s ssh panel to tabbed pane", () -> applianceName));
            this.cliPanelTabbedPane.addTab(applianceName, newPanel);
            AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Adding %s ssh panel to map", () -> applianceName));
            this.sshPanels.put(applianceName, newPanel);
        }
        this.changingAppliances = false;
        AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances):  Done");
    }

    private void removeTabs(UniqueArrayList<Appliance> selectedAppliances) {
        AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances)");
        this.LOCK.writeLock().lock();
        try {
            ArrayList<String> tabs = new ArrayList<String>(this.sshPanels.keySet());
            AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Removing %d panels from ssh panel map", () -> tabs.size()));
            for (Appliance appliance : selectedAppliances) {
                AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Removing panel %s from ssh panel map", () -> appliance.getName()));
                tabs.remove(appliance.getName());
            }
            AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances):  Removing ssh panel tabs\n");
            for (String tabName : tabs) {
                AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Beginning removeal of ssh panel tab: %s", () -> tabName));
                DataPowerSSHPanel tabComponent = this.sshPanels.get(tabName);
                AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Successfully got SSH Panel %s from sshPanels.  Disconnecting", () -> tabName));
                tabComponent.disConnect();
                AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Removing tab component SSH Panel %s", () -> tabName));
                this.cliPanelTabbedPane.remove(tabComponent);
                AbstractPanel.logger.finer(() -> LMG.log("(UniqueArrayList<Appliance> selectedAppliances):  Removing SSH Panel %s from map", () -> tabName));
                this.sshPanels.remove(tabName);
            }
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
        AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances):  Done");
    }

    @Reflected
    private void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        logger.finer("(Index<Appliance, Domain> selectedDomains): Starting");
        this.LOCK.writeLock().lock();
        try {
            if (!this.changingAppliances) {
                String domainName;
                logger.finer("(Index<Appliance, Domain> selectedDomains): Appliances not changing.  OK to switch domains.");
                UniqueArrayList<String> domainNames = new UniqueArrayList<String>();
                for (Appliance appliance : selectedDomains.getKeys()) {
                    for (Domain domain : selectedDomains.get(appliance)) {
                        String domainName2 = domain.getName();
                        logger.finer(() -> LMG.log("(Index<Appliance, Domain> selectedDomains): Adding domain %s to selected domains.", () -> domain.getName()));
                        domainNames.add(domainName2);
                    }
                }
                logger.finer(() -> LMG.log("(Index<Appliance, Domain> selectedDomains): There are %d domains selected.", () -> domainNames.size()));
                if (domainNames.size() == 1 && !(domainName = (String)domainNames.get(0)).equals("All")) {
                    logger.fine(() -> LMG.log("(Index<Appliance, Domain> selectedDomains): Switching domain to %s.", () -> domainNames.get(0)));
                    this.sendSingleCommand("switch domain " + domainName);
                }
            }
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
        logger.finer("(Index<Appliance, Domain> selectedDomains): Done");
    }

    private static /* synthetic */ String lambda$39(String string, String string2, String string3) {
        return LMG.log("%s: Sending '%s' to %s.", () -> string, () -> string2, () -> string3);
    }

    private static /* synthetic */ String lambda$43(String string, String string2, String string3) {
        return LMG.log("%s: '%s' to %s completed.", () -> string, () -> string2, () -> string3);
    }

    private static /* synthetic */ String lambda$47(String string, String string2) {
        return LMG.log("%s: Appending '%s' to script panel.", () -> string, () -> string2);
    }
}

