/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.InvocationEventInvoker;
import com.jmorgan.lang.MathExt;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.swing.util.ComponentConnector;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationRelationship;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ConfigurationRelationshipGraphPanel
extends ScrollablePanel {
    private static final int HORIZONTAL_GAP = 40;
    private static final int VERTICAL_GAP = 80;
    private static final Logger logger = Application.getApplication().getApplicationLogger();
    private ConfigurationRelationship configurationRelationship;
    private Index<Integer, JMPanel> panelHiererchy;
    private HashMap<DataPowerConfig, JMPanel> objectToPanelMap;

    public ConfigurationRelationshipGraphPanel(ConfigurationRelationship configurationRelationship) {
        logger.finer(() -> LMG.log("(configurationRelationship): Starting", new Supplier[0]));
        this.setLayout(null);
        this.setPreferredSize(500, 600);
        this.configurationRelationship = configurationRelationship;
        this.panelHiererchy = new Index();
        ConfigurationRelationshipType relationshipType = this.configurationRelationship.getRelationshipType();
        this.objectToPanelMap = new HashMap();
        switch (relationshipType) {
            case PARENT_DOWN: {
                new InvocationEventInvoker(configurationRelationship.getSetupThread(), 2, this, "displayRelationships", 0);
                break;
            }
            case CHILD_UP: {
                new InvocationEventInvoker(configurationRelationship.getSetupThread(), 2, this, "displayRelationships", 10000);
            }
        }
        logger.finer(() -> LMG.log("(configurationRelationship): Starting", new Supplier[0]));
    }

    @Reflected
    private void displayRelationships(int startingLevel) {
        String loggerPrefix = String.format("(startingLevel=%d)", startingLevel);
        logger.finer(() -> LMG.log("%s:  Starting", () -> loggerPrefix));
        this.setupDisplay(this.configurationRelationship, startingLevel);
        Collection<Integer> levelSet = this.panelHiererchy.getKeys();
        ArrayList<Integer> levels = new ArrayList<Integer>(levelSet);
        Collections.sort(levels);
        int levelSize = levels.size();
        logger.fine(() -> LMG.log("%s:  Computing graph panel size.", () -> loggerPrefix));
        ArrayList<Integer> levelWidths = new ArrayList<Integer>(levelSize);
        ArrayList<Integer> levelHeights = new ArrayList<Integer>(levelSize);
        int maximumLevelWidth = 0;
        int totalPanelsHeight = 0;
        int i = 0;
        while (i < levelSize) {
            int levelWidth = 0;
            int levelHeight = 0;
            int panelLevel = levels.get(i);
            ArrayList panelsAtLevel = (ArrayList)this.panelHiererchy.get(panelLevel);
            for (JMPanel panel : panelsAtLevel) {
                levelWidth += panel.getWidth();
                int panelHeight = panel.getHeight();
                if (levelHeight >= panelHeight) continue;
                levelHeight = panelHeight;
            }
            if (maximumLevelWidth < (levelWidth += (panelsAtLevel.size() - 1) * 40)) {
                maximumLevelWidth = levelWidth;
            }
            totalPanelsHeight += levelHeight;
            int levelWidthF = levelWidth;
            int levelHeightF = levelHeight;
            logger.fine(() -> LMG.log("%s:  Level %d size:  (%d, %d)", () -> loggerPrefix, () -> panelLevel, () -> levelWidthF, () -> levelHeightF));
            levelWidths.add(levelWidth);
            levelHeights.add(levelHeight);
            ++i;
        }
        int maximumLevelWidthF = maximumLevelWidth += 20;
        int totalPanelsHeightF = totalPanelsHeight += (levelSize - 1) * 80 + 20;
        logger.fine(() -> LMG.log("%s:  Total Panel Size:  (%d, %d)", () -> loggerPrefix, () -> maximumLevelWidthF, () -> totalPanelsHeightF));
        this.setSize(maximumLevelWidth, totalPanelsHeight);
        this.setPreferredSize(maximumLevelWidth, totalPanelsHeight);
        int centerX = maximumLevelWidth / 2;
        logger.fine(() -> LMG.log("%s:  Laying out panels.", () -> loggerPrefix));
        int i2 = 0;
        int y = 10;
        while (i2 < levelSize) {
            int panelLevel = levels.get(i2);
            int levelWidth = (Integer)levelWidths.get(i2);
            int halfWidth = levelWidth / 2;
            int x = centerX - halfWidth;
            ArrayList panelsAtLevel = (ArrayList)this.panelHiererchy.get(panelLevel);
            for (JMPanel panel : panelsAtLevel) {
                int panelWidth = panel.getWidth();
                int panelHeight = panel.getHeight();
                panel.setBounds(x, y, panelWidth, panelHeight);
                this.add(panel);
                x += panelWidth + 40;
            }
            y += (Integer)levelHeights.get(i2) + 80;
            ++i2;
        }
        this.buildConnectors(this.configurationRelationship);
        logger.fine(() -> LMG.log("%s:  Cleaning up.", () -> loggerPrefix));
        this.repaint();
        JMDialog dialog = (JMDialog)GUIServices.getParentWindow(this);
        dialog.setTitle("Show Object References");
        dialog.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        logger.finer(() -> LMG.log("%s:  Done", () -> loggerPrefix));
    }

    private void buildConnectors(ConfigurationRelationship configurationRelationship) {
        logger.entering(this.getClass().getName(), "buildConnectors(configurationRelationship)");
        DataPowerConfig config = configurationRelationship.getObjectInFocus();
        JMPanel configPanel = this.objectToPanelMap.get(config);
        ArrayList<ConfigurationRelationship> relatives = configurationRelationship.getReferences();
        for (ConfigurationRelationship relative : relatives) {
            DataPowerConfig relativeConfig = relative.getObjectInFocus();
            JMPanel relativeConfigPanel = this.objectToPanelMap.get(relativeConfig);
            ComponentConnector connector = new ComponentConnector(configPanel, relativeConfigPanel, KumbaCoreUIConstants.FOREGROUND, KumbaCoreUIConstants.LIST_SELECTED_BACKGROUND);
            connector.setConnectorStartSymbolType(1);
            this.add(connector);
            this.buildConnectors(relative);
        }
        logger.exiting(this.getClass().getName(), "buildConnectors(configurationRelationship)");
    }

    private void setupDisplay(ConfigurationRelationship configurationRelationship, int panelLevel) {
        String loggerPrefix = String.format("(ConfigurationRelationship configurationRelationship, int panelLevel=%d)", panelLevel);
        logger.finer(() -> LMG.log("%s:  Entering", () -> loggerPrefix));
        DataPowerConfig configObject = configurationRelationship.getObjectInFocus();
        if (configObject == null) {
            logger.severe(() -> LMG.log("%s: Object in focus is NULL.  How?", () -> loggerPrefix));
            return;
        }
        JMPanel childObjectPanel = this.createObjectDisplayPanel(configObject);
        if (childObjectPanel == null) {
            logger.fine(() -> LMG.log("%s:  Panel already exists for %s", () -> loggerPrefix, () -> configObject.getFQON()));
            return;
        }
        this.panelHiererchy.put((Integer)panelLevel, childObjectPanel);
        panelLevel += configurationRelationship.getRelationshipType().value;
        ArrayList<ConfigurationRelationship> relatives = configurationRelationship.getReferences();
        for (ConfigurationRelationship relative : relatives) {
            this.setupDisplay(relative, panelLevel);
        }
        logger.finer(() -> LMG.log("%s:  Done", () -> loggerPrefix));
    }

    private JMPanel createObjectDisplayPanel(DataPowerConfig objectConfig) {
        JMLabel configStateIcon;
        JMLabel opStateIcon;
        JMLabel adminStateIcon;
        JMPanel iconPanel;
        JLabel errorLabel;
        JMLabel nameLabel;
        JMLabel typeLabel;
        JMLabel locationLabel;
        int displayedLabelCount;
        String objectName;
        String objectType;
        String location;
        JMPanel panel;
        block25: {
            StatusObjectStatus objectStatus;
            logger.finer("(objectConfig): Starting");
            if (objectConfig == null) {
                new NullPointerException("ConfigurationRelationshipGraphPanel.createObjectDisplayPanel(objectConfig):  Object config is null!").printStackTrace();
                logger.severe("ConfigurationRelationshipGraphPanel.createObjectDisplayPanel(objectConfig):  Object config is null!");
                return null;
            }
            if (this.objectToPanelMap.containsKey(objectConfig)) {
                return null;
            }
            logger.fine(() -> LMG.log("ConfigurationRelationshipGraphPanel.createObjectDisplayPanel(objectConfig):  Creating panel for %s", () -> objectConfig.getFQON()));
            panel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(3);
            panel.setInsets(InsetsFactory.createFixedInsets(5));
            panel.setBorder(BorderFactory.createEtchedBorder());
            Appliance appliance = objectConfig.getAppliance();
            Domain domain = objectConfig.getSourceDomain();
            location = String.format("%s - %s", appliance.getName(), domain.getName());
            objectType = objectConfig.getConfigObjectType();
            if (objectType.equals("DataPowerFileInfo")) {
                objectType = "file";
            }
            objectName = objectConfig.getName();
            displayedLabelCount = 3;
            locationLabel = new JMLabel(location, 0);
            typeLabel = new JMLabel(objectType, 0);
            nameLabel = new JMLabel(objectName, 0);
            errorLabel = null;
            iconPanel = new JMPanel(new GridLayout(1, 3, 5, 0));
            iconPanel.setBackground(KumbaCoreUIConstants.LIGHT_BACKGROUND);
            adminStateIcon = null;
            opStateIcon = null;
            configStateIcon = null;
            if (objectType.equals("file") || (objectStatus = objectConfig.getStatus()) == null) break block25;
            String errorCode = objectStatus.getErrorCode();
            String adminState = objectStatus.getAdminState();
            String opState = objectStatus.getOpState();
            String configState = objectStatus.getConfigState();
            if (StringUtility.isNotEmpty(errorCode)) {
                String eventCode = objectStatus.getEventCode();
                errorLabel = new JMLabel(String.format("%s - %s", eventCode, errorCode), 0);
                errorLabel.setForeground(Color.YELLOW);
                panel.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
            }
            adminStateIcon = new JMLabel(adminState.equals("enabled") ? KumbaCoreUIConstants.ENABLED_ICON : KumbaCoreUIConstants.DISABLED_ICON);
            opStateIcon = new JMLabel(opState.equals("up") ? KumbaCoreUIConstants.OP_STATE_UP_ICON : KumbaCoreUIConstants.OP_STATE_DOWN_ICON);
            switch (configState) {
                case "new": {
                    configStateIcon = new JMLabel(KumbaCoreUIConstants.NEW_ICON);
                    break;
                }
                case "saved": {
                    configStateIcon = new JMLabel(KumbaCoreUIConstants.SAVED_ICON);
                    break;
                }
                case "modified": {
                    configStateIcon = new JMLabel(KumbaCoreUIConstants.MODIFIED_ICON);
                    break;
                }
                case "deleted": {
                    configStateIcon = new JMLabel(KumbaCoreUIConstants.DELETED_ICON);
                    break;
                }
                case "external": {
                    configStateIcon = new JMLabel(KumbaCoreUIConstants.EXTERNAL_ICON);
                }
            }
        }
        panel.addAll(locationLabel, typeLabel, nameLabel);
        if (adminStateIcon != null) {
            iconPanel.addAll(adminStateIcon, opStateIcon, configStateIcon);
            ++displayedLabelCount;
            panel.add(iconPanel);
        }
        if (errorLabel != null) {
            panel.add(errorLabel);
            ++displayedLabelCount;
        }
        Rectangle2D locationSize = GUIServices.getFontDisplaySize(location, "Label.font");
        Rectangle2D objectTypeSize = GUIServices.getFontDisplaySize(objectType, "Label.font");
        Rectangle2D objectNameSize = GUIServices.getFontDisplaySize(objectName, "Label.font");
        double errorWidth = errorLabel == null ? 0.0 : GUIServices.getFontDisplaySize(errorLabel.getText(), "Label.font").getWidth();
        int width = (int)MathExt.getMaximumOf(locationSize.getWidth(), objectTypeSize.getWidth(), objectNameSize.getWidth(), errorWidth) + 15;
        int height = displayedLabelCount * 20 + (displayedLabelCount - 1) * 10;
        panel.setSize(width + 10, height);
        panel.setBackground(KumbaCoreUIConstants.LIGHT_BACKGROUND);
        this.objectToPanelMap.put(objectConfig, panel);
        logger.finer("(objectConfig):  Done");
        return panel;
    }
}

