/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dnd.FileDropHandler;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.table.BeanRowSorter;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ImportConfigurationBean;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.tools.ImportConfiguration;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.models.ImportConfigurationColumnModel;
import com.kumbasoft.core.ui.models.ImportConfigurationTableModel;
import com.kumbasoft.core.util.CleanupXMLExport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import javax.swing.JFileChooser;
import javax.swing.table.TableCellEditor;

public class ImportConfigurationPanel
extends AbstractPanel {
    private ImportConfigurationTableModel importConfigurationTableModel;
    private ImportConfigurationColumnModel importConfigurationColumnModel;
    private JMTable importConfigurationTable;
    private JMButton addImport;
    private JMButton deleteImport;
    private JMButton btnImportConfiguration;
    private JMCheckBox cbxDryRun;
    private JMCheckBox cbxSaveConfigs;
    private UniqueArrayList<String> deploymentPolicies = new UniqueArrayList();
    private UniqueArrayList<String> deploymentPolicyVariables = new UniqueArrayList();
    private Index<Appliance, Domain> selectedDomains;
    private File lastDirectory;
    private boolean dryRun;
    private boolean saveConfigs;
    private MultiThreadInvocationListener importConfigThreadInvocationListener;

    public ImportConfigurationPanel() {
        super(new BorderLayout(5, 5));
        JMPanel addDeletePanel = new JMPanel(new FlowLayout(0, 5, 5));
        this.addImport = new JMButton(KumbaCoreUIConstants.ADD_ICON);
        this.addImport.setToolTipText("Add new configuration file to import");
        new ActionEventInvoker(this.addImport, this, "fileOpen");
        this.deleteImport = new JMButton(KumbaCoreUIConstants.DELETE_ICON);
        this.deleteImport.setToolTipText("Delete selected entries");
        new ActionEventInvoker(this.deleteImport, this, "editDelete");
        this.btnImportConfiguration = new JMButton(KumbaCoreUIConstants.IMPORT_ICON, "Import Configurations");
        new ActionEventInvoker(this.btnImportConfiguration, this, "importConfigs");
        this.cbxDryRun = new JMCheckBox("Dry Run");
        this.cbxSaveConfigs = new JMCheckBox("Save Configs", true);
        this.cbxSaveConfigs.setToolTipText("Save the configurations when import is complete");
        addDeletePanel.addAll(this.addImport, this.deleteImport, ComponentFactory.createSpacer(20, 1), this.cbxDryRun, this.cbxSaveConfigs, ComponentFactory.createSpacer(40, 1), this.btnImportConfiguration);
        this.add((Component)addDeletePanel, "North");
        this.importConfigurationTableModel = new ImportConfigurationTableModel();
        this.importConfigurationColumnModel = new ImportConfigurationColumnModel(this.importConfigurationTableModel);
        this.importConfigurationTable = new JMTable(this.importConfigurationTableModel, this.importConfigurationColumnModel);
        this.importConfigurationTable.setRowSorter(new BeanRowSorter<ImportConfigurationBean>(this.importConfigurationTableModel));
        this.importConfigurationTable.setFillsViewportHeight(true);
        this.importConfigurationTable.setPreferredScrollableViewportSize(new Dimension(10, 10));
        this.importConfigurationTable.setRowHeight(25);
        FileDropHandler fileDropHandler = new FileDropHandler();
        fileDropHandler.setFileDropHandlerListener(this.importConfigurationTableModel);
        this.importConfigurationTable.setTransferHandler(fileDropHandler);
        this.add((Component)KumbaCoreUIConstants.createScrollPane(this.importConfigurationTable), "Center");
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainSelectionChanged");
    }

    @Reflected
    private void fileOpen() {
        JFileChooser fileChooser = new JFileChooser(this.lastDirectory);
        fileChooser.setDialogTitle("Select one or more files to imporrt");
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(0);
        int choice = fileChooser.showDialog(frame, "Select");
        if (choice == 1) {
            return;
        }
        Object[] selectedFiles = fileChooser.getSelectedFiles();
        if (ArrayUtility.isEmpty(selectedFiles)) {
            return;
        }
        this.lastDirectory = ((File)selectedFiles[0]).getParentFile();
        Object[] objectArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            ImportConfigurationBean bean = new ImportConfigurationBean();
            String fileName = ((File)file).getAbsolutePath();
            bean.setFileName(fileName);
            int dot = fileName.lastIndexOf(46);
            String extension = fileName.substring(dot + 1).toUpperCase();
            if (extension.equals("XCFG")) {
                extension = "XML";
            }
            switch (extension) {
                case "XML": 
                case "ZIP": {
                    bean.setFileType(extension);
                }
            }
            this.importConfigurationTableModel.addRow(bean);
            ++n2;
        }
        this.importConfigurationColumnModel.setDeploymentPolicies(this.deploymentPolicies);
    }

    @Reflected
    private void editDelete() {
        String message;
        int[] selectedRows = this.importConfigurationTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        String title = selectedRows.length == 1 ? "Delete Selected Entry" : "Delete Selected Entries";
        String string = message = selectedRows.length == 1 ? "Are you sure you want to delete the selected entry?" : "Are you sure you want to delete all selected entries?";
        if (!this.continueAction(title, message)) {
            return;
        }
        TableCellEditor cellEditor = this.importConfigurationTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
        this.importConfigurationTable.clearSelection();
        if (selectedRows.length == this.importConfigurationTableModel.getRowCount()) {
            this.importConfigurationTableModel.reset();
        } else {
            this.importConfigurationTableModel.deleteAll(selectedRows);
        }
    }

    private void loadDeploymentPolicies() {
        if (this.selectedDomains == null) {
            return;
        }
        this.domainSelectionChanged(this.selectedDomains);
    }

    @Reflected
    private void domainSelectionChanged(Index<Appliance, Domain> selectedDomains) {
        this.selectedDomains = selectedDomains;
        int rowCount = this.importConfigurationTable.getRowCount();
        int r = 0;
        while (r < rowCount) {
            this.importConfigurationTable.setValueAt("", r, 4);
            this.importConfigurationTable.setValueAt("", r, 5);
            ++r;
        }
        new AsynchMethodInvoker((Object)this, "loadDeploymentPolicies", selectedDomains);
        new AsynchMethodInvoker((Object)this, "loadDeploymentPolicyVariables", selectedDomains);
    }

    @Reflected
    private void loadDeploymentPolicies(Index<Appliance, Domain> selectedDomains) {
        this.deploymentPolicies.clear();
        this.deploymentPolicies.add("");
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> deploymentPolicies = configurationManager.listObjects(selectedDomains, "ConfigDeploymentPolicy", ".*");
        for (StatusObjectStatus deploymentPolicy : deploymentPolicies) {
            this.deploymentPolicies.add(deploymentPolicy.getName());
        }
        this.deploymentPolicies.sort();
        this.importConfigurationColumnModel.setDeploymentPolicies(this.deploymentPolicies);
    }

    @Reflected
    private void loadDeploymentPolicyVariables(Index<Appliance, Domain> selectedDomains) {
        this.deploymentPolicyVariables.clear();
        this.deploymentPolicyVariables.add("");
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> deploymentPolicyVariables = configurationManager.listObjects(selectedDomains, "DeploymentPolicyParametersBinding", ".*");
        for (StatusObjectStatus deploymentPolicyVariable : deploymentPolicyVariables) {
            this.deploymentPolicyVariables.add(deploymentPolicyVariable.getName());
        }
        this.deploymentPolicyVariables.sort();
        this.importConfigurationColumnModel.setDeploymentPolicyVariables(this.deploymentPolicyVariables);
    }

    @Reflected
    private void importConfigs() {
        AbstractPanel.logger.finer("(): Starting.");
        if (!this.continueAction("Import Configurations To", "import configurations to", true)) {
            AbstractPanel.logger.finer("(): User Cancelled.  Returning.");
            return;
        }
        this.importConfigurationTable.commitEdits();
        this.dryRun = this.cbxDryRun.isSelected();
        this.saveConfigs = this.cbxSaveConfigs.isSelected();
        String actionTitle = this.dryRun ? "Import Configurations - Dry Run" : "Import Configurations";
        this.openResultsDialogAndSetWaitCursor(actionTitle);
        this.btnImportConfiguration.setEnabled(false);
        logger.finer("():  Invoking Import Configuration for all selected appliances and domains.");
        this.importConfigThreadInvocationListener = new MultiThreadInvocationListener();
        MultiThreadInvocationListener kickoffListener = ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "importConfiguration", false);
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ImportConfigurationPanel.importConfigs()", kickoffListener, kickoffListener.getRunningThreadCount() * KumbaCoreConstants.STARTUP_DELAY, 0);
        if (completedOnTime) {
            logger.finer("():  All import configs have started.");
        } else {
            logger.warning("():  Timed out waiting for import configurations to begin.");
        }
        int importConfigsThreadCount = this.importConfigThreadInvocationListener.getRunningThreadCount();
        logger.finer(() -> LMG.log("(): %d import config threads running.  Waiting for import configurations to complete", () -> importConfigsThreadCount));
        completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ImportConfigurationPanel.importConfigs()", this.importConfigThreadInvocationListener, importConfigsThreadCount * KumbaCoreConstants.STARTUP_DELAY, 0);
        if (completedOnTime) {
            logger.finer("():  All import configurations completed on time.");
        } else {
            logger.warning("():  Timed out waiting for import configurations to complete.");
        }
        if (!this.dryRun && this.saveConfigs) {
            logger.finer(() -> LMG.log("ImportConfigurationPanel.importConfigs():  Imports complete.  Saving configurations", new Supplier[0]));
            MultiThreadInvocationListener mtil = ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "saveConfigs", false);
            completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ImportConfigurationPanel.importConfigs()", mtil, mtil.getRunningThreadCount() * KumbaCoreConstants.STARTUP_DELAY, 0);
            if (completedOnTime) {
                logger.finer("(): Save configs completed on time");
            } else {
                logger.warning("(): Timed out waiting for configurations saves to complete.  Continuing anyway.");
            }
        }
        DataPowerXMLManagement.clearLocalCache();
        this.loadDeploymentPolicies();
        this.waitForResultsDialogToCloseAndResetCursor();
        this.btnImportConfiguration.setEnabled(true);
        AbstractPanel.logger.finer("(): Done.");
    }

    @Reflected
    private void importConfiguration(Appliance appliance, Domain domain) {
        logger.finer(() -> LMG.log("(Appliance %s, Domain %s):  Importing configurations", () -> appliance.getName(), () -> domain.getName()));
        ArrayList beans = this.importConfigurationTableModel.getModelData();
        Collections.sort(beans);
        for (ImportConfigurationBean bean : beans) {
            if (bean == null) {
                logger.severe(() -> LMG.log("Import Configuration Bean from model data is null.  How???  Size of model is: %d", () -> beans.size()));
                continue;
            }
            String fileName = bean.getFileName();
            String fileType = bean.getFileType();
            if (fileType.equalsIgnoreCase("XML")) {
                try {
                    File tempFile = File.createTempFile("DPAA", "");
                    new CleanupXMLExport(fileName, tempFile.getAbsolutePath());
                    fileName = tempFile.getAbsolutePath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            boolean overwriteObjects = bean.isOverwriteObjects();
            boolean overwriteFiles = bean.isOverwriteFiles();
            String deploymentPolicy = bean.getDeploymentPolicy();
            String deploymentPolicyVariables = bean.getDeploymentPolicyVariables();
            ImportConfiguration importConfiguration = null;
            String fileNameF = fileName;
            logger.finer(() -> LMG.log("(appliance=%s, domain=%s):  Importing %s", () -> appliance.getName(), () -> domain.getName(), () -> fileNameF));
            importConfiguration = StringUtility.isEmpty(deploymentPolicy) ? new ImportConfiguration(appliance, domain, fileType, overwriteFiles, overwriteObjects, fileName) : (StringUtility.isEmpty(deploymentPolicyVariables) ? new ImportConfiguration(appliance, domain, fileType, overwriteFiles, overwriteObjects, fileName, deploymentPolicy) : new ImportConfiguration(appliance, domain, fileType, overwriteFiles, overwriteObjects, fileName, deploymentPolicy, deploymentPolicyVariables));
            this.importConfigThreadInvocationListener.addThread(importConfiguration.getProcessThread());
            importConfiguration.setDryRun(this.dryRun);
            importConfiguration.addManagementCommandSubscriber(this.commandResultsDialog);
        }
        logger.finer(() -> LMG.log("(Appliance %s, Domain %s):  Done.", () -> appliance.getName(), () -> domain.getName()));
    }

    @Reflected
    private void saveConfigs(Appliance appliance, Domain domain) {
        logger.fine(() -> LMG.log("ImportConfigurationPanel.saveConfigs(Appliance %s, Domain %s):  Saving Configurations", () -> appliance.getName(), () -> domain.getName()));
        ConfigurationManager.saveConfiguration(appliance, domain, this.commandResultsDialog);
    }
}

