/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.ArrayUtility;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.dpaa.ui.panels.configurations.ManageCertificatesPanel;
import java.awt.Component;
import javax.swing.JSeparator;

public class ManageCertificatesPopupMenu
extends JMPopupMenu
implements PopupMenuController {
    private JMTable displayTable;

    public ManageCertificatesPopupMenu(ManageCertificatesPanel eventTarget, JMTable displayTable) {
        this.displayTable = displayTable;
        this.setPopupController(this);
        this.addPopupMenuClient(displayTable);
        this.addMenuItem("Save Off Box...", (Object)eventTarget, "fileSaveAs");
        this.add(new JSeparator());
        this.addMenuItem("Compare selected certificates", (Object)eventTarget, "compareSelected");
        this.addMenuItem("Compare with local certificate file...", (Object)eventTarget, "compareWithLocalFile");
        this.addMenuItem("Compare with certificate at URL...", (Object)eventTarget, "compareWithURL");
        this.add(new JSeparator());
        this.addMenuItem("Replace with local certificate file...", (Object)eventTarget, "replaceWithLocal");
        this.addMenuItem("Replace with certificate at URL...", (Object)eventTarget, "replaceWithURL");
        this.add(new JSeparator());
        this.addMenuItem("Create Certificates from external files...", (Object)eventTarget, "fileCreateCertsFromExternalFiles");
        this.addMenuItem("Create Certificates from URLs...", (Object)eventTarget, "fileCreateCertsFromURLs");
        this.add(new JSeparator());
        this.addMenuItem("Create Validation Credential from selected...", (Object)eventTarget, "fileCreateValCredFromCerts");
        this.add(new JSeparator());
        this.addMenuItem("Enable selected certificates", (Object)eventTarget, "editEnable");
        this.addMenuItem("Disable selected certificates", (Object)eventTarget, "editDisable");
        this.add(new JSeparator());
        this.addMenuItem("Show Referenced By...", (Object)eventTarget, "showReferencedBy");
        this.add(new JSeparator());
        this.addMenuItem("Delete selected certificate objects...", (Object)eventTarget, "editDelete");
        this.setEnabled(false);
    }

    @Override
    public boolean isPopupReady() {
        BeanTableModel tableModel = (BeanTableModel)this.displayTable.getModel();
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            this.setMenuItemEnabled(".*", false);
            this.setMenuItemEnabled("createCertificates.+", true);
            return true;
        }
        this.setMenuItemEnabled(".*", true);
        int errorCertsSelected = 0;
        int r = 0;
        while (r < selectedRows.length) {
            CertificateInformation row = (CertificateInformation)tableModel.getValue(selectedRows[r]);
            String fingerPrint = row.getFingerPrint();
            if (fingerPrint == null) {
                ++errorCertsSelected;
            }
            ++r;
        }
        int cc = this.getComponentCount();
        int c = 0;
        while (c < cc) {
            Component component = this.getComponent(c);
            if (component instanceof JMMenuItem) {
                JMMenuItem menuItem = (JMMenuItem)component;
                String menuItemName = menuItem.getName();
                if (menuItemName.equals("saveAs")) {
                    menuItem.setEnabled(errorCertsSelected != selectedRows.length);
                } else if (menuItemName.startsWith("compare")) {
                    menuItem.setEnabled(errorCertsSelected != selectedRows.length);
                }
            }
            ++c;
        }
        return true;
    }
}

