/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.IPInfoBean;
import com.kumbasoft.core.beans.IPInfoSubscriber;
import com.kumbasoft.core.beans.actions.ActionPing;
import com.kumbasoft.core.beans.actions.ActionTCPConnectionTest;
import com.kumbasoft.core.beans.config.ConfigDNSNameService;
import com.kumbasoft.core.beans.config.ConfigEthernetInterface;
import com.kumbasoft.core.beans.config.ConfigHostAlias;
import com.kumbasoft.core.beans.config.ConfigIPInterface;
import com.kumbasoft.core.beans.config.ConfigLinkAggregation;
import com.kumbasoft.core.beans.config.ConfigVLANInterface;
import com.kumbasoft.core.beans.types.StaticHost;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.DeleteIP;
import com.kumbasoft.core.tools.FindIP;
import com.kumbasoft.core.tools.ModifyTool;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.AbstractSearchPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.RegexUtility;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.AddIPWizardDialog;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.AssignIPsToInterfacePage;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.CopyMoveIPInterfaceListPanel;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.DeleteIPPreviewWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.DestinationApplianceSelectionPage;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.DestinationInterfaceTypeSelectionPage;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.IPAssignmentWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.TCPConnectionTestWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.UpdateInterfaceIPs;
import com.kumbasoft.dpaa.ui.dialogs.wizards.StandardWizardWelcomePage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JSeparator;

public class ManageIPPanel
extends AbstractSearchPanel<IPInfoBean>
implements IPInfoSubscriber,
PopupMenuController {
    private static final String DEFAULT_SEARCH_STRING = "(\\d{1,3}\\.){3}\\d{1,3}.*";
    private UniqueArrayList<Appliance> affectedAppliances;

    public ManageIPPanel() {
        super(IPInfoBean.class);
        this.createPopupMenu();
    }

    @Override
    protected void createPopupMenu() {
        logger.finer("(): Starting");
        if (this.displayTableScrollPane == null) {
            logger.severe("(): Display Table Scroll Pane is NULL.  Timing issue?");
        }
        this.getPopupMenu(this.displayTableScrollPane);
        this.popupMenu.addPopupMenuClient(this.displayTable);
        this.popupMenu.setPopupController(this);
        this.popupMenu.addMenuItem("Add IPs...", (Object)this, "fileNew");
        this.popupMenu.add(new JSeparator());
        this.popupMenu.addMenuItem("Copy IPs...", (Object)this, "editCopy");
        this.popupMenu.addMenuItem("Move IPs...", (Object)this, "editMove");
        this.popupMenu.add(new JSeparator());
        this.popupMenu.addMenuItem("Delete IPs...", (Object)this, "editDelete");
        this.popupMenu.add(new JSeparator());
        this.popupMenu.addMenuItem("Ping Test", (Object)this, "pingTest");
        this.popupMenu.addMenuItem("TCP Connection Test...", (Object)this, "tcpTest");
        this.popupMenu.add(new JSeparator());
        this.popupMenu.addMenuItem("Create Host Aliases...", (Object)this, "createHostAliases");
        this.popupMenu.addMenuItem("Create DNS Static Hosts...", (Object)this, "createStaticHosts");
        this.popupMenu.setEnabled(true);
        logger.finer("(): Done");
    }

    @Override
    protected String getTFPatternLabel() {
        return "IP Address Match Pattern:";
    }

    @Override
    protected String getDefaultSearchPattern() {
        return DEFAULT_SEARCH_STRING;
    }

    @Override
    protected int getMatchPatternLabelWidth() {
        return 155;
    }

    @Override
    protected boolean includeCaseSensitivityButton() {
        return false;
    }

    @Override
    protected String getMatchPattern() {
        String ipMatchPattern = super.getMatchPattern();
        ipMatchPattern = StringUtility.isEmpty(ipMatchPattern) ? DEFAULT_SEARCH_STRING : RegexUtility.normalizeRegex(ipMatchPattern, false);
        return ipMatchPattern;
    }

    @Override
    protected String getProcessMethodName() {
        return "findIPAddress";
    }

    @Override
    protected BeanColumnModel<IPInfoBean> getColumnModel() {
        BeanColumnModel<IPInfoBean> model = super.getColumnModel();
        model.hideColumns("adminState", "name", "configObjectType", "isIntrinsic", "isExternal", "isReadOnly", "isLocal", "quiesceState", "userSummary", "status", "fQON");
        return model;
    }

    @Reflected
    private void findIPAddress() {
        this.resetUI();
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        FindIP findIP = new FindIP(selectedDomains, this.getMatchPattern());
        findIP.addIPInfoSubscriber(this);
    }

    @Override
    public void processIPInfo(IPInfoBean ipInfo) {
        this.addRow(ipInfo);
    }

    @Override
    public void findIPComplete(FindIP ipFinder) {
        logger.finer("(FindIP):  Starting");
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        logger.finer("(FindIP):  Kicking off thread to resolve host names");
        new AsynchMethodInvoker((Object)this, "resolveHostNames");
        logger.finer("(FindIP):  Done");
    }

    @Reflected
    private void resolveHostNames() {
        logger.finer("(): Starting");
        ArrayList allIPs = this.tableModel.getModelData(false);
        BeanIndexer ipIndexer = new BeanIndexer(allIPs);
        Index ipIndex = ipIndexer.getIndexOf("ipAddress", null);
        Collection<Object> ips = ipIndex.getKeys();
        logger.finer(() -> LMG.log("(): Found %d unique IPs", () -> ips.size()));
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        Index groupIndex = new Index();
        int n = 0;
        for (String string : ips) {
            logger.finer(() -> LMG.log("(): Preparing to process IP %s", () -> ip));
            Collection beans = ipIndex.get(string);
            groupIndex.put(string, beans);
            if (++n != 10) continue;
            int groupSize = groupIndex.size();
            logger.finer(() -> LMG.log("(): Processing a group of %d IPs asynchronously", () -> groupSize));
            AsynchMethodInvoker thread = new AsynchMethodInvoker((Object)this, "resolveHostNames", groupIndex);
            mtil.addThread(thread);
            groupIndex = new Index();
            n = 0;
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ManageIPPanel.resolveHostNames()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        this.displayTable.repaint();
        logger.finer("(): Done");
    }

    @Reflected
    private void resolveHostNames(Index<String, IPInfoBean> ipIndex) {
        Collection<String> ips = ipIndex.getKeys();
        logger.finer(() -> LMG.log("(ipIndex): Working on %d unique IPs", () -> ips.size()));
        for (String ip : ips) {
            logger.finer(() -> LMG.log("(ipIndex): Looking up host for ip '%s'", () -> ip));
            try {
                InetAddress addr = InetAddress.getByName(StringUtility.substringBefore(ip, "/"));
                String host = addr.getHostName();
                logger.finer(() -> LMG.log("(ipIndex): Host for ip '%s' is '%s'.  Updating data.", () -> ip, () -> host));
                Collection<IPInfoBean> beans = ipIndex.get(ip);
                for (IPInfoBean bean : beans) {
                    bean.setHostName(host);
                }
                logger.finer(() -> LMG.log("(ipIndex): Finished updating data for ip '%s' and host '%s'.", () -> ip, () -> host));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.displayTable.repaint();
        logger.finer("(ipIndex): Done");
    }

    @Override
    public boolean isPopupReady() {
        AbstractPanel.logger.finer("(): Starting");
        int[] selectedRows = this.displayTable.getSelectedRows();
        boolean isEmpty = ArrayUtility.isEmpty(selectedRows);
        boolean deleteable = false;
        int i = 0;
        while (i < selectedRows.length) {
            IPInfoBean ipInfo = (IPInfoBean)this.tableModel.getValue(selectedRows[i]);
            String objectType = ipInfo.getSourceObjectType();
            String objectName = ipInfo.getSourceObjectName();
            if (objectType.equals("EthernetInterface") && !objectName.equals("lo")) {
                deleteable = true;
                break;
            }
            ++i;
        }
        this.popupMenu.setMenuItemEnabled("(ping|tCP|create).*", !isEmpty);
        this.popupMenu.setMenuItemEnabled("(copy|move|delete).*", !isEmpty && deleteable);
        AbstractPanel.logger.finer("(): Done");
        return true;
    }

    @Reflected
    private void fileNew() {
        DynamicBean addIPModel = new DynamicBean();
        this.setupAffectedAppliances();
        UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        this.affectedAppliances.addAll(selectedAppliances);
        new AsynchMethodInvoker((Object)this, "loadInterfaces", new Object[]{selectedAppliances, addIPModel});
        addIPModel.setProperty("appliances", selectedAppliances);
        new AddIPWizardDialog((JFrame)frame, addIPModel);
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Add IP");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        UpdateInterfaceIPs updateIPs = new UpdateInterfaceIPs(addIPModel, mtil);
        updateIPs.addManagementCommandSubscriber(this.commandResultsDialog);
        mtil.waitUntilComplete();
        this.waitForResultsDialogToCloseAndResetCursor();
        this.searchFind();
    }

    public static ConfigIPInterface getInterfaceOfAppliance(Appliance appliance, ArrayList<ConfigIPInterface> interfaces) {
        for (ConfigIPInterface i : interfaces) {
            if (!i.getAppliance().equals(appliance)) continue;
            return i;
        }
        return null;
    }

    @Reflected
    private static void loadInterfaces(UniqueArrayList<Appliance> selectedAppliances, DynamicBean model) {
        Domain defaultDomain = new Domain("default");
        for (Appliance appliance : selectedAppliances) {
            Domain dd = appliance.getDomain("default");
            if (dd != null) continue;
            appliance.addDomain(defaultDomain);
        }
        ManageIPPanel.loadInterfaces(selectedAppliances, model, ConfigEthernetInterface.class, "ethernetInterfaces");
        ManageIPPanel.loadInterfaces(selectedAppliances, model, ConfigLinkAggregation.class, "linkAggregationInterfaces");
        ManageIPPanel.loadInterfaces(selectedAppliances, model, ConfigVLANInterface.class, "vlanInterfaces");
    }

    private static void loadInterfaces(UniqueArrayList<Appliance> selectedAppliances, DynamicBean model, Class<? extends ConfigIPInterface> configClass, String propertyName) {
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<? extends ConfigIPInterface> interfaces = configurationManager.getObjects(selectedAppliances, configClass, ".*");
        try {
            ArrayList existingInterfaces = (ArrayList)model.getProperty(propertyName);
            if (existingInterfaces == null) {
                model.setProperty(propertyName, interfaces);
            } else {
                existingInterfaces.addAll(interfaces);
            }
        }
        catch (PropertyNotFoundException e) {
            model.setProperty(propertyName, interfaces);
        }
    }

    private void setupAffectedAppliances() {
        if (this.affectedAppliances != null) {
            this.affectedAppliances.clear();
        } else {
            this.affectedAppliances = new UniqueArrayList();
        }
    }

    @Reflected
    private void editDelete() {
        ArrayList<DynamicBean> ipsToDelete = this.getModifiableIPs();
        if (CollectionUtility.isEmpty(ipsToDelete)) {
            return;
        }
        this.setupAffectedAppliances();
        for (DynamicBean ipToDelete : ipsToDelete) {
            Appliance appliance = (Appliance)ipToDelete.getProperty("appliance");
            appliance.addDomain(new Domain("default"));
            this.affectedAppliances.add(appliance);
            ipToDelete.setProperty("delete", true);
        }
        DynamicBean ipInterfaces = new DynamicBean();
        ipInterfaces.setProperty("ethernetInterfaces", null);
        ipInterfaces.setProperty("linkAggregationInterfaces", null);
        ipInterfaces.setProperty("vlanInterfaces", null);
        new AsynchMethodInvoker((Object)this, "loadInterfaces", new Object[]{this.affectedAppliances, ipInterfaces});
        WizardDialog<ArrayList<DynamicBean>> deleteWizard = new WizardDialog<ArrayList<DynamicBean>>((JFrame)frame, "Delete IPs");
        deleteWizard.addWizardPage(new DeleteIPPreviewWizardPage(ipsToDelete), "delete");
        deleteWizard.setSize(800, 600);
        deleteWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Delete IP Addresses");
        ArrayList ethInterfaces = (ArrayList)ipInterfaces.getProperty("ethernetInterfaces");
        ArrayList linkAggInterfaces = (ArrayList)ipInterfaces.getProperty("linkAggregationInterfaces");
        ArrayList vlanInterfaces = (ArrayList)ipInterfaces.getProperty("vlanInterfaces");
        HashMap collation = new HashMap();
        for (DynamicBean ipToDelete : ipsToDelete) {
            boolean delete = (Boolean)ipToDelete.getProperty("delete");
            if (!delete) continue;
            Appliance appliance = (Appliance)ipToDelete.getProperty("appliance");
            String iface = (String)ipToDelete.getProperty("sourceObjectName");
            int vipIndex = iface.indexOf("-vip");
            if (vipIndex > 0) {
                iface = iface.substring(0, vipIndex);
            }
            String interfaceType = (String)ipToDelete.getProperty("sourceObjectType");
            String ipAddress = (String)ipToDelete.getProperty("ipAddress");
            Index<ConfigIPInterface, String> applianceCollation = (Index<ConfigIPInterface, String>)collation.get(appliance);
            if (applianceCollation == null) {
                applianceCollation = new Index<ConfigIPInterface, String>();
                collation.put(appliance, applianceCollation);
            }
            if (interfaceType.equals("EthernetInterface")) {
                for (ConfigEthernetInterface ethInterface : ethInterfaces) {
                    if (!ethInterface.getAppliance().equals(appliance) || !ethInterface.getName().equals(iface)) continue;
                    applianceCollation.put(ethInterface, ipAddress);
                }
                continue;
            }
            if (interfaceType.equals("LinkAggregation")) {
                for (ConfigLinkAggregation linkAggInterface : linkAggInterfaces) {
                    if (!linkAggInterface.getAppliance().equals(appliance) || !linkAggInterface.getName().equals(iface)) continue;
                    applianceCollation.put(linkAggInterface, ipAddress);
                }
                continue;
            }
            if (interfaceType.equals("VLANInterface")) {
                for (ConfigVLANInterface vlanInterface : vlanInterfaces) {
                    if (!vlanInterface.getAppliance().equals(appliance) || !vlanInterface.getName().equals(iface)) continue;
                    applianceCollation.put(vlanInterface, ipAddress);
                }
                continue;
            }
            String interfaceName = iface;
            AbstractPanel.logger.config(() -> LMG.log("():  Interface %s of %s type is not handled.", () -> interfaceName, () -> interfaceType));
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : collation.keySet()) {
            Index applianceCollation = (Index)collation.get(appliance);
            for (ConfigIPInterface ipInterface : applianceCollation.getKeys()) {
                ArrayList ipCollation = (ArrayList)applianceCollation.get(ipInterface);
                DeleteIP deleteIP = new DeleteIP(appliance, ipInterface, ipCollation);
                mtil.addThread(deleteIP.getProcessThread());
                deleteIP.addManagementCommandSubscriber(this.commandResultsDialog);
            }
        }
        mtil.waitUntilComplete();
        this.waitForResultsDialogToCloseAndResetCursor();
        this.searchFind();
    }

    @Reflected
    private void editCopy() {
        this.copyMove("copy");
    }

    @Reflected
    private void editMove() {
        this.copyMove("move");
    }

    private void copyMove(String action) {
        logger.finer(() -> LMG.log("(action=%s): Starting", () -> action));
        ArrayList<DynamicBean> ipsToCopy = this.getModifiableIPs();
        if (CollectionUtility.isEmpty(ipsToCopy)) {
            return;
        }
        this.setupAffectedAppliances();
        for (DynamicBean ipToCopy : ipsToCopy) {
            Appliance appliance = (Appliance)ipToCopy.getProperty("appliance");
            this.affectedAppliances.add(appliance);
        }
        DynamicBean copyInfoModel = new DynamicBean();
        copyInfoModel.setProperty("action", action);
        copyInfoModel.setProperty("ipsToCopy", ipsToCopy);
        copyInfoModel.setProperty("ethernetInterfaces", null);
        copyInfoModel.setProperty("linkAggregationInterfaces", null);
        copyInfoModel.setProperty("vlanInterfaces", null);
        copyInfoModel.setProperty("destinationAppliances", null);
        copyInfoModel.setProperty("isEthernet", true);
        copyInfoModel.setProperty("isLinkAggregation", false);
        copyInfoModel.setProperty("isVLAN", false);
        copyInfoModel.setProperty("ethernetInterface", null);
        copyInfoModel.setProperty("linkAggInterface", null);
        copyInfoModel.setProperty("vlanInterface", null);
        copyInfoModel.setProperty("finalData", null);
        new AsynchMethodInvoker((Object)this, "loadInterfaces", new Object[]{this.affectedAppliances, copyInfoModel});
        String actionTitle = String.format("%s IP Addresses", StringUtility.toNameCase(action));
        WizardDialog<DynamicBean> addIPWizard = new WizardDialog<DynamicBean>((JFrame)frame, actionTitle);
        String leftSidePage = action.equals("copy") ? "CopyIPWelcomePage" : "MoveIPWelcomePage";
        String centerPage = leftSidePage + "_centerControl";
        addIPWizard.addWizardPage(new StandardWizardWelcomePage<DynamicBean>(copyInfoModel, leftSidePage, centerPage), "welcome");
        addIPWizard.addWizardPage(new DestinationApplianceSelectionPage(copyInfoModel, "CopyMoveAppliancesPage.html"), "destinationAppliances");
        addIPWizard.addWizardPage(new DestinationInterfaceTypeSelectionPage(copyInfoModel), "interfaceType");
        addIPWizard.addWizardPage(new CopyMoveIPInterfaceListPanel(copyInfoModel, "CopyIPInterfacePage.html"), "interface");
        addIPWizard.addWizardPage(new AssignIPsToInterfacePage(copyInfoModel), "assign");
        addIPWizard.setSize(1200, 650);
        addIPWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor(actionTitle);
        ArrayList finalData = (ArrayList)copyInfoModel.getProperty("finalData");
        HashMap<Appliance, Index<ConfigIPInterface, DynamicBean>> addInfo = new HashMap<Appliance, Index<ConfigIPInterface, DynamicBean>>();
        HashMap deleteInfo = new HashMap();
        UniqueArrayList<Appliance> destAppliances = new UniqueArrayList<Appliance>();
        for (DynamicBean actionInfo : finalData) {
            Appliance destinationAppliance = (Appliance)actionInfo.getProperty("destinationAppliance");
            destAppliances.add(destinationAppliance);
            this.affectedAppliances.add(destinationAppliance);
        }
        ManageIPPanel.loadInterfaces(destAppliances, copyInfoModel);
        for (DynamicBean actionInfo : finalData) {
            Appliance sourceAppliance = (Appliance)actionInfo.getProperty("sourceAppliance");
            String sourceInterfaceType = (String)actionInfo.getProperty("sourceInterfaceType");
            String sourceInterfaceName = (String)actionInfo.getProperty("sourceInterfaceName");
            ConfigIPInterface sourceInterface = ManageIPPanel.getInterface(copyInfoModel, sourceAppliance, sourceInterfaceType, sourceInterfaceName);
            Index sourceInterfaces = (Index)deleteInfo.get(sourceAppliance);
            if (sourceInterfaces == null) {
                sourceInterfaces = new Index();
                deleteInfo.put(sourceAppliance, sourceInterfaces);
            }
            sourceInterfaces.put(sourceInterface, actionInfo);
            Appliance destinationAppliance = (Appliance)actionInfo.getProperty("destinationAppliance");
            String destinationInterfaceType = (String)actionInfo.getProperty("destinationInterfaceType");
            String destinationInterfaceName = (String)actionInfo.getProperty("destinationInterfaceName");
            ConfigIPInterface destinationInterface = ManageIPPanel.getInterface(copyInfoModel, destinationAppliance, destinationInterfaceType, destinationInterfaceName);
            Index<ConfigIPInterface, DynamicBean> destInterfaces = (Index<ConfigIPInterface, DynamicBean>)addInfo.get(destinationAppliance);
            if (destInterfaces == null) {
                destInterfaces = new Index<ConfigIPInterface, DynamicBean>();
                addInfo.put(destinationAppliance, destInterfaces);
            }
            destInterfaces.put(destinationInterface, actionInfo);
        }
        logger.finer(() -> LMG.log("(action=%s): Applying Destination Modifications.", () -> action));
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : addInfo.keySet()) {
            Domain defaultDomain = appliance.getDomain("default");
            if (defaultDomain == null) {
                logger.warning(() -> LMG.log("(action=%s): default domain not found for '%s'.", () -> action, () -> appliance.getName()));
                defaultDomain = new Domain("default");
                appliance.addDomain(defaultDomain);
            }
            Index destInterfaces = (Index)addInfo.get(appliance);
            for (ConfigIPInterface ipInterface : destInterfaces.getKeys()) {
                if (ipInterface == null) {
                    logger.warning(() -> LMG.log("(action=%s): No Destination interfaces for '%s'.  How?  Do they not exist?  Continuing.", () -> action, () -> appliance.getName()));
                    continue;
                }
                Collection destIPs = destInterfaces.get(ipInterface);
                for (DynamicBean destIPInfo : destIPs) {
                    String ipAddress = (String)destIPInfo.getProperty("ipAddress");
                    boolean isPrimary = (Boolean)destIPInfo.getProperty("isPrimary");
                    boolean isVirtual = (Boolean)destIPInfo.getProperty("isVirtual");
                    boolean isSecondary = (Boolean)destIPInfo.getProperty("isSecondary");
                    boolean isVirtualSecondary = (Boolean)destIPInfo.getProperty("isVirtualSecondary");
                    boolean isDefaultGateway = (Boolean)destIPInfo.getProperty("isDefaultGateway");
                    if ((isVirtual || isVirtualSecondary) && ipAddress.contains("/")) {
                        ipAddress = StringUtility.substringBefore(ipAddress, "/");
                    }
                    String destIP = ipAddress;
                    if (isPrimary) {
                        logger.config(() -> LMG.log("(action=%s): Setting %s as the primary to the %s %s of '%s'.", () -> action, () -> destIP, () -> ipInterface.getName(), () -> ipInterface.getConfigObjectType(), () -> appliance.getName()));
                        ipInterface.setIPAddress(ipAddress);
                        continue;
                    }
                    if (isVirtual) {
                        logger.config(() -> LMG.log("(action=%s): Setting %s as the main virtual IP to the %s %s of '%s'.", () -> action, () -> destIP, () -> ipInterface.getName(), () -> ipInterface.getConfigObjectType(), () -> appliance.getName()));
                        ipInterface.setVirtualIP(ipAddress);
                        continue;
                    }
                    if (isDefaultGateway) {
                        logger.config(() -> LMG.log("(action=%s): Setting %s as the default gateway to the %s %s of '%s'.", () -> action, () -> destIP, () -> ipInterface.getName(), () -> ipInterface.getConfigObjectType(), () -> appliance.getName()));
                        ipInterface.setDefaultGateway(ipAddress);
                        continue;
                    }
                    if (isSecondary) {
                        ArrayList<String> secondaryIPs = ipInterface.getSecondaryAddress();
                        if (CollectionUtility.isEmpty(secondaryIPs)) {
                            logger.config(() -> LMG.log("(action=%s): Adding %s as a secondary IP to the %s %s of '%s'.", () -> action, () -> destIP, () -> ipInterface.getName(), () -> ipInterface.getConfigObjectType(), () -> appliance.getName()));
                            ipInterface.addSecondaryAddress(ipAddress);
                            continue;
                        }
                        logger.config(() -> LMG.log("(action=%s): Adding %s as a secondary IP to the %s %s of '%s' provided it does not create a duplicate.", () -> action, () -> destIP, () -> ipInterface.getName(), () -> ipInterface.getConfigObjectType(), () -> appliance.getName()));
                        CollectionUtility.addNoDuplicate(secondaryIPs, ipAddress);
                        continue;
                    }
                    if (!isVirtualSecondary) continue;
                    ArrayList<String> secondaryVirtualIPs = ipInterface.getSecondaryVirtualIP();
                    if (CollectionUtility.isEmpty(secondaryVirtualIPs)) {
                        logger.config(() -> LMG.log("(action=%s): Adding %s as a virtual secondary IP to the %s %s of '%s'.", () -> action, () -> destIP, () -> ipInterface.getName(), () -> ipInterface.getConfigObjectType(), () -> appliance.getName()));
                        ipInterface.addSecondaryVirtualIP(ipAddress);
                        continue;
                    }
                    logger.config(() -> LMG.log("(action=%s): Adding %s as a virtual secondary IP to the %s %s of '%s' provided it does not create a duplicate.", () -> action, () -> destIP, () -> ipInterface.getName(), () -> ipInterface.getConfigObjectType(), () -> appliance.getName()));
                    CollectionUtility.addNoDuplicate(secondaryVirtualIPs, ipAddress);
                }
                logger.config(() -> LMG.log("(action=%s): Comitting modifications to the %s %s of '%s'.", () -> action, () -> ipInterface.getName(), () -> ipInterface.getConfigObjectType(), () -> appliance.getName()));
                ModifyTool modifyTool = new ModifyTool(appliance, defaultDomain, ipInterface);
                mtil.addThread(modifyTool.getProcessThread());
                modifyTool.setCommandDescription(String.format("Add IPs to the %s interface", ipInterface.getName()));
                modifyTool.addManagementCommandSubscriber(this.commandResultsDialog);
            }
        }
        logger.finer(() -> LMG.log("(action=%s): Waiting on adds to complete.", () -> action));
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle(String.format("ManageIPPane.copyMove(%s)", action), mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            logger.warning(() -> LMG.log("(%s): Timed out waiting for modify processes to complete.", () -> action));
            if (action.equals("move")) {
                logger.info(() -> LMG.log("(%s): Will not delete from source due to unexpected outcome..", () -> action));
                new JMMessageBox((JFrame)frame, "Timed Out", LabelUtility.wrapInHTML("Timed out waiting to " + actionTitle + "\n\nCheck all interfaces."));
            }
        }
        mtil.resetThreadCount();
        if (completedOnTime && action.equals("move")) {
            logger.finer(() -> LMG.log("(action=%s): Removing IP's from source.", () -> action));
            for (Appliance appliance : deleteInfo.keySet()) {
                Domain defaultDomain = appliance.getDomain("default");
                if (defaultDomain == null) {
                    logger.warning(() -> LMG.log("(action=%s): default domain not found for '%s'.", () -> action, () -> appliance.getName()));
                    defaultDomain = new Domain("default");
                    appliance.addDomain(defaultDomain);
                }
                Index sourceInterfaces = (Index)deleteInfo.get(appliance);
                for (ConfigIPInterface ipInterface : sourceInterfaces.getKeys()) {
                    Collection sourceIPs = sourceInterfaces.get(ipInterface);
                    for (DynamicBean sourceIP : sourceIPs) {
                        String ipAddress = (String)sourceIP.getProperty("ipAddress");
                        logger.finer(() -> LMG.log("(action=%s): Preparing to remove %s from %s interface %s.", () -> action, () -> ipAddress, () -> ipInterface.getConfigObjectType(), () -> ipInterface.getName()));
                        String ipIP = ipInterface.getIPAddress();
                        String ipVirtualIP = ipInterface.getVirtualIP();
                        String ipDefaultGateway = ipInterface.getDefaultGateway();
                        ArrayList<String> ipSecondaryAddress = ipInterface.getSecondaryAddress();
                        ArrayList<String> ipVirtualSecondaryAddress = ipInterface.getSecondaryVirtualIP();
                        if (!StringUtility.isEmpty(ipIP) && ipIP.startsWith(ipAddress)) {
                            ipInterface.setIPAddress("");
                            continue;
                        }
                        if (!StringUtility.isEmpty(ipVirtualIP) && ipVirtualIP.startsWith(ipAddress)) {
                            ipInterface.setVirtualIP("");
                            continue;
                        }
                        if (!StringUtility.isEmpty(ipDefaultGateway) && ipDefaultGateway.startsWith(ipAddress)) {
                            ipInterface.setDefaultGateway("");
                            continue;
                        }
                        if (!CollectionUtility.isEmpty(ipSecondaryAddress) && CollectionUtility.containsElementStartingWith(ipSecondaryAddress, ipAddress)) {
                            CollectionUtility.removeElementsStartingWith(ipSecondaryAddress, ipAddress);
                            continue;
                        }
                        if (CollectionUtility.isEmpty(ipVirtualSecondaryAddress) || !CollectionUtility.containsElementStartingWith(ipVirtualSecondaryAddress, ipAddress)) continue;
                        CollectionUtility.removeElementsStartingWith(ipVirtualSecondaryAddress, ipAddress);
                    }
                    logger.finer(() -> LMG.log("(action=%s): Removing source IPs from %s interface %s.", () -> action, () -> ipInterface.getConfigObjectType(), () -> ipInterface.getName()));
                    ModifyTool modifyTool = new ModifyTool(appliance, defaultDomain, ipInterface);
                    modifyTool.setCommandDescription(String.format("Delete IPs from the %s interface", ipInterface.getName()));
                    mtil.addThread(modifyTool.getProcessThread());
                    modifyTool.addManagementCommandSubscriber(this.commandResultsDialog);
                }
            }
        }
        mtil.waitUntilComplete();
        this.waitForResultsDialogToCloseAndResetCursor();
        logger.finer(() -> LMG.log("(action=%s): Updating search results", () -> action));
        this.searchFind();
        logger.finer(() -> LMG.log("(action=%s): Done.", () -> action));
    }

    private static ConfigIPInterface getInterface(DynamicBean configInfoModel, Appliance appliance, String interfaceType, String interfaceName) {
        UniqueArrayList<Appliance> appliances = new UniqueArrayList<Appliance>();
        appliances.add(appliance);
        AbstractPanel.logger.finer(() -> LMG.log("(configInfoModel, appliance=%s, interfaceType=%s, interfaceName=%s): %s connected", () -> appliance.getName(), () -> interfaceType, () -> interfaceName, () -> appliance.isConnected() ? "is" : "is not"));
        ArrayList interfaces = null;
        switch (interfaceType) {
            case "EthernetInterface": {
                interfaces = (ArrayList)configInfoModel.getProperty("ethernetInterfaces");
                if (!CollectionUtility.isEmpty(interfaces)) break;
                ManageIPPanel.loadInterfaces(appliances, configInfoModel, ConfigEthernetInterface.class, "ethernetInterfaces");
                interfaces = (ArrayList)configInfoModel.getProperty("ethernetInterfaces");
                break;
            }
            case "LinkAggInterface": {
                interfaces = (ArrayList)configInfoModel.getProperty("linkAggregationInterfaces");
                if (!CollectionUtility.isEmpty(interfaces)) break;
                ManageIPPanel.loadInterfaces(appliances, configInfoModel, ConfigLinkAggregation.class, "linkAggregationInterfaces");
                interfaces = (ArrayList)configInfoModel.getProperty("linkAggregationInterfaces");
                break;
            }
            case "VLANInterface": {
                interfaces = (ArrayList)configInfoModel.getProperty("vlanInterfaces");
                if (!CollectionUtility.isEmpty(interfaces)) break;
                ManageIPPanel.loadInterfaces(appliances, configInfoModel, ConfigVLANInterface.class, "vlanInterfaces");
                interfaces = (ArrayList)configInfoModel.getProperty("vlanInterfaces");
            }
        }
        for (ConfigIPInterface targetInterface : interfaces) {
            if (!targetInterface.getAppliance().equals(appliance) || !targetInterface.getName().equals(interfaceName)) continue;
            return targetInterface;
        }
        return null;
    }

    private ArrayList<DynamicBean> getModifiableIPs() {
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            return null;
        }
        ArrayList<DynamicBean> modifiableIPs = new ArrayList<DynamicBean>();
        int i = 0;
        while (i < selectedRows.length) {
            IPInfoBean ipInfo = (IPInfoBean)this.tableModel.getValue(selectedRows[i]);
            String objectType = ipInfo.getSourceObjectType();
            String objectName = ipInfo.getSourceObjectName();
            if ((objectType.equals("EthernetInterface") || objectType.equals("LinkAggregation") || objectType.equals("VLANInterface")) && !objectName.equals("lo")) {
                DynamicBean modifiableIP = new DynamicBean(ipInfo);
                modifiableIPs.add(modifiableIP);
            }
            ++i;
        }
        return modifiableIPs;
    }

    @Reflected
    private void pingTest() {
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Ping Test");
        Index<Appliance, ActionPing> pingsByAppliance = new Index<Appliance, ActionPing>();
        int i = 0;
        while (i < selectedRows.length) {
            IPInfoBean ipInfo = (IPInfoBean)this.tableModel.getValue(selectedRows[i]);
            String ipAddress = ipInfo.getIpAddress();
            Appliance appliance = ipInfo.getAppliance();
            ActionPing actionPing = new ActionPing();
            actionPing.setRemoteHost(ipAddress);
            pingsByAppliance.put(appliance, actionPing);
            ++i;
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : pingsByAppliance.getKeys()) {
            Collection pings = pingsByAppliance.get(appliance);
            AsynchMethodInvoker pingInvoker = new AsynchMethodInvoker((Object)this, "performPings", new Object[]{appliance, pings});
            mtil.addThread(pingInvoker);
        }
        mtil.waitUntilComplete();
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void performPings(Appliance appliance, Collection<ActionPing> pings) {
        String applianceName = appliance.getName();
        AbstractPanel.logger.finer(() -> LMG.log("(Appliance appliance=%s, pings):  Starting pings.", () -> applianceName));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        for (ActionPing actionPing : pings) {
            String remoteHost = actionPing.getRemoteHost();
            AbstractPanel.logger.fine(() -> LMG.log("ManageIPPanel.performPings(Appliance appliance=%s, pings):  Conducting Ping Test for %s!", () -> applianceName, () -> remoteHost));
            ActionTool pingTest = new ActionTool(appliance, (JMBean)actionPing);
            pingTest.getProcessThread().addInvocationListener(stil);
            pingTest.setCommandDescription(String.format("Ping %s", remoteHost));
            pingTest.setConnectionTimeout(30000);
            pingTest.setReadTimeout(30000);
            pingTest.setRetryCount(0);
            pingTest.addManagementCommandSubscriber(this.commandResultsDialog);
            boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT * 3);
            if (!completedOnTime) {
                AbstractPanel.logger.warning(() -> LMG.log("ManageIPPanel.performPings(Appliance appliance=%s, pings): Ping Test for %s did not complete on time!", () -> applianceName, () -> remoteHost));
            }
            stil.clearCompletionStatus();
        }
        AbstractPanel.logger.info(() -> LMG.log("ManageIPPanel.performPings(Appliance appliance=%s, pings):  All ping tests are complete.", () -> applianceName));
    }

    @Reflected
    private void tcpTest() {
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            return;
        }
        DynamicBean tcpTestData = new DynamicBean();
        ArrayList<DynamicBean> ipPortData = new ArrayList<DynamicBean>();
        tcpTestData.setProperty("ipPortData", ipPortData);
        int i = 0;
        while (i < selectedRows.length) {
            IPInfoBean ipInfo = (IPInfoBean)this.tableModel.getValue(selectedRows[i]);
            String ipAddress = ipInfo.getIpAddress();
            Object appliance = ipInfo.getAppliance();
            DynamicBean ipPort = new DynamicBean();
            ipPort.setProperty("appliance", appliance);
            ipPort.setProperty("ipAddress", ipAddress);
            ipPort.setProperty("ports", "");
            ipPortData.add(ipPort);
            ++i;
        }
        WizardDialog<DynamicBean> portSelectionWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Perform TCP Connection Test");
        portSelectionWizard.addWizardPage(new TCPConnectionTestWizardPage(tcpTestData), "setData");
        portSelectionWizard.setSize(1200, 600);
        portSelectionWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("TCP Test");
        Index<Object, DynamicBean> testsByAppliance = new Index<Object, DynamicBean>();
        for (DynamicBean ipPort : ipPortData) {
            Appliance appliance = (Appliance)ipPort.getProperty("appliance");
            testsByAppliance.put(appliance, ipPort);
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Object appliance : testsByAppliance.getKeys()) {
            ArrayList tests = (ArrayList)testsByAppliance.get(appliance);
            AsynchMethodInvoker applianceTestInvoker = new AsynchMethodInvoker((Object)this, "performTCPConnectionTests", new Object[]{appliance, tests});
            mtil.addThread(applianceTestInvoker);
        }
        mtil.waitUntilComplete();
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void performTCPConnectionTests(Appliance appliance, ArrayList<DynamicBean> ipPortData) {
        String applianceName = appliance.getName();
        AbstractPanel.logger.finer(() -> LMG.log("(Appliance appliance=%s, ipPortData):  Starting tcp tests.", () -> applianceName));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        for (DynamicBean ipPort : ipPortData) {
            String ipAddress = (String)ipPort.getProperty("ipAddress");
            ArrayList testPorts = (ArrayList)ipPort.getProperty("allPorts");
            Iterator iterator = testPorts.iterator();
            while (iterator.hasNext()) {
                int remotePort = (Integer)iterator.next();
                ActionTCPConnectionTest actionTCPConnectionTest = new ActionTCPConnectionTest();
                actionTCPConnectionTest.setRemoteHost(ipAddress);
                actionTCPConnectionTest.setRemotePort(remotePort);
                stil.clearCompletionStatus();
                AbstractPanel.logger.fine(() -> LMG.log("(Appliance appliance=%s, ipPortData):  Conducting TCP Test for %s:%d!", () -> applianceName, () -> ipAddress, () -> remotePort));
                ActionTool tcpTest = new ActionTool(appliance, (JMBean)actionTCPConnectionTest);
                tcpTest.getProcessThread().addInvocationListener(stil);
                tcpTest.setCommandDescription(String.format("TCP Connection test to %s:%d", ipAddress, remotePort));
                tcpTest.setConnectionTimeout(30000);
                tcpTest.setReadTimeout(30000);
                tcpTest.setRetryCount(0);
                tcpTest.addManagementCommandSubscriber(this.commandResultsDialog);
                boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT * 3);
                if (completedOnTime) continue;
                AbstractPanel.logger.warning(() -> LMG.log("(Appliance appliance=%s, ipPortData):  TCP Test for %s:%d did not complete on time!", () -> applianceName, () -> ipAddress, () -> remotePort));
            }
        }
        AbstractPanel.logger.info(() -> LMG.log("(Appliance appliance=%s, ipPortData):  All tcp tests are complete.", () -> applianceName));
    }

    @Reflected
    private void createHostAliases() {
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            return;
        }
        DynamicBean hostAliasData = new DynamicBean();
        Index<String, String> ipHostAliasIndex = this.getIPValueIndex("HostAlias");
        hostAliasData.setProperty("hostAliases", ipHostAliasIndex);
        Index<String, Appliance> ipApplianceIndex = this.getIPApplianceIndex(selectedRows);
        hostAliasData.setProperty("ipApplianceIndex", ipApplianceIndex);
        WizardDialog<DynamicBean> haCreationWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Create Host Aliases from Selected IPs");
        haCreationWizard.addWizardPage(new IPAssignmentWizardPage(hostAliasData, "Host Alias", "hostAlias", "hostAliases", "CreateHostAliasWizardPage.html"), "createHostAliases");
        haCreationWizard.setSize(600, 600);
        haCreationWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        ArrayList finalData = (ArrayList)hostAliasData.getProperty("finalData");
        if (finalData.size() == 0) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Create Host Aliases");
        for (DynamicBean haBean : finalData) {
            Appliance appliance = (Appliance)haBean.getProperty("appliance");
            String ipAddress = (String)haBean.getProperty("ipAddress");
            String hostAlias = (String)haBean.getProperty("hostAlias");
            ConfigHostAlias configHostAlias = new ConfigHostAlias();
            configHostAlias.setAdminState("enabled");
            configHostAlias.setIPAddress(ipAddress);
            configHostAlias.setName(hostAlias);
            ConfigTool haConfig = new ConfigTool(appliance, appliance.getDomain("default"), configHostAlias);
            haConfig.addManagementCommandSubscriber(this.commandResultsDialog);
            haConfig.setCommandDescription(String.format("Create host alias %s from %s", hostAlias, ipAddress));
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void createStaticHosts() {
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            return;
        }
        DynamicBean staticHostData = new DynamicBean();
        Index<String, String> ipHostTable = this.getIPValueIndex("DNSNameService");
        staticHostData.setProperty("staticHosts", ipHostTable);
        Index<String, Appliance> ipApplianceIndex = this.getIPApplianceIndex(selectedRows);
        staticHostData.setProperty("ipApplianceIndex", ipApplianceIndex);
        WizardDialog<DynamicBean> staticHostCreationWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Create Static Hosts from Selected IPs");
        staticHostCreationWizard.addWizardPage(new IPAssignmentWizardPage(staticHostData, "Static Host", "staticHost", "staticHosts", "CreateStaticHostWizardPage.html"), "createStaticHosts");
        staticHostCreationWizard.setSize(600, 600);
        staticHostCreationWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        ArrayList finalData = (ArrayList)staticHostData.getProperty("finalData");
        if (finalData.size() == 0) {
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        UniqueArrayList<Appliance> chosenAppliances = this.getChosenAppliances(selectedRows);
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<ConfigDNSNameService> dnsConfigs = configurationManager.getObjects(chosenAppliances, ConfigDNSNameService.class, ".*");
        BeanIndexer<ConfigDNSNameService> dnsConfigIndexer = new BeanIndexer<ConfigDNSNameService>(dnsConfigs);
        HashMap<Object, ConfigDNSNameService> dnsByAppliance = dnsConfigIndexer.getMapOf("appliance", null);
        this.openResultsDialogAndSetWaitCursor("Create Static Hosts");
        DateTime createDate = new DateTime();
        String userSummary = String.format("Created by DPAA on %s", createDate.toString());
        for (DynamicBean dynamicBean : finalData) {
            Appliance appliance = (Appliance)dynamicBean.getProperty("appliance");
            String ipAddress = (String)dynamicBean.getProperty("ipAddress");
            String staticHost = (String)dynamicBean.getProperty("staticHost");
            ConfigDNSNameService dnsConfig = dnsByAppliance.get(appliance);
            ArrayList<StaticHost> staticHosts = dnsConfig.getStaticHosts();
            if (staticHosts == null) {
                staticHosts = new ArrayList();
                dnsConfig.setStaticHosts(staticHosts);
            }
            boolean exists = false;
            for (StaticHost staticHostObject : staticHosts) {
                String shIP = staticHostObject.getIPAddress();
                String shHost = staticHostObject.getHostname();
                if (!shIP.equals(ipAddress)) continue;
                staticHostObject.setHostname(staticHost);
                if (!shHost.equals(staticHost)) {
                    staticHostObject.setUserSummary(String.format("Modified from %s to %s by DPAA on %s", shHost, staticHost, createDate.toString()));
                }
                exists = true;
                break;
            }
            if (exists) continue;
            StaticHost newStaticHost = new StaticHost();
            newStaticHost.setIPAddress(ipAddress);
            newStaticHost.setHostname(staticHost);
            newStaticHost.setUserSummary(userSummary);
            staticHosts.add(newStaticHost);
        }
        for (Appliance appliance : dnsByAppliance.keySet()) {
            ConfigDNSNameService dnsNameService = dnsByAppliance.get(appliance);
            ConfigTool configTool = new ConfigTool(appliance, appliance.getDomain("default"), dnsNameService);
            configTool.addManagementCommandSubscriber(this.commandResultsDialog);
            configTool.setCommandDescription("Create DNS Static Hosts");
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    private UniqueArrayList<Appliance> getChosenAppliances(int[] selectedRows) {
        UniqueArrayList<Appliance> chosenAppliances = new UniqueArrayList<Appliance>();
        int i = 0;
        while (i < selectedRows.length) {
            IPInfoBean ipInfo = (IPInfoBean)this.tableModel.getValue(selectedRows[i]);
            Appliance appliance = ipInfo.getAppliance();
            chosenAppliances.add(appliance);
            ++i;
        }
        return chosenAppliances;
    }

    private Index<String, String> getIPValueIndex(String objectType) {
        Index<String, String> ipHostTable = new Index<String, String>();
        ArrayList tableData = this.tableModel.getModelData();
        for (IPInfoBean ipInfo : tableData) {
            if (ipInfo == null) {
                AbstractPanel.logger.config("ManageIPPanel.getIPValueIndex():  Entire ipInfo entry is null.  How???");
                continue;
            }
            String sourceObjectType = ipInfo.getSourceObjectType();
            if (!StringUtility.isNotEmpty(sourceObjectType) || !sourceObjectType.equals(objectType)) continue;
            String ipAddress = ipInfo.getIpAddress();
            String ipValue = ipInfo.getSourceObjectName();
            if (ipHostTable.containsKey(ipAddress)) {
                ArrayList values = (ArrayList)ipHostTable.get(ipAddress);
                if (values.contains(ipValue)) continue;
                ipHostTable.put(ipAddress, ipValue);
                continue;
            }
            ipHostTable.put(ipAddress, ipValue);
        }
        return ipHostTable;
    }

    private Index<String, Appliance> getIPApplianceIndex(int[] selectedRows) {
        Index<String, Appliance> ipApplianceIndex = new Index<String, Appliance>();
        int i = 0;
        while (i < selectedRows.length) {
            IPInfoBean ipInfo = (IPInfoBean)this.tableModel.getValue(selectedRows[i]);
            String ipAddress = ipInfo.getIpAddress();
            Appliance appliance = ipInfo.getAppliance();
            if (ipApplianceIndex.containsKey(ipAddress)) {
                ArrayList appliances = (ArrayList)ipApplianceIndex.get(ipAddress);
                if (!appliances.contains(appliance)) {
                    ipApplianceIndex.put(ipAddress, appliance);
                }
            } else {
                ipApplianceIndex.put(ipAddress, appliance);
            }
            ++i;
        }
        return ipApplianceIndex;
    }
}

