/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.ExceptionListenerClient;
import com.jmorgan.lang.MutableInteger;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.menu.JMMenu;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.menu.MenuGroup;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.ui.beans.ComplexTypeTableEditorInfo;
import com.kumbasoft.core.ui.beans.ListPropertyTableEditorInfo;
import com.kumbasoft.core.ui.beans.TableEditorInfo;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import com.kumbasoft.dpaa.ui.panels.configurations.ManageObjectsPanel;
import java.awt.Component;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ManageObjectsPopupMenu
extends JMPopupMenu
implements PopupMenuController,
ListSelectionListener {
    private static final String CERTIFICATE_ACTIONS = "certificateActions";
    private static final String COPY_MOVE_ACTIONS = "copyMoveActions";
    private static final String CRYPTO_ID_CRED_ACTIONS = "cryptoIDCredActions";
    private static final String CRYPTO_KEY_ACTIONS = "cryptoKeyActions";
    private static final String DELETE_ACTIONS = "deleteActions";
    private static final String EXPORT_SAVE_ACTIONS = "exportSaveActions";
    private static final String KEYTAB_ACTIONS = "keyTabActions";
    private static final String LOG_TARGET_ACTIONS = "logTargetActions";
    private static final String MONITOR_ACTIONS = "monitorActions";
    private static final String OBJECT_COMPARE_ACTIONS = "objectCompareActions";
    private static final String PASSWORD_ACTIONS = "passwordManagementActions";
    private static final String PROBE_MANAGEMENT = "probeManagementActions";
    private static final String QUIESCIBLE_ACTIONS = "quiescibleActions";
    private static final String REFACTOR_ACTIONS = "refactorActions";
    private static final String SHARED_SECRET_KEY_ACTIONS = "sharedSecretKeyActions";
    private static final String SHOW_REFERENCE_ACTIONS = "showReferencesActions";
    private static final String ADMIN_ACTIONS = "administrativeActions";
    private static Logger logger;
    private static final HashSet<String> REFACTOR_EXCEPTIONS;
    private HashMap<String, HashMap<String, ? extends TableEditorInfo>> propertiesEditorInfo;
    private ManageObjectsPanel eventTarget;
    private JMTable displayTable;
    private Index<String, String> menuGroupsByType;
    private boolean selectionChanging = false;
    private Collection<DataPowerConfig> migrationTargets;
    private AsynchMethodInvoker<Void> valueChangedReplayThread;

    static {
        REFACTOR_EXCEPTIONS = new HashSet();
        try {
            String[] exceptions;
            String exceptionData = FileUtility.readFile("/configs/RefactorableExceptions.txt");
            String[] stringArray = exceptions = exceptionData.split("\n");
            int n = exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                String exception = stringArray[n2];
                if (!StringUtility.isEmpty(exception) && !exception.startsWith("#")) {
                    REFACTOR_EXCEPTIONS.add(exception);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            logger.config("ManageObjectsPopupMenu.clinit():  Error reading /configs/RefactorableExceptions.txt");
            e.printStackTrace();
        }
        logger = Application.getApplication().getApplicationLogger();
    }

    public ManageObjectsPopupMenu(ManageObjectsPanel eventTarget, JMTable displayTable) {
        this.eventTarget = eventTarget;
        this.displayTable = displayTable;
        this.propertiesEditorInfo = ManageObjectsPopupMenu.createPropertiesEditorInfo();
        logger.finer("():  Creating popup menu.");
        while (this.displayTable == null) {
            logger.fine("():  Display table doesn't yet exist - Cannot create popup menu - Waiting.");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        this.displayTable.addListSelectionListener(this);
        this.setPopupController(this);
        this.addPopupMenuClient(displayTable);
        this.buildObjectCompareItems();
        this.buildAdministrativeItems();
        this.buildCryptoCertificateItems();
        this.buildCryptoKeyItems();
        this.buildCryptoIDCredItems();
        this.buildKeytabItems();
        this.buildSharedSecretKeyItems();
        this.buildQuiescenseItems();
        this.buildPasswordManagementItems();
        this.buildExportSaveItems();
        this.buildRefactoringMenu();
        this.buildCopyToMoveToMenu();
        this.buildShowReferencesItems();
        this.buildProbeManagementItems();
        this.buildLogTargetMenuItems();
        this.buildCountDurationMonitorItems();
        this.buildDynamicEditorItems();
        this.buildDeleteItems();
        this.setEnabled(false);
    }

    private void buildObjectCompareItems() {
        MenuGroup menuGroup = new MenuGroup();
        menuGroup.addMenuItem(ComponentFactory.createMenuItem("Open selected objects...", (Object)this.eventTarget, "fileCompare"));
        menuGroup.addMenuItem(ComponentFactory.createMenuItem("Undo configuration changes on selected objects", (Object)this.eventTarget, "undoConfig"));
        menuGroup.addSeparator();
        this.addMenuGroup(OBJECT_COMPARE_ACTIONS, menuGroup);
    }

    private void buildAdministrativeItems() {
        MenuGroup menuGroup = new MenuGroup();
        menuGroup.addMenuItem(ComponentFactory.createMenuItem("Reset Failed Login for selected users...", (Object)this.eventTarget, "resetFailedLogin"));
        menuGroup.addMenuItem(ComponentFactory.createMenuItem("Force ILMT Scan for selected ILMT Scanners", (Object)this.eventTarget, "forceILMTScan"));
        this.addMenuGroup(ADMIN_ACTIONS, menuGroup);
    }

    private void buildCryptoCertificateItems() {
        MenuGroup certificateGroup = new MenuGroup();
        JMMenu cryptoCertMenu = new JMMenu("Certificate Actions");
        cryptoCertMenu.addMenuItem("Show Certificate Details...", this.eventTarget, "showCertificateDetails");
        cryptoCertMenu.addSeparator();
        cryptoCertMenu.addMenuItem("Update Certificate From On-Board File...", this.eventTarget, "editCryptoObject", 0, "certFromLocalFile");
        cryptoCertMenu.addMenuItem("Update Certificate From External File...", this.eventTarget, "editCryptoObject", 0, "certFromExternalFile");
        cryptoCertMenu.addMenuItem("Update Certificate From URL...", this.eventTarget, "editCryptoObject", 0, "certFromURL");
        certificateGroup.addMenu(cryptoCertMenu);
        certificateGroup.addSeparator();
        this.addMenuGroup(CERTIFICATE_ACTIONS, certificateGroup);
    }

    private void buildCryptoKeyItems() {
        MenuGroup keyGroup = new MenuGroup();
        JMMenu cryptoKeyMenu = new JMMenu("Crypto Key Actions");
        cryptoKeyMenu.addMenuItem("Update Key From On-Board File...", this.eventTarget, "editCryptoObject", 1, "keyFromLocalFile");
        cryptoKeyMenu.addMenuItem("Update Key From External File...", this.eventTarget, "editCryptoObject", 1, "keyFromExternalFile");
        keyGroup.addMenu(cryptoKeyMenu);
        keyGroup.addSeparator();
        this.addMenuGroup(CRYPTO_KEY_ACTIONS, keyGroup);
    }

    private void buildCryptoIDCredItems() {
        MenuGroup cryptoIDCredGroup = new MenuGroup();
        JMMenu cryptoIDCredMenu = new JMMenu("Crypto Identification Credential Actions");
        cryptoIDCredMenu.addMenuItem("Update Certificate From On-Board File...", this.eventTarget, "editCryptoIDCredential", "certFromLocalFile");
        cryptoIDCredMenu.addMenuItem("Update Certificate From External File...", this.eventTarget, "editCryptoIDCredential", "certFromExternalFile");
        cryptoIDCredMenu.addMenuItem("Update Certificate From URL...", this.eventTarget, "editCryptoIDCredential", "certFromURL");
        cryptoIDCredMenu.addSeparator();
        cryptoIDCredMenu.addMenuItem("Update Key From On-Board File...", this.eventTarget, "editCryptoIDCredential", "keyFromLocalFile");
        cryptoIDCredMenu.addMenuItem("Update Key From External File...", this.eventTarget, "editCryptoIDCredential", "keyFromExternalFile");
        cryptoIDCredMenu.addSeparator();
        cryptoIDCredMenu.addMenuItem("Update Certificate && Key From Same On-Board File...", this.eventTarget, "editCryptoIDCredential", "certAndKeyFromLocalFile");
        cryptoIDCredMenu.addMenuItem("Update Certificate && Key From Same External File...", this.eventTarget, "editCryptoIDCredential", "certAndKeyFromExternalFile");
        cryptoIDCredGroup.addMenu(cryptoIDCredMenu);
        cryptoIDCredGroup.addSeparator();
        this.addMenuGroup(CRYPTO_ID_CRED_ACTIONS, cryptoIDCredGroup);
    }

    private void buildKeytabItems() {
        MenuGroup keyTabGroup = new MenuGroup();
        JMMenu keytabFileMenu = new JMMenu("Kerberos Keytab Actions");
        keytabFileMenu.addMenuItem("Update Keytab From On-Board File...", this.eventTarget, "editCryptoObject", 2, "keyFromLocalFile");
        keytabFileMenu.addMenuItem("Update Keytab From External File...", this.eventTarget, "editCryptoObject", 2, "keyFromExternalFile");
        keyTabGroup.addMenu(keytabFileMenu);
        keyTabGroup.addSeparator();
        this.addMenuGroup(KEYTAB_ACTIONS, keyTabGroup);
    }

    private void buildSharedSecretKeyItems() {
        MenuGroup cryptoSSKeyGroup = new MenuGroup();
        JMMenu sharedSecretKeyMenu = new JMMenu("Shared Secret Key Actions");
        sharedSecretKeyMenu.addMenuItem("Update Key From On-Board File...", this.eventTarget, "editCryptoObject", 3, "keyFromLocalFile");
        sharedSecretKeyMenu.addMenuItem("Update Key From External File...", this.eventTarget, "editCryptoObject", 3, "keyFromExternalFile");
        sharedSecretKeyMenu.addMenuItem("Generate A New Key...", this.eventTarget, "generateSharedSecretKey");
        cryptoSSKeyGroup.addMenu(sharedSecretKeyMenu);
        cryptoSSKeyGroup.addSeparator();
        this.addMenuGroup(SHARED_SECRET_KEY_ACTIONS, cryptoSSKeyGroup);
    }

    private void buildQuiescenseItems() {
        MenuGroup quiesceGroup = new MenuGroup();
        quiesceGroup.addMenuItem(ComponentFactory.createMenuItem("Toggle Admin State of selected objects...", (Object)this.eventTarget, "toggleAdminState"));
        quiesceGroup.addMenuItem(ComponentFactory.createMenuItem("Toggle Quiescence of selected objects...", (Object)this.eventTarget, "toggleQuiescence"));
        quiesceGroup.addSeparator();
        this.addMenuGroup(QUIESCIBLE_ACTIONS, quiesceGroup);
    }

    private void buildPasswordManagementItems() {
        MenuGroup passwordGroup = new MenuGroup();
        passwordGroup.addMenuItem(ComponentFactory.createMenuItem("Change Password for applicable selected types...", (Object)this.eventTarget, "changePasswordDialog"));
        passwordGroup.addMenuItem(ComponentFactory.createMenuItem("Migrate Plain Text Password to Pass Map Alias for applicable selected types...", (Object)this.eventTarget, "migratePasswordDialog"));
        passwordGroup.addSeparator();
        this.addMenuGroup(PASSWORD_ACTIONS, passwordGroup);
    }

    private void buildExportSaveItems() {
        MenuGroup exportSaveGroup = new MenuGroup();
        exportSaveGroup.addMenuItem(ComponentFactory.createMenuItem("Export Configuration...", (Object)this.eventTarget, "fileExportConfiguration"));
        exportSaveGroup.addMenuItem(ComponentFactory.createMenuItem("Save As...", (Object)this.eventTarget, "fileSaveAs"));
        exportSaveGroup.addSeparator();
        this.addMenuGroup(EXPORT_SAVE_ACTIONS, exportSaveGroup);
    }

    private void buildRefactoringMenu() {
        MenuGroup menuGroup = new MenuGroup();
        JMMenu refactorMenu = new JMMenu("Refactor");
        refactorMenu.addMenuItem("Replace...", this.eventTarget, "fileReplace");
        refactorMenu.addMenuItem("Rename...", this.eventTarget, "fileRename");
        refactorMenu.addSeparator();
        refactorMenu.addMenuItem("Migrate Selected Proxy Profiles...", this.eventTarget, "migrateProxyProfiles");
        menuGroup.addMenu(refactorMenu);
        menuGroup.addSeparator();
        this.addMenuGroup(REFACTOR_ACTIONS, menuGroup);
    }

    private void buildCopyToMoveToMenu() {
        MenuGroup copyMoveGroup = new MenuGroup();
        copyMoveGroup.addMenuItem(ComponentFactory.createMenuItem("Copy to...", (Object)this.eventTarget, "editCopy"));
        copyMoveGroup.addMenuItem(ComponentFactory.createMenuItem("Move to...", (Object)this.eventTarget, "editMove"));
        copyMoveGroup.addSeparator();
        this.addMenuGroup(COPY_MOVE_ACTIONS, copyMoveGroup);
    }

    private void buildShowReferencesItems() {
        MenuGroup menuGroup = new MenuGroup();
        menuGroup.addMenuItem(ComponentFactory.createMenuItem("Show References...", (Object)this.eventTarget, "showReferencesDialog", new Object[]{ConfigurationRelationshipType.PARENT_DOWN}));
        menuGroup.addMenuItem(ComponentFactory.createMenuItem("Show Referenced By...", (Object)this.eventTarget, "showReferencesDialog", new Object[]{ConfigurationRelationshipType.CHILD_UP}));
        menuGroup.addSeparator();
        this.addMenuGroup(SHOW_REFERENCE_ACTIONS, menuGroup);
    }

    private void buildProbeManagementItems() {
        MenuGroup probeGroup = new MenuGroup();
        probeGroup.addMenuItem(ComponentFactory.createMenuItem("Enable probes for selected service objects...", (Object)this.eventTarget, "editEnableProbes"));
        JMMenu probeTransQuickSet = new JMMenu("Set probe transaction history");
        probeTransQuickSet.add(ComponentFactory.createMenuItem("10", (Object)this.eventTarget, "setProbeTransactionHistory", 10));
        probeTransQuickSet.add(ComponentFactory.createMenuItem("25", (Object)this.eventTarget, "setProbeTransactionHistory", 25));
        probeTransQuickSet.add(ComponentFactory.createMenuItem("50", (Object)this.eventTarget, "setProbeTransactionHistory", 50));
        probeTransQuickSet.add(ComponentFactory.createMenuItem("100", (Object)this.eventTarget, "setProbeTransactionHistory", 100));
        probeTransQuickSet.add(ComponentFactory.createMenuItem("200", (Object)this.eventTarget, "setProbeTransactionHistory", 200));
        probeTransQuickSet.add(ComponentFactory.createMenuItem("unbounded", (Object)this.eventTarget, "setProbeTransactionHistory", Integer.MAX_VALUE));
        probeGroup.addMenu(probeTransQuickSet);
        probeGroup.addMenuItem(ComponentFactory.createMenuItem("Flush probes for selected service objects...", (Object)this.eventTarget, "editFlushProbes"));
        probeGroup.addMenuItem(ComponentFactory.createMenuItem("Show Probes...", (Object)this.eventTarget, "showProbes"));
        probeGroup.addMenuItem(ComponentFactory.createMenuItem("Disable probes for selected service objects", (Object)this.eventTarget, "editDisableProbes"));
        probeGroup.addSeparator();
        this.addMenuGroup(PROBE_MANAGEMENT, probeGroup);
    }

    private void buildLogTargetMenuItems() {
        MenuGroup logTargetGroup = new MenuGroup();
        JMMenu logLevelQuickSet = new JMMenu("Set log level for selected logging targets");
        String[] stringArray = DPEnumerations.LOG_LEVEL;
        int n = DPEnumerations.LOG_LEVEL.length;
        int n2 = 0;
        while (n2 < n) {
            String logLevel = stringArray[n2];
            logLevelQuickSet.add(ComponentFactory.createMenuItem(logLevel, (Object)this.eventTarget, "editSetLogLevel", logLevel));
            ++n2;
        }
        logTargetGroup.addMenuItem(ComponentFactory.createMenuItem("Create Logging Target for selected objects", (Object)this.eventTarget, "editCreateLogTarget"));
        logTargetGroup.addMenu(logLevelQuickSet);
        logTargetGroup.addSeparator();
        this.addMenuGroup(LOG_TARGET_ACTIONS, logTargetGroup);
    }

    private void buildCountDurationMonitorItems() {
        MenuGroup monitorGroup = new MenuGroup();
        monitorGroup.addMenuItem(ComponentFactory.createMenuItem("Create Simple Count/Duration monitors for selected objects", (Object)this.eventTarget, "editCreateMonitors"));
        monitorGroup.addSeparator();
        this.addMenuGroup(MONITOR_ACTIONS, monitorGroup);
    }

    private void buildDeleteItems() {
        MenuGroup menuGroup = new MenuGroup();
        menuGroup.addMenuItem(ComponentFactory.createMenuItem("Delete selected objects...", (Object)this.eventTarget, "editDelete"));
        this.addMenuGroup(DELETE_ACTIONS, menuGroup);
    }

    private void buildDynamicEditorItems() {
        ArrayList<TableEditorInfo> allEditors = new ArrayList<TableEditorInfo>();
        for (String configName : this.propertiesEditorInfo.keySet()) {
            HashMap<String, ? extends TableEditorInfo> editorsByConfig = this.propertiesEditorInfo.get(configName);
            for (String propertyName : editorsByConfig.keySet()) {
                allEditors.add(editorsByConfig.get(propertyName));
            }
        }
        BeanComparator editorSorter = new BeanComparator();
        editorSorter.addCompareProperties("menuGroup", "containerPropertyName");
        Collections.sort(allEditors, editorSorter);
        this.menuGroupsByType = new Index();
        for (TableEditorInfo tei : allEditors) {
            String menuGroupName = tei.getMenuGroup();
            String containerType = tei.getContainingType();
            this.menuGroupsByType.put(containerType, menuGroupName);
        }
        BeanIndexer editorIndexer = new BeanIndexer(allEditors);
        Index editorsByMenuGroup = editorIndexer.getIndexOf("menuGroup", "");
        for (String menuGroupName : editorsByMenuGroup.getKeys()) {
            MenuGroup menuGroup = new MenuGroup();
            Collection editors = editorsByMenuGroup.get(menuGroupName);
            for (TableEditorInfo editor : editors) {
                String invocationMethodName = editor instanceof ListPropertyTableEditorInfo ? "editManageConfigMembers" : "editManageComplexMembers";
                JMMenuItem newItem = ComponentFactory.createMenuItem(editor.getMenuItemText(), (Object)this.eventTarget, invocationMethodName, editor);
                menuGroup.addMenuItem(newItem);
            }
            menuGroup.addSeparator();
            this.addMenuGroup(menuGroupName, menuGroup);
        }
    }

    public Collection<DataPowerConfig> getMigrationTargets() {
        return this.migrationTargets;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        logger.finer("(ListSelectionEvent e): Starting");
        if (this.selectionChanging) {
            logger.finer("(ListSelectionEvent e): Waiting for previous invocation to complete.");
            if (this.valueChangedReplayThread != null) {
                this.valueChangedReplayThread.cancel();
            }
            this.valueChangedReplayThread = new AsynchMethodInvoker((Object)this, "valueChanged", (Object)e, 250);
            return;
        }
        this.selectionChanging = true;
        this.migrationTargets = null;
        logger.finer("(ListSelectionEvent e): Getting selected items.");
        BeanTableModel tableModel = (BeanTableModel)this.displayTable.getModel();
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (selectedRows.length == 0) {
            logger.info("(ListSelectionEvent e): No rows selected.  Returning.");
            this.selectionChanging = false;
            return;
        }
        logger.finer(() -> LMG.log("(ListSelectionEvent e): Processing %d selected rows.", () -> selectedRows.length));
        ArrayList selectedValues = tableModel.getValues(selectedRows);
        PropertyValueSelector certKeySelector = new PropertyValueSelector(selectedValues);
        certKeySelector.addPropertyValueMap("dataPowerClass", "(Crypto(Certificate|Key))", 11);
        ArrayList certsAndKeys = (ArrayList)certKeySelector.getSelectedElements();
        if (certsAndKeys.size() == 0) {
            logger.info("(ListSelectionEvent e): No certs and keys selected.  Returning.");
            this.selectionChanging = false;
            return;
        }
        logger.finer(() -> LMG.log("(ListSelectionEvent e): Getting configurations for %d certs and keys.", () -> certsAndKeys.size()));
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<DataPowerConfig> certAndKeyConfigs = configurationManager.getObjects(certsAndKeys);
        logger.finer(() -> LMG.log("(ListSelectionEvent e): Checking %d configs to see if they are a password migration target.", () -> certAndKeyConfigs.size()));
        PropertyValueSelector<DataPowerConfig> migrationTargetSelector = new PropertyValueSelector<DataPowerConfig>(certAndKeyConfigs);
        migrationTargetSelector.addPropertyValueMap("password", null, 101);
        migrationTargetSelector.addPropertyValueMap("alias", null, 100);
        this.migrationTargets = migrationTargetSelector.getSelectedElements();
        logger.finer(() -> LMG.log("(ListSelectionEvent e): There are %d migration targets.", () -> this.migrationTargets.size()));
        this.selectionChanging = false;
        logger.finer("(ListSelectionEvent e): Done.");
    }

    @Override
    public boolean isPopupReady() {
        logger.finer("(): Starting");
        BeanTableModel tableModel = (BeanTableModel)this.displayTable.getModel();
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (selectedRows.length == 0) {
            logger.finer("(): No rows selected.  Returning false.");
            return false;
        }
        logger.finer(() -> LMG.log("(): %d objects selected.", () -> selectedRows.length));
        boolean configChanged = false;
        boolean quiesceAble = false;
        boolean probeAble = false;
        boolean logTargetSelected = false;
        boolean deleteAble = true;
        int externalCount = 0;
        boolean monitorable = false;
        boolean certificateSelected = false;
        boolean keySelected = false;
        boolean cryptoIDCredSelected = false;
        boolean keytabSelected = false;
        boolean sharedSecretKeySelected = false;
        boolean proxyProfileSelected = false;
        boolean refactorable = true;
        boolean hasPassword = false;
        boolean userSelected = false;
        boolean ilmtScannerSelected = false;
        UniqueArrayList<String> selectedTypes = new UniqueArrayList<String>();
        HashMap<Integer, MutableInteger> countByApplianceDomain = new HashMap<Integer, MutableInteger>();
        int r = 0;
        while (r < selectedRows.length) {
            String configState;
            StatusObjectStatus objectStatus = (StatusObjectStatus)tableModel.getValue(selectedRows[r]);
            Iterator appliance = objectStatus.getAppliance();
            Domain domain = objectStatus.getSourceDomain();
            int countKey = String.format("%s-%s", ((Appliance)((Object)appliance)).getName(), domain.getName()).hashCode();
            MutableInteger count = (MutableInteger)countByApplianceDomain.get(countKey);
            if (count == null) {
                countByApplianceDomain.put(countKey, new MutableInteger(1));
            } else {
                count.increment();
            }
            String dataPowerClass = objectStatus.getDataPowerClass();
            String errorCode = objectStatus.getErrorCode();
            selectedTypes.add(dataPowerClass);
            if (!configChanged) {
                configState = objectStatus.getConfigState();
                boolean bl = configChanged = configState.equals("new") || configState.equals("modified") || configState.equals("deleted");
            }
            if (!quiesceAble) {
                quiesceAble = Comparison.isIn(dataPowerClass, ConfigurationManager.QUIESCABLE_TYPES);
            }
            if (!probeAble) {
                probeAble = ManageObjectsPanel.DEBUG_TYPES.contains(dataPowerClass);
            }
            if (!logTargetSelected) {
                logTargetSelected = dataPowerClass.equals("LogTarget");
            }
            if (!monitorable) {
                monitorable = ManageObjectsPanel.MONITORED_TYPES.contains(dataPowerClass);
            }
            if (!certificateSelected) {
                certificateSelected = dataPowerClass.equals("CryptoCertificate");
            }
            if (!keySelected) {
                keySelected = dataPowerClass.equals("CryptoKey");
            }
            if (!cryptoIDCredSelected) {
                cryptoIDCredSelected = dataPowerClass.equals("CryptoIdentCred");
            }
            if (!sharedSecretKeySelected) {
                sharedSecretKeySelected = dataPowerClass.equals("CryptoSSKey");
            }
            if (!keytabSelected) {
                keytabSelected = dataPowerClass.equals("CryptoKerberosKeytab");
            }
            if (!proxyProfileSelected) {
                proxyProfileSelected = dataPowerClass.equals("SSLProxyProfile");
            }
            if (!userSelected) {
                boolean bl = userSelected = dataPowerClass.equals("User") && errorCode != null && errorCode.equals("Lock out due to number of failed logins");
            }
            if (!ilmtScannerSelected) {
                ilmtScannerSelected = dataPowerClass.equals("ILMTScanner");
            }
            if (refactorable) {
                boolean bl = refactorable = !REFACTOR_EXCEPTIONS.contains(dataPowerClass);
            }
            if (!hasPassword) {
                hasPassword = ConfigurationManager.doesObjectContainPassword(dataPowerClass);
            }
            if ((configState = objectStatus.getConfigState()).equals("external")) {
                ++externalCount;
            }
            ++r;
        }
        if (externalCount == selectedRows.length) {
            deleteAble = false;
        }
        MenuGroup menuGroup = this.getMenuGroup(OBJECT_COMPARE_ACTIONS);
        menuGroup.setVisible("Undo.*", configChanged);
        menuGroup = this.getMenuGroup(QUIESCIBLE_ACTIONS);
        menuGroup.setVisible(".*?Quiescence.*", quiesceAble);
        menuGroup = this.getMenuGroup(ADMIN_ACTIONS);
        menuGroup.setVisible("Reset Failed Login.*", userSelected);
        menuGroup.setVisible("Force ILMT Scan.*", ilmtScannerSelected);
        menuGroup = this.getMenuGroup(CERTIFICATE_ACTIONS);
        menuGroup.setVisible(certificateSelected);
        menuGroup = this.getMenuGroup(CRYPTO_KEY_ACTIONS);
        menuGroup.setVisible(keySelected);
        menuGroup = this.getMenuGroup(CRYPTO_ID_CRED_ACTIONS);
        menuGroup.setVisible(cryptoIDCredSelected);
        menuGroup = this.getMenuGroup(KEYTAB_ACTIONS);
        menuGroup.setVisible(keytabSelected);
        menuGroup = this.getMenuGroup(SHARED_SECRET_KEY_ACTIONS);
        menuGroup.setVisible(sharedSecretKeySelected);
        menuGroup = this.getMenuGroup(PROBE_MANAGEMENT);
        menuGroup.setVisible(probeAble);
        menuGroup = this.getMenuGroup(LOG_TARGET_ACTIONS);
        for (JComponent component : menuGroup.getMenuComponents()) {
            if (!(component instanceof JMMenu)) continue;
            component.setVisible(logTargetSelected);
        }
        menuGroup = this.getMenuGroup(MONITOR_ACTIONS);
        menuGroup.setVisible(monitorable);
        menuGroup = this.getMenuGroup(DELETE_ACTIONS);
        menuGroup.setVisible(deleteAble);
        if (refactorable) {
            for (MutableInteger count : countByApplianceDomain.values()) {
                if (count.getValue() <= 1) continue;
                logger.info("(): Potential object collisions can occur on refactorable objects when more than one is selected in any given appliance/domain.  Setting refactoriable off.");
                refactorable = false;
                break;
            }
        }
        logger.finer("(): Handling 'Refactor' and 'Migrate' options.");
        menuGroup = this.getMenuGroup(REFACTOR_ACTIONS);
        if (!refactorable && !proxyProfileSelected) {
            menuGroup.setVisible(false);
        } else {
            menuGroup.setVisible(true);
            Collection<JComponent> menuItems = menuGroup.getMenuComponents();
            for (JComponent menuItem : menuItems) {
                Component[] menuComponents;
                if (!(menuItem instanceof JMMenu)) continue;
                JMMenu refactorMenu = (JMMenu)menuItem;
                Component[] componentArray = menuComponents = refactorMenu.getMenuComponents();
                int n = menuComponents.length;
                int n2 = 0;
                while (n2 < n) {
                    Component menuComponent = componentArray[n2];
                    if (menuComponent instanceof JMMenuItem) {
                        JMMenuItem mi = (JMMenuItem)menuComponent;
                        String miText = mi.getText();
                        if (miText.startsWith("Refactor")) {
                            mi.setEnabled(refactorable);
                        } else if (miText.startsWith("Migrate")) {
                            mi.setEnabled(proxyProfileSelected);
                        }
                    }
                    ++n2;
                }
            }
        }
        boolean isCertKeyWithPassword = hasPassword && (certificateSelected || keySelected);
        menuGroup = this.getMenuGroup(PASSWORD_ACTIONS);
        menuGroup.setVisible(isCertKeyWithPassword);
        if (isCertKeyWithPassword) {
            logger.finer("(): Certs or keys selected.");
            while (this.selectionChanging) {
                logger.finer("(): Waiting for list selection process to complete.");
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            }
            if (CollectionUtility.isNotEmpty(this.migrationTargets)) {
                Collection<JComponent> menuComponents = menuGroup.getMenuComponents();
                for (JComponent component : menuComponents) {
                    JMMenuItem menuItem;
                    String text;
                    if (!(component instanceof JMMenuItem) || !(text = (menuItem = (JMMenuItem)component).getText()).startsWith("Migrate")) continue;
                    menuItem.setEnabled(this.migrationTargets.size() > 0);
                    break;
                }
            }
        }
        logger.finer("(): Handling Dynamic menu items.");
        this.manageDynamicPopupMenuItems(selectedTypes);
        logger.finer("() : Done");
        return selectedRows.length > 0;
    }

    private void manageDynamicPopupMenuItems(UniqueArrayList<String> selectedTypes) {
        logger.finer("(selectedTypes): Starting");
        for (String configuredType : this.propertiesEditorInfo.keySet()) {
            boolean menuVisible = Comparison.isIn(configuredType, selectedTypes);
            String configTypeName = String.format("Config%s", configuredType);
            Collection<String> menuGroups = this.menuGroupsByType.get(configTypeName);
            for (String menuGroupName : menuGroups) {
                logger.finer(() -> LMG.log("(selectedTypes): Setting menu group '%s' visibility to %b for type '%s'", () -> menuGroupName, () -> menuVisible, () -> configuredType));
                MenuGroup menuGroup = this.getMenuGroup(menuGroupName);
                menuGroup.setVisible(menuVisible);
            }
        }
        logger.finer("(selectedTypes): Done");
    }

    private static HashMap<String, HashMap<String, ? extends TableEditorInfo>> createPropertiesEditorInfo() {
        logger.finer("():  Starting.");
        DPAAApplicationProperties applicationProperties = (DPAAApplicationProperties)Application.getApplication().getApplicationProperties();
        String listEditorInfoFileName = applicationProperties.getListPropertiesMetaDataFileName();
        logger.finer(() -> LMG.log("(): Reading list properties editing info from %s", () -> listEditorInfoFileName));
        HashMap<String, HashMap<String, ? extends TableEditorInfo>> propertiesEditorInfo = ManageObjectsPopupMenu.readEditorInfoConfig(listEditorInfoFileName);
        if (propertiesEditorInfo == null) {
            logger.severe(() -> LMG.log("(): Error Reading list properties editing info from %s", () -> listEditorInfoFileName));
            return null;
        }
        logger.finer(() -> LMG.log("():  Completed reading list properties editing info from %s.", () -> listEditorInfoFileName));
        String complexEditorInfoFileName = applicationProperties.getComplexTypePropertiesMetaDataFileName();
        logger.finer(() -> LMG.log("(): Reading complex properties editing info from %s", () -> complexEditorInfoFileName));
        HashMap<String, HashMap<String, ? extends TableEditorInfo>> complexPropertiesEditorInfo = ManageObjectsPopupMenu.readEditorInfoConfig(complexEditorInfoFileName);
        if (complexPropertiesEditorInfo == null) {
            logger.severe(() -> LMG.log("(): Error Reading complex properties editing info from %s", () -> complexEditorInfoFileName));
            return null;
        }
        logger.finer(() -> LMG.log("():  Completed reading complex properties editing info from %s.  Combining the two.", () -> complexEditorInfoFileName));
        for (String configTypeName : complexPropertiesEditorInfo.keySet()) {
            HashMap<String, ? extends TableEditorInfo> propertyMap = propertiesEditorInfo.get(configTypeName);
            if (propertyMap == null) {
                propertiesEditorInfo.put(configTypeName, propertyMap);
                continue;
            }
            HashMap<String, ? extends TableEditorInfo> complexPropertyMap = complexPropertiesEditorInfo.get(configTypeName);
            for (String propertyName : complexPropertyMap.keySet()) {
                ComplexTypeTableEditorInfo tableEditorInfo = (ComplexTypeTableEditorInfo)complexPropertyMap.get(propertyName);
                propertyMap.put(propertyName, tableEditorInfo);
            }
        }
        logger.finer("():  Reparing list (removing not ready).");
        ArrayList<String> emptyConfigTypes = new ArrayList<String>();
        for (String configType : propertiesEditorInfo.keySet()) {
            HashMap<String, ? extends TableEditorInfo> editorInfoByConfig = propertiesEditorInfo.get(configType);
            ArrayList<String> propertiesNotReady = new ArrayList<String>();
            for (String property : editorInfoByConfig.keySet()) {
                TableEditorInfo editorInfo = editorInfoByConfig.get(property);
                if (editorInfo.isReady()) continue;
                propertiesNotReady.add(property);
            }
            for (String propertyNotReady : propertiesNotReady) {
                editorInfoByConfig.remove(propertyNotReady);
            }
            if (editorInfoByConfig.size() != 0) continue;
            emptyConfigTypes.add(configType);
        }
        for (String emptyConfigType : emptyConfigTypes) {
            propertiesEditorInfo.remove(emptyConfigType);
        }
        logger.finer("():  Done.");
        return propertiesEditorInfo;
    }

    private static HashMap<String, HashMap<String, ? extends TableEditorInfo>> readEditorInfoConfig(String editorInfoFileName) {
        ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
        HashMap editorInfo = (HashMap)FileUtility.readObject(editorInfoFileName, (ExceptionListener)exceptionListenerClient);
        if (exceptionListenerClient.hasException()) {
            new JMMessageBox(null, "Failed to read Editor Information", String.format("Error reading Editor Info from %s", editorInfoFileName));
        }
        if (editorInfo == null) {
            logger.severe(() -> LMG.log("():  %s does not exist!!!", () -> editorInfoFileName));
            return null;
        }
        return editorInfo;
    }
}

