/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.domainactions;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.table.RowFocusEventInvoker;
import com.jmorgan.util.Index;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;

abstract class AbstractDomainActionTablePanel<TableRowType>
extends AbstractTablePanel<TableRowType> {
    protected Index<Appliance, Domain> selectedDomains;
    protected MultiThreadInvocationListener mtil;

    AbstractDomainActionTablePanel(Class<TableRowType> elementType) {
        super(elementType);
        new RowFocusEventInvoker(this.displayTable, this, "rowFocusChanged");
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
    }

    @Reflected
    protected void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        this.selectedDomains = selectedDomains;
        this.displayTable.clearSelection();
        this.tableModel.reset();
        this.displayTable.repaint();
    }

    protected void addProcessListeners(Object actionRunner) {
        AsynchMethodInvoker thread = (AsynchMethodInvoker)new MethodInvoker(actionRunner, "getProcessThread", new Object[0]).invoke();
        this.mtil.addThread(thread);
        new MethodInvoker(actionRunner, "addManagementCommandSubscriber", this.commandResultsDialog).invoke();
    }

    protected boolean start(String actionTitle, String confirmationMessage) {
        if (AbstractDomainActionTablePanel.areAllAppliancesSelected() || AbstractDomainActionTablePanel.areAllDomainsSelected() ? !this.continueAction(actionTitle, actionTitle.toLowerCase(), true) : !this.continueAction(actionTitle, confirmationMessage)) {
            return false;
        }
        if (this.mtil == null) {
            this.mtil = new MultiThreadInvocationListener();
        } else {
            this.mtil.resetThreadCount();
        }
        this.openResultsDialogAndSetWaitCursor(actionTitle);
        return true;
    }

    protected void finish() {
        int timeout = 120000 * this.mtil.getRunningThreadCount();
        ThreadManager.monitorAsynchThreadLifeCycle("AbstractDomainActionTablePanel.finish()", this.mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        this.waitForResultsDialogToCloseAndResetCursor();
        this.domainsChanged(this.selectedDomains);
    }
}

