/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.files;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dnd.FileDropHandler;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.RowFocusEvent;
import com.jmorgan.swing.table.RowFocusListener;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.FileUploadBean;
import com.kumbasoft.core.beans.actions.ActionCreateDir;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DirectoryLister;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.editors.DataPowerDirectoryTableCellEditor;
import com.kumbasoft.core.ui.editors.DataPowerFileStoreTableCellEditor;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.models.FileUploadColumnModel;
import com.kumbasoft.dpaa.ui.models.FileUploadTableModel;
import com.kumbasoft.dpaa.ui.panels.files.ManageFilesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.swing.JFileChooser;
import javax.swing.JSeparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FileUploadPanel
extends AbstractPanel
implements PopupMenuController,
RowFocusListener,
TableModelListener {
    private static String[] FILESTORE_NO_DIRECTORIES_ALLOWED = new String[]{"cert:", "export:", "chkpoints:", "sharedcert:", "pubcert:", "store:", "image:"};
    private static String[] FILESTORE_DEFAULT_ONLY = new String[]{"sharedcert:", "pubcert:", "store:", "image:"};
    private ManageFilesPanel manageFilesPanelInstance;
    private HashMap<Appliance, Index<Domain, DataPowerFileInfo>> directoryMap;
    private PropertyValueSelector<DataPowerFileInfo> directoryMatchSelector;
    private UniqueArrayList<String> listedDirectories;
    private FileUploadTableModel fileUploadTableModel;
    private FileUploadColumnModel fileUploadColumnModel;
    private JMTable fileUploadTable;
    DataPowerDirectoryTableCellEditor dirEditor;
    DataPowerFileStoreTableCellEditor storeEditor;
    private JMButton btnAddFiles;
    private JMButton btnDeleteFiles;
    private JMButton btnUploadFiles;
    private JMButton btnSelectAll;
    private JMButton btnSelectNone;
    private boolean running;
    private AsynchMethodInvoker<Void> optimizeTableThread;
    private File lastDirectory;
    private int currentRow = -1;
    private MultiThreadInvocationListener directoryCreationThreads;
    private boolean directoriesCreated;

    public FileUploadPanel(ManageFilesPanel manageFilesPanelInstance) {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.manageFilesPanelInstance = manageFilesPanelInstance;
        this.createFileUploadTable();
        this.createConrolsPanel();
        this.createPopupMenu();
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "getDirectories");
    }

    private void createConrolsPanel() {
        JMPanel controlsPanel = new JMPanel(new FlowLayout(0));
        this.btnAddFiles = new JMButton(KumbaCoreUIConstants.ADD_ICON, "Select file(s) for upload");
        new ActionEventInvoker(this.btnAddFiles, this, "fileOpen");
        this.btnDeleteFiles = new JMButton(KumbaCoreUIConstants.DELETE_ICON, "Delete selected entries");
        new ActionEventInvoker(this.btnDeleteFiles, this, "editDelete");
        this.btnUploadFiles = new JMButton(KumbaCoreUIConstants.UPLOAD_ICON, "Upload the files to the selected domains of the selected appliances.");
        new ActionEventInvoker(this.btnUploadFiles, this, "fileUpload");
        this.btnSelectAll = new JMButton(KumbaCoreUIConstants.SELECT_ALL_ICON, "Select all files.");
        new ActionEventInvoker(this.btnSelectAll, this.fileUploadTable, "selectAll");
        this.btnSelectNone = new JMButton(KumbaCoreUIConstants.SELECT_NONE_ICON, "Un-Select all files.");
        new ActionEventInvoker(this.btnSelectNone, this.fileUploadTable, "clearSelection");
        controlsPanel.addAll(this.btnAddFiles, ComponentFactory.createSpacer(20, 20), this.btnUploadFiles, ComponentFactory.createSpacer(20, 20), this.btnSelectAll, this.btnSelectNone, ComponentFactory.createSpacer(20, 20), this.btnDeleteFiles);
        JMPanel hamburgerMenu = new JMPanel(new FlowLayout(2));
        hamburgerMenu.add(this.getPopupMenuButton());
        JMPanel topPanel = new JMPanel(new BorderLayout());
        topPanel.add((Component)controlsPanel, "West");
        topPanel.add((Component)hamburgerMenu, "Center");
        this.add((Component)topPanel, "North");
    }

    private void createFileUploadTable() {
        this.storeEditor = new DataPowerFileStoreTableCellEditor();
        this.dirEditor = new DataPowerDirectoryTableCellEditor();
        this.fileUploadTableModel = new FileUploadTableModel();
        this.fileUploadTableModel.addTableModelListener(this);
        this.fileUploadColumnModel = new FileUploadColumnModel();
        this.fileUploadColumnModel.setEditor("fileStore", this.storeEditor);
        this.fileUploadColumnModel.setEditor("directory", this.dirEditor);
        this.fileUploadTable = new JMTable(this.fileUploadTableModel, this.fileUploadColumnModel);
        this.fileUploadTable.setFillsViewportHeight(true);
        this.fileUploadTable.setPreferredScrollableViewportSize(new Dimension(10, 10));
        this.fileUploadTable.addRowFocusListener(this);
        FileDropHandler fileDropHandler = new FileDropHandler();
        fileDropHandler.setFileDropHandlerListener(this.fileUploadTableModel);
        this.fileUploadTable.setTransferHandler(fileDropHandler);
        this.add((Component)KumbaCoreUIConstants.createScrollPane(this.fileUploadTable), "Center");
    }

    @Override
    protected void createPopupMenu() {
        JMPopupMenu popupMenu = this.getPopupMenu(this.fileUploadTable);
        popupMenu.setPopupController(this);
        popupMenu.addMenuItem("Copy File Store to all or selected", (Object)this, "copyFilestore");
        popupMenu.addMenuItem("Copy Directory to all or selected", (Object)this, "copyDirectory");
        popupMenu.addMenuItem("Copy New Directory to all or selected", (Object)this, "copyNewDirectory");
        popupMenu.add(new JSeparator());
        popupMenu.addMenuItem("Upload File(s)", (Object)this, "fileUpload");
        popupMenu.add(new JSeparator());
        popupMenu.addMenuItem("Select All", (Object)this.fileUploadTable, "selectAll");
        popupMenu.addMenuItem("Select None", (Object)this.fileUploadTable, "clearSelection");
        popupMenu.add(new JSeparator());
        popupMenu.addMenuItem("Delete...", (Object)this, "editDelete");
    }

    @Override
    public boolean isPopupReady() {
        return this.currentRow > -1 && this.fileUploadTableModel.getRowCount() > 0;
    }

    @Override
    public void rowFocusChange(RowFocusEvent event) {
        this.currentRow = event.getNewRow();
    }

    @Reflected
    private void copyFilestore() {
        this.copyField("fileStore");
    }

    @Reflected
    private void copyDirectory() {
        this.copyField("directory");
    }

    @Reflected
    private void copyNewDirectory() {
        this.copyField("newDirectory");
    }

    private void copyField(String fieldName) {
        FileUploadBean fileUploadBean = (FileUploadBean)this.fileUploadTableModel.getValue(this.fileUploadTable.convertRowIndexToModel(this.currentRow));
        String fieldValue = (String)BeanService.getPropertyValue(fileUploadBean, fieldName);
        int[] selectedRows = this.fileUploadTable.getSelectedRows();
        if (selectedRows.length == 1) {
            if (!this.continueAction("Copy to all?", "Copy the value to all rows?")) {
                return;
            }
            this.fileUploadTable.selectAll();
            selectedRows = this.fileUploadTable.getSelectedRows();
            this.fileUploadTable.clearSelection();
            this.fileUploadTable.setSelectedRow(this.currentRow);
        }
        int i = 0;
        while (i < selectedRows.length) {
            FileUploadBean target = (FileUploadBean)this.fileUploadTableModel.getValue(selectedRows[i]);
            BeanService.setPropertyValue(target, fieldName, fieldValue);
            ++i;
        }
        this.fileUploadTable.repaint();
    }

    @Reflected
    private void fileOpen() {
        JFileChooser fileChooser = new JFileChooser(this.lastDirectory);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setDialogTitle("Select one or more files or directories for upload");
        int option = fileChooser.showDialog(frame, "Select");
        if (option == 1) {
            return;
        }
        Object[] selectedFiles = fileChooser.getSelectedFiles();
        if (ArrayUtility.isEmpty(selectedFiles)) {
            return;
        }
        this.lastDirectory = null;
        Object[] objectArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).isDirectory()) {
                if (this.lastDirectory == null) {
                    this.lastDirectory = file;
                }
                this.processDirectory((File)file);
            } else {
                if (this.lastDirectory == null) {
                    this.lastDirectory = ((File)file).getParentFile();
                }
                this.addUploadFile((File)file);
            }
            ++n2;
        }
        this.fileUploadTable.optimizeColumnWidths();
    }

    private void processDirectory(File directory) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.processDirectory(file);
            } else {
                this.addUploadFile(file);
            }
            ++n2;
        }
    }

    private void addUploadFile(File file) {
        this.fileUploadTableModel.setListedDirectories(this.listedDirectories);
        this.fileUploadTableModel.addDroppedFile(file);
    }

    @Reflected
    private void getDirectories(Index<Appliance, Domain> domains) {
        if (this.running) {
            return;
        }
        this.running = true;
        while (frame == null) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        if (this.listedDirectories == null) {
            this.listedDirectories = new UniqueArrayList();
        } else {
            this.listedDirectories.clear();
            this.directoryMap.clear();
            this.directoryMap = null;
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ArrayList<String> fileStores = new ArrayList<String>(Arrays.asList(DPEnumerations.FILESTORE_LOCATION));
        ConfigObjectCache<DataPowerFileInfo> direcoriesCache = new ConfigObjectCache<DataPowerFileInfo>();
        DirectoryLister.list(domains, fileStores, mtil);
        DirectoryLister.addConfigObjectSubscriber(direcoriesCache);
        ThreadManager.monitorAsynchThreadLifeCycle("FileUploadPanel.getDirectories(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        for (DataPowerFileInfo dir : direcoriesCache.getObjectCache()) {
            String dirPath = dir.getAbsolutePath();
            this.listedDirectories.add(dirPath);
        }
        this.directoryMap = DataStructureUtility.mapByApplianceDomain(direcoriesCache.getObjectCache());
        this.running = false;
        this.setEditorDirectories();
    }

    @Reflected
    private void editDelete() {
        String message;
        int[] selectedRows = this.fileUploadTable.getSelectedRows();
        String title = selectedRows.length == 1 ? "Delete Selected Entry" : "Delete Selected Entries";
        String string = message = selectedRows.length == 1 ? "Are you sure you want to delete the selected entry?" : "Are you sure you want to delete all selected entries?";
        if (selectedRows.length == 0) {
            title = "Clear the table?";
            message = "Do you want to delete all of the entries in the table?";
        }
        if (!this.continueAction(title, message)) {
            return;
        }
        if (selectedRows.length == 0) {
            this.fileUploadTable.selectAll();
            selectedRows = this.fileUploadTable.getSelectedRows();
        }
        this.fileUploadTable.commitEdits();
        this.fileUploadTable.clearSelection();
        try {
            if (selectedRows.length == this.fileUploadTable.getRowCount()) {
                this.fileUploadTableModel.reset();
            } else {
                this.fileUploadTableModel.deleteAll(selectedRows);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fileUploadTable.repaint();
        if (this.fileUploadTableModel.getRowCount() == 0) {
            this.currentRow = -1;
        }
    }

    @Reflected
    private void fileUpload() {
        if (this.fileUploadTable.getRowCount() == 0) {
            return;
        }
        if (!this.continueAction("Upload Files To", "upload files to", true)) {
            return;
        }
        this.fileUploadTable.commitEdits();
        this.openResultsDialogAndSetWaitCursor("Upload Files");
        this.directoryCreationThreads = new MultiThreadInvocationListener();
        logger.finer("(): Creating Directories");
        this.directoriesCreated = false;
        MultiThreadInvocationListener mtil = ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "createDirectories", false);
        if (this.directoriesCreated) {
            boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("FileUploadPanel.fileUpload()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
            if (!completedOnTime) {
                logger.warning("(): Not all directory creation threads completed on time.  Doing what we can.");
            } else {
                logger.finer("(): All threads to kick off directory creation are complete.");
            }
            completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("FileUploadPanel.fileUpload()", this.directoryCreationThreads, KumbaCoreConstants.STARTUP_DELAY, 0);
            if (!completedOnTime) {
                logger.warning("(): Some directory creation threads have timed out.  Continuing with what we have.");
            } else {
                logger.finer("(): All directory creation threads are complete.");
            }
            this.directoryCreationThreads.resetThreadCount();
            this.directoryCreationThreads = null;
            logger.finer("(): Directory Creation complete.  Uploading files.");
        }
        this.uploadFiles();
        this.waitForResultsDialogToCloseAndResetCursor();
        if (this.directoriesCreated) {
            this.manageFilesPanelInstance.domainsChanged(ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Reflected
    private void createDirectories(Appliance appliance, Domain domain) {
        methodSignature = String.format("(appliance=%s, domain=%s): ", new Object[]{appliance.getName(), domain.getName()});
        FileUploadPanel.logger.finer((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$0(java.lang.String ), ()Ljava/lang/String;)((String)methodSignature));
        rowCount = this.fileUploadTableModel.getRowCount();
        createdDirectories = new HashMap<String, String>();
        i = 0;
        while (i < rowCount) {
            block10: {
                bean = (FileUploadBean)this.fileUploadTableModel.getValue(i);
                fileStore = bean.getFileStore();
                if (Comparison.isIn(fileStore, FileUploadPanel.FILESTORE_NO_DIRECTORIES_ALLOWED)) break block10;
                newDirectory = bean.getNewDirectory();
                if (newDirectory == null) {
                    newDirectory = "";
                }
                if (!StringUtility.isEmpty(newDirectory)) {
                    newDirectory = FileUploadPanel.normalizeDirectory(newDirectory);
                }
                if (StringUtility.isEmpty(directory = bean.getDirectory())) {
                    directory = "/";
                }
                fullDirectory = String.format("%s%s", new Object[]{directory, newDirectory});
                if ((fullDirectory = StringUtility.coalesce(fullDirectory, "/")).equals("/") || createdDirectories.containsKey(fullDirectory)) break block10;
                fullPath = String.format("%s/%s", new Object[]{fileStore, fullDirectory});
                if (this.directoryMatchSelector == null) {
                    this.directoryMatchSelector = new PropertyValueSelector<E>(new ArrayList<E>());
                } else {
                    this.directoryMatchSelector.clearMap();
                }
                fullDirectoryF = fullDirectory;
                FileUploadPanel.logger.finer((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$2(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)methodSignature, (String)fullDirectoryF));
                domainDirectories = this.directoryMap.get(appliance);
                if (domainDirectories.isEmpty() || !CollectionUtility.isNotEmpty(domainFiles = (ArrayList)domainDirectories.get(domain))) ** GOTO lbl-1000
                this.directoryMatchSelector.setCollection(domainFiles);
                this.directoryMatchSelector.addPropertyValueMap("absolutePath", fullPath);
                matchingDirectories = this.directoryMatchSelector.getSelectedElements();
                matchingDirectoryCount = matchingDirectories.size();
                directoryExists = matchingDirectoryCount > 0;
                FileUploadPanel.logger.finer((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$5(java.lang.String java.lang.String boolean ), ()Ljava/lang/String;)((String)methodSignature, (String)fullPath, (boolean)directoryExists));
                if (directoryExists) {
                    FileUploadPanel.logger.fine((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$9(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)methodSignature, (String)fullPath));
                } else lbl-1000:
                // 2 sources

                {
                    createdDirectories.put(fullDirectory, "");
                    FileUploadPanel.logger.config((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$12(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)methodSignature, (String)fullPath));
                    actionCreateDir = new ActionCreateDir();
                    actionCreateDir.setDir(fullPath);
                    createDirectory = new ActionTool(appliance, domain, actionCreateDir);
                    this.directoryCreationThreads.addThread(createDirectory.getProcessThread());
                    createDirectory.setCommandDescription("Create Directory '" + fullPath + "'");
                    createDirectory.addManagementCommandSubscriber(this.commandResultsDialog);
                    this.directoriesCreated = true;
                }
            }
            ++i;
        }
        if (this.directoriesCreated) {
            FileUploadPanel.logger.finer((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$15(java.lang.String ), ()Ljava/lang/String;)((String)methodSignature));
        } else {
            FileUploadPanel.logger.finer((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$17(java.lang.String ), ()Ljava/lang/String;)((String)methodSignature));
        }
    }

    @Reflected
    private void uploadFiles() {
        logger.finer("(): Starting");
        Index<Appliance, Domain> domainSelection = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        ArrayList<DataPowerFileInfo> filesToUpload = new ArrayList<DataPowerFileInfo>();
        for (Appliance appliance : domainSelection.getKeys()) {
            for (Domain domain : domainSelection.get(appliance)) {
                logger.finer(() -> LMG.log("(): Uploading Files to the %s domain of %s", () -> domain.getName(), () -> appliance.getName()));
                int rowCount = this.fileUploadTableModel.getRowCount();
                int row = 0;
                while (row < rowCount) {
                    String newDirectory;
                    Domain targetDomain = domain;
                    FileUploadBean bean = (FileUploadBean)this.fileUploadTableModel.getValue(row);
                    String fileStore = bean.getFileStore();
                    Object directory = Comparison.isIn(fileStore, FILESTORE_NO_DIRECTORIES_ALLOWED) ? "/" : bean.getDirectory();
                    String string = newDirectory = Comparison.isIn(fileStore, FILESTORE_NO_DIRECTORIES_ALLOWED) ? "" : bean.getNewDirectory();
                    if (!StringUtility.isEmpty(newDirectory)) {
                        newDirectory = FileUploadPanel.normalizeDirectory(newDirectory);
                        directory = (String)directory + newDirectory;
                    }
                    directory = String.format("%s/%s", fileStore, directory);
                    String fileName = bean.getFileName();
                    String sourceFileName = bean.getSourceFileName();
                    Object directoryF = directory;
                    logger.config(() -> FileUploadPanel.lambda$22(sourceFileName, (String)directoryF, fileName));
                    if (Comparison.isIn(fileStore, FILESTORE_DEFAULT_ONLY)) {
                        logger.info(() -> FileUploadPanel.lambda$26(sourceFileName, (String)directoryF, fileName, fileStore));
                        targetDomain = appliance.getDomain("default");
                    }
                    DataPowerFileInfo dpFileInfo = new DataPowerFileInfo(appliance, targetDomain, null, 0L, (String)directory, fileName);
                    dpFileInfo.setLocalFile(new File(sourceFileName));
                    filesToUpload.add(dpFileInfo);
                    ++row;
                }
            }
        }
        logger.finer(() -> LMG.log("(): Starting upload of %d files.", () -> filesToUpload.size()));
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        FileUploader.upload(filesToUpload, mtil);
        FileUploader.addCommandSubscriber(this.commandResultsDialog);
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("FileUploadPanel.uploadFiles(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            logger.warning("():  Files did not complete uploading on time.  Continuing.");
        }
        FileUploader.resetStaticState();
        logger.finer("(): Done.");
    }

    private static String normalizeDirectory(String newDirectory) {
        if (((String)newDirectory).startsWith("/")) {
            newDirectory = ((String)newDirectory).substring(1);
        }
        if (!((String)newDirectory).endsWith("/")) {
            newDirectory = (String)newDirectory + "/";
        }
        return newDirectory;
    }

    private void setEditorDirectories() {
        this.listedDirectories.sort();
        this.dirEditor.setDirectories(this.listedDirectories);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 1) {
            if (this.optimizeTableThread != null) {
                this.optimizeTableThread.cancel();
                this.optimizeTableThread = null;
            }
            this.optimizeTableThread = new AsynchMethodInvoker((Object)this.fileUploadTable, "optimizeColumnWidths", 250);
        }
    }

    private static /* synthetic */ String lambda$0(String string) {
        return LMG.log("%sCreating directories.", () -> string);
    }

    private static /* synthetic */ String lambda$2(String string, String string2) {
        return LMG.log("%sChecking if directory exists: %s", () -> string, () -> string2);
    }

    private static /* synthetic */ String lambda$5(String string, String string2, boolean bl) {
        return LMG.log("%sDirectory '%s' exists? %b", () -> string, () -> string2, () -> bl);
    }

    private static /* synthetic */ String lambda$9(String string, String string2) {
        return LMG.log("%sDirectory exists.  Won't create: %s", () -> string, () -> string2);
    }

    private static /* synthetic */ String lambda$12(String string, String string2) {
        return LMG.log("%sCreating %s", () -> string, () -> string2);
    }

    private static /* synthetic */ String lambda$15(String string) {
        return LMG.log("%sDone Creating directories.", () -> string);
    }

    private static /* synthetic */ String lambda$17(String string) {
        return LMG.log("%sDone.  No new directories created.", () -> string);
    }

    private static /* synthetic */ String lambda$22(String string, String string2, String string3) {
        return LMG.log("(): Uploading: %s -> %s%s", () -> string, () -> string2, () -> string3);
    }

    private static /* synthetic */ String lambda$26(String string, String string2, String string3, String string4) {
        return LMG.log("(): Uploading: %s -> %s%s.  Changing domain to default due to file store %s", () -> string, () -> string2, () -> string3, () -> string4);
    }
}

