/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.files;

import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.menu.JMMenu;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.dpaa.ui.panels.files.ManageFilesPanel;
import java.util.ArrayList;
import javax.swing.JSeparator;

public class ManageFilesPopupMenu
extends JMPopupMenu
implements PopupMenuController {
    private ManageFilesPanel manageFilesPanel;
    private JMTable displayTable;

    public ManageFilesPopupMenu(ManageFilesPanel eventTarget, JMTable displayTable, JMScrollPane displayTableScrollPane) {
        this.manageFilesPanel = eventTarget;
        this.displayTable = displayTable;
        this.setPopupController(this);
        this.addPopupMenuClient(displayTableScrollPane);
        this.addMenuItem("Create New File...", (Object)eventTarget, "fileNew");
        this.addMenuItem("Open Selected Files...", (Object)eventTarget, "fileOpen");
        this.add(new JSeparator());
        this.addMenuItem("Search && Replace...", (Object)eventTarget, "searchReplace");
        this.add(new JSeparator());
        this.addMenuItem("Open with external file...", (Object)eventTarget, "fileCompareWithExternal");
        this.add(new JSeparator());
        this.addMenuItem("Copy To...", (Object)eventTarget, "editCopy");
        this.addMenuItem("Move To...", (Object)eventTarget, "editMove");
        JMMenu refactorMenu = new JMMenu("Refactor");
        refactorMenu.addMenuItem("Rename...", eventTarget, "fileRename");
        this.add(refactorMenu);
        this.add(new JSeparator());
        this.addMenuItem("Export...", (Object)eventTarget, "fileExportFile");
        this.addMenuItem("Replace File With...", (Object)eventTarget, "replaceFileWith");
        this.add(new JSeparator());
        this.addMenuItem("Show Referenced By...", (Object)eventTarget, "showReferencedBy");
        this.add(new JSeparator());
        this.addMenuItem("Delete...", (Object)eventTarget, "editDelete");
        this.setEnabled(false);
    }

    @Override
    public boolean isPopupReady() {
        this.setMenuItemEnabled(".*", true);
        int rowCount = this.displayTable.getSelectedRowCount();
        if (rowCount == 0) {
            this.setMenuItemEnabled("(open|Search|copy|move|export|refactor|replace|delete|showReferenced).*", false);
        } else {
            ArrayList<DataPowerFileInfo> exportableFiles;
            ArrayList<DataPowerFileInfo> refactorableFiles = this.manageFilesPanel.getRefactorableFiles();
            if (CollectionUtility.isEmpty(refactorableFiles)) {
                this.setMenuItemEnabled("refactor.*", false);
            }
            if (CollectionUtility.isEmpty(exportableFiles = this.manageFilesPanel.getExportableFiles())) {
                this.setMenuItemEnabled("export.*", false);
            }
        }
        return true;
    }
}

