/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.status;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.StatusProviderGraphDefinition;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class StatusProviderGraphPanel
extends AbstractPanel {
    private static final Class<?>[] CHART_TYPE_RENDERERS = new Class[]{XYLineAndShapeRenderer.class, XYAreaRenderer2.class};
    private static final float[] CHART_TYPE_ALPHA = new float[]{1.0f, 0.5f};
    private static final TimeZone TIME_ZONE = TimeZone.getDefault();
    private static final Locale LOCALE = Locale.getDefault();
    private static final Object LOCK = new Object();
    private StatusProviderGraphDefinition statusProviderGraphDefinition;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private XYPlot xyPlot;
    private TimeSeriesCollection dataset;
    private HashMap<String, TimeSeries> graphSeries;
    private int maxRows;
    private int lastMaxRows = -1;

    public StatusProviderGraphPanel(StatusProviderGraphDefinition spgd) {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.statusProviderGraphDefinition = spgd;
        this.dataset = new TimeSeriesCollection();
        this.graphSeries = new HashMap();
        this.chartPanel = new ChartPanel(this.createChart(spgd));
        this.add((Component)this.chartPanel, "Center");
    }

    private JFreeChart createChart(StatusProviderGraphDefinition graphDefinition) {
        String graphName = graphDefinition.getGraphName();
        ArrayList<String> propertyNames = graphDefinition.getValueProperties();
        String rangeName = propertyNames.size() == 1 ? StringUtility.getDisplayableTitle(propertyNames.get(0)) : "Values";
        this.chart = ChartFactory.createTimeSeriesChart(graphName, "Status Time", rangeName, this.dataset);
        this.chart.setBackgroundPaint(KumbaCoreUIConstants.BACKGROUND);
        this.chart.getTitle().setPaint(KumbaCoreUIConstants.FOREGROUND);
        this.xyPlot = this.chart.getXYPlot();
        this.xyPlot.setBackgroundPaint(Color.black);
        this.setChartType(graphDefinition.getGraphType());
        ValueAxis ra = this.xyPlot.getRangeAxis();
        ra.setLabelPaint(KumbaCoreUIConstants.FOREGROUND);
        ra.setTickLabelPaint(KumbaCoreUIConstants.FOREGROUND);
        ValueAxis da = this.xyPlot.getDomainAxis();
        da.setLabelPaint(KumbaCoreUIConstants.FOREGROUND);
        da.setTickLabelPaint(KumbaCoreUIConstants.FOREGROUND);
        LegendTitle legend = this.chart.getLegend();
        legend.setBackgroundPaint(KumbaCoreUIConstants.BACKGROUND);
        legend.setItemPaint(KumbaCoreUIConstants.FOREGROUND);
        return this.chart;
    }

    public StatusProviderGraphDefinition getGraphDefinition() {
        return this.statusProviderGraphDefinition;
    }

    public void setData(ArrayList<DataPowerStatus> graphData) {
        for (DataPowerStatus status : graphData) {
            this.addEvent(status);
        }
    }

    public void addEvent(DataPowerStatus status) {
        String loggerPrefix = String.format("(status=%s)", status.getFQON());
        DateTime statusTime = status.getStatusTime();
        Date statusDate = statusTime.getDate().toJavaUtilDate();
        ArrayList<String> propertyNames = this.statusProviderGraphDefinition.getValueProperties();
        for (String propertyName : propertyNames) {
            logger.finer(() -> LMG.log("%s:  Graphing Property '%s'", () -> loggerPrefix, () -> propertyName));
            Object v = BeanService.getPropertyValue(status, propertyName);
            String graphSeriesName = StatusProviderGraphPanel.getGraphSeriesName(status, propertyName);
            TimeSeries timeSeries = this.graphSeries.get(graphSeriesName);
            if (timeSeries == null) {
                logger.finer(() -> LMG.log("%s:  Nothing yet in the series named '%s'.  Adding.", () -> loggerPrefix, () -> graphSeriesName));
                timeSeries = this.addTimeSeries(graphSeriesName);
            }
            if (v == null || !(v instanceof Number)) continue;
            Number value = (Number)v;
            RegularTimePeriod tp = RegularTimePeriod.createInstance(Millisecond.class, statusDate, TIME_ZONE, LOCALE);
            try {
                logger.finer(() -> LMG.log("%s:  Adding value %d to time series '%s'.", () -> loggerPrefix, () -> value, () -> graphSeriesName));
                timeSeries.add(tp, value);
            }
            catch (SeriesException e) {
                logger.warning(() -> LMG.log("%s:  SeriesException for '%s' Exists?  %d\n%s", () -> loggerPrefix, () -> graphSeriesName, () -> value, () -> e.getMessage()));
            }
            catch (IndexOutOfBoundsException e) {
                logger.warning(() -> LMG.log("%s:  Index out of bounds.  Replaying %d for '%s'.", () -> loggerPrefix, () -> value, () -> graphSeriesName));
                ThreadUtility.sleep(50L);
                this.addEvent(status);
            }
            if (this.maxRows <= 0 || this.maxRows == this.lastMaxRows) continue;
            this.setMaxRows(this.maxRows);
            this.lastMaxRows = this.maxRows;
        }
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        for (String graphSeriesName : this.graphSeries.keySet()) {
            int itemCount;
            TimeSeries timeSeries = this.graphSeries.get(graphSeriesName);
            if (timeSeries == null || (itemCount = timeSeries.getItemCount()) <= maxRows) continue;
            int end = itemCount - maxRows;
            timeSeries.delete(0, end);
        }
    }

    public void clearGraphData() {
        if (!CollectionUtility.isEmpty(this.graphSeries)) {
            this.dataset.removeAllSeries();
            this.graphSeries.clear();
        }
    }

    private static String getGraphSeriesName(DataPowerStatus status, String propertyName) {
        Appliance appliance = status.getAppliance();
        Domain domain = status.getSourceDomain();
        String graphSeriesName = String.format("%s-%s-%s", appliance.getName(), domain.getName(), StringUtility.getDisplayableTitle(propertyName));
        return graphSeriesName;
    }

    private TimeSeries addTimeSeries(String graphSeriesName) {
        int itemCount;
        TimeSeries s = new TimeSeries((Comparable)((Object)graphSeriesName));
        int n = itemCount = this.maxRows > 50 ? 50 : this.maxRows;
        if (itemCount == 0) {
            itemCount = 50;
        }
        s.setMaximumItemCount(itemCount);
        this.addTimeSeriesToData(s);
        this.addTimeSeriesToGraph(s, graphSeriesName);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimeSeriesToData(TimeSeries s) {
        Object object = LOCK;
        synchronized (object) {
            try {
                this.dataset.addSeries(s);
            }
            catch (ConcurrentModificationException e) {
                AbstractPanel.logger.info("(TimeSeries):  ConcurrentModificationException.  Replaying.");
                ThreadUtility.sleep(50L);
                this.addTimeSeriesToData(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimeSeriesToGraph(TimeSeries s, String graphSeriesName) {
        Object object = LOCK;
        synchronized (object) {
            try {
                this.graphSeries.put(graphSeriesName, s);
            }
            catch (ConcurrentModificationException e) {
                AbstractPanel.logger.info("(TimeSeries):  ConcurrentModificationException.  Replaying.");
                ThreadUtility.sleep(50L);
                this.addTimeSeriesToGraph(s, graphSeriesName);
            }
        }
    }

    void setChartType(int chartTypeIndex) {
        this.statusProviderGraphDefinition.setGraphType(chartTypeIndex);
        AbstractXYItemRenderer renderer = null;
        try {
            renderer = (AbstractXYItemRenderer)BeanService.getBean(CHART_TYPE_RENDERERS[chartTypeIndex]);
            this.xyPlot.setForegroundAlpha(CHART_TYPE_ALPHA[chartTypeIndex]);
            this.xyPlot.setRenderer(renderer);
            if (chartTypeIndex == 2) {
                XYBarRenderer r = (XYBarRenderer)renderer;
                r.setShadowVisible(false);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

