/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.combobox.ListComboBox;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionPropertySelector;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.DirectoryLister;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.systemControl.AbstractSystemActionPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Vector;

abstract class AbstractSecureBackupRestorePanel<ActionObjectType extends JMBean>
extends AbstractSystemActionPanel<ActionObjectType> {
    protected static final int LABEL_WIDTH = 80;
    protected static final int FIELD_WIDTH = 300;
    protected ArrayList<Appliance> selectedAppliances;
    protected JMButton btnRefresh = ComponentFactory.createButton(KumbaCoreUIConstants.REFRESH_ICON, null, "Update List", true, this, "loadArtifacts", new Object[0]);
    protected JMPanel labelComponent = new JMPanel(new BorderLayout());
    protected JMPanel controlsPanel;
    protected JMRadioButton rbLocalDestination;
    protected JMRadioButton rbTemporaryDestination;
    protected JMRadioButton rbFTPDestination;
    protected ListComboBox lcbxLocalDirectories;
    protected ListComboBox lcbxTempDirectories;
    protected JMTextField tfFTPDestinationURL;
    protected JMPanel destinationControls;
    protected JMPanel destinationPanel;
    protected CardLayout destinationLayout;
    protected boolean isFileDestination;
    protected String destinationLocation;
    protected JMCheckBox cbxSynchronizeActions;
    protected JMPanel actionButtonPanel;

    public AbstractSecureBackupRestorePanel(String buttonLabel) {
        super(buttonLabel);
        this.labelComponent.add((Component)new JMLabel(this.getListLabel()), "Center");
        this.labelComponent.add((Component)this.btnRefresh, "East");
        this.controlsPanel = new JMPanel(new BorderLayout(10, 10));
        this.add(this.controlsPanel);
        this.rbLocalDestination = new JMRadioButton("Local", false);
        this.rbLocalDestination.setToolTipText(this.getHelpFile("LocalDestinationRadioButton", "Use a 'local:' directory."));
        new ActionEventInvoker(this.rbLocalDestination, this, "showDestinationComponent", "localDirectories");
        this.rbTemporaryDestination = new JMRadioButton("Temporary", true);
        this.rbTemporaryDestination.setToolTipText(this.getHelpFile("TemporaryDestinationRadioButton", "Use a 'temporary:' directory."));
        new ActionEventInvoker(this.rbTemporaryDestination, this, "showDestinationComponent", "tempDirectories");
        this.rbFTPDestination = new JMRadioButton("FTP", false);
        this.rbFTPDestination.setToolTipText(this.getHelpFile("FTPDestinationRadioButton", "Use FTP location."));
        new ActionEventInvoker(this.rbFTPDestination, this, "showDestinationComponent", "ftpURL");
        new JMButtonGroup(this.rbLocalDestination, this.rbTemporaryDestination, this.rbFTPDestination);
        this.lcbxLocalDirectories = new ListComboBox();
        this.lcbxLocalDirectories.setToolTipText(this.getHelpFile("LocalDirectoryCBX", "Select the local directory."));
        LabeledComponent lblLocalDirectories = new LabeledComponent("Local:", (Component)this.lcbxLocalDirectories, 80, 300);
        this.lcbxTempDirectories = new ListComboBox();
        this.lcbxTempDirectories.setToolTipText(this.getHelpFile("TemporaryDirectoryCBX", "Select the temporary directory."));
        LabeledComponent lblTempDirectories = new LabeledComponent("Temporary:", (Component)this.lcbxTempDirectories, 80, 300);
        this.tfFTPDestinationURL = new JMTextField();
        ComponentService.addHelpIcon(this.tfFTPDestinationURL, this.getHelpFile("FTPDestinationField", "Choose the FTP Destination"));
        LabeledComponent lblFTPDestinationURL = new LabeledComponent("FTP URL:", (Component)this.tfFTPDestinationURL, 80, 300);
        this.destinationLayout = new CardLayout();
        this.destinationPanel = new JMPanel(this.destinationLayout);
        this.destinationPanel.add((Component)lblTempDirectories, "tempDirectories");
        this.destinationPanel.add((Component)lblLocalDirectories, "localDirectories");
        this.destinationPanel.add((Component)lblFTPDestinationURL, "ftpURL");
        this.destinationControls = new JMPanel(new VerticalFlowLayout(0, 10));
        this.destinationControls.addAll(ComponentFactory.createSpacer(10, 23), this.rbTemporaryDestination, this.rbLocalDestination, this.rbFTPDestination, this.destinationPanel);
        this.controlsPanel.add(this.destinationControls);
        this.cbxSynchronizeActions = new JMCheckBox("Synchronize Actions", true);
        this.cbxSynchronizeActions.setToolTipText(this.getHelpFile("SynchronizeActionsCheckbox", "Synchronize Actions"));
        ApplianceDomainChangeMonitor.getInstance().addApplianceChangeSubscriber(this, "loadArtifacts");
    }

    @Override
    protected Dimension getButtonSize() {
        return new Dimension(150, 25);
    }

    protected abstract String getListLabel();

    @Reflected
    private void loadArtifacts() {
        UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        this.loadArtifacts(selectedAppliances);
    }

    @Reflected
    protected void loadArtifacts(ArrayList<Appliance> selectedAppliances) {
        this.selectedAppliances = selectedAppliances;
        this.setButtonState(false);
        this.loadDirectories();
        this.setButtonState(this.makeButtonStateDecision());
    }

    @Reflected
    private void loadDirectories() {
        this.lcbxLocalDirectories.clearListModel();
        this.lcbxTempDirectories.clearListModel();
        Index<Appliance, Domain> searchDomains = new Index<Appliance, Domain>();
        for (Appliance appliance : this.selectedAppliances) {
            searchDomains.put(appliance, appliance.getDomain("default"));
        }
        ArrayList<String> fileStores = new ArrayList<String>();
        fileStores.add("local:");
        fileStores.add("temporary:");
        ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        DirectoryLister.list(searchDomains, fileStores, mtil);
        DirectoryLister.addConfigObjectSubscriber(fileCache);
        ThreadManager.monitorAsynchThreadLifeCycle("AbstractSecureBackupRestorePanel.loadDirectories()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        Vector<DataPowerFileInfo> files = fileCache.getObjectCache();
        CollectionPropertySelector<DataPowerFileInfo> fileNameSelector = new CollectionPropertySelector<DataPowerFileInfo>(files);
        UniqueArrayList<String> fileNames = new UniqueArrayList<String>(fileNameSelector.get("name", String.class));
        fileNames.sort();
        ArrayList<String> localFileNames = new ArrayList<String>();
        ArrayList<String> temporaryFileNames = new ArrayList<String>();
        for (String fileName : fileNames) {
            if (fileName.startsWith("local:")) {
                if (fileName.equals("local:")) {
                    localFileNames.add("local:///");
                    continue;
                }
                localFileNames.add(fileName);
                continue;
            }
            if (fileName.equals("temporary:")) {
                temporaryFileNames.add("temporary:///");
                continue;
            }
            temporaryFileNames.add(fileName);
        }
        this.lcbxLocalDirectories.addItems(localFileNames);
        this.lcbxTempDirectories.addItems(temporaryFileNames);
        this.lcbxLocalDirectories.setSelectedIndex(0);
        this.lcbxTempDirectories.setSelectedIndex(0);
    }

    @Reflected
    private void showDestinationComponent(String componentName) {
        this.destinationLayout.show(this.destinationPanel, componentName);
    }

    @Override
    protected Container getButtonControl() {
        this.actionButtonPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        this.actionButtonPanel.addAll(this.cbxSynchronizeActions, super.getButtonControl());
        return this.actionButtonPanel;
    }

    protected boolean makeButtonStateDecision() {
        return this.lcbxLocalDirectories.getList().getModel().getSize() > 0 && this.lcbxTempDirectories.getList().getModel().getSize() > 0;
    }

    @Override
    protected boolean shouldInvokeSystemActionSyncronously() {
        return this.cbxSynchronizeActions.isSelected();
    }
}

