/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.Date;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionQuiesceDP;
import com.kumbasoft.core.beans.actions.ActionSecureBackup;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.DataPowerFileUtility;
import com.kumbasoft.dpaa.ui.panels.systemControl.AbstractSecureBackupRestorePanel;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.ListModel;

public class SecureBackupPanel
extends AbstractSecureBackupRestorePanel<ActionSecureBackup>
implements ConfigObjectSubscriber<DataPowerFileInfo> {
    private JMListModel<String> certificateListModel = new JMListModel();
    private JMList<String> certificateList = new JMList<String>((ListModel<String>)this.certificateListModel);
    private ArrayList<StatusObjectStatus> certificateObjects;
    private JMCheckBox cbxIncludeRaid;
    private JMCheckBox cbxQuiesce;
    private Date today;

    public SecureBackupPanel() {
        super("Secure Backup");
        this.certificateList.setPreferredSize(300, 600);
        LabeledComponent certListPanel = new LabeledComponent(this.labelComponent, (Component)KumbaCoreUIConstants.createScrollPane(this.certificateList), 1);
        this.controlsPanel.add((Component)certListPanel, "West");
        this.cbxIncludeRaid = new JMCheckBox("Include RAID");
        this.cbxIncludeRaid.setToolTipText(this.getHelpFile("IncludeRAIDCheckbox", "Include the RAID drive contents."));
        this.cbxQuiesce = new JMCheckBox("Quiesce First", true);
        this.cbxQuiesce.setToolTipText(this.getHelpFile("QuiesceCheckbox", "Quiesce each appliance before running the secure backup."));
        this.destinationControls.add(this.cbxIncludeRaid);
    }

    @Override
    protected String getListLabel() {
        return "Certificates:";
    }

    @Override
    protected String getCommandResultsDialogTitle() {
        return "Secure Backup";
    }

    @Override
    protected Container getButtonControl() {
        Container c = super.getButtonControl();
        c.add((Component)this.cbxQuiesce, 0);
        return c;
    }

    @Override
    protected boolean isUserInputValid() {
        if (this.certificateList.getSelectedIndex() == -1) {
            this.showMessage("Secure Backup Error", "You must select a certificate for backup.");
            return false;
        }
        if (this.rbFTPDestination.isSelected() && StringUtility.isEmpty(this.tfFTPDestinationURL.getText())) {
            this.showMessage("Secure Backup Error", "No FTP destination provided.");
            return false;
        }
        return true;
    }

    @Override
    protected ActionSecureBackup setupActionObjectType() {
        String certificateName = this.certificateList.getSelectedItem();
        ObjectReference<ConfigCryptoCertificate> certificateRef = new ObjectReference<ConfigCryptoCertificate>();
        certificateRef.setClassName("CryptoCertificate");
        certificateRef.setName(certificateName);
        this.isFileDestination = false;
        String destination = null;
        if (this.rbTemporaryDestination.isSelected()) {
            destination = (String)this.lcbxTempDirectories.getSelectedValue();
            this.isFileDestination = true;
        } else if (this.rbLocalDestination.isSelected()) {
            destination = (String)this.lcbxLocalDirectories.getSelectedValue();
            this.isFileDestination = true;
        } else {
            destination = this.tfFTPDestinationURL.getText();
        }
        this.destinationLocation = destination;
        ActionSecureBackup secureBackup = new ActionSecureBackup();
        secureBackup.setCert(certificateRef);
        secureBackup.setDestination(destination);
        secureBackup.setIncludeIscsi("off");
        secureBackup.setIncludeRaid(this.cbxIncludeRaid.isSelected() ? "on" : "off");
        this.today = new Date();
        this.today.setFormat(Date.SQL_FORMAT);
        return secureBackup;
    }

    @Override
    protected boolean performPreProcessing(Appliance appliance) {
        String loggerPrefix = String.format("(Appliance=%s)", appliance.getName());
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        if (this.cbxQuiesce.isSelected()) {
            AbstractPanel.logger.config(() -> LMG.log("%s: Quiescing Appliance.", () -> loggerPrefix));
            ActionQuiesceDP quiesceDP = new ActionQuiesceDP();
            quiesceDP.setTimeout(60);
            quiesceDP.setDelay(0);
            SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
            ActionTool actionTool = new ActionTool(appliance, (JMBean)quiesceDP);
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
            actionTool.getProcessThread().addInvocationListener(stil);
            boolean complete = stil.waitForCompletion(quiesceDP.getTimeout() * 1000 + KumbaCoreConstants.THREAD_TIMEOUT);
            if (!complete) {
                AbstractPanel.logger.warning(() -> LMG.log("%s: Timeout waiting for the appliance to quiesce.", () -> loggerPrefix));
            }
            while (!appliance.isQuiesced()) {
                ThreadUtility.sleep(KumbaCoreConstants.APPLIANCE_QUIESCE_WAIT_SLEEP_TIME);
                if (appliance.isConnected()) continue;
                ManagementCommandError error = new ManagementCommandError(appliance, new Domain("default"), "Quiesce", actionTool, "Appliance crashed on quiesce");
                return false;
            }
        }
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
        return true;
    }

    @Override
    protected void performPostActionProcessing(Appliance appliance, boolean error) {
        AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, error=%b): Starting", () -> appliance.getName(), () -> error));
        if (this.isFileDestination) {
            AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, error=%b): Getting backup files from '%s'.", () -> appliance.getName(), () -> error, () -> this.destinationLocation));
            Domain defaultDomain = appliance.getDomain("default");
            boolean isRaidSelected = this.cbxIncludeRaid.isSelected();
            String[] stringArray = DataPowerFileUtility.SECURE_BACKUP_FILES;
            int n = DataPowerFileUtility.SECURE_BACKUP_FILES.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (isRaidSelected || !fileName.equals("raid-volume.tgz")) {
                    AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, error=%b): Getting '%s'.", () -> appliance.getName(), () -> error, () -> fileName));
                    DataPowerFileInfo applianceSecureBackupFile = new DataPowerFileInfo(appliance, defaultDomain, null, 0L, this.destinationLocation, fileName);
                    DataPowerFileReader fileReader = new DataPowerFileReader(applianceSecureBackupFile, true);
                    fileReader.addConfigObjectSubscriber(DataPowerFileInfo.class, this);
                }
                ++n2;
            }
        }
        AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, error=%b): Done", () -> appliance.getName(), () -> error));
    }

    @Override
    public void processDataPowerConfig(DataPowerFileInfo dataPowerConfig) {
        AbstractPanel.logger.finer(() -> LMG.log("(dataPowerConfig='%s'):  Starting", () -> dataPowerConfig.getFileName()));
        byte[] fileData = dataPowerConfig.getFileData();
        if (fileData == null) {
            AbstractPanel.logger.finer(() -> LMG.log("(dataPowerConfig='%s'):  File has no data yet.  Returning.", () -> dataPowerConfig.getFileName()));
            return;
        }
        String secureBackupsDirectory = AbstractPanel.applicationProperties.getSecureBackupsDirectory();
        String secureBackupsDirName = String.format("%s%s%s%s%s%s", secureBackupsDirectory, File.separator, dataPowerConfig.getAppliance().getName(), File.separator, this.today.toString(), File.separator);
        logger.finer(() -> LMG.log("(dataPowerConfig='%s'):  Secure Backup output dir = '%s'", () -> dataPowerConfig.getFileName(), () -> secureBackupsDirName));
        File secureBackupsDir = new File(secureBackupsDirName);
        if (!secureBackupsDir.exists()) {
            logger.fine(() -> LMG.log("(dataPowerConfig='%s'):  Creating secure backup output dir '%s'", () -> dataPowerConfig.getFileName(), () -> secureBackupsDirName));
            secureBackupsDir.mkdirs();
        }
        File outputFile = new File(secureBackupsDir, dataPowerConfig.getFileName());
        logger.fine(() -> LMG.log("(dataPowerConfig='%s'):  Writing output file '%s'", () -> dataPowerConfig.getFileName(), () -> outputFile.getAbsolutePath()));
        try {
            FileOutputStreamHelper fout = new FileOutputStreamHelper(outputFile);
            fout.open();
            fout.setBufferSize(fileData.length);
            ((OutputStream)fout.getStream()).write(fileData);
            fout.close();
            ManagementCommandStatus status = new ManagementCommandStatus(dataPowerConfig.getAppliance(), dataPowerConfig.getSourceDomain(), "Save File " + outputFile.getAbsolutePath(), null, "Save succeeded");
            this.commandResultsDialog.commandSucceeded(status);
        }
        catch (IOException e) {
            logger.severe(() -> LMG.log("(dataPowerConfig='%s'):  Error Writing to '%s'", () -> dataPowerConfig.getFileName(), () -> outputFile.getAbsolutePath()));
            ManagementCommandError error = new ManagementCommandError(dataPowerConfig.getAppliance(), dataPowerConfig.getSourceDomain(), "Save File " + outputFile.getAbsolutePath(), null, "Failed to save file: " + e.getMessage());
            this.commandResultsDialog.commandFailed(error);
        }
        logger.finer(() -> LMG.log("(dataPowerConfig='%s'):  Done", () -> dataPowerConfig.getFileName()));
    }

    @Override
    public void configProcessingComplete() {
    }

    @Override
    @Reflected
    protected void loadArtifacts(ArrayList<Appliance> selectedAppliances) {
        this.selectedAppliances = selectedAppliances;
        if (this.certificateObjects != null) {
            this.certificateObjects.clear();
            this.certificateObjects = null;
        }
        this.certificateList.clearSelection();
        this.certificateListModel.clear();
        this.loadCertificates();
        super.loadArtifacts(selectedAppliances);
    }

    @Reflected
    private void loadCertificates() {
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.certificateObjects = configurationManager.listObjects(this.selectedAppliances, "CryptoCertificate", ".*");
        UniqueArrayList<String> certificateNames = new UniqueArrayList<String>();
        for (StatusObjectStatus cert : this.certificateObjects) {
            certificateNames.add(cert.getName());
        }
        certificateNames.sort();
        this.certificateListModel.addAll(certificateNames);
        if (certificateNames.size() > 0) {
            this.certificateList.setSelectedIndex(0);
        }
    }

    @Override
    protected boolean makeButtonStateDecision() {
        boolean decision = super.makeButtonStateDecision();
        if (decision) {
            decision = this.certificateListModel.getSize() > 0;
        }
        return decision;
    }
}

