/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.KeyEventInvoker;
import com.jmorgan.swing.util.ComponentService;
import com.kumbasoft.core.beans.actions.ActionSetSystemVar;
import com.kumbasoft.dpaa.ui.panels.systemControl.AbstractSystemActionPanel;
import java.awt.Component;
import java.awt.Dimension;

public class SetSystemVariablePanel
extends AbstractSystemActionPanel<ActionSetSystemVar> {
    private static final String SYSTEM_VAR_PREFIX = "var://system/";
    private JMTextField tfContext;
    private JMTextField tfVariableName;
    private JMTextField tfVariableValue;
    private JMLabel lblFullVariableName;

    public SetSystemVariablePanel() {
        super("Set System Variable");
        String helpText = this.getHelp();
        this.tfContext = this.createTextField(helpText);
        LabeledComponent lblContext = new LabeledComponent("Context:", (Component)this.tfContext, 100, 300);
        this.tfVariableName = this.createTextField(helpText);
        LabeledComponent lblVariableName = new LabeledComponent("Variable Name:", (Component)this.tfVariableName, 100, 300);
        this.tfVariableValue = this.createTextField(helpText);
        LabeledComponent lblVariableValue = new LabeledComponent("Variable Value:", (Component)this.tfVariableValue, 100, 300);
        this.lblFullVariableName = new JMLabel(SYSTEM_VAR_PREFIX);
        LabeledComponent lblForFullVariableName = new LabeledComponent("Full Name:", (Component)this.lblFullVariableName, 100, 300);
        this.addAll(lblContext, lblVariableName, lblVariableValue, lblForFullVariableName);
    }

    @Override
    protected Dimension getButtonSize() {
        return new Dimension(225, 25);
    }

    private JMTextField createTextField(String helpText) {
        JMTextField tf = new JMTextField();
        ComponentService.addHelpIcon(tf, helpText);
        ComponentService.addClearIcon(tf, "Clear the text from the field.");
        new KeyEventInvoker((Object)tf, 4, this, "computeSampleVariableName");
        return tf;
    }

    private String getHelp() {
        return this.getHelpFile("allFields", "Enter the context, name and value for the system variable.");
    }

    @Reflected
    private void computeSampleVariableName() {
        String variableName = this.computeVariableName();
        String variableValue = this.tfVariableValue.getText();
        String variable = String.format("%s=%s", variableName, variableValue);
        this.lblFullVariableName.setText(variable);
    }

    @Override
    protected String getCommandResultsDialogTitle() {
        return "Set System Variable";
    }

    @Override
    protected ActionSetSystemVar setupActionObjectType() {
        String variableValue = this.tfVariableValue.getText();
        ActionSetSystemVar actionObject = new ActionSetSystemVar();
        actionObject.setVar(this.computeVariableName());
        actionObject.setValue(variableValue);
        return actionObject;
    }

    private String computeVariableName() {
        String context = this.tfContext.getText();
        String variableName = this.tfVariableName.getText();
        String variable = String.format("%s%s/%s", SYSTEM_VAR_PREFIX, context, variableName);
        return variable;
    }
}

