/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.troubleshooting;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.actions.ActionDeleteFile;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractPacketCaptureActionTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.StartPacketCapture;
import com.kumbasoft.core.tools.StopPacketCapture;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.models.DataPowerFileInfoColumnModel;
import com.kumbasoft.core.ui.models.DataPowerFileInfoTableModel;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class PacketCapturePanel
extends AbstractPanel
implements ConfigObjectSubscriber<DataPowerFileInfo> {
    private static final int LABEL_WIDTH = 180;
    private static final int COMPONENT_WIDTH = 200;
    private static final String CAPTURE_DIRECTORY;
    private DefaultComboBoxModel<String> interfaceTypeModel;
    private JMComboBox<String> cbxInterfaceTypes;
    private UniqueArrayList<String> ethernetInterfaceNames;
    private DefaultComboBoxModel<String> ethCbxModel;
    private JMComboBox<String> cbxEthernetInterface;
    private UniqueArrayList<String> vlanInterfaceNames;
    private DefaultComboBoxModel<String> vlanCbxModel;
    private JMComboBox<String> cbxVLANInterface;
    private UniqueArrayList<String> lingAggregationNames;
    private DefaultComboBoxModel<String> linkAggCbxModel;
    private JMComboBox<String> cbxLinkAggInterface;
    private UniqueArrayList<String> standAloneInterfaceNames;
    private DefaultComboBoxModel<String> standAloneCbxModel;
    private JMComboBox<String> cbxStandAloneInterface;
    private CardLayout interfaceCardLayout;
    private JMPanel interfacePanel;
    private JMRadioButton rbCaputureModeTimed;
    private JMRadioButton rbCaputureModeContinuous;
    private NumberField nfMaximumDuration;
    private NumberSpinner nsMaximumDuration;
    private NumberField nfMaximumCaptureSize;
    private NumberSpinner nsMaximumCaptureSize;
    private NumberField nfMaximumPacketSize;
    private NumberSpinner nsMaximumPacketSize;
    private JMTextField tfPCAPFilter;
    private JMCheckBox cbxLogSSLKey;
    private JMButton btnStart;
    private JMButton btnStop;
    private JMButton btnGetCapture;
    private JMCheckBox cbxDeleteFilesAfterDownload;
    private DataPowerFileInfoTableModel captureFileTableModel;
    private DataPowerFileInfoColumnModel captureFileColumnModel;
    private JMTable captureFileTable;
    private String interfaceType;
    private String ethernetInterface;
    private String vlanInterface;
    private String linkAggInterface;
    private String standAloneInterface;
    private String captureMode;
    private int maxDuration;
    private int maximumCaptureSize;
    private int maximumPacketSize;
    private String pcapFilter;
    private String logSSLKey;
    private MultiThreadInvocationListener mtil;

    static {
        Application application = Application.getApplication();
        DPAAApplicationProperties appProps = (DPAAApplicationProperties)application.getApplicationProperties();
        CAPTURE_DIRECTORY = appProps.getPacketCaptureDirectory();
        File outputDir = new File(CAPTURE_DIRECTORY);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
    }

    public PacketCapturePanel() {
        super(new VerticalFlowLayout(3, 10));
        this.setInsets(InsetsFactory.createFixedInsets(20));
        String[] pcapTypes = new String[DPEnumerations.PCAP_INTERFACE_TYPE.length];
        int i = 0;
        while (i < pcapTypes.length) {
            pcapTypes[i] = String.format("%s Interface", DPEnumerations.PCAP_INTERFACE_TYPE[i]);
            ++i;
        }
        this.interfaceTypeModel = new DefaultComboBoxModel<String>(pcapTypes);
        this.cbxInterfaceTypes = new JMComboBox<String>((ComboBoxModel<String>)this.interfaceTypeModel);
        new ItemEventInvoker(this.cbxInterfaceTypes, this, "interfaceTypeChanged");
        LabeledComponent lblInterfaceTypes = new LabeledComponent("Interface Type:", this.cbxInterfaceTypes, 180, 200);
        this.ethCbxModel = new DefaultComboBoxModel();
        this.cbxEthernetInterface = new JMComboBox<String>((ComboBoxModel<String>)this.ethCbxModel);
        this.cbxEthernetInterface.setPreferredSize(new Dimension(100, 25));
        LabeledComponent lblEthernetInterface = new LabeledComponent("Ethernet Interface:", this.cbxEthernetInterface, 180, 200);
        this.vlanCbxModel = new DefaultComboBoxModel();
        this.cbxVLANInterface = new JMComboBox<String>((ComboBoxModel<String>)this.vlanCbxModel);
        this.cbxVLANInterface.setPreferredSize(new Dimension(100, 25));
        LabeledComponent lblVLANInterface = new LabeledComponent("VLAN Interface:", this.cbxVLANInterface, 180, 200);
        this.linkAggCbxModel = new DefaultComboBoxModel();
        this.cbxLinkAggInterface = new JMComboBox<String>((ComboBoxModel<String>)this.vlanCbxModel);
        this.cbxLinkAggInterface.setPreferredSize(new Dimension(100, 25));
        LabeledComponent lblLinkAggInterface = new LabeledComponent("Link Aggregation Interface: ", this.cbxLinkAggInterface, 180, 200);
        this.standAloneCbxModel = new DefaultComboBoxModel();
        this.cbxStandAloneInterface = new JMComboBox<String>((ComboBoxModel<String>)this.standAloneCbxModel);
        this.cbxStandAloneInterface.setPreferredSize(new Dimension(100, 25));
        LabeledComponent lblStandAloneInterface = new LabeledComponent("Stand Alone Interface: ", this.cbxStandAloneInterface, 180, 200);
        this.interfaceCardLayout = new CardLayout();
        this.interfacePanel = new JMPanel(this.interfaceCardLayout);
        this.interfacePanel.add((Component)lblEthernetInterface, "EthernetInterface");
        this.interfacePanel.add((Component)lblVLANInterface, "VLANInterface");
        this.interfacePanel.add((Component)lblLinkAggInterface, "LinkAggInterface");
        this.interfacePanel.add((Component)lblStandAloneInterface, "StandAloneInterface");
        this.interfacePanel.add((Component)new JMPanel(), "EmptyPanel");
        this.ethernetInterfaceNames = new UniqueArrayList();
        this.vlanInterfaceNames = new UniqueArrayList();
        this.lingAggregationNames = new UniqueArrayList();
        this.standAloneInterfaceNames = new UniqueArrayList();
        this.rbCaputureModeTimed = new JMRadioButton("Timed", true);
        this.rbCaputureModeContinuous = new JMRadioButton("Continuous");
        new JMButtonGroup(this.rbCaputureModeTimed, this.rbCaputureModeContinuous);
        JMPanel rbGroup = new JMPanel(new FlowLayout(0));
        rbGroup.addAll(this.rbCaputureModeTimed, this.rbCaputureModeContinuous);
        LabeledComponent captureMode = new LabeledComponent("Capture Mode:", (Component)rbGroup, 180, 200);
        this.nfMaximumDuration = new NumberField(30.0, "###0;-###0");
        this.nsMaximumDuration = new NumberSpinner(this.nfMaximumDuration, 5.0, 5.0, 86400.0);
        LabeledComponent maxTimeComponent = new LabeledComponent("Maximum Duration:", (Component)this.nsMaximumDuration, 180, 200);
        this.nfMaximumCaptureSize = new NumberField(10000.0, "###0;-###0");
        this.nsMaximumCaptureSize = new NumberSpinner(this.nfMaximumCaptureSize, 10.0, 10.0, 500000.0);
        LabeledComponent maxSizeComponent = new LabeledComponent("Maximum Capture Size:", (Component)this.nsMaximumCaptureSize, 180, 200);
        this.nfMaximumPacketSize = new NumberField(9000.0, "###0;-###0");
        this.nsMaximumPacketSize = new NumberSpinner(this.nfMaximumPacketSize, 20.0, 20.0, 9000.0);
        LabeledComponent maxPacketComponent = new LabeledComponent("Maximum Packet Size:", (Component)this.nsMaximumPacketSize, 180, 200);
        this.tfPCAPFilter = new JMTextField(50);
        ComponentService.addClearIcon(this.tfPCAPFilter, "Clear the PCAP Filter.");
        LabeledComponent pcapFilterComponent = new LabeledComponent("PCAP(7) Filter:", (Component)this.tfPCAPFilter, 180, 200);
        this.cbxLogSSLKey = new JMCheckBox("Log SSL Key:");
        JMPanel controlsPanel = new JMPanel(new VerticalFlowLayout(0));
        controlsPanel.addAll(lblInterfaceTypes, this.interfacePanel, captureMode, maxTimeComponent, maxSizeComponent, maxPacketComponent, pcapFilterComponent, this.cbxLogSSLKey);
        JMPanel buttonPanel = this.getButtonPanel();
        JMTable captureFileTable = this.getCaptureTable();
        this.addAll(controlsPanel, buttonPanel, new JMScrollPane(captureFileTable));
        this.mtil = new MultiThreadInvocationListener();
        ApplianceDomainChangeMonitor.getInstance().addApplianceChangeSubscriber(this, "appliancesChanged");
    }

    private JMPanel getButtonPanel() {
        this.btnStart = new JMButton("Start");
        new ActionEventInvoker(this.btnStart, this, "startCapture");
        this.btnStop = new JMButton("Stop");
        new ActionEventInvoker(this.btnStop, this, "stopCapture");
        this.btnGetCapture = new JMButton("Get Capture");
        this.btnGetCapture.setEnabled(false);
        new ActionEventInvoker(this.btnGetCapture, this, "getCapture");
        JMPanel buttonPanel = new JMPanel(new FlowLayout(0));
        this.cbxDeleteFilesAfterDownload = new JMCheckBox("Delete Files After Download", true);
        buttonPanel.addAll(this.btnStart, this.btnStop, ComponentFactory.createSpacer(300, 1), this.btnGetCapture, this.cbxDeleteFilesAfterDownload);
        return buttonPanel;
    }

    private JMTable getCaptureTable() {
        this.captureFileTableModel = new DataPowerFileInfoTableModel("name", "name");
        this.captureFileColumnModel = new DataPowerFileInfoColumnModel();
        this.captureFileTable = new JMTable(this.captureFileTableModel, this.captureFileColumnModel);
        return this.captureFileTable;
    }

    @Reflected
    private void interfaceTypeChanged() {
        String selectedType = (String)this.cbxInterfaceTypes.getSelectedItem();
        int spacePos = selectedType.indexOf(32);
        selectedType = selectedType.substring(0, spacePos);
        String panelToShow = "EmptyPanel";
        switch (selectedType) {
            case "Ethernet": {
                panelToShow = "EthernetInterface";
                break;
            }
            case "VLAN": {
                panelToShow = "VLANInterface";
                break;
            }
            case "Aggregate": {
                panelToShow = "LinkAggInterface";
                break;
            }
            case "Standalone": {
                panelToShow = "StandAloneInterface";
            }
        }
        this.interfaceCardLayout.show(this.interfacePanel, panelToShow);
    }

    @Reflected
    private void appliancesChanged(ArrayList<Appliance> appliances) {
        this.clearElements();
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.mtil.resetThreadCount();
        this.mtil.addThread(new AsynchMethodInvoker((Object)this, "getEthernetInterfaces", appliances));
        this.mtil.addThread(new AsynchMethodInvoker((Object)this, "getVLANInterfaces", appliances));
        this.mtil.addThread(new AsynchMethodInvoker((Object)this, "getLinkAggInterfaces", appliances));
        this.mtil.addThread(new AsynchMethodInvoker((Object)this, "getStandAloneInterfaces", appliances));
        this.mtil.addThread(new AsynchMethodInvoker((Object)this, "listCaptureFiles"));
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    private void clearElements() {
        this.ethCbxModel.removeAllElements();
        this.vlanCbxModel.removeAllElements();
        this.linkAggCbxModel.removeAllElements();
        this.standAloneCbxModel.removeAllElements();
        this.ethernetInterfaceNames.clear();
        this.vlanInterfaceNames.clear();
        this.lingAggregationNames.clear();
        this.standAloneInterfaceNames.clear();
    }

    @Reflected
    private void getEthernetInterfaces(ArrayList<Appliance> appliances) {
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> ethernetInterfaces = configurationManager.listObjects(appliances, "EthernetInterface", ".*");
        PacketCapturePanel.processInterfaceModel(ethernetInterfaces, this.cbxEthernetInterface, this.ethCbxModel);
    }

    @Reflected
    private void getVLANInterfaces(ArrayList<Appliance> appliances) {
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> vlanInterfaces = configurationManager.listObjects(appliances, "VLANInterface", ".*");
        PacketCapturePanel.processInterfaceModel(vlanInterfaces, this.cbxVLANInterface, this.vlanCbxModel);
    }

    @Reflected
    private void getLinkAggInterfaces(ArrayList<Appliance> appliances) {
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> linkAggregationInterfaces = configurationManager.listObjects(appliances, "LinkAggregation", ".*");
        PacketCapturePanel.processInterfaceModel(linkAggregationInterfaces, this.cbxLinkAggInterface, this.linkAggCbxModel);
    }

    @Reflected
    private void getStandAloneInterfaces(ArrayList<Appliance> appliances) {
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> standAloneInterfaces = configurationManager.listObjects(appliances, "StandaloneStandbyControlInterface", ".*");
        PacketCapturePanel.processInterfaceModel(standAloneInterfaces, this.cbxStandAloneInterface, this.standAloneCbxModel);
    }

    private static void processInterfaceModel(ArrayList<StatusObjectStatus> interfaceObjects, JMComboBox<?> comboBox, DefaultComboBoxModel<String> cbxModel) {
        UniqueArrayList<String> objectNames = new UniqueArrayList<String>();
        for (StatusObjectStatus pcapInterface : interfaceObjects) {
            objectNames.add(pcapInterface.getName());
        }
        objectNames.sort();
        cbxModel.addAll(objectNames);
        if (objectNames.size() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    @Reflected
    private void startCapture() {
        logger.finer("(): Starting");
        this.btnStart.setEnabled(false);
        this.interfaceType = (String)this.cbxInterfaceTypes.getSelectedItem();
        this.ethernetInterface = (String)this.cbxEthernetInterface.getSelectedItem();
        this.vlanInterface = (String)this.cbxVLANInterface.getSelectedItem();
        this.linkAggInterface = (String)this.cbxLinkAggInterface.getSelectedItem();
        this.standAloneInterface = (String)this.cbxStandAloneInterface.getSelectedItem();
        this.captureMode = this.rbCaputureModeContinuous.isSelected() ? "continuous" : "timed";
        this.maxDuration = (int)this.nfMaximumDuration.getNumber();
        this.maximumCaptureSize = (int)this.nfMaximumCaptureSize.getNumber();
        this.maximumPacketSize = (int)this.nfMaximumPacketSize.getNumber();
        this.pcapFilter = this.tfPCAPFilter.getText();
        this.logSSLKey = this.cbxLogSSLKey.isSelected() ? "on" : "off";
        String dialogTitle = String.format("Starting %s Packet Capture", StringUtility.toNameCase(this.captureMode));
        this.openResultsDialogAndSetWaitCursor(dialogTitle);
        if (this.rbCaputureModeTimed.isSelected()) {
            int timedDuration = this.maxDuration * 1000 + 200;
            logger.finer(() -> LMG.log("(): This is a timed capture.  Resetting start button to enabled after %dms", () -> timedDuration));
            new AsynchMethodInvoker((Object)this, "timedCaptureComplete", timedDuration);
        }
        this.mtil.resetThreadCount();
        logger.finer("(): Initiating Packet Capture");
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "startCapture", true);
        ThreadManager.monitorAsynchThreadLifeCycle("PacketCapturePanel.startCapture()", this.mtil, KumbaCoreConstants.STARTUP_DELAY * 5, 0);
        this.waitForResultsDialogToCloseAndResetCursor();
        if (!this.rbCaputureModeTimed.isSelected()) {
            this.btnStart.setEnabled(true);
        }
        logger.finer("(): Done");
    }

    @Reflected
    private void startCapture(Appliance appliance) {
        StartPacketCapture startPacketCapture = new StartPacketCapture(appliance, this.interfaceType, this.maxDuration, this.maximumCaptureSize, this.maximumPacketSize);
        startPacketCapture.setCaptureMode(this.captureMode);
        startPacketCapture.setFilter(this.pcapFilter);
        startPacketCapture.setSslKeyLog(this.logSSLKey);
        this.setInterface(startPacketCapture);
        this.mtil.addThread(startPacketCapture.getProcessThread());
        startPacketCapture.addManagementCommandSubscriber(this.commandResultsDialog);
    }

    @Reflected
    private void stopCapture() {
        this.openResultsDialogAndSetWaitCursor("Stopping Packet Capture");
        this.mtil.resetThreadCount();
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "stopCapture", true);
        ThreadManager.monitorAsynchThreadLifeCycle("PacketCapturePanel.stopCapture()", this.mtil, KumbaCoreConstants.STARTUP_DELAY * 3, 0);
        this.listCaptureFiles();
        this.btnStart.setEnabled(true);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void stopCapture(Appliance appliance) {
        StopPacketCapture stopPacketCapture = new StopPacketCapture(appliance, this.interfaceType);
        this.setInterface(stopPacketCapture);
        this.mtil.addThread(stopPacketCapture.getProcessThread());
        stopPacketCapture.addManagementCommandSubscriber(this.commandResultsDialog);
    }

    private void setInterface(AbstractPacketCaptureActionTool actionObject) {
        switch (this.interfaceType) {
            case "Ethernet Interface": {
                actionObject.setEthernetInterface(this.ethernetInterface);
                break;
            }
            case "VLAN Interface": {
                actionObject.setVlanInterface(this.vlanInterface);
                break;
            }
            case "Link Aggregate Interface": {
                actionObject.setLinkAggInterface(this.linkAggInterface);
                break;
            }
            case "Standalone Interface": {
                actionObject.setStandAloneInterface(this.standAloneInterface);
            }
        }
    }

    @Reflected
    private void timedCaptureComplete() {
        this.listCaptureFiles();
        this.btnStart.setEnabled(true);
    }

    @Reflected
    private void getCapture() {
        AbstractPanel.logger.finer("(): Starting");
        int rowCount = this.captureFileTableModel.getRowCount();
        if (rowCount == 0) {
            AbstractPanel.logger.info("(): No capture files present.  Returning");
            return;
        }
        int[] selectedCaptures = this.captureFileTable.getSelectedRows();
        if (selectedCaptures.length == 0) {
            this.captureFileTable.selectAll();
            selectedCaptures = this.captureFileTable.getSelectedRows();
        }
        ArrayList selectedFiles = this.captureFileTableModel.getValues(selectedCaptures);
        this.openResultsDialogAndSetWaitCursor("Downloading Packet Captures");
        AbstractPanel.logger.info(() -> LMG.log("(): Fetching %d capture files.", () -> selectedFiles.size()));
        this.mtil.resetThreadCount();
        for (DataPowerFileInfo captureFile : selectedFiles) {
            DataPowerFileReader fileReader = new DataPowerFileReader(captureFile);
            fileReader.addConfigObjectSubscriber(DataPowerFileInfo.class, this);
            this.mtil.addThread(fileReader.getProcessThread());
        }
        ThreadManager.monitorAsynchThreadLifeCycle("PacketCapturePanel.getCapture()", this.mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        this.mtil.clearCompleted();
        if (this.cbxDeleteFilesAfterDownload.isSelected()) {
            for (DataPowerFileInfo captureFile : selectedFiles) {
                ActionDeleteFile deleteFileAction = new ActionDeleteFile();
                deleteFileAction.setFile(captureFile.getAbsolutePath());
                Appliance appliance = captureFile.getAppliance();
                Domain domain = captureFile.getSourceDomain();
                ActionTool fileDeleter = new ActionTool(appliance, domain, deleteFileAction);
                fileDeleter.getProcessThread().addInvocationListener(this.mtil);
                fileDeleter.setCommandDescription(String.format("Delete file '%s' in %s domain of %s", captureFile.getAbsolutePath(), domain.getName(), appliance.getName()));
                fileDeleter.addManagementCommandSubscriber(this.commandResultsDialog);
                ThreadManager.monitorAsynchThreadLifeCycle("PacketCapturePanel.getCapture()", this.mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
                this.captureFileTableModel.deleteRow(captureFile);
            }
            this.captureFileTable.repaint();
            this.btnGetCapture.setEnabled(this.captureFileTableModel.getRowCount() > 0);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done");
    }

    private void listCaptureFiles() {
        AbstractPanel.logger.finer("(): Starting");
        this.captureFileTableModel.reset();
        this.captureFileTable.repaint();
        this.btnGetCapture.setEnabled(false);
        UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        Index<Appliance, Domain> selectedDomains = new Index<Appliance, Domain>();
        for (Appliance appliance : selectedAppliances) {
            selectedDomains.put(appliance, appliance.getDomain("default"));
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
        ListFiles.list(selectedDomains, CollectionUtility.createListFrom("temporary:/"), "capture\\.pcap.*", mtil);
        ListFiles.addConfigObjectSubscriber(fileCache);
        ThreadManager.monitorAsynchThreadLifeCycle("PacketCapturePanel.listCaptureFiles()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        Vector<DataPowerFileInfo> captureFiles = fileCache.getObjectCache();
        AbstractPanel.logger.finer(() -> LMG.log("(): Found %d capture file(s).", () -> captureFiles.size()));
        if (CollectionUtility.isNotEmpty(captureFiles)) {
            this.captureFileTableModel.addAll(captureFiles);
            this.captureFileTable.optimizeColumnWidths();
            this.btnGetCapture.setEnabled(true);
            this.captureFileTable.clearSelection();
        }
        AbstractPanel.logger.finer("(): Done");
    }

    @Override
    public void processDataPowerConfig(DataPowerFileInfo fileInfo) {
        AbstractPanel.logger.finer(() -> LMG.log("(DataPowerFileInfo=%s): Starting.", () -> fileInfo.getFQON()));
        byte[] fileData = fileInfo.getFileData();
        if (fileData == null) {
            AbstractPanel.logger.warning(() -> LMG.log("(DataPowerFileInfo=%s):  File Data is NULL.", () -> fileInfo.getFQON()));
            ManagementCommandError error = new ManagementCommandError(fileInfo.getAppliance(), fileInfo.getSourceDomain(), "Get PCAP File", null, "Failed to read capture file.  The file may not exist.");
            this.commandResultsDialog.commandFailed(error);
        } else {
            String applianceName = fileInfo.getAppliance().getName();
            DateTime now = new DateTime();
            now.getDate().setFormat(Date.SQL_FORMAT);
            String currentDate = now.toString().replaceAll("[/:]", "-").replace(" ", "_");
            String outputDirectory = String.format("%s%s%s%s%s%s", CAPTURE_DIRECTORY, File.separator, applianceName, File.separator, "default", File.separator);
            File pcapDirectory = new File(outputDirectory);
            if (!pcapDirectory.exists()) {
                pcapDirectory.mkdirs();
            }
            File pcapFile = new File(pcapDirectory, String.format("%s-%s", currentDate, fileInfo.getFileName()));
            AbstractPanel.logger.finer(() -> LMG.log("(DataPowerFileInfo=%s): Writing capture data to file '%s'.", () -> fileInfo.getFQON(), () -> pcapFile.getAbsolutePath()));
            try {
                FileOutputStreamHelper fout = new FileOutputStreamHelper(pcapFile);
                fout.open();
                ((OutputStream)fout.getStream()).write(fileData);
                fout.close();
                AbstractPanel.logger.finer(() -> LMG.log("(DataPowerFileInfo=%s): Successfully wrote capture data to file '%s'.", () -> fileInfo.getFQON(), () -> pcapFile.getAbsolutePath()));
                ManagementCommandStatus result = new ManagementCommandStatus(fileInfo.getAppliance(), fileInfo.getSourceDomain(), "Get PCAP File", null, "PCAP File written to " + pcapFile.getAbsolutePath());
                this.commandResultsDialog.commandSucceeded(result);
            }
            catch (IOException e) {
                AbstractPanel.logger.finer(() -> LMG.log("(DataPowerFileInfo=%s): Failed to write capture data to file '%s'.", () -> fileInfo.getFQON(), () -> pcapFile.getAbsolutePath()));
                ManagementCommandError error = new ManagementCommandError(fileInfo.getAppliance(), fileInfo.getSourceDomain(), "Get PCAP File", null, "Failed to wrtie capture file.");
                this.commandResultsDialog.commandFailed(error);
            }
        }
        AbstractPanel.logger.finer(() -> LMG.log("(DataPowerFileInfo=%s): Done.", () -> fileInfo.getFQON()));
    }

    @Override
    public void configProcessingComplete() {
    }
}

