/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.troubleshooting;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.IPAddress;
import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.net.SubnetUtils;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.actions.ActionPing;
import com.kumbasoft.core.beans.actions.ActionTCPConnectionTest;
import com.kumbasoft.core.beans.status.StatusLoadBalancerStatus2;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.ListModel;

public class TCPConnectionPanel
extends AbstractPanel {
    private static final int LABEL_WIDTH = 45;
    private Index<String, StatusLoadBalancerStatus2> lbgStatusIndex;
    private JMListModel<String> loadBalancerGroupListModel;
    private JMList<String> loadBalancerGroupList;
    private JMListCellRenderer<String> loadBalancerGroupCellRenderer;
    private JMTextField tfHosts;
    private NumberField nfPort;
    private NumberSpinner nsPort;
    private JMButton btnTCPTest;
    private JMButton btnPing;
    private ArrayList<Pair<String, Integer>> testHosts;

    public TCPConnectionPanel() {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.setInsets(InsetsFactory.createFixedInsets(5));
        this.loadBalancerGroupListModel = new JMListModel();
        this.loadBalancerGroupList = new JMList<String>((ListModel<String>)this.loadBalancerGroupListModel);
        this.loadBalancerGroupCellRenderer = (JMListCellRenderer)this.loadBalancerGroupList.getCellRenderer();
        LabeledComponent lblLoadBalancerList = new LabeledComponent("Load Balancers", (Component)new JMScrollPane(this.loadBalancerGroupList), 1);
        JMPanel rightPane = new JMPanel(new VerticalFlowLayout(3));
        rightPane.setInsets(InsetsFactory.createFixedInsets(5));
        JMPanel hostPanel = new JMPanel(new FlowLayout(0));
        this.tfHosts = new JMTextField(50);
        ComponentService.addHelpIcon(this.tfHosts, this.getHelpFile("hostsField", "Enter one or more hosts separated by spaces, commas or semi-colons."));
        ComponentService.addClearIcon(this.tfHosts, "Clear the hosts field.");
        this.btnPing = new JMButton("Ping Host");
        new ActionEventInvoker(this.btnPing, this, "performTest", "pingTest");
        hostPanel.add(new LabeledComponent("Host:", (Component)this.tfHosts, 45, 300));
        hostPanel.add(this.btnPing);
        this.add(hostPanel);
        JMPanel portPanel = new JMPanel(new FlowLayout(0));
        this.nfPort = new NumberField(443.0, 5);
        this.nfPort.setFormatString("###0;-###0");
        this.nsPort = new NumberSpinner(this.nfPort, 1.0, 0.0, 65535.0);
        this.btnTCPTest = new JMButton("TCP Test");
        new ActionEventInvoker(this.btnTCPTest, this, "performTest", "tcpConnectionTest");
        portPanel.add(new LabeledComponent("Port:", (Component)this.nsPort, 45, 75));
        portPanel.add(this.btnTCPTest);
        rightPane.addAll(hostPanel, portPanel);
        this.add((Component)lblLoadBalancerList, "West");
        this.add((Component)rightPane, "Center");
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
    }

    @Override
    public void updateUI() {
        if (this.loadBalancerGroupCellRenderer != null) {
            KumbaCoreUIConstants.setupRenderer(this.loadBalancerGroupCellRenderer);
        }
        super.updateUI();
    }

    @Reflected
    private void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        logger.entering(this.getClass().getName(), "domainsChanged");
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        if (this.lbgStatusIndex == null) {
            this.lbgStatusIndex = new Index();
        } else {
            this.lbgStatusIndex.clear();
        }
        this.loadBalancerGroupList.clearSelection();
        this.loadBalancerGroupListModel.clear();
        logger.finest(() -> LMG.log("TCPConnectionPanel.domainsChanged(selectedDomains): Looking for Load Balancer Groups", new Supplier[0]));
        try {
            DataPowerStatusCache statusCache = new DataPowerStatusCache();
            for (Appliance appliance : selectedDomains.getKeys()) {
                for (Domain domain : selectedDomains.get(appliance)) {
                    DataPowerStatusMonitor lbgStatusMonitor = new DataPowerStatusMonitor(appliance, domain, "LoadBalancerStatus2", 0L);
                    lbgStatusMonitor.addStatusListener(statusCache);
                }
            }
            logger.finest(() -> LMG.log("TCPConnectionPanel.domainsChanged(selectedDomains):  Waiting for status to complete\n", new Supplier[0]));
            while (!statusCache.isComplete()) {
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            }
            ArrayList cacheData = statusCache.getStatusCache();
            logger.finest(() -> LMG.log("(selectedDomains):  Received %d status objects", () -> cacheData.size()));
            if (cacheData.size() == 0) {
                return;
            }
            try {
                BeanComparator sorter = new BeanComparator();
                sorter.addCompareProperty("group.name");
                Collections.sort(cacheData, sorter);
                logger.finest(() -> LMG.log("TCPConnectionPanel.domainsChanged(selectedDomains):  Sorted.  Extracting names and adding to list", new Supplier[0]));
                UniqueArrayList<String> tempModel = new UniqueArrayList<String>();
                for (StatusLoadBalancerStatus2 loadBalancerStatus : cacheData) {
                    String name = loadBalancerStatus.getGroup().getName();
                    this.lbgStatusIndex.put(name, loadBalancerStatus);
                    logger.finest(() -> LMG.log("(selectedDomains):  Adding to temp model %s", () -> name));
                    tempModel.add(name);
                }
                logger.finest(() -> LMG.log("TCPConnectionPanel.domainsChanged(selectedDomains):  Setting temp model elements to model", new Supplier[0]));
                this.loadBalancerGroupListModel.addAll(tempModel);
            }
            catch (Exception e) {
                logger.config(e.toString());
            }
        }
        finally {
            this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
            logger.exiting(this.getClass().getName(), "domainsChanged");
        }
    }

    @Reflected
    private void performTest(String testMethodName) {
        if (this.testHosts != null) {
            this.testHosts.clear();
            this.testHosts = null;
        }
        this.testHosts = this.getTestHosts();
        if (this.testHosts.size() < 1) {
            new JMMessageBox((JFrame)AbstractPanel.frame, "Invalid hosts", "No hosts or all host entries invalid");
            return;
        }
        String resultsTitle = testMethodName.equals("pingTest") ? "Ping Test" : "TCP Connection Test";
        this.openResultsDialogAndSetWaitCursor(resultsTitle);
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, testMethodName, true, false);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    private ArrayList<Pair<String, Integer>> getTestHosts() {
        String[] hostList;
        logger.finer("(): Starting");
        int port = (int)this.nfPort.getNumber();
        logger.finer(() -> LMG.log("(): User supplied port to use in TCP tests: %d", () -> (int)this.nfPort.getNumber()));
        logger.finer("(): Processing LBGs");
        List selectedLBGs = this.loadBalancerGroupList.getSelectedValuesList();
        UniqueArrayList<Pair<String, Integer>> testHosts = new UniqueArrayList<Pair<String, Integer>>();
        if (CollectionUtility.isNotEmpty(selectedLBGs)) {
            logger.finer(() -> LMG.log("(): Loading Members from %d LBGs", () -> selectedLBGs.size()));
            for (String lbg : selectedLBGs) {
                ArrayList lbgMembers = (ArrayList)this.lbgStatusIndex.get(lbg);
                logger.finer(() -> LMG.log("(): LBG '%s' has %d Members from %d LBGs", () -> lbg, () -> lbgMembers.size(), () -> selectedLBGs.size()));
                for (StatusLoadBalancerStatus2 lbgMember : lbgMembers) {
                    String adminState = lbgMember.getAdminState();
                    if (adminState.equals("disabled")) continue;
                    String server = lbgMember.getServer();
                    int memberPort = lbgMember.getPort();
                    if (memberPort == 0) {
                        memberPort = port;
                    }
                    int testPort = memberPort;
                    logger.finer(() -> LMG.log("(): Will test LBG member '%s' on port %d", () -> server, () -> testPort));
                    testHosts.add(new Pair<String, Integer>(server, memberPort));
                }
            }
            logger.finer(() -> LMG.log("(): %d test hosts found in selected LBGs.", () -> testHosts.size()));
        } else {
            logger.finer("(): No LBGs selected.");
        }
        String hosts = this.tfHosts.getText();
        if (StringUtility.isEmpty(hosts) && CollectionUtility.isEmpty(testHosts)) {
            logger.info("(): No hosts entered and no LBGs selected.  Done.");
            return testHosts;
        }
        logger.finer("(): Preparing manually entered host list.");
        String[] stringArray = hostList = hosts.split("[\\s,;]");
        int n = hostList.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            if (!StringUtility.isEmpty(host)) {
                String enteredHost = host = host.trim();
                logger.finer(() -> LMG.log("(): Processing entered host: %s.", () -> enteredHost));
                int slashCount = StringUtility.getCountOf(host, "/");
                if (slashCount > 1) {
                    logger.finer(() -> LMG.log("(): Host '%s' is a URI.  Making repairs if possible.", () -> enteredHost));
                    while (slashCount > 1) {
                        int firstSlash = host.indexOf(47);
                        int secondSlash = host.indexOf(47, firstSlash + 1);
                        String subString = host.substring(firstSlash, secondSlash);
                        host = StringUtility.remove(host, subString, firstSlash);
                        slashCount = StringUtility.getCountOf(host, "/");
                    }
                    LMG.log(logger, Level.FINER, "TCPConnectionPanel.getTestHosts(): Host '%s' after making repairs is now '%s.", enteredHost, host);
                }
                int portSeparator = host.indexOf(58);
                int netMaskSeparator = host.indexOf(47);
                char firstDelimiter = '\u0000';
                int firstDelimiterLocation = Math.min(portSeparator, netMaskSeparator);
                if (firstDelimiterLocation == -1) {
                    firstDelimiterLocation = Math.max(portSeparator, netMaskSeparator);
                }
                String extras = "";
                if (firstDelimiterLocation >= 0) {
                    firstDelimiter = host.charAt(firstDelimiterLocation);
                    extras = host.substring(firstDelimiterLocation + 1);
                    host = host.substring(0, firstDelimiterLocation);
                }
                LMG.log(logger, Level.FINER, "TCPConnectionPanel.getTestHosts(): Entered host is: '%s'.  Actual host is: '%s', everything else is '%s'.", enteredHost, host, extras);
                if (StringUtility.isNotEmpty(extras)) {
                    String portString = "";
                    String netMaskString = "";
                    if (extras.contains(":") || extras.contains("/")) {
                        String regex = firstDelimiter == ':' ? "/" : "\\:";
                        String[] portNetMask = extras.split(regex);
                        if (firstDelimiter == ':') {
                            portString = portNetMask[0];
                            netMaskString = portNetMask[1];
                        } else {
                            portString = portNetMask[1];
                            netMaskString = portNetMask[0];
                        }
                        if (!NumberUtility.isInteger(portString) || !Comparison.isBetween(Integer.parseInt(portString), 0, 65535)) {
                            return TCPConnectionPanel.showPortError(portString, testHosts);
                        }
                        if (!NumberUtility.isInteger(netMaskString) || !Comparison.isBetween(Integer.parseInt(netMaskString), 0, 32)) {
                            return TCPConnectionPanel.showNetMaskError(netMaskString, testHosts);
                        }
                        LMG.log(logger, Level.FINER, "TCPConnectionPanel.getTestHosts(): Parsed Port %d, NetMask of %d.", Integer.parseInt(portString), Integer.parseInt(netMaskString));
                    } else if (firstDelimiter == ':') {
                        portString = extras;
                        if (!NumberUtility.isInteger(portString) || !Comparison.isBetween(Integer.parseInt(portString), 0, 65535)) {
                            return TCPConnectionPanel.showPortError(portString, testHosts);
                        }
                        int parsedPort = Integer.parseInt(portString);
                        logger.finer(() -> LMG.log("(): Parsed Port %d", () -> parsedPort));
                    } else {
                        netMaskString = extras;
                        if (!NumberUtility.isInteger(netMaskString) || !Comparison.isBetween(Integer.parseInt(netMaskString), 0, 32)) {
                            return TCPConnectionPanel.showNetMaskError(netMaskString, testHosts);
                        }
                        int parsedNetMask = Integer.parseInt(netMaskString);
                        logger.finer(() -> LMG.log("(): NetMask of %d.", () -> parsedNetMask));
                    }
                    if (!StringUtility.isEmpty(portString) && NumberUtility.isNumber(portString)) {
                        port = Integer.parseInt(portString);
                    }
                    int testingPort = port;
                    if (!StringUtility.isEmpty(netMaskString) && NumberUtility.isNumber(netMaskString)) {
                        String hostName;
                        String string = hostName = host.matches("\\d+\\.\\d+\\.\\d+\\.\\d+") ? host : IPAddress.getByName(host);
                        if (hostName != null) {
                            int netMask = Integer.parseInt(netMaskString);
                            int netMaskCount = (int)Math.pow(2.0, 32 - netMask);
                            if (netMaskCount > 10) {
                                logger.finer(() -> LMG.log("(): Netmask count is %d.  Issuing warning", () -> netMaskCount));
                                new JMMessageBox((JFrame)AbstractPanel.frame, "Large Test Count", String.format("The number of TCP tests for host '%s' with netmask %d is %d.  Continue?", hostName, netMask, netMaskCount), 12);
                                if (JMMessageBox.getSelection() == 8) {
                                    logger.finer(() -> LMG.log("(): Netmask count is %d.  User is not continuing.", () -> netMaskCount));
                                    return testHosts;
                                }
                                logger.finer(() -> LMG.log("(): Netmask count is %d.  User is allowing to continue.", () -> netMaskCount));
                            }
                            if (netMaskString.equals("32")) {
                                logger.finer("(): Netmask is 32.  Just use the host and port given.");
                                testHosts.add(new Pair<String, Integer>(hostName, port));
                            } else {
                                String maskedHost = String.format("%s/%s", hostName, netMaskString);
                                SubnetUtils subnetUtils = new SubnetUtils(maskedHost);
                                SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
                                String[] allAddresses = subnetInfo.getAllAddresses();
                                if (allAddresses.length == 0) {
                                    logger.finer(() -> LMG.log("(): No addresses returned fron subnet mask.  Only Host Port %s:%d added.", () -> hostName, () -> testingPort));
                                    testHosts.add(new Pair<String, Integer>(hostName, port));
                                } else {
                                    String[] stringArray2 = allAddresses;
                                    int n3 = allAddresses.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        String address = stringArray2[n4];
                                        logger.finer(() -> LMG.log("(): Subnet address %s:%d added", () -> address, () -> testingPort));
                                        testHosts.add(new Pair<String, Integer>(address, port));
                                        ++n4;
                                    }
                                }
                            }
                        } else {
                            logger.info(() -> LMG.log("(): Host '%s' could not be resolved to an IP.", () -> hostName));
                            ManagementCommandError error = new ManagementCommandError();
                            error.setErrorMessage(String.format("Host '%s' could not be resolved to an IP.", hostName));
                            this.commandResultsDialog.commandFailed(error);
                        }
                    } else {
                        String testingHost = host;
                        logger.finer(() -> LMG.log("(): Host Port %s:%d added", () -> testingHost, () -> testingPort));
                        testHosts.add(new Pair<String, Integer>(host, port));
                    }
                } else {
                    String testingHost = host;
                    int testingPort = port;
                    logger.finer(() -> LMG.log("(): Host Port %s:%d added", () -> testingHost, () -> testingPort));
                    testHosts.add(new Pair<String, Integer>(host, port));
                }
            }
            ++n2;
        }
        logger.finer(() -> LMG.log("(): Done.  Returning %d testHosts", () -> testHosts.size()));
        return testHosts;
    }

    private static ArrayList<Pair<String, Integer>> showPortError(String port, ArrayList<Pair<String, Integer>> testHosts) {
        new JMMessageBox((JFrame)AbstractPanel.frame, "Port is invalid", String.format("The given port '%s' must be an integer from 0 - 65535.", port));
        return testHosts;
    }

    private static ArrayList<Pair<String, Integer>> showNetMaskError(String netMask, ArrayList<Pair<String, Integer>> testHosts) {
        new JMMessageBox((JFrame)AbstractPanel.frame, "The net mask prefix is invalid", String.format("The netmask prefix '%s' must be an integer from 0 - 32.", netMask));
        return testHosts;
    }

    @Reflected
    private void tcpConnectionTest(Appliance appliance) {
        String applianceName = appliance.getName();
        AbstractPanel.logger.finer(() -> LMG.log("(Appliance appliance=%s):  Starting TCP tests.", () -> applianceName));
        ArrayList<Pair<String, Integer>> iterationCopy = new ArrayList<Pair<String, Integer>>(this.testHosts);
        for (Pair<String, Integer> testHost : iterationCopy) {
            ActionTCPConnectionTest actionTCPConnectionTest = new ActionTCPConnectionTest();
            actionTCPConnectionTest.setRemoteHost((String)testHost.first);
            actionTCPConnectionTest.setRemotePort((Integer)testHost.second);
            SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
            AbstractPanel.logger.fine(() -> LMG.log("(Appliance appliance=%s):  Conducting TCP test for %s:%d!", () -> applianceName, () -> pair.first, () -> pair.second));
            ActionTool tcpConnectionTest = new ActionTool(appliance, (JMBean)actionTCPConnectionTest);
            tcpConnectionTest.getProcessThread().addInvocationListener(stil);
            tcpConnectionTest.setCommandDescription(String.format("TCP Connection to %s:%d", testHost.first, testHost.second));
            tcpConnectionTest.setConnectionTimeout(30000);
            tcpConnectionTest.setReadTimeout(30000);
            tcpConnectionTest.setRetryCount(0);
            tcpConnectionTest.addManagementCommandSubscriber(this.commandResultsDialog);
            boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT * 3);
            if (completedOnTime) continue;
            AbstractPanel.logger.warning(() -> LMG.log("(Appliance appliance=%s):  TCP test for %s:%d timed out!", () -> applianceName, () -> pair.first, () -> pair.second));
        }
        AbstractPanel.logger.info(() -> LMG.log("(Appliance appliance=%s):  All TCP tests complete.", () -> applianceName));
    }

    @Reflected
    private void pingTest(Appliance appliance) {
        String applianceName = appliance.getName();
        AbstractPanel.logger.finer(() -> LMG.log("(Appliance appliance=%s):  Starting Ping tests.", () -> applianceName));
        UniqueArrayList<String> hosts = new UniqueArrayList<String>();
        for (Pair<String, Integer> testHost : this.testHosts) {
            hosts.add((String)testHost.first);
        }
        for (String host : hosts) {
            ActionPing actionPing = new ActionPing();
            actionPing.setRemoteHost(host);
            SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
            AbstractPanel.logger.fine(() -> LMG.log("(Appliance appliance=%s):  Starting Ping test for %s!", () -> applianceName, () -> host));
            ActionTool pingTest = new ActionTool(appliance, (JMBean)actionPing);
            pingTest.getProcessThread().addInvocationListener(stil);
            pingTest.setCommandDescription(String.format("Ping %s", host));
            pingTest.setConnectionTimeout(30000);
            pingTest.setReadTimeout(30000);
            pingTest.setRetryCount(0);
            pingTest.addManagementCommandSubscriber(this.commandResultsDialog);
            boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT * 3);
            if (completedOnTime) continue;
            AbstractPanel.logger.warning(() -> LMG.log("(Appliance appliance=%s):  Ping test for %s timed out!", () -> applianceName, () -> host));
        }
        AbstractPanel.logger.info(() -> LMG.log("(Appliance appliance=%s):  All Ping Tests are complete.", () -> applianceName));
    }
}

