/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.chart.util.Args;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xml.CategoryDatasetHandler;
import org.jfree.data.xml.PieDatasetHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DatasetReader {
    static SAXParserFactory factory;

    public static SAXParserFactory getSAXParserFactory() {
        if (factory == null) {
            SAXParserFactory f = SAXParserFactory.newInstance();
            try {
                f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                factory = f;
            }
            catch (SAXNotRecognizedException e) {
                throw new RuntimeException(e);
            }
            catch (SAXNotSupportedException e) {
                throw new RuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return factory;
    }

    public static void setSAXParserFactory(SAXParserFactory f) {
        Args.nullNotPermitted(f, "f");
        factory = f;
    }

    public static PieDataset readPieDatasetFromXML(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        return DatasetReader.readPieDatasetFromXML(in);
    }

    public static PieDataset readPieDatasetFromXML(InputStream in) throws IOException {
        PieDataset result = null;
        try {
            SAXParser parser = DatasetReader.getSAXParserFactory().newSAXParser();
            PieDatasetHandler handler = new PieDatasetHandler();
            parser.parse(in, (DefaultHandler)handler);
            result = handler.getDataset();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e2) {
            throw new RuntimeException(e2);
        }
        return result;
    }

    public static CategoryDataset readCategoryDatasetFromXML(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        return DatasetReader.readCategoryDatasetFromXML(in);
    }

    public static CategoryDataset readCategoryDatasetFromXML(InputStream in) throws IOException {
        CategoryDataset result = null;
        try {
            SAXParser parser = DatasetReader.getSAXParserFactory().newSAXParser();
            CategoryDatasetHandler handler = new CategoryDatasetHandler();
            parser.parse(in, (DefaultHandler)handler);
            result = handler.getDataset();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e2) {
            throw new RuntimeException(e2);
        }
        return result;
    }
}

