/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.ObjectUtils;
import org.jfree.chart.util.PublicCloneable;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.MatrixSeries;
import org.jfree.data.xy.XYZDataset;

public class MatrixSeriesCollection
extends AbstractXYZDataset
implements XYZDataset,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3197705779242543945L;
    private List seriesList = new ArrayList();

    public MatrixSeriesCollection() {
        this(null);
    }

    public MatrixSeriesCollection(MatrixSeries series) {
        if (series != null) {
            this.seriesList.add(series);
            series.addChangeListener(this);
        }
    }

    @Override
    public int getItemCount(int seriesIndex) {
        return this.getSeries(seriesIndex).getItemCount();
    }

    public MatrixSeries getSeries(int seriesIndex) {
        if (seriesIndex < 0 || seriesIndex > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        MatrixSeries series = (MatrixSeries)this.seriesList.get(seriesIndex);
        return series;
    }

    @Override
    public int getSeriesCount() {
        return this.seriesList.size();
    }

    @Override
    public Comparable getSeriesKey(int seriesIndex) {
        return this.getSeries(seriesIndex).getKey();
    }

    @Override
    public Number getX(int seriesIndex, int itemIndex) {
        MatrixSeries series = (MatrixSeries)this.seriesList.get(seriesIndex);
        int x = series.getItemColumn(itemIndex);
        return new Integer(x);
    }

    @Override
    public Number getY(int seriesIndex, int itemIndex) {
        MatrixSeries series = (MatrixSeries)this.seriesList.get(seriesIndex);
        int y = series.getItemRow(itemIndex);
        return new Integer(y);
    }

    @Override
    public Number getZ(int seriesIndex, int itemIndex) {
        MatrixSeries series = (MatrixSeries)this.seriesList.get(seriesIndex);
        Number z = series.getItem(itemIndex);
        return z;
    }

    public void addSeries(MatrixSeries series) {
        Args.nullNotPermitted(series, "series");
        this.seriesList.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MatrixSeriesCollection) {
            MatrixSeriesCollection c = (MatrixSeriesCollection)obj;
            return ObjectUtils.equal(this.seriesList, c.seriesList);
        }
        return false;
    }

    public int hashCode() {
        return this.seriesList != null ? this.seriesList.hashCode() : 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MatrixSeriesCollection clone = (MatrixSeriesCollection)super.clone();
        clone.seriesList = (List)ObjectUtils.deepClone(this.seriesList);
        return clone;
    }

    public void removeAllSeries() {
        int i = 0;
        while (i < this.seriesList.size()) {
            MatrixSeries series = (MatrixSeries)this.seriesList.get(i);
            series.removeChangeListener(this);
            ++i;
        }
        this.seriesList.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(MatrixSeries series) {
        Args.nullNotPermitted(series, "series");
        if (this.seriesList.contains(series)) {
            series.removeChangeListener(this);
            this.seriesList.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int seriesIndex) {
        if (seriesIndex < 0 || seriesIndex > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        MatrixSeries series = (MatrixSeries)this.seriesList.get(seriesIndex);
        series.removeChangeListener(this);
        this.seriesList.remove(seriesIndex);
        this.fireDatasetChanged();
    }
}

