/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.awt;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.border.RoundedCornerBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;

public class ShapePainter {
    private JComponent component;
    private Shape shape;
    private Dimension shapeSize;

    public ShapePainter(JComponent component, Shape shape) {
        this.setComponent(component);
        this.setShape(shape);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent component) {
        this.component = component;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        if (this.shape != null) {
            this.component.setOpaque(false);
            JComponent jComponent = this.component;
            if (jComponent instanceof JButton) {
                JButton b = (JButton)jComponent;
                b.setContentAreaFilled(false);
            }
            Rectangle bounds = this.shape.getBounds();
            this.shapeSize = new Dimension(bounds.width, bounds.height);
        }
    }

    public void paintBorder(Graphics g) {
        Border border = this.component.getBorder();
        if (border == null || border instanceof EmptyBorder) {
            return;
        }
        if (border instanceof LineBorder) {
            LineBorder lineBorder = (LineBorder)border;
            g.setColor(lineBorder.getLineColor());
        } else if (border instanceof EtchedBorder) {
            EtchedBorder etchedBorder = (EtchedBorder)border;
            g.setColor(etchedBorder.getShadowColor());
        } else if (border instanceof BevelBorder) {
            BevelBorder bevelBorder = (BevelBorder)border;
            g.setColor(bevelBorder.getShadowInnerColor());
        } else if (border instanceof RoundedCornerBorder) {
            RoundedCornerBorder rcBorder = (RoundedCornerBorder)border;
            g.setColor(rcBorder.getColor());
        } else if (border instanceof CompoundBorder) {
            if (this.component instanceof JButton) {
                g.setColor(UIManager.getColor("Button.darkShadow"));
            } else if (this.component instanceof JTextComponent) {
                g.setColor(UIManager.getColor("TextField.darkShadow"));
            }
        } else {
            g.setColor(UIManager.getColor("Panel.background"));
        }
        this.paintShape(g, false);
    }

    public void paintComponent(Graphics g) {
        MethodInvoker mi;
        boolean isOpaque;
        Graphics2D g2 = (Graphics2D)g;
        Color backgroundColor = this.component.getBackground();
        if (BeanService.hasProperty(this.component, "backgroundPaint")) {
            MethodInvoker mi2 = new MethodInvoker((Object)this.component, "getBackgroundPaint", new Object[0]);
            Paint paint = (Paint)mi2.invoke();
            if (paint != null) {
                g2.setPaint(paint);
            } else {
                g2.setColor(backgroundColor);
            }
        } else if (BeanService.hasProperty(this.component, "opaque") && (isOpaque = ((Boolean)(mi = new MethodInvoker((Object)this.component, "isOpaque", new Object[0])).invoke()).booleanValue())) {
            g2.setColor(backgroundColor);
        }
        this.paintShape(g, true);
    }

    private void paintShape(Graphics graphics, boolean fill) {
        if (this.shape != null) {
            Graphics2D g2 = (Graphics2D)graphics;
            Dimension size = this.component.getSize();
            --size.width;
            --size.height;
            double xRatio = (double)size.width / (double)this.shapeSize.width;
            double yRatio = (double)size.height / (double)this.shapeSize.height;
            g2.scale(xRatio, yRatio);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (fill) {
                g2.fill(this.shape);
            } else {
                g2.draw(this.shape);
            }
            xRatio = (double)this.shapeSize.width / (double)size.width;
            yRatio = (double)this.shapeSize.height / (double)size.height;
            g2.scale(xRatio, yRatio);
        }
    }
}

