/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.StringUtility;
import java.util.ArrayList;

public class UserAgentInfo
extends JMBean
implements Comparable<UserAgentInfo> {
    private static final String[] BROWSER_NAMES = new String[]{"MSIE", "Firefox", "Chrome", "Safari", "Opera", "Mozilla"};
    private static final String[] VERSION_DELIMITERS = new String[]{" ", "/", "/", "/", "/", "/"};
    private static final String[] OS_NAMES = new String[]{"Windows", "Mac", "Linux", "Android", "iPad", "iPod"};
    private String name;
    private String version;
    private ArrayList<String> plugins = new ArrayList();
    private String operatingSystem;

    public UserAgentInfo() {
    }

    public UserAgentInfo(String userAgentString) {
        this();
        this.processUserAgentString(userAgentString);
    }

    public void processUserAgentString(String userAgentString) {
        if (StringUtility.isEmpty(userAgentString)) {
            return;
        }
        int i = 0;
        while (i < BROWSER_NAMES.length) {
            String browserName = BROWSER_NAMES[i];
            if (userAgentString.contains(browserName)) {
                this.setName(browserName);
                int browserNameLocation = userAgentString.indexOf(browserName);
                int versionDelimiterLocation = userAgentString.indexOf(VERSION_DELIMITERS[i], browserNameLocation) + 1;
                int endOfVersion = userAgentString.indexOf(32, versionDelimiterLocation);
                if (endOfVersion == -1) {
                    endOfVersion = userAgentString.length();
                }
                String version = userAgentString.substring(versionDelimiterLocation, endOfVersion);
                this.setVersion(version);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < OS_NAMES.length) {
            String osName = OS_NAMES[i];
            if (userAgentString.contains(osName)) {
                this.setOperatingSystem(osName);
                break;
            }
            ++i;
        }
    }

    public boolean isIE() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals(BROWSER_NAMES[0]);
    }

    public boolean isFireFox() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals(BROWSER_NAMES[1]);
    }

    public boolean isSafari() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals(BROWSER_NAMES[3]);
    }

    public boolean isChrome() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals(BROWSER_NAMES[2]);
    }

    public boolean isOpera() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals(BROWSER_NAMES[4]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ArrayList<String> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(ArrayList<String> plugins) {
        this.plugins = plugins;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    @Override
    public int compareTo(UserAgentInfo that) {
        return this.compareTo(that, "name", "operatingSystem", "version", "plugins");
    }

    public boolean equals(Object o) {
        return this.equals(o, "name", "operatingSystem", "version", "plugins");
    }

    @Override
    public int hashCode() {
        return this.hashCode("name", "operatingSystem", "version", "plugins");
    }

    @Override
    public String toString() {
        return this.toString("name", "operatingSystem", "version", "plugins");
    }
}

