/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.util.DataTypeConverter;
import com.jmorgan.beans.util.NamedPropertyBindingMap;
import com.jmorgan.beans.util.PropertyBinder;
import com.jmorgan.beans.util.PropertyBindingMap;
import com.jmorgan.lang.MethodInvoker;
import java.beans.PropertyChangeEvent;

public class NamedPropertyBinder
extends PropertyBinder {
    public NamedPropertyBinder() {
    }

    public NamedPropertyBinder(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, String targetMethodName) {
        this.addBindingMap(sourceObject, sourceProperty, targetObject, targetProperty, targetMethodName);
    }

    public NamedPropertyBinder(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, String targetMethodName, DataTypeConverter<?, ?> typeConverter) {
        this.addBindingMap(sourceObject, sourceProperty, targetObject, targetProperty, targetMethodName, typeConverter);
    }

    public void addBindingMap(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, String targetMethodName) {
        NamedPropertyBindingMap map = new NamedPropertyBindingMap(sourceObject, sourceProperty, targetObject, targetProperty, targetMethodName);
        this.getBindingMap().add(map);
        new MethodInvoker(sourceObject, "addPropertyChangeListener", this).invoke();
    }

    public void addBindingMap(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, String targetMethodName, DataTypeConverter<?, ?> typeConverter) {
        NamedPropertyBindingMap map = new NamedPropertyBindingMap(sourceObject, sourceProperty, targetObject, targetProperty, targetMethodName, typeConverter);
        this.getBindingMap().add(map);
        new MethodInvoker(sourceObject, "addPropertyChangeListener", this).invoke();
    }

    public void removeBindingMap(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, String targetMethodName) {
        NamedPropertyBindingMap map = new NamedPropertyBindingMap(sourceObject, sourceProperty, targetObject, targetProperty, targetMethodName);
        this.getBindingMap().remove(map);
        new MethodInvoker(sourceObject, "removePropertyChangeListener", this).invoke();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (this.showProperties()) {
            System.out.println("NamedPropertyBinder.propertyChange(" + source.getClass().getName() + "." + propertyName + ")\nProperty Name: " + propertyName + "\nOldValue=" + String.valueOf(evt.getOldValue()) + " New Value=" + String.valueOf(evt.getNewValue()));
        }
        for (PropertyBindingMap pmap : this.getBindingMap()) {
            NamedPropertyBindingMap map = (NamedPropertyBindingMap)pmap;
            if (!map.getSourceObject().equals(source) || !map.getSourceProperty().equals(propertyName)) continue;
            DataTypeConverter<?, ?> typeConverter = map.getTypeConverter();
            if (typeConverter != null) {
                if (this.getAnimator() == null) {
                    new MethodInvoker(map.getTargetObject(), map.getTargetMethodName(), map.getTargetProperty(), typeConverter.convert(evt.getNewValue())).invoke();
                } else {
                    this.getAnimator().animate(map.getTargetObject(), map.getTargetProperty(), typeConverter.convert(evt.getNewValue()));
                }
            } else if (this.getAnimator() == null) {
                new MethodInvoker(map.getTargetObject(), map.getTargetMethodName(), map.getTargetProperty(), evt.getNewValue()).invoke();
            } else {
                this.getAnimator().animate(map.getTargetObject(), map.getTargetProperty(), evt.getNewValue());
            }
            return;
        }
        if (this.showProperties()) {
            System.out.println("NamedPropertyBinder.propertyChange(" + source.getClass().getName() + "." + propertyName + "):\nThe changed property name \"" + propertyName + "\" did not match any bound property in the mapping of this binder.  \nRemember, if the bound property is from a component, the component may send the name of the component as the property \nname, rather than the bean compliant name of the actual property being changed.");
        }
    }
}

