/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.beans.util.DataTypeConverter;
import com.jmorgan.util.comparator.AnyObjectComparator;

public class PropertyBindingMap
extends JMBean
implements Comparable<PropertyBindingMap> {
    private Object sourceObject;
    private String sourceProperty;
    private Object targetObject;
    private String targetProperty;
    private DataTypeConverter<?, ?> typeConverter;

    public PropertyBindingMap(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty) {
        this.setSourceObject(sourceObject);
        this.setSourceProperty(sourceProperty);
        this.setTargetObject(targetObject);
        this.setTargetProperty(targetProperty);
    }

    public PropertyBindingMap(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, DataTypeConverter<?, ?> typeConverter) {
        this(sourceObject, sourceProperty, targetObject, targetProperty);
        this.setTypeConverter(typeConverter);
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    public void setSourceObject(Object sourceObject) {
        this.sourceObject = sourceObject;
    }

    public String getSourceProperty() {
        return this.sourceProperty;
    }

    public void setSourceProperty(String sourceProperty) {
        this.sourceProperty = sourceProperty;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
    }

    public DataTypeConverter<?, ?> getTypeConverter() {
        return this.typeConverter;
    }

    public void setTypeConverter(DataTypeConverter<?, ?> typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public int compareTo(PropertyBindingMap that) {
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        AnyObjectComparator comparator = new AnyObjectComparator();
        int cmp = comparator.compare(this.sourceObject, that.sourceObject);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare((Comparable)((Object)this.sourceProperty), (Comparable)((Object)that.sourceProperty));
        if (cmp != 0) {
            return cmp;
        }
        cmp = comparator.compare(this.targetObject, that.targetObject);
        if (cmp != 0) {
            return cmp;
        }
        return this.compare((Comparable)((Object)this.targetProperty), (Comparable)((Object)that.targetProperty));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof PropertyBindingMap) {
            PropertyBindingMap that = (PropertyBindingMap)o;
            return this.areEqual(this.sourceObject, that.sourceObject) && this.areEqual(this.sourceProperty, that.sourceProperty) && this.areEqual(this.targetObject, that.targetObject) && this.areEqual(this.targetProperty, that.targetProperty);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + BeanService.getHashcodeOf(this.sourceObject);
        result = 31 * result + BeanService.getHashcodeOf(this.sourceProperty);
        result = 31 * result + BeanService.getHashcodeOf(this.targetObject);
        result = 31 * result + BeanService.getHashcodeOf(this.targetProperty);
        return result;
    }

    @Override
    public String toString() {
        return this.getSourceObject().getClass().getName() + "." + this.getSourceProperty() + "=>" + this.getTargetObject().getClass().getName() + "." + this.getTargetProperty();
    }
}

