/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics;

import com.jmorgan.graphics.RadialGradientPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class GlassyIcon
implements Icon {
    private Shape iconShape;
    private Color highlightColor;
    private Color darkColor;
    private RadialGradientPainter painter = new RadialGradientPainter();

    public GlassyIcon(Shape iconShape) {
        this(iconShape, Color.WHITE, new Color(163, 184, 204));
    }

    public GlassyIcon(Shape iconShape, Color highlightColor, Color darkColor) {
        this.setIconShape(iconShape);
        this.setHighlightColor(highlightColor);
        this.setDarkColor(darkColor);
    }

    public Shape getIconShape() {
        return this.iconShape;
    }

    public void setIconShape(Shape iconShape) {
        this.iconShape = iconShape;
        this.painter.setShape(this.iconShape);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        if (this.highlightColor != null) {
            this.painter.removeColor(this.highlightColor, 1.0f);
        }
        this.highlightColor = highlightColor;
        this.painter.addColor(this.highlightColor, 0.1f);
    }

    public Color getDarkColor() {
        return this.darkColor;
    }

    public void setDarkColor(Color darkColor) {
        if (this.darkColor != null) {
            this.painter.removeColor(this.darkColor, 1.0f);
        }
        this.darkColor = darkColor;
        this.painter.addColor(this.darkColor, 1.0f);
    }

    @Override
    public int getIconHeight() {
        return this.iconShape.getBounds().height;
    }

    @Override
    public int getIconWidth() {
        return this.iconShape.getBounds().width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D r = this.iconShape.getBounds2D();
        g2.translate((double)x - r.getWidth(), (double)y - r.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float[] stops = new float[]{0.1f, 1.0f};
        Color[] colors = new Color[]{this.highlightColor, this.darkColor};
        this.painter = new RadialGradientPainter();
        this.painter.setShape(this.iconShape);
        int i = 0;
        while (i < stops.length) {
            this.painter.addColor(colors[i], stops[i]);
            ++i;
        }
        this.painter.paint(g2);
        g2.setColor(this.getDarkColor().darker());
        g2.draw(this.iconShape);
    }
}

